/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.print;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetupUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.print.PrintManager;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.cosmic.ctrl.print.extend.MultiPrintJobManager;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public final class PrintBookTrans {
    public static final String Print_Area = "Print_Area";
    public static final String Print_Titles = "Print_Titles";

    public static final void copyPrintSetup(Book srcBook, Book desBook) {
        int count = desBook.getSheetCount();
        for (int i = 0; i < count; ++i) {
            PrintSetup ps = srcBook.getSheet(i).getSheetOption().getPrintSetup(false);
            if (ps == null) continue;
            desBook.getSheet(i).getSheetOption().getPrintSetup(true).copyFrom(ps);
        }
    }

    public static final void loadFromBook(MultiPrintJobManager pm, Book book) {
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            PrintBookTrans.loadFromSheet(pm, book.getSheet(i));
        }
        Sheet sheet = book.getActiveSheet();
        if (sheet != null) {
            PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
            if (ps == null) {
                return;
            }
            PrintJobConfig pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
            if (pc != null) {
                pc.addAttribute((Attribute)KDPrinterUtils.getMediaSizeNameByValue((int)ps.getPagesizeIndex(), (float)ps.getPagesizeX(), (float)ps.getPagesizeY()));
            }
        }
    }

    public static final void loadFromSheet(MultiPrintJobManager pm, Sheet sheet) {
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        UserObject obj = sheet.getBook().getUserObject("reportPrintInfo");
        boolean isUseScheme = false;
        if (obj != null && obj.getValue() instanceof String) {
            PrintSetup psModel = PrintSetupUtil.fromXml((String)obj.getValue());
            isUseScheme = PrintSetupUtil.checkPrintSchemeInfo(psModel, ps);
            PrintSetup printSetup = ps = isUseScheme ? psModel : ps;
        }
        if (ps == null) {
            PrintBookTrans.loadPrintAreaAndTitles(pm, sheet);
            return;
        }
        PrintJobConfig pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
        if (pc == null) {
            pm.createAllPrintJobs();
            pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
        }
        PageIntervalInfo pageInfo = KDPrinterUtils.getPageContentArea((PrintRequestAttributeSet)pc.getPrintRequestAttributeSet());
        pageInfo.setTop(ps.getTopMargin(), 25430);
        pageInfo.setBottom(ps.getBottomMargin(), 25430);
        pageInfo.setLeft(ps.getLeftMargin(), 25430);
        pageInfo.setRight(ps.getRightMargin(), 25430);
        pc.getPrintRequestAttributeSet().add((Attribute)pageInfo);
        HeadFootIntervalInfo hfiInfo = new HeadFootIntervalInfo(ps.getHeadMargin(), ps.getFootMargin(), 25400);
        pc.getPrintRequestAttributeSet().add((Attribute)hfiInfo);
        pc.addAttribute((Attribute)KDPrinterUtils.getMediaSizeNameByValue((int)ps.getPagesizeIndex(), (float)ps.getPagesizeX(), (float)ps.getPagesizeY()));
        if (ps.isAutoFit()) {
            pc.addAttribute((Attribute)new ZoomScaleInfo(ps.getAutoFitWidth(), ps.getAutoFitHeight(), (double)ps.getScale() / 100.0));
        } else {
            pc.addAttribute((Attribute)new ZoomScaleInfo((double)ps.getScale() / 100.0));
        }
        pc.addAttribute((Attribute)(ps.isLandScape() ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT));
        int ch = ps.getCenterHorizontal();
        int cv = ps.getCenterVertical();
        int cAlign = 0;
        cAlign = ch == 1 && cv == 1 ? PageSetupModel.CENTERALIGN_CENTER : (ch == 1 ? PageSetupModel.CENTERALIGN_HORIZONTAL : (cv == 1 ? PageSetupModel.CENTERALIGN_VERTICAL : PageSetupModel.CENTERALIGN_DEFAULT));
        PageSetupModel psModel = pc.getPageSetupModel();
        psModel.setCenterAlign(cAlign);
        psModel.setFooterAlign(ps.getFootAlign());
        psModel.setHeaderAlign(ps.getHeadAlign());
        psModel.setWaterMark(ps.getWaterMark());
        psModel.setWaterMark_onlyFirstPage(ps.isWaterMark_onlyFirstPage());
        psModel.setBackGround(ps.getBackGround());
        psModel.setBackGroundColor(ps.getBackGroundColor());
        psModel.setBackGroundFillMode(ps.getBackGroundFillMode());
        psModel.setPageAdjustX(ps.getPageAdjustX());
        psModel.setPageAdjustY(ps.getPageAdjustY());
        HeadFootIntervalInfo hfi = KDPrinterUtils.getHeadFootIntervalInfo((PrintRequestAttributeSet)pc.getPrintRequestAttributeSet());
        hfi.setHeadTop(ps.getHeadMargin(), 25430);
        hfi.setFootBottom(ps.getFootMargin(), 25430);
        HeaderFooter hf = new HeaderFooter();
        hf.setModel(new HeadFootModel());
        hf.getModel().setRowList(ps.getHeadData());
        pc.getHeaderFooterModel().setHeader((Canvas)hf);
        hf = new HeaderFooter();
        hf.setModel(new HeadFootModel());
        hf.getModel().setRowList(ps.getFootData());
        pc.getHeaderFooterModel().setFooter((Canvas)hf);
        TablePageSetupModel model = (TablePageSetupModel)pm.getTableSetupModel(sheet.getID());
        model.setSingleColor(ps.isBlackWhite());
        model.setRowIndex(ps.hasRowHead());
        model.setColumnIndex(ps.hasColHead());
        model.setGrid(ps.hasGrid());
        model.setOrder(!ps.isRowFirst());
        if (isUseScheme) {
            model.setVerEconomizePaper(ps.isVerEconomizePaper());
            model.setHorEconomizePaper(ps.isHorEconomizePaper());
            model.setVerSpace(ps.getVerSpace());
            model.setHorSpace(ps.getHorSpace());
            model.setPrintAreas(ps.getPrintAreas());
            model.setTopTitleRows(ps.getTopTitleRows());
            model.setLeftTitleColumns(ps.getLeftTitleColumns());
        } else {
            PrintBookTrans.loadPrintAreaAndTitles(pm, sheet);
        }
    }

    public static final void loadPrintAreaAndTitles(MultiPrintJobManager pm, Sheet sheet) {
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(true);
        PrintJobConfig pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
        if (pc == null) {
            pm.createAllPrintJobs();
            pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
        }
        TablePageSetupModel model = (TablePageSetupModel)pm.getTableSetupModel(sheet.getID());
        NamedObjectNode nodeArea = sheet.getNamedObject(Print_Area, false);
        if (nodeArea != null && nodeArea.getRefersTo() != null) {
            String rt = nodeArea.getRefersTo();
            if (!StringUtil.isEmptyString((String)rt)) {
                String[] strs = rt.split("!");
                model.setPrintAreas(strs[strs.length - 1]);
                ps.setPrintAreas(strs[strs.length - 1]);
            } else {
                model.setPrintAreas(null);
                ps.setPrintAreas(null);
            }
        } else {
            model.setPrintAreas(null);
            ps.setPrintAreas(null);
        }
        NamedObjectNode nodeTitles = sheet.getNamedObject(Print_Titles, false);
        if (nodeTitles != null && nodeTitles.getRefersTo() != null) {
            model.setTopTitleRows(null);
            model.setLeftTitleColumns(null);
            ps.setTopTitleRows(null);
            ps.setLeftTitleColumns(null);
            Expr expr = nodeTitles.getExpr();
            IExprNode[] nodes = expr.getExprParams().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof CellBlockNode)) continue;
                CellBlockNode cn = (CellBlockNode)nodes[i];
                String titles = cn.getBlockName(true, (CellBlock)null);
                if (cn.isRow()) {
                    model.setTopTitleRows(titles);
                    ps.setTopTitleRows(titles);
                    continue;
                }
                if (!cn.isCol()) continue;
                model.setLeftTitleColumns(titles);
                ps.setLeftTitleColumns(titles);
            }
        } else {
            model.setTopTitleRows(null);
            model.setLeftTitleColumns(null);
            ps.setTopTitleRows(null);
            ps.setLeftTitleColumns(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveToBook(PrintManager manager, Book book, String[] sheetIDs) {
        if (sheetIDs == null || sheetIDs.length < 1) {
            return;
        }
        MultiPrintJobManager pm = manager.getMultiPrintManager();
        PrintJobConfig activePC = null;
        Sheet activeSheet = book.getSheet(sheetIDs[0]);
        if (activeSheet == null) {
            activeSheet = book.getSheet(sheetIDs[0]);
        }
        if (activeSheet != null) {
            activePC = pm.getPrinter().getPrintConfig().getJobConfig(activeSheet.getID());
        }
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            PrintJobConfig pc;
            Sheet sheet = book.getSheet(i);
            if (!PrintBookTrans.needImported(sheet.getID(), sheetIDs)) continue;
            PrintSetup ps = null;
            if (pm.getPrinter().getPrintJob().getTaskCount() != book.getSheetCount()) {
                pm.createPrintJobs();
            }
            PrintJobConfig printJobConfig = pc = activePC == null ? pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID()) : activePC;
            if (pc != null) {
                PageSetupModel psModel;
                PrintRequestAttributeSet set;
                Attribute att;
                ps = sheet.getSheetOption().getPrintSetup(true);
                ps.setTopMargin(pc.getBodyTopMargin(25430));
                ps.setBottomMargin(pc.getBodyBottomMargin(25430));
                ps.setLeftMargin(pc.getLeftMargin(25430));
                ps.setRightMargin(pc.getRightMargin(25430));
                ps.setHeadMargin(pc.getHeaderMargin(25430));
                ps.setFootMargin(pc.getFooterMargin(25430));
                Media m = (Media)pc.getPrintRequestAttributeSet().get(Media.class);
                if (m == null) {
                    m = MediaSize.ISO.A4.getMediaSizeName();
                }
                ps.setPagesizeIndex(m.getValue());
                if (m instanceof MediaSizeNameExtend) {
                    MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)m);
                    ps.setPagesizeX(ms.getX(1000));
                    ps.setPagesizeY(ms.getY(1000));
                }
                PrintRequestAttributeSet pr = pc.getPrintRequestAttributeSet();
                ps.setScale((int)(KDPrinterUtils.getZoomScaleInfo((PrintRequestAttributeSet)pr) * 100.0));
                ZoomScaleInfo info = (ZoomScaleInfo)pr.get(ZoomScaleInfo.class);
                if (info != null) {
                    ps.setAutoFit(info.isAutoFit());
                    ps.setAutoFitHeight(info.getAutoFitHeight());
                    ps.setAutoFitWidth(info.getAutoFitWidth());
                } else {
                    ps.setAutoFit(false);
                    ps.setAutoFitHeight(1);
                    ps.setAutoFitWidth(1);
                }
                HeaderFooterModel hfm = pc.getHeaderFooterModel();
                HeaderFooter hf = (HeaderFooter)hfm.getHeader();
                if (hf != null && hf.getModel() != null) {
                    ps.setHeadData(hf.getModel().getRowList());
                }
                if ((hf = (HeaderFooter)hfm.getFooter()) != null && hf.getModel() != null) {
                    ps.setFootData(hf.getModel().getRowList());
                }
                ps.setLandScape((att = (set = (psModel = pc.getPageSetupModel()).getPrintRequestAttributeSet()).get(OrientationRequested.class)) == OrientationRequested.LANDSCAPE);
                int centerAlign = psModel.getCenterAlign();
                if (centerAlign == PageSetupModel.CENTERALIGN_HORIZONTAL) {
                    ps.setCenterHorizontal(1);
                } else if (centerAlign == PageSetupModel.CENTERALIGN_VERTICAL) {
                    ps.setCenterVertical(1);
                } else if (centerAlign == PageSetupModel.CENTERALIGN_CENTER) {
                    ps.setCenterHorizontal(1);
                    ps.setCenterVertical(1);
                } else {
                    ps.setCenterHorizontal(0);
                    ps.setCenterVertical(0);
                }
                ps.setFootAlign(psModel.getFooterAlign());
                ps.setHeadAlign(psModel.getHeaderAlign());
                ps.setWaterMark(psModel.getWaterMark());
                ps.setWaterMark_onlyFirstPage(psModel.isWaterMark_onlyFirstPage());
                ps.setBackGround(psModel.getBackGround());
                ps.setBackGroundColor(psModel.getBackGroundColor());
                ps.setBackGroundFillMode(psModel.getBackGroundFillMode());
                ps.setPageAdjustX(psModel.getPageAdjustX());
                ps.setPageAdjustY(psModel.getPageAdjustY());
                TablePageSetupModel model = (TablePageSetupModel)pm.getTableSetupModel(sheet.getID());
                if (model != null) {
                    ps.setBlackWhite(model.isSingleColor());
                    ps.setHasRowHead(model.isRowIndex());
                    ps.setHasColHead(model.isColumnIndex());
                    ps.setHasGrid(model.isGrid());
                    ps.setRowFirst(!model.getOrder());
                    ps.setVerEconomizePaper(model.isVerEconomizePaper());
                    ps.setHorEconomizePaper(model.isHorEconomizePaper());
                    ps.setVerSpace(model.getVerSpace());
                    ps.setHorSpace(model.getHorSpace());
                    ps.setPrintAreas(model.getPrintAreas());
                    ps.setTopTitleRows(model.getTopTitleRows());
                    ps.setLeftTitleColumns(model.getLeftTitleColumns());
                    try {
                        String sheetName = sheet.getSheetName();
                        String printAreas = model.getPrintAreas();
                        if (!StringUtil.isEmptyString((String)printAreas)) {
                            sheet.getRange(1, 1).setName(sheetName + '!' + Print_Area, printAreas);
                        } else {
                            sheet.getNames().remove(Print_Area);
                        }
                        String printTitleColumns = model.getLeftTitleColumns();
                        String printTitleRows = model.getTopTitleRows();
                        String printTitles = "";
                        if (!StringUtil.isEmptyString((String)printTitleColumns)) {
                            printTitles = printTitles + printTitleColumns;
                        }
                        if (!StringUtil.isEmptyString((String)printTitleRows)) {
                            if (!StringUtil.isEmptyString((String)printTitles)) {
                                printTitles = printTitles + ',';
                            }
                            printTitles = printTitles + printTitleRows;
                        }
                        if (!StringUtil.isEmptyString((String)printTitles)) {
                            sheet.getRange(1, 1).setName(sheetName + '!' + Print_Titles, printTitles);
                        } else {
                            sheet.getNames().remove(Print_Titles);
                        }
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                    }
                    finally {
                        sheet.getNames().removeEmptyName();
                    }
                }
            }
            if (ps == null) continue;
            String xml = PrintSetupUtil.toXml(ps);
            sheet.getBook().setUserObject("printSchemeInfo", xml);
        }
    }

    private static boolean needImported(String id, String[] sheetIDs) {
        int size = sheetIDs.length;
        for (int i = 0; i < size; ++i) {
            if (!id.equals(sheetIDs[i])) continue;
            return true;
        }
        return false;
    }

    public static final void saveToBook(PrintManager pm, Book book) {
        PrintBookTrans.saveToBook(pm, book, null);
    }
}

