/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class JsonUtil {
    private static final Gson gson = new Gson();

    private JsonUtil() {
    }

    public static String encodeToString(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T decodeFromString(String jsonString, Class<T> clz) {
        return (T)gson.fromJson(jsonString, clz);
    }

    public static String encodeToString(GsonBuilder gb, Object obj) {
        return gb.create().toJson(obj);
    }

    public static String encodeToString(CustomJsonParser customParser, Object obj) {
        return customParser.getGson().toJson(obj);
    }

    public static <T> T decodeFromString(CustomJsonParser customParser, String jsonString, Class<T> clz) {
        return (T)customParser.getGson().fromJson(jsonString, clz);
    }

    public static abstract class AbstractJsonDecoder<T>
    implements JsonDeserializer<T> {
        private GsonBuilder gsonBuilderWithCustomAdapter;

        public final void bindGsonBuilder(GsonBuilder gsonBuilder) {
            this.gsonBuilderWithCustomAdapter = gsonBuilder;
        }

        protected final <U extends T> T fromJson(Json json, Class<U> clz) {
            return (T)this.gsonBuilderWithCustomAdapter.create().fromJson((JsonElement)json.jsonObject, clz);
        }

        public final T deserialize(JsonElement jsonElement, Type typeT, JsonDeserializationContext ctx) {
            if (jsonElement.isJsonObject()) {
                JsonObject jo = jsonElement.getAsJsonObject();
                try {
                    return this.decode(new Json(jo));
                }
                catch (Exception ex) {
                    throw new JsonParseException((Throwable)ex);
                }
            }
            return null;
        }

        protected abstract T decode(Json var1);

        protected static class Json {
            private JsonObject jsonObject;

            public Json(JsonObject jo) {
                this.jsonObject = jo;
            }

            public boolean hasAttr(String attrKey) {
                return this.jsonObject.has(attrKey);
            }

            public String getAttrValue(String attrKey) {
                return this.jsonObject.get(attrKey).getAsString();
            }

            public int getAttrValueAsInt(String attrKey) {
                return this.jsonObject.get(attrKey).getAsInt();
            }
        }
    }

    public static class CustomJsonParser {
        private GsonBuilder gsonBuilder = new GsonBuilder();
        private Gson gson;

        public void addCustomDecoder(Class<?> clz, AbstractJsonDecoder<?> decoder) {
            this.gson = null;
            this.gsonBuilder.registerTypeAdapter(clz, decoder);
            decoder.bindGsonBuilder(this.gsonBuilder);
        }

        public Gson getGson() {
            if (this.gson == null) {
                this.gson = this.gsonBuilder.create();
            }
            return this.gson;
        }
    }
}

