/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.util;

import com.kingdee.cosmic.ctrl.common.util.SectionByteInputStream;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSReadException;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public class KDSDataInputStream
extends DataInputStream {
    private static final String ENCODING = "UTF-8";
    private static final int BufSize = 1024;
    private byte[] bytes = new byte[1024];

    public KDSDataInputStream(InputStream in) {
        super(in);
    }

    public String readDirectString(int len) throws IOException {
        if (this.bytes != null && len <= this.bytes.length) {
            this.read(this.bytes, 0, len);
            return new String(this.bytes, 0, len, ENCODING);
        }
        this.lengthLimit(len);
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return new String(bb, 0, len, ENCODING);
    }

    public byte[] readLengthBytes() throws IOException {
        int len = this.readShortOrInt();
        if (len <= 0) {
            return new byte[0];
        }
        this.lengthLimit(len);
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return bb;
    }

    public String readString() throws IOException {
        int len = this.readShortOrInt();
        if (len <= 0) {
            return "";
        }
        if (this.bytes != null && len <= this.bytes.length) {
            this.read(this.bytes, 0, len);
            return new String(this.bytes, 0, len, ENCODING);
        }
        this.lengthLimit(len);
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return new String(bb, 0, len, ENCODING);
    }

    public int readShortOrInt() throws IOException {
        int len;
        int s1 = this.readShort();
        if (s1 < 0) {
            short s2 = this.readShort();
            len = (s1 << 16) + (s2 & 0xFFFF);
            len = -len;
        } else {
            len = s1;
        }
        return len;
    }

    private void lengthLimit(int len) throws KDSReadException {
        int count = Integer.MAX_VALUE;
        if (this.in instanceof SectionByteInputStream) {
            count = ((SectionByteInputStream)this.in).getCount();
        }
        if (len > count) {
            throw new KDSReadException("read length(" + len + ") greater than the total length(" + count + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readDesc(String absPath) throws Exception {
        DataInputStream in = null;
        FileInputStream fis = null;
        if (absPath.endsWith(".xml")) {
            try {
                StringBuffer builder = new StringBuffer();
                fis = new FileInputStream(FilenameUtils.normalize((String)absPath));
                in = new DataInputStream(fis);
                byte[] buffer = new byte[1024];
                int len = -1;
                while ((len = in.read(buffer)) != -1) {
                    builder.append(new String(buffer, 0, len, ENCODING));
                }
                System.out.println(builder);
            }
            catch (Throwable throwable) {
                CloseUtil.close(in, fis);
                throw throwable;
            }
            CloseUtil.close(in, fis);
        }
    }
}

