/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.util;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class KDSDataOutputStream
extends DataOutputStream {
    private static final String ENCODING = "UTF-8";

    public KDSDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeLengthBytes(byte[] data) throws IOException {
        int len = data.length;
        this.writeShortOrInt(len);
        this.write(data);
    }

    public void writeString(String str) throws IOException {
        this.writeString(str, true, true);
    }

    public void writeString(String str, boolean judgeEmpty) throws IOException {
        this.writeString(str, judgeEmpty, true);
    }

    public void writeString(String str, boolean judgeEmpty, boolean writeLen) throws IOException {
        if (judgeEmpty && StringUtil.isEmptyString((String)str)) {
            this.writeShort(0);
        } else {
            byte[] sbytes = str.getBytes(ENCODING);
            if (writeLen) {
                int len = sbytes.length;
                this.writeShortOrInt(len);
            }
            this.write(sbytes);
        }
    }

    public void writeShortOrInt(int i) throws IOException {
        if (i > Short.MAX_VALUE) {
            this.writeInt(-i);
        } else {
            this.writeShort(i);
        }
    }
}

