/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.datasource;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;

public final class EntityDataSource
extends DataSource {
    private String source;
    private String encoding = "UNICODE";
    private boolean linked = false;
    private int type = -1;
    public static final int TYPE_CUSTOM = -1;
    public static final int TYPE_XML = 0;
    public static final int TYPE_CSV = 1;

    public EntityDataSource() {
    }

    public EntityDataSource(String id, boolean isLinked, String source) {
        super(id);
        this.linked = isLinked;
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    @Override
    public Object readFromNode(IXmlElement ele) {
        IXmlElement eleEntity;
        String src;
        IXmlElement eleSource;
        String type;
        this.setID(ele.getAttribute("id").trim());
        IXmlElement dsn = ele.getChild("DesignedDataSource");
        if (dsn != null) {
            this.setUserObject(dsn);
        }
        if ((type = (eleSource = ele.getChild("EntityDataSource")).getAttribute("type")) != null) {
            if (type.equalsIgnoreCase("xml")) {
                this.type = 0;
            } else if (type.equalsIgnoreCase("csv")) {
                this.type = 1;
            }
        }
        if ((src = (eleEntity = eleSource.getChild("Entity")).getAttribute("src")) != null && src.trim().length() > 0) {
            this.linked = true;
            this.setSource(src);
        } else {
            this.setSource(eleEntity.getText().trim());
        }
        this.setParams(this.resolveParamsNode(eleSource));
        return this;
    }

    @Override
    public IXmlElement writeToNode() {
        IXmlElement eleDS = this.createDSNode();
        eleDS.setAttribute("id", this.getID());
        IXmlElement eleSource = XmlUtil.createNode((String)"EntityDataSource");
        switch (this.type) {
            case 0: {
                eleSource.setAttribute("type", "xml");
                break;
            }
            case 1: {
                eleSource.setAttribute("type", "csv");
                break;
            }
            default: {
                eleSource.setAttribute("type", "custom");
            }
        }
        eleDS.addChild(eleSource);
        if (this.getUserObject() instanceof IXmlElement) {
            eleDS.addChild((IXmlElement)this.getUserObject());
        }
        IXmlElement eleEntity = XmlUtil.createNode((String)"Entity");
        if (this.isLinked()) {
            eleEntity.setAttribute("src", this.source);
        } else {
            eleEntity.addCData(this.source);
        }
        eleSource.addChild(eleEntity);
        eleSource.addChild(this.buildParamsNode());
        return eleDS;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getType() {
        return this.type;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public void setType(int type) {
        this.type = type;
    }
}

