/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.datasource;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;

public final class JDBCDataSource
extends DataSource {
    private String sqlString;
    private String connectionID;

    public JDBCDataSource() {
    }

    public JDBCDataSource(String id, String sqlString) {
        super(id);
        this.sqlString = sqlString;
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    @Override
    public String getSource() {
        return this.sqlString;
    }

    @Override
    public void setSource(String sql) {
        this.sqlString = sql;
    }

    @Override
    public IXmlElement writeToNode() {
        IXmlElement ele = this.createDSNode();
        IXmlElement eleJdbc = XmlUtil.createNode((String)"DBConnectionDataSource");
        if (this.connectionID != null) {
            eleJdbc.setAttribute("connection", this.connectionID);
        }
        IXmlElement eleSql = XmlUtil.createNode((String)"SqlString");
        eleSql.addCData(this.getSource());
        eleJdbc.addChild(eleSql);
        eleJdbc.addChild(this.buildParamsNode());
        ele.setAttribute("id", this.getID());
        ele.addChild(eleJdbc);
        if (this.getUserObject() instanceof IXmlElement) {
            ele.addChild((IXmlElement)this.getUserObject());
        }
        return ele;
    }

    @Override
    public Object readFromNode(IXmlElement ele) {
        this.setID(ele.getAttribute("id").trim());
        IXmlElement dsn = ele.getChild("DesignedDataSource");
        if (dsn != null) {
            this.setUserObject(dsn);
        }
        ele = ele.getChild("DBConnectionDataSource");
        this.setConnectionID(ele.getAttribute("connection"));
        this.setSource(ele.getChild("SqlString").getText());
        this.setParams(this.resolveParamsNode(ele));
        return this;
    }
}

