/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.cosmic.ctrl.kdf.data.Row;
import com.kingdee.cosmic.ctrl.kdf.data.config.DBInfo;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.EntityDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.ObjectDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.ReferencedDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.event.RequestDataEvent;
import com.kingdee.cosmic.ctrl.kdf.data.event.RequestDataListener;
import com.kingdee.cosmic.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.cosmic.ctrl.kdf.data.impl.BOSQuerySetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.impl.CsvDataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.impl.JDBCDataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.impl.XDataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.impl.XmlDataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.param.ReportParam;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.proxy.SocketDataVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public final class BaseDataSetWrapper
extends Observable
implements DataSetWrapper {
    private static final Logger logger = LogUtil.getPackageLogger(BaseDataSetWrapper.class);
    private static final String[] NULL_FIELDS = new String[0];
    private EventListenerList listenerList = new EventListenerList();
    private boolean parentRowIsNull = false;
    private boolean currentRowIsNull = true;
    private boolean isADOVisitMode = false;
    private boolean dataChanged = false;
    private boolean canChanged = true;
    private boolean hasNext = false;
    private int currentPosition = 0;
    private String id;
    private DataSetVisitor visitor;
    private DataSource ds;
    private String source;
    private String query;
    private ArrayList params;
    private String[] fields = null;
    private Map fieldsMap = new HashMap();
    private ArrayList currentRow;
    private ArrayList row;
    private ReportParam[] commonParams;

    private void fireRequestData(RequestDataEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RequestDataListener.class) continue;
            ((RequestDataListener)listeners[i + 1]).doRequestData(e);
        }
    }

    String processCommonParams() {
        if (this.commonParams == null || this.commonParams.length == 0) {
            return this.source;
        }
        RequestDataEvent e = new RequestDataEvent(this, this.source);
        String[] pms = e.getFilterList();
        for (int i = 0; i < pms.length; ++i) {
            for (int j = 0; j < this.commonParams.length; ++j) {
                if (!pms[i].equals(this.commonParams[j].getId())) continue;
                if (this.commonParams[j].getValue() == null) {
                    e.setFilter(pms[i], "");
                    continue;
                }
                e.setFilter(pms[i], this.commonParams[j].getValue().toString());
            }
        }
        return e.getQuery();
    }

    void obtainFilterData(String source) {
        RequestDataEvent e = new RequestDataEvent(this, source);
        this.fireRequestData(e);
        this.query = e.getQuery();
    }

    void addRequestDataListener(RequestDataListener listener) {
        this.listenerList.add(RequestDataListener.class, listener);
    }

    void setCommonParams(ReportParam[] params) {
        this.commonParams = params;
    }

    void addMasterChangedListener(BaseDataSetWrapper wrapper) {
        if (wrapper == this) {
            return;
        }
        this.addObserver(wrapper);
    }

    BaseDataSetWrapper(DataSource ds, DBInfo[] extraInfo) {
        this.ds = ds;
        this.params = ds.getParams();
        this.id = ds.getID().trim();
        this.query = this.source = ds.getSource();
        this.visitor = null;
        this.dataChanged = true;
        if (ds instanceof JDBCDataSource) {
            this.visitor = new JDBCDataSetVisitor(((JDBCDataSource)ds).getConnectionID());
            ((JDBCDataSetVisitor)this.visitor).setExtraDBInfo(extraInfo);
        } else if (!(ds instanceof ObjectDataSource)) {
            if (ds instanceof EntityDataSource) {
                EntityDataSource eds = (EntityDataSource)ds;
                switch (eds.getType()) {
                    case 0: {
                        XmlDataSetVisitor xvis = new XmlDataSetVisitor(eds.isLinked());
                        xvis.setDecoder(eds.getEncoding());
                        this.visitor = xvis;
                        break;
                    }
                    case 1: {
                        CsvDataSetVisitor cvis = new CsvDataSetVisitor();
                        cvis.setLinkMode(eds.isLinked());
                        this.visitor = cvis;
                        break;
                    }
                }
            } else if (ds instanceof BOSQueryDataSource) {
                BOSQueryDataSource bqds = (BOSQueryDataSource)ds;
                BOSQuerySetVisitor bsv = new BOSQuerySetVisitor(bqds.getConnectionID());
                bsv.setPackageName(bqds.getPackageName());
                bsv.setName(bqds.getName());
                bsv.setType(bqds.getType());
                bsv.setDs(bqds);
                this.visitor = bsv;
            } else if (ds instanceof ReferencedDataSource) {
                XDataSetVisitor xdsv = new XDataSetVisitor();
                xdsv.setDS((ReferencedDataSource)ds);
                this.visitor = xdsv;
            }
        }
    }

    private String assemblySQL(String sql) {
        StringBuffer execSQL = new StringBuffer(sql);
        StringBuffer execSQLUpperCase = new StringBuffer(sql.toUpperCase());
        for (int i = 0; i < this.params.size(); ++i) {
            DSParam dsParam = (DSParam)this.params.get(i);
            String paramName = ":[" + dsParam.getColName().toUpperCase(Locale.ENGLISH) + "]";
            Variant value = dsParam.getValue();
            int length = paramName.length();
            int start = execSQLUpperCase.indexOf(paramName);
            if (start < 0) continue;
            String param = "";
            if (value != null) {
                param = dsParam.getDataType().equalsIgnoreCase("string") ? "'" + value + "'" : (dsParam.getDataType().equalsIgnoreCase("number") ? value.toString() : (dsParam.getDataType().equalsIgnoreCase("date") ? "'" + value + "'" : value.toString()));
            }
            execSQL = execSQL.replace(start, start + length, param);
            execSQLUpperCase = execSQLUpperCase.replace(start, start + length, param);
        }
        return execSQL.toString();
    }

    private synchronized boolean init() throws DataSetWrapperException {
        if (this.dataChanged) {
            if (null == this.visitor) {
                return false;
            }
            boolean result = false;
            this.dataChanged = false;
            this.currentPosition = 0;
            if (this.parentRowIsNull) {
                this.fields = null;
                this.fieldsMap.clear();
                this.currentRow = new ArrayList();
                this.row = new ArrayList();
            } else {
                String src = this.processCommonParams();
                this.obtainFilterData(src);
                src = this.assemblySQL(this.query);
                boolean recordsetIsValid = this.visitor.execute(this.id, src);
                this.fields = this.visitor.getAllFieldName();
                this.currentRow = new ArrayList(this.fields.length);
                this.row = new ArrayList(this.fields.length);
                this.fieldsMap.clear();
                for (int i = 0; i < this.fields.length; ++i) {
                    this.fieldsMap.put(this.fields[i], i);
                    this.currentRow.add(new Variant());
                    this.row.add(new Variant());
                }
                result = true;
                this.currentRowIsNull = true;
                if (recordsetIsValid) {
                    this.hasNext = this.visitor.next(this.currentRow);
                    if (this.isADOVisitMode) {
                        this.currentRowIsNull = false;
                        this.setRow();
                    }
                } else {
                    this.hasNext = false;
                }
            }
            return result;
        }
        return false;
    }

    private void setRow() {
        if (this.fields != null) {
            this.row.clear();
            for (int i = 0; i < this.currentRow.size(); ++i) {
                this.row.add(((Variant)this.currentRow.get(i)).clone());
            }
            if (this.canChanged) {
                this.changed();
            }
        }
    }

    @Override
    public boolean next() {
        if (null == this.visitor) {
            return false;
        }
        try {
            this.init();
            boolean bl = this.currentRowIsNull = !this.hasNext;
            if (this.currentRowIsNull) {
                this.hasNext = false;
                if (this.isADOVisitMode && this.currentPosition < this.visitor.getRecordCount()) {
                    ++this.currentPosition;
                    this.currentRowIsNull = false;
                    this.setRow();
                } else {
                    ++this.currentPosition;
                    int size = this.currentRow.size();
                    for (int i = 0; i < size; ++i) {
                        this.row.set(i, new Variant());
                    }
                }
            } else {
                ++this.currentPosition;
                this.setRow();
                this.hasNext = this.visitor.next(this.currentRow);
            }
        }
        catch (DataSetWrapperException e) {
            this.fields = new String[0];
            this.fieldsMap.clear();
            this.currentRow = new ArrayList(0);
            this.row = new ArrayList(0);
            this.hasNext = false;
            this.currentRowIsNull = true;
        }
        return !this.currentRowIsNull;
    }

    @Override
    public boolean hasNext() {
        if (null == this.visitor) {
            return false;
        }
        try {
            this.init();
        }
        catch (DataSetWrapperException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return this.isADOVisitMode ? this.currentPosition < this.visitor.getRecordCount() : this.hasNext;
    }

    private void changed() {
        this.setChanged();
        ArrayList<Object> arg = new ArrayList<Object>();
        arg.add(this.id);
        arg.add(new DataSetRow(this.fields, this.row, this.fieldsMap));
        arg.add(this.currentRowIsNull);
        this.notifyObservers(arg);
    }

    @Override
    public Variant getField(String name) {
        try {
            this.init();
        }
        catch (DataSetWrapperException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (this.fields == null) {
            return new Variant();
        }
        Object index = this.fieldsMap.get(name);
        if (index != null) {
            return (Variant)this.row.get((Integer)index);
        }
        String s = name.toUpperCase(Locale.ENGLISH).intern();
        Object obj = this.fieldsMap.get(s);
        if (obj != null) {
            this.fieldsMap.put(name, obj);
            return (Variant)this.row.get((Integer)obj);
        }
        return new Variant();
    }

    @Override
    public Row getRow() {
        try {
            this.init();
        }
        catch (DataSetWrapperException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (this.fields == null) {
            return new DataSetRow(new String[0], (List)this.row.clone(), this.fieldsMap);
        }
        return new DataSetRow(this.fields, (List)this.row.clone(), this.fieldsMap);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ArrayList) {
            ArrayList parent = (ArrayList)arg;
            String parentID = (String)parent.get(0);
            DataSetRow parentRow = (DataSetRow)parent.get(1);
            this.parentRowIsNull = (Boolean)parent.get(2);
            if (this.parentRowIsNull) {
                this.dataChanged = true;
            } else {
                for (int i = 0; i < this.params.size(); ++i) {
                    DSParam param = (DSParam)this.params.get(i);
                    if (param.getAssociateSource() == null || !param.getAssociateSource().equalsIgnoreCase(parentID)) continue;
                    Variant var = parentRow.get(param.getAssociateField());
                    try {
                        if (var.equals(param.getValue())) continue;
                        param.setValue(var);
                        this.dataChanged = true;
                        continue;
                    }
                    catch (SyntaxErrorException e) {
                        param.setValue(var);
                        this.dataChanged = true;
                    }
                }
            }
        }
    }

    @Override
    public void changeDataSource(DataSetVisitor visitor) {
        this.visitor = visitor;
        this.dataChanged = true;
        this.isADOVisitMode = visitor instanceof SocketDataVisitor;
    }

    public void changeADODS(DataSetVisitor visitor) {
        this.visitor = visitor;
        this.dataChanged = true;
        this.isADOVisitMode = true;
    }

    @Override
    public DataSetVisitor getDataSetVisitor() {
        return this.visitor;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public DSParam getDSParam(int index) {
        if (index < 0 || index >= this.params.size()) {
            return null;
        }
        return (DSParam)this.params.get(index);
    }

    @Override
    public void blockDataSet() {
        this.canChanged = false;
    }

    @Override
    public void syncDataSet() {
        try {
            this.init();
        }
        catch (DataSetWrapperException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        this.canChanged = true;
        this.changed();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public int getDSParamCount() {
        return this.params.size();
    }

    @Override
    public boolean isBOF() {
        return this.currentPosition == 0;
    }

    @Override
    public int getCurrentPositon() {
        return this.currentPosition - 1;
    }

    @Override
    public void addMasterDataSetListener(DataSetWrapper wrapper) {
        this.addMasterChangedListener((BaseDataSetWrapper)wrapper);
    }

    @Override
    public int getTotalRecordCount() {
        if (this.visitor != null) {
            try {
                this.init();
                return this.visitor.getRecordCount();
            }
            catch (DataSetWrapperException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return 0;
    }

    public void setVisitor(DataSetVisitor dataSetVisitor) {
        this.visitor = dataSetVisitor;
    }

    class DataSetRow
    implements Row {
        private List Values;
        private String[] Fields;
        private Map fieldMap;

        @Override
        public Iterator iterator() {
            return this.Values.iterator();
        }

        DataSetRow(String[] fields, List row, Map fieldMap) {
            this.Fields = fields;
            this.Values = row;
            this.fieldMap = fieldMap;
        }

        @Override
        public Variant get(String name) {
            if (this.Fields == null) {
                return new Variant();
            }
            Object index = this.fieldMap.get(name);
            if (index != null) {
                return (Variant)this.Values.get((Integer)index);
            }
            String key = name.trim().toUpperCase(Locale.ENGLISH).intern();
            Object obj = this.fieldMap.get(key);
            if (obj != null) {
                this.fieldMap.put(name, obj);
                return (Variant)this.Values.get((Integer)obj);
            }
            return new Variant();
        }

        @Override
        public Variant get(int idx) {
            if (null == this.Values) {
                return new Variant();
            }
            return (Variant)this.Values.get(idx);
        }

        @Override
        public String[] getFields() {
            if (null == this.Fields) {
                return NULL_FIELDS;
            }
            return this.Fields;
        }

        @Override
        public boolean isEmpty() {
            if (null == this.Values) {
                return true;
            }
            return this.Values.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < BaseDataSetWrapper.this.fields.length; ++index) {
                sb.append('[').append(BaseDataSetWrapper.this.fields[index]).append(':').append(this.Values.get(index)).append("] ");
            }
            return sb.toString();
        }
    }
}

