/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.config.DBInfo;
import com.kingdee.cosmic.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.cosmic.ctrl.kdf.data.impl.DBConnection;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class JDBCDataSetVisitor
implements DataSetVisitor {
    private static final Logger logger = LogUtil.getPackageLogger(JDBCDataSetVisitor.class);
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    private PreparedStatement preps;
    private ResultSet rs = null;
    private String[] fields;
    private int[] colTypes;
    private boolean validRow;
    private Connection conn;
    private String connectionID;
    private DBInfo[] extraInfo;

    public JDBCDataSetVisitor(String connectionID) {
        this.connectionID = connectionID;
    }

    public void setExtraDBInfo(DBInfo[] info) {
        this.extraInfo = info;
    }

    @Override
    public boolean execute(String name, String query) throws DataSetWrapperException {
        try {
            DBConnection instance = DBConnection.instance();
            instance.setExtraInfo(this.extraInfo);
            this.conn = instance.getConnection(this.connectionID);
            if (null != this.conn) {
                this.preps = this.conn.prepareStatement(query);
            }
            this.rs = this.preps.executeQuery();
            ResultSetMetaData rsma = this.rs.getMetaData();
            int size = rsma.getColumnCount();
            this.fields = new String[size];
            this.colTypes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = rsma.getColumnName(i + 1);
                this.colTypes[i] = rsma.getColumnType(i + 1);
            }
            return true;
        }
        catch (SQLException sqle) {
            throw new DataSetWrapperException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void getRecord(ArrayList row) throws SQLException, IOException {
        tmp = "";
        binarys = null;
        is = null;
        baos = null;
        c = new byte[1024];
        chrText = new char[1024];
        len = 0;
        block39: for (i = 0; i < this.colTypes.length; ++i) {
            var = (Variant)row.get(i);
            index = i + 1;
            switch (this.colTypes[i]) {
                case -1: 
                case 12: 
                case 2005: {
                    reader = this.rs.getCharacterStream(index);
                    var13_13 = null;
                    if (reader == null) {
                        var.setObject(null, 11);
                    } else {
                        sb = new StringBuffer();
                        while ((len = reader.read(chrText, 0, chrText.length)) != -1) {
                            sb.append(chrText, 0, len);
                        }
                        var.setObject((Object)sb.toString(), 11);
                        sb = null;
                    }
                    if (reader == null) continue block39;
                    if (var13_13 == null) ** GOTO lbl34
                    try {
                        reader.close();
                    }
                    catch (Throwable var14_16) {
                        var13_13.addSuppressed(var14_16);
                    }
                    continue block39;
lbl34:
                    // 1 sources

                    reader.close();
                    continue block39;
                    catch (Throwable var14_17) {
                        try {
                            var13_13 = var14_17;
                            throw var14_17;
                        }
                        catch (Throwable var15_18) {
                            if (reader != null) {
                                if (var13_13 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var16_19) {
                                        var13_13.addSuppressed(var16_19);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var15_18;
                        }
                    }
                }
                case 8: {
                    var.setDouble(this.rs.getDouble(index));
                    continue block39;
                }
                case 6: {
                    var.setFloat(this.rs.getFloat(index));
                    continue block39;
                }
                case 4: {
                    var.setInt(this.rs.getInt(index));
                    continue block39;
                }
                case 1: {
                    tmp = this.rs.getString(index);
                    if (tmp == null) {
                        tmp = "";
                    }
                    var.setObject((Object)tmp, 11);
                    continue block39;
                }
                case -7: {
                    var.setByte(this.rs.getByte(index));
                    continue block39;
                }
                case 91: {
                    date = this.rs.getDate(index);
                    var.setObject((Object)date, 12);
                    continue block39;
                }
                case 3: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    continue block39;
                }
                case 16: {
                    var.setBoolean(this.rs.getBoolean(index));
                    continue block39;
                }
                case 92: {
                    var.setObject((Object)this.rs.getString(index), 11);
                    continue block39;
                }
                case 93: {
                    var.setObject((Object)this.rs.getString(index), 11);
                    continue block39;
                }
                case 5: {
                    var.setInt(this.rs.getInt(index));
                    continue block39;
                }
                case -6: {
                    var.setInt(this.rs.getInt(index));
                    continue block39;
                }
                case -5: {
                    var.setLong(this.rs.getLong(index));
                    continue block39;
                }
                case 2: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    continue block39;
                }
                case -2: {
                    binary = this.rs.getByte(index);
                    var.setByte(binary);
                    continue block39;
                }
                case -4: 
                case -3: 
                case 2004: {
                    is = this.rs.getBinaryStream(index);
                    if (is == null) ** GOTO lbl117
                    baos = new ByteArrayOutputStream();
                    try {
                        while ((len = is.read(c, 0, c.length)) != -1) {
                            baos.write(c, 0, len);
                        }
                        binarys = baos.toByteArray();
                    }
                    finally {
                        baos.close();
                        is.close();
                    }
                    baos = null;
                    ** GOTO lbl118
lbl117:
                    // 1 sources

                    binarys = JDBCDataSetVisitor.NULL_BYTE_ARRAY;
lbl118:
                    // 2 sources

                    var.setObject((Object)binarys, 512);
                    if (null != is) {
                        is.close();
                    }
                    binarys = null;
                    is = null;
                    continue block39;
                }
                case 70: {
                    continue block39;
                }
                case 2001: {
                    continue block39;
                }
                case 2000: {
                    var.setObject(this.rs.getObject(index));
                    continue block39;
                }
                case 0: {
                    continue block39;
                }
                case 1111: {
                    continue block39;
                }
                case 7: {
                    var.setDouble(this.rs.getDouble(index));
                    continue block39;
                }
                case 2006: {
                    continue block39;
                }
                case 2002: {
                    continue block39;
                }
                case 2003: {
                    var.setObject((Object)this.rs.getArray(index), 512);
                }
            }
        }
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        try {
            this.validRow = this.rs.next();
            if (!this.validRow) {
                return false;
            }
            this.getRecord(avOut);
        }
        catch (SQLException sqle) {
            throw new DataSetWrapperException(sqle);
        }
        catch (IOException ioe) {
            throw new DataSetWrapperException(ioe);
        }
        return this.validRow;
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        return this.validRow;
    }

    @Override
    public int getRecordCount() {
        if (this.rs != null) {
            try {
                return this.rs.getFetchSize();
            }
            catch (SQLException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return 0;
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public String[] getAllFieldName() {
        if (null == this.rs) {
            return new String[0];
        }
        String[] result = new String[this.fields.length];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        return result;
    }
}

