/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class RowSetVisitor
implements DataSetVisitor {
    private static final Logger logger = LogUtil.getPackageLogger(RowSetVisitor.class);
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    private String[] fields;
    private IRowSet rs;
    private boolean validRow = false;
    private int[] colTypes = null;

    public RowSetVisitor(IRowSet rowset) {
        this.rs = rowset;
    }

    @Override
    public boolean execute(String name, String sQuery) throws DataSetWrapperException {
        if (null == this.rs) {
            return false;
        }
        try {
            IRowSetMetaData rsmd = this.rs.getRowSetMetaData();
            int size = rsmd.getColumnCount();
            this.colTypes = new int[size];
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = rsmd.getColumnName(i + 1).toUpperCase().intern();
                this.colTypes[i] = rsmd.getColumnType(i + 1);
            }
            return true;
        }
        catch (SQLException sqle) {
            throw new DataSetWrapperException(sqle);
        }
    }

    private void getRecord(ArrayList row) throws SQLException, IOException {
        String tmp = "";
        byte[] binarys = null;
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        byte[] c = new byte[1024];
        char[] chrText = new char[1024];
        int len = 0;
        block28: for (int i = 0; i < this.colTypes.length; ++i) {
            Variant var = (Variant)row.get(i);
            int index = i + 1;
            switch (this.colTypes[i]) {
                case -1: 
                case 12: 
                case 2005: {
                    Reader reader = this.rs.getCharacterStream(index);
                    if (reader == null) {
                        var.setObject(null, 0);
                        continue block28;
                    }
                    StringBuffer sb = new StringBuffer();
                    while ((len = reader.read(chrText, 0, chrText.length)) != -1) {
                        sb.append(chrText, 0, len);
                    }
                    var.setObject((Object)sb.toString(), 11);
                    sb = null;
                    continue block28;
                }
                case 8: {
                    var.setDouble(this.rs.getDouble(index));
                    continue block28;
                }
                case 6: {
                    var.setFloat(this.rs.getFloat(index));
                    continue block28;
                }
                case 4: {
                    var.setInt(this.rs.getInt(index));
                    continue block28;
                }
                case 1: {
                    tmp = this.rs.getString(index);
                    if (tmp == null) {
                        tmp = "";
                    }
                    var.setObject((Object)tmp, 11);
                    continue block28;
                }
                case -7: {
                    var.setBoolean(this.rs.getBoolean(index));
                    continue block28;
                }
                case 91: {
                    var.setObject((Object)this.rs.getDate(index), 12);
                    continue block28;
                }
                case 3: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    continue block28;
                }
                case 16: {
                    var.setBoolean(this.rs.getBoolean(index));
                    continue block28;
                }
                case 92: {
                    var.setObject((Object)this.rs.getTime(index), 12);
                    continue block28;
                }
                case 93: {
                    var.setObject((Object)this.rs.getTimestamp(index), 12);
                    continue block28;
                }
                case 5: {
                    var.setInt(this.rs.getInt(index));
                    continue block28;
                }
                case -6: {
                    var.setInt(this.rs.getInt(index));
                    continue block28;
                }
                case -5: {
                    var.setLong(this.rs.getLong(index));
                    continue block28;
                }
                case 2: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    continue block28;
                }
                case -2: {
                    byte[] binary = this.rs.getBytes(index);
                    var.setObject((Object)binary, 512);
                    continue block28;
                }
                case -4: 
                case -3: 
                case 2004: {
                    is = this.rs.getBinaryStream(index);
                    if (is != null) {
                        baos = new ByteArrayOutputStream();
                        while ((len = is.read(c, 0, c.length)) != -1) {
                            baos.write(c, 0, len);
                        }
                        binarys = baos.toByteArray();
                        baos.close();
                        is.close();
                        baos = null;
                    } else {
                        binarys = NULL_BYTE_ARRAY;
                    }
                    var.setObject((Object)binarys, 512);
                    binarys = null;
                    is = null;
                    continue block28;
                }
                case 70: {
                    continue block28;
                }
                case 2001: {
                    continue block28;
                }
                case 2000: {
                    var.setObject(this.rs.getObject(index));
                    continue block28;
                }
                case 0: {
                    continue block28;
                }
                case 1111: {
                    continue block28;
                }
                case 7: {
                    var.setDouble(this.rs.getDouble(index));
                    continue block28;
                }
                case 2006: {
                    continue block28;
                }
                case 2002: {
                    continue block28;
                }
                case 2003: {
                    var.setObject((Object)this.rs.getArray(index), 512);
                }
            }
        }
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        if (null == this.rs) {
            return false;
        }
        try {
            this.validRow = this.rs.next();
            if (!this.validRow) {
                for (int i = 0; i < avOut.size(); ++i) {
                    ((Variant)avOut.get(i)).setObject(null);
                }
                return false;
            }
            this.getRecord(avOut);
        }
        catch (SQLException sqle) {
            logger.error((Object)"err", (Throwable)sqle);
            throw new DataSetWrapperException(sqle);
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
            throw new DataSetWrapperException(ioe);
        }
        return this.validRow;
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        if (null == this.rs) {
            return false;
        }
        return this.validRow;
    }

    @Override
    public int getRecordCount() {
        return -1;
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public String[] getAllFieldName() {
        if (null == this.rs) {
            return new String[0];
        }
        if (this.fields != null && this.fields.length > 0) {
            String[] result = new String[this.fields.length];
            System.arraycopy(this.fields, 0, result, 0, this.fields.length);
            return result;
        }
        return new String[0];
    }
}

