/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.pool;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.pool.Cache;
import com.kingdee.cosmic.ctrl.kdf.data.pool.DataPoolProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class IOCache
implements Cache {
    private static final Logger logger = LogUtil.getPackageLogger(IOCache.class);
    private String ext = ".dat";
    private String filepath = null;
    private DataPoolProperties prop = DataPoolProperties.getInstance();

    public IOCache() {
        this.filepath = this.prop.getFilePath() + File.separator + "pool";
        File f = new File(FilenameUtils.normalize((String)this.filepath));
        if (!f.exists()) {
            f.mkdir();
        }
        f = null;
    }

    @Override
    public void addBlock(int taskID, int blockID, byte[] block) {
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        try {
            this.createTaskPath(pathname);
            this.createBlockFile(filename);
            try (FileOutputStream fos = new FileOutputStream(new File(FilenameUtils.normalize((String)filename)));){
                fos.write(block);
            }
        }
        catch (SecurityException fos) {
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)"err", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }

    private void createBlockFile(String filename) throws IOException, SecurityException {
        File f = new File(FilenameUtils.normalize((String)filename));
        if (!f.exists() && !f.createNewFile()) {
            logger.warn((Object)(f.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
        }
        f = null;
    }

    private void createTaskPath(String pathname) throws SecurityException {
        File f = new File(FilenameUtils.normalize((String)pathname));
        if (!f.exists()) {
            f.mkdir();
        }
        f = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBlock(int taskID, int blockID) {
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        try (FileInputStream fis = new FileInputStream(new File(FilenameUtils.normalize((String)filename)));){
            int i = fis.available();
            byte[] b = new byte[i];
            fis.read(b);
            byte[] byArray = b;
            return byArray;
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)"err", (Throwable)fnfe);
            return new byte[0];
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
        return new byte[0];
    }

    @Override
    public boolean remove() {
        boolean result = true;
        File f = new File(FilenameUtils.normalize((String)this.filepath));
        if (f.exists()) {
            String[] s = f.list();
            for (int i = 0; i < s.length; ++i) {
                result = this.removeTask(Integer.parseInt(s[i]));
            }
        }
        return result;
    }

    @Override
    public boolean removeBlock(int taskID, int blockID) {
        boolean result = true;
        String pathname = this.filepath + File.separator + taskID;
        String filename = pathname + File.separator + blockID + this.ext;
        File f = new File(FilenameUtils.normalize((String)filename));
        if (f.exists()) {
            result = f.delete();
        }
        return result;
    }

    @Override
    public boolean removeTask(int taskID) {
        boolean result = true;
        String pathname = this.filepath + File.separator + taskID;
        File f = new File(FilenameUtils.normalize((String)pathname));
        if (f.exists()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                logger.warn((Object)(files[i].getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            result = f.delete();
        }
        return result;
    }

    @Override
    public void addTask(int taskID) {
    }

    @Override
    public void updateTask(int taskID) {
    }

    @Override
    public void updateBlock(int taskID, int blockID, byte[] block) {
    }
}

