/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.query;

import java.util.HashMap;
import java.util.Locale;

public final class SqlType {
    private String name;
    public static final HashMap TYPE_MAP = new HashMap();
    public static final SqlType BOOLEAN = new SqlType("BOOLEAN");
    public static final SqlType CHAR = new SqlType("CHAR");
    public static final SqlType BYTE = new SqlType("BYTE");
    public static final SqlType SHORT = new SqlType("SHORT");
    public static final SqlType INTEGER = new SqlType("INTEGER");
    public static final SqlType LONG = new SqlType("LONG");
    public static final SqlType FLOAT = new SqlType("FLOAT");
    public static final SqlType DOUBLE = new SqlType("DOUBLE");
    public static final SqlType STRING = new SqlType("STRING");
    public static final SqlType DATETIME = new SqlType("DATETIME");
    public static final SqlType CURRENCY = new SqlType("CURRENCY");
    public static final SqlType BINARY = new SqlType("BINARY");

    protected SqlType(String name) {
        this.name = name;
    }

    public static SqlType instance(String type) {
        Object obj = TYPE_MAP.get(type.toLowerCase());
        if (obj == null) {
            if (type.equalsIgnoreCase("int")) {
                return INTEGER;
            }
            obj = new SqlType(type);
            TYPE_MAP.put(type, obj);
        }
        return (SqlType)obj;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SqlType)) {
            return false;
        }
        SqlType type = (SqlType)obj;
        return this.getName() == null ? type.getName() == null : this.getName().equalsIgnoreCase(type.getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase(Locale.ENGLISH).hashCode();
    }

    public String toString() {
        return this.getName().toUpperCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    static {
        TYPE_MAP.put(BOOLEAN.getName(), BOOLEAN);
        TYPE_MAP.put(CHAR.getName(), CHAR);
        TYPE_MAP.put(BYTE.getName(), BYTE);
        TYPE_MAP.put(SHORT.getName(), SHORT);
        TYPE_MAP.put(INTEGER.getName(), INTEGER);
        TYPE_MAP.put(LONG.getName(), LONG);
        TYPE_MAP.put(FLOAT.getName(), FLOAT);
        TYPE_MAP.put(DOUBLE.getName(), DOUBLE);
        TYPE_MAP.put(STRING.getName(), STRING);
        TYPE_MAP.put(DATETIME.getName(), DATETIME);
        TYPE_MAP.put(CURRENCY.getName(), CURRENCY);
        TYPE_MAP.put(BINARY.getName(), BINARY);
    }
}

