/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.wizard;

import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDBasicQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryDir;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryElement;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryFilter;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryGroup;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryJoin;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryParam;
import com.kingdee.cosmic.ctrl.kdf.data.query.QuerySort;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryTable;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentEntitySource;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentHorizolAlignPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentObjectSource;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentVerticalAlignPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataWizardTreeNode;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ResultPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.icons.Icons;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.cosmic.ctrl.swing.tree.ITreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class KDDataWizard
extends KDDialog
implements TreeModelListener,
TreeSelectionListener,
TreeExpansionListener {
    private static final Logger logger;
    private static final long serialVersionUID = 4586148734651349098L;
    public static final int DEFAULT_WIDTH = 792;
    public static final int DEFAULT_HEIGHT = 596;
    public static final Color DEFAULT_TEXTAREA_BACKCOLOR;
    public static final Color DEFAULT_BORDERCOLOR;
    public static final ImageIcon IMG_QUERY;
    public static final ImageIcon IMG_TABLE;
    public static final ImageIcon IMG_FIELD;
    public static final ImageIcon IMG_JOIN;
    public static final ImageIcon IMG_SORT;
    public static final ImageIcon IMG_GROUP;
    public static final ImageIcon IMG_FILTER;
    public static final ImageIcon IMG_PARAMETER;
    public static final ImageIcon IMG_DATASOURCE;
    public static final ImageIcon IMG_ON;
    public static final ImageIcon IMG_OFF;
    public static final ImageIcon IMG_ASC;
    public static final ImageIcon IMG_DESC;
    public static final ImageIcon IMG_DIR;
    public static final boolean BSETFONT = false;
    private JPanel treePanel = null;
    private KDSplitPane rightSplitPane = null;
    private KDTree kdTree = null;
    private KDDataWizardTreeNode treeRootNode = null;
    private KDDataWizardTreeNode treeSystemNode = null;
    private KDDataWizardTreeNode treeCustomerNode = null;
    private ResultPanel objBottomResult = null;
    private KDDataManager dataManager = null;
    private static final String[] INVALID_STRING;
    private static final String[] VALID_STRING;
    public static final Vector VEC_VALIDSTRING;
    public static final Vector VEC_INVALIDSTRING;

    private static final String getDefaultTitle() {
        return CtrlKDFMessages.getMLS("datawizard", "\u6570\u636e\u5411\u5bfc");
    }

    public KDDataWizard(KDDataManager dataManager) throws HeadlessException {
        this.setTitle(KDDataWizard.getDefaultTitle());
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Dialog owner, KDDataManager dataManager) throws HeadlessException {
        super(owner, true);
        this.setTitle(KDDataWizard.getDefaultTitle());
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Dialog owner, boolean modal, KDDataManager dataManager) throws HeadlessException {
        super(owner, modal);
        this.setTitle(KDDataWizard.getDefaultTitle());
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Dialog owner, String title, boolean modal, KDDataManager dataManager) throws HeadlessException {
        super(owner, title, modal);
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Frame owner, KDDataManager dataManager) throws HeadlessException {
        super(owner, true);
        this.setTitle(KDDataWizard.getDefaultTitle());
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Frame owner, boolean modal, KDDataManager dataManager) throws HeadlessException {
        super(owner, modal);
        this.setTitle(KDDataWizard.getDefaultTitle());
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    public KDDataWizard(Frame owner, String title, boolean modal, KDDataManager dataManager) throws HeadlessException {
        super(owner, title, modal);
        this.setSize(792, 596);
        this.dataManager = dataManager;
        this.initGUI();
    }

    private void initGUI() {
        this.initData();
        this.initComponents();
        this.initEvents();
        KDDataWizard.center((Dialog)((Object)this));
        this.setSelectNode(this.treeCustomerNode);
    }

    protected void refreshTree() {
        this.kdTree.removeAllChildrenFromParent((MutableTreeNode)((Object)this.treeRootNode));
        this.initData();
        this.kdTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)((Object)this.treeRootNode)));
    }

    private void initComponents() {
        this.rightSplitPane = new KDSplitPane(0);
        this.rightSplitPane.setDividerLocation(357);
        KDSplitPane sppMain = new KDSplitPane(1, (Component)this.getTreePanel(), (Component)this.rightSplitPane);
        sppMain.setDividerLocation(264);
        this.getContentPane().add((Component)sppMain, "Center");
    }

    private JPanel getTreePanel() {
        if (this.treePanel == null) {
            try {
                TableLayout layout = TableLayout.split((int)1, (int)1);
                layout.style().setMargin(10, 10, 2, 10);
                this.treePanel = new JPanel((LayoutManager)layout);
                this.treePanel.setName("treePanel");
                KDTreeView kdTreeView = new KDTreeView(this.getKDTree());
                kdTreeView.setShowButton(false);
                kdTreeView.setTitle(KDDataWizard.getMLS("_", "\u67e5\u8be2\u5bf9\u8c61"));
                this.treePanel.add((Component)kdTreeView, layout.cell(0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.treePanel;
    }

    private void changeContent(Component topComponent, Component bottomComponent) {
        TableLayout tl = TableLayout.split((int)1, (int)1);
        tl.style().setMargin(3, 10, 10, 3);
        KDPanel panelTop = new KDPanel((LayoutManager)tl);
        panelTop.add(topComponent, (Object)tl.cell(0));
        tl = TableLayout.split((int)1, (int)1);
        tl.style().setMargin(3, 3, 10, 10);
        KDPanel paneDown = new KDPanel((LayoutManager)tl);
        paneDown.add(bottomComponent, (Object)tl.cell(0));
        int temp = this.rightSplitPane.getDividerLocation();
        this.rightSplitPane.setTopComponent((Component)panelTop);
        this.rightSplitPane.setBottomComponent((Component)paneDown);
        this.rightSplitPane.setDividerLocation(temp);
    }

    public KDTree getKDTree() {
        if (this.kdTree == null) {
            try {
                this.kdTree = new KDTree((ITreeNode)this.getTreeRootNode());
                this.kdTree.getSelectionModel().setSelectionMode(1);
                this.kdTree.setRootVisible(false);
                this.kdTree.setShowCheckBox(false);
                this.kdTree.setShowsRootHandles(true);
                this.kdTree.getModel().addTreeModelListener(this);
                this.kdTree.addTreeSelectionListener((TreeSelectionListener)this);
                this.kdTree.addTreeExpansionListener((TreeExpansionListener)this);
                ((KingdeeTreeModel)this.kdTree.getModel()).setAsksAllowsChildren(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.kdTree;
    }

    private void initEvents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                KDDataWizard.this.closeDialog(evt);
            }
        });
    }

    public static boolean checkIdentityPrgID(String oriPrgID, ListModel lsm, int selfIndex) {
        for (int i = 0; i < lsm.getSize(); ++i) {
            Object obj;
            if (i == selfIndex || !((obj = lsm.getElementAt(i)) instanceof QueryColumn) || !((QueryColumn)obj).getProgramID().equals(oriPrgID)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIdentiryName(String oriName, ListModel lsm, int selfIndex) {
        for (int i = 0; i < lsm.getSize(); ++i) {
            Object obj;
            if (i == selfIndex || !((obj = lsm.getElementAt(i)) instanceof QueryElement ? ((QueryElement)obj).getName().equals(oriName) : obj instanceof KDDataWizardTreeNode && ((KDDataWizardTreeNode)((Object)obj)).getText().equals(oriName))) continue;
            return false;
        }
        return true;
    }

    public static String getAIdentiryName(String oriName, JList lst, int selfIndex) {
        return KDDataWizard.getAIdentiryName(oriName, lst.getModel(), selfIndex);
    }

    public static String getAIdentiryName(String oriName, ListModel lsm, int selfIndex) {
        int index = 1;
        String retName = oriName;
        boolean bContinue = true;
        block0: do {
            bContinue = false;
            for (int i = 0; i < lsm.getSize(); ++i) {
                if (i == selfIndex) continue;
                Object obj = lsm.getElementAt(i);
                if (obj instanceof QueryElement) {
                    if (!((QueryElement)obj).getName().equals(retName)) continue;
                    retName = oriName + "_" + index++;
                    bContinue = true;
                    continue block0;
                }
                if (!(obj instanceof KDDataWizardTreeNode) || !((KDDataWizardTreeNode)((Object)obj)).getText().equals(retName)) continue;
                retName = oriName + "_" + index++;
                bContinue = true;
                continue block0;
            }
        } while (bContinue);
        return retName;
    }

    public static String getAIdentityPrgID(String oriID, JList lst, int selfIndex) {
        return KDDataWizard.getAIdentityPrgID(oriID, lst.getModel(), selfIndex);
    }

    public static String getAIdentityPrgID(String oriID, ListModel lsm, int selfIndex) {
        int index = 1;
        String retID = oriID;
        boolean bContinue = true;
        block0: do {
            bContinue = false;
            for (int i = 0; i < lsm.getSize(); ++i) {
                Object obj;
                if (i == selfIndex || !((obj = lsm.getElementAt(i)) instanceof QueryColumn) || !((QueryColumn)obj).getProgramID().equals(retID)) continue;
                retID = oriID + index++;
                bContinue = true;
                continue block0;
            }
        } while (bContinue);
        return retID;
    }

    public static boolean checkInvalidInString(String inStr) {
        if (inStr.substring(0, 1).equals("_")) {
            return true;
        }
        boolean bOnlyUnderline = true;
        for (int i = 0; i < inStr.length(); ++i) {
            if (VEC_INVALIDSTRING.contains(inStr.substring(i, i + 1))) {
                return true;
            }
            if (inStr.substring(i, i + 1).equals("_")) continue;
            bOnlyUnderline = false;
        }
        return bOnlyUnderline;
    }

    public boolean checkHasQryTable(KDQuery kdQuery, QueryTable qryTable) {
        return kdQuery.getSubQueryList().contains(qryTable);
    }

    public boolean checkHasQryColumn(KDQuery kdQuery, QueryColumn qryCln) {
        return kdQuery.getColumnList().contains(qryCln);
    }

    public boolean checkTabHasBeenUsedByJoin(KDQuery kdQry, QueryTable qryTab) {
        for (QueryJoin qryJoin : kdQry.getJoinList()) {
            if (!qryTab.equals(qryJoin.getFirstTable()) && !qryTab.equals(qryJoin.getSecondTable())) continue;
            return true;
        }
        return false;
    }

    public boolean checkTabHasBeenUsedByFld(KDQuery kdQry, QueryTable qryTab) {
        Vector vecContain = null;
        for (QueryColumn qryCln : kdQry.getColumnList()) {
            vecContain = KDDataWizard.getFld2TabVector(kdQry, qryCln.getFormula());
            if (vecContain == null || !vecContain.contains(qryTab)) continue;
            return true;
        }
        return false;
    }

    public boolean checkTabHasBeenUsedBySort(KDQuery kdQry, QueryTable qryTab) {
        for (QuerySort qrySort : kdQry.getSortList()) {
            for (QuerySort.SortItem qrySortItem : qrySort.getItemList()) {
                Vector vecContain = KDDataWizard.getFld2TabVector(kdQry, qrySortItem.getColumn().getFormula());
                if (vecContain == null || !vecContain.contains(qryTab)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkTabHasBeenUsedByGroup(KDQuery kdQry, QueryTable qryTab) {
        Vector vecContain = null;
        for (QueryGroup.GroupItem qryGroupItem : kdQry.getGroupList()) {
            vecContain = KDDataWizard.getFld2TabVector(kdQry, qryGroupItem.getColumn().getFormula());
            if (vecContain == null || !vecContain.contains(qryTab)) continue;
            return true;
        }
        return false;
    }

    public boolean checkFldHasBeenUsedByGroup(KDQuery kdQry, QueryColumn qryCln) {
        for (QueryGroup.GroupItem qryGroupItem : kdQry.getGroupList()) {
            if (!qryGroupItem.getColumn().equals(qryCln)) continue;
            return true;
        }
        return false;
    }

    public boolean checkTabHasBeenUsedByParam(KDQuery kdQry, QueryTable qryTab) {
        Vector vecContain = null;
        for (QueryParam qryPara : kdQry.getParamList()) {
            vecContain = KDDataWizard.getFld2TabVector(kdQry, qryPara.getColumn().getFormula());
            if (vecContain == null || !vecContain.contains(qryTab)) continue;
            return true;
        }
        return false;
    }

    public void refreshKDDataWizardTreeNode(KDDataWizardTreeNode note, int count) {
        if (note == null) {
            return;
        }
        if (note.getTreeNodeType() == 11) {
            note.setText(CtrlKDFMessages.getMLS("table", "\u8868") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 12) {
            note.setText(CtrlKDFMessages.getMLS("field", "\u5b57\u6bb5") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 14) {
            note.setText(CtrlKDFMessages.getMLS("filter", "\u8fc7\u6ee4") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 15) {
            note.setText(CtrlKDFMessages.getMLS("sort", "\u6392\u5e8f") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 21) {
            note.setText(CtrlKDFMessages.getMLS("group", "\u5206\u7ec4") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 18) {
            note.setText(CtrlKDFMessages.getMLS("parameter", "\u53c2\u6570") + "(" + count + ")");
        } else if (note.getTreeNodeType() == 13) {
            note.setText(CtrlKDFMessages.getMLS("join", "\u5173\u8054") + "(" + count + ")");
        }
        ((KingdeeTreeUI)this.getKDTree().getUI()).resetSize();
    }

    public void delTreeNode(KDDataWizardTreeNode node) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getKDTree().getModel();
        treeModel.removeNodeFromParent((MutableTreeNode)((Object)node));
    }

    public void addTreeNode(KDDataWizardTreeNode node, KDDataWizardTreeNode parentNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getKDTree().getModel();
        treeModel.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)parentNode), parentNode.getChildCount());
    }

    public void setSelectNode(KDDataWizardTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.getKDTree().scrollPathToVisible(treePath);
        this.getKDTree().expandPath(treePath);
        this.getKDTree().setSelectionPath(treePath);
    }

    private void addDirSingle(Object obj, KDDataWizardTreeNode parentNode, int type) {
        QueryDir dir = (QueryDir)obj;
        KDDataWizardTreeNode treeNodeDirObject = new KDDataWizardTreeNode((Object)dir, type, dir.getName(), (Icon)IMG_DIR);
        if (this.kdTree != null) {
            this.kdTree.addNodeInto((MutableTreeNode)((Object)treeNodeDirObject), (MutableTreeNode)((Object)parentNode));
        } else {
            parentNode.add((MutableTreeNode)((Object)treeNodeDirObject));
        }
    }

    public static void center(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = dialog.getSize();
        dialog.setLocation((dimension.width - dimension1.width) / 2, (dimension.height - dimension1.height) / 2);
    }

    public static String getItemTabName(String strItemName) {
        if (StringUtil.isEmptyString((String)strItemName)) {
            return "";
        }
        int startPos = 0;
        int matchPos = 0;
        int tempPos = 0;
        matchPos = strItemName.indexOf("].[", startPos);
        if (matchPos != -1 && (tempPos = strItemName.lastIndexOf(91, matchPos)) != -1 && tempPos >= startPos) {
            return strItemName.substring(tempPos + 1, matchPos);
        }
        return "";
    }

    public static Vector getFld2TabVector(KDQuery note, String strFormular) {
        if (strFormular.trim().length() <= 0) {
            return null;
        }
        Vector<QueryTable> vecFld2Tab = new Vector<QueryTable>(0);
        HashMap<String, QueryTable> hsTab = new HashMap<String, QueryTable>();
        for (QueryTable qryTab : note.getSubQueryList()) {
            hsTab.put("[" + qryTab.getName() + "]", qryTab);
        }
        int startPos = 0;
        int matchPos = 0;
        int tempPos = 0;
        while ((matchPos = strFormular.indexOf("].[", startPos)) != -1) {
            tempPos = strFormular.lastIndexOf(91, matchPos);
            if (tempPos != -1 && tempPos >= startPos) {
                if (hsTab.containsKey(strFormular.substring(tempPos, matchPos + 1))) {
                    QueryTable qryTab;
                    qryTab = (QueryTable)hsTab.get(strFormular.substring(tempPos, matchPos + 1));
                    if (!vecFld2Tab.contains(qryTab)) {
                        vecFld2Tab.add(qryTab);
                    }
                    startPos = matchPos + 3;
                    continue;
                }
                startPos = matchPos + 3;
                continue;
            }
            startPos = matchPos + 3;
        }
        return vecFld2Tab;
    }

    public static HashMap getFld2TabHashMap(KDQuery note, String strFormular) {
        if (strFormular.trim().length() <= 0) {
            return null;
        }
        HashMap<String, QueryTable> hsTab = new HashMap<String, QueryTable>();
        for (QueryTable qryTab : note.getSubQueryList()) {
            hsTab.put("[" + qryTab.getName() + "]", qryTab);
        }
        int startPos = 0;
        int matchPos = 0;
        int tempPos = 0;
        while (true) {
            String strFldName = "";
            matchPos = strFormular.indexOf("].[", startPos);
            if (matchPos == -1) break;
            tempPos = strFormular.lastIndexOf(91, matchPos);
            if (tempPos != -1 && tempPos >= startPos) {
                if (hsTab.containsKey(strFormular.substring(tempPos, matchPos + 1))) {
                    QueryTable qryTab;
                    qryTab = (QueryTable)hsTab.get(strFormular.substring(tempPos, matchPos + 1));
                    strFldName = strFldName + strFormular.substring(tempPos, matchPos + 1);
                    tempPos = strFormular.indexOf(93, matchPos + 3);
                    if (tempPos != -1) {
                        strFldName = strFldName + strFormular.substring(matchPos + 1, tempPos + 1);
                        startPos = tempPos + 1;
                        continue;
                    }
                    startPos = matchPos + 3;
                    continue;
                }
                startPos = matchPos + 3;
                continue;
            }
            startPos = matchPos + 3;
        }
        return hsTab;
    }

    public static void synTabName(KDQuery note, String orgName, String newName, boolean bTab) {
        String strTmp;
        String newName2;
        String orgName2;
        String newName1;
        String orgName1;
        Pattern p = null;
        Matcher m = null;
        if (bTab) {
            orgName1 = "\\[" + orgName + "\\].";
            newName1 = "\\[" + newName + "\\].";
            orgName2 = orgName + ".";
            newName2 = newName + ".";
        } else {
            orgName1 = ".\\[" + orgName + "\\]";
            newName1 = ".\\[" + newName + "\\]";
            orgName2 = "." + orgName;
            newName2 = "." + newName;
        }
        for (QueryColumn qryCln : note.getColumnList()) {
            p = Pattern.compile(orgName1);
            strTmp = qryCln.getFormula();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName1);
            qryCln.setFormula(strTmp);
            p = Pattern.compile(orgName2);
            strTmp = qryCln.getFormula4Sql();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName2);
            qryCln.setFormula4Sql(strTmp);
        }
        for (QueryFilter qryFilter : note.getFilterList()) {
            p = Pattern.compile(orgName1);
            strTmp = qryFilter.getFormula();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName1);
            qryFilter.setFormula(strTmp);
            p = Pattern.compile(orgName2);
            strTmp = qryFilter.getFormula4Sql();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName2);
            qryFilter.setFormula4Sql(strTmp);
        }
        for (QuerySort qrySort : note.getSortList()) {
            for (QuerySort.SortItem qrySortItem : qrySort.getItemList()) {
                p = Pattern.compile(orgName1);
                strTmp = qrySortItem.getColumn().getFormula();
                m = p.matcher(strTmp);
                strTmp = m.replaceAll(newName1);
                qrySortItem.getColumn().setFormula(strTmp);
                p = Pattern.compile(orgName2);
                strTmp = qrySortItem.getColumn().getFormula4Sql();
                m = p.matcher(strTmp);
                strTmp = m.replaceAll(newName2);
                qrySortItem.getColumn().setFormula4Sql(strTmp);
            }
        }
        for (QueryParam qryParam : note.getParamList()) {
            p = Pattern.compile(orgName1);
            strTmp = qryParam.getColumn().getFormula();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName1);
            qryParam.getColumn().setFormula(strTmp);
            p = Pattern.compile(orgName2);
            strTmp = qryParam.getColumn().getFormula4Sql();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName2);
            qryParam.getColumn().setFormula4Sql(strTmp);
        }
        for (QueryJoin qryJoin : note.getJoinList()) {
            p = Pattern.compile(orgName1);
            strTmp = qryJoin.getFormula();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName1);
            qryJoin.setFormula(strTmp);
            p = Pattern.compile(orgName2);
            strTmp = qryJoin.getFormula4Sql();
            m = p.matcher(strTmp);
            strTmp = m.replaceAll(newName2);
            qryJoin.setFormula4Sql(strTmp);
        }
    }

    public static void center(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = window.getSize();
        window.setLocation((dimension.width - dimension1.width) / 2, (dimension.height - dimension1.height) / 2);
    }

    private void initData() {
        if (this.treeRootNode == null) {
            this.treeRootNode = new KDDataWizardTreeNode(null, 0, "root");
        }
        this.treeRootNode.removeAllChildren();
        if (this.treeSystemNode == null) {
            this.treeSystemNode = new KDDataWizardTreeNode((Object)this.dataManager.getDirSystem(), 26, this.dataManager.getDirSystem().getName(), (Icon)IMG_DIR);
        }
        this.treeSystemNode.removeAllChildren();
        if (this.treeCustomerNode == null) {
            this.treeCustomerNode = new KDDataWizardTreeNode((Object)this.dataManager.getDirCustomer(), 25, this.dataManager.getDirCustomer().getName(), (Icon)IMG_DIR);
        }
        this.treeCustomerNode.removeAllChildren();
        this.treeRootNode.add((MutableTreeNode)((Object)this.treeCustomerNode));
        if (this.dataManager == null) {
            return;
        }
        this.addObj2CustomerNote();
    }

    private void addObj2CustomerNote() {
        Object obj = null;
        Iterator it = this.dataManager.getDirCustomer().iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj instanceof QueryDir) {
                this.addDir(obj, this.treeCustomerNode, 22);
                continue;
            }
            if (!(obj instanceof KDBasicQuery)) continue;
            this.addNode(obj, this.treeCustomerNode);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    private void addDir(Object obj, KDDataWizardTreeNode parentNode, int type) {
        QueryDir dir = (QueryDir)obj;
        KDDataWizardTreeNode treeNodeDirObject = new KDDataWizardTreeNode((Object)dir, type, dir.getName(), (Icon)IMG_DIR);
        parentNode.add((MutableTreeNode)((Object)treeNodeDirObject));
        Iterator it = dir.iterator();
        Object objTemp = null;
        while (it.hasNext()) {
            objTemp = it.next();
            if (objTemp instanceof QueryDir) {
                this.addDir(objTemp, treeNodeDirObject, type);
                continue;
            }
            if (!(objTemp instanceof KDBasicQuery)) continue;
            this.addNode(objTemp, treeNodeDirObject);
        }
    }

    public KDDataManager getDataManager() {
        return this.dataManager;
    }

    public void setDataManager(KDDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public ResultPanel getObjBottomResult() {
        return this.objBottomResult;
    }

    private void addNode(KDBasicQuery obj, KDDataWizardTreeNode parentNode) {
        KDQuery kdQry = null;
        if (obj instanceof KDQuery) {
            kdQry = (KDQuery)obj;
        }
        String strType = KDDataWizard.getQueryTypeString(obj.getQueryType());
        KDDataWizardTreeNode treeNodeQueryObject = new KDDataWizardTreeNode((Object)obj, 100, obj.getName() + strType, (Icon)IMG_QUERY);
        if (kdQry != null) {
            switch (kdQry.getQueryType()) {
                case 1: {
                    treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 11, CtrlKDFMessages.getMLS("table", "\u8868") + "(" + kdQry.getSubQueryList().size() + ")", IMG_TABLE, false)));
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 10, CtrlKDFMessages.getMLS("source", "\u6765\u6e90"), IMG_TABLE, false)));
                    break;
                }
            }
        }
        if (kdQry != null && kdQry.getQueryType() == 1) {
            treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 13, CtrlKDFMessages.getMLS("join", "\u5173\u8054") + "(" + kdQry.getJoinList().size() + ")", IMG_JOIN, false)));
        }
        treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(obj, 12, CtrlKDFMessages.getMLS("field", "\u5b57\u6bb5") + "(" + obj.getColumnList().size() + ")", IMG_FIELD, false)));
        if (kdQry != null && kdQry.getQueryType() == 1) {
            treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 21, CtrlKDFMessages.getMLS("group", "\u5206\u7ec4") + "(" + kdQry.getGroupList().size() + ")", IMG_GROUP, false)));
            treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 15, CtrlKDFMessages.getMLS("sort", "\u6392\u5e8f") + "(" + kdQry.getSortList().size() + ")", IMG_SORT, false)));
            treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 14, CtrlKDFMessages.getMLS("filter", "\u8fc7\u6ee4") + "(" + kdQry.getFilterList().size() + ")", IMG_FILTER, false)));
        }
        if (kdQry != null) {
            treeNodeQueryObject.add((MutableTreeNode)((Object)new KDDataWizardTreeNode(kdQry, 18, CtrlKDFMessages.getMLS("parameter", "\u53c2\u6570") + "(" + kdQry.getParamList().size() + ")", IMG_PARAMETER, false)));
        }
        if (this.kdTree != null) {
            this.kdTree.addNodeInto((MutableTreeNode)((Object)treeNodeQueryObject), (MutableTreeNode)((Object)parentNode));
        } else {
            parentNode.add((MutableTreeNode)((Object)treeNodeQueryObject));
        }
    }

    private void handleException(Throwable ivjExc) {
        logger.error((Object)"err", ivjExc);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        KDDataWizardTreeNode node = (KDDataWizardTreeNode)((Object)this.getKDTree().getLastSelectedPathComponent());
        if (node == null) {
            return;
        }
        try {
            if (node.getTreeNodeType() == 10) {
                Object pNodeInfo;
                KDDataWizardTreeNode pNode = (KDDataWizardTreeNode)((Object)node.getParent());
                if (pNode != null && (pNodeInfo = pNode.getUserObject()) instanceof KDBasicQuery) {
                    KDBasicQuery bqry = (KDBasicQuery)pNodeInfo;
                    switch (bqry.getQueryType()) {
                        case 0: {
                            ContentHorizolAlignPanel objbosQuery = new ContentHorizolAlignPanel(node.getTreeNodeType(), node, this);
                            this.objBottomResult = new ResultPanel(19, node, this);
                            this.changeContent(objbosQuery, this.objBottomResult);
                            this.objBottomResult.getTxtAreaResult().setText(null);
                            objbosQuery.setTitle(KDDataWizard.getMLS("bosQry", "\u6570\u636e\u6765\u6e90\u8bbe\u7f6e"));
                            this.objBottomResult.setTitle(KDDataWizard.getMLS("printPreview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
                            break;
                        }
                        case 2: 
                        case 3: {
                            ContentEntitySource entySourceQuery = new ContentEntitySource(node.getTreeNodeType(), node, this);
                            this.objBottomResult = new ResultPanel(19, node, this);
                            this.changeContent(entySourceQuery, this.objBottomResult);
                            this.objBottomResult.getTxtAreaResult().setText(null);
                            entySourceQuery.setTitle(KDDataWizard.getMLS("sourceQuery", "\u5b9e\u4f53\u6570\u636e\u6765\u6e90\u8bbe\u7f6e"));
                            this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
                            break;
                        }
                        case 4: {
                            ContentObjectSource objSourceQuery = new ContentObjectSource(node.getTreeNodeType(), node, this);
                            this.objBottomResult = new ResultPanel(19, node, this);
                            this.changeContent(objSourceQuery, this.objBottomResult);
                            this.objBottomResult.getTxtAreaResult().setText(null);
                            objSourceQuery.setTitle(KDDataWizard.getMLS("sourceQuery", "\u5bf9\u8c61\u6570\u636e\u6765\u6e90\u8bbe\u7f6e"));
                            this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
                            break;
                        }
                    }
                }
            } else if (node.getTreeNodeType() == 11) {
                ContentHorizolAlignPanel objTabQuery = new ContentHorizolAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objTabQuery, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objTabQuery.setTitle(KDDataWizard.getMLS("tabQry", "\u8868\u548c\u5b50\u67e5\u8be2\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 12) {
                KDDataWizardTreeNode pNode = (KDDataWizardTreeNode)((Object)node.getParent());
                if (pNode != null) {
                    Object pNodeInfo = pNode.getUserObject();
                    if (pNodeInfo instanceof KDQuery && (((KDQuery)pNodeInfo).getQueryType() == 2 || ((KDQuery)pNodeInfo).getQueryType() == 3 || ((KDQuery)pNodeInfo).getQueryType() == 4)) {
                        ContentVerticalAlignPanel objField = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                        this.objBottomResult = new ResultPanel(19, node, this);
                        this.changeContent(objField, this.objBottomResult);
                        this.objBottomResult.getTxtAreaResult().setText(null);
                        objField.setTitle(KDDataWizard.getMLS("fields", "\u5b57\u6bb5\u5bf9\u8c61\u7ba1\u7406"));
                        this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
                    } else {
                        ContentHorizolAlignPanel objField = new ContentHorizolAlignPanel(node.getTreeNodeType(), node, this);
                        this.objBottomResult = new ResultPanel(19, node, this);
                        this.changeContent(objField, this.objBottomResult);
                        this.objBottomResult.getTxtAreaResult().setText(null);
                        objField.setTitle(KDDataWizard.getMLS("fields", "\u5b57\u6bb5\u5bf9\u8c61\u7ba1\u7406"));
                        this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
                    }
                }
            } else if (node.getTreeNodeType() == 21) {
                ContentHorizolAlignPanel objGroup = new ContentHorizolAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objGroup, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objGroup.setTitle(KDDataWizard.getMLS("groups", "\u5206\u7ec4\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 26) {
                ContentVerticalAlignPanel objRoot = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objRoot, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objRoot.setTitle(KDDataWizard.getMLS("datasources", "\u6570\u636e\u6e90\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 23 || node.getTreeNodeType() == 22 || node.getTreeNodeType() == 25) {
                ContentVerticalAlignPanel objRoot = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objRoot, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objRoot.setTitle(KDDataWizard.getMLS("querys", "\u67e5\u8be2\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 18) {
                ContentVerticalAlignPanel objParameter = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objParameter, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objParameter.setTitle(KDDataWizard.getMLS("parameters", "\u53c2\u6570\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 15) {
                ContentVerticalAlignPanel objSort = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objSort, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objSort.setTitle(KDDataWizard.getMLS("sorts", "\u6392\u5e8f\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 13) {
                ContentVerticalAlignPanel objJion = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objJion, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objJion.setTitle(KDDataWizard.getMLS("joins", "\u5173\u8054\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 14) {
                ContentVerticalAlignPanel objFilter = new ContentVerticalAlignPanel(node.getTreeNodeType(), node, this);
                this.objBottomResult = new ResultPanel(19, node, this);
                this.changeContent(objFilter, this.objBottomResult);
                this.objBottomResult.getTxtAreaResult().setText(null);
                objFilter.setTitle(KDDataWizard.getMLS("filters", "\u8fc7\u6ee4\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            } else if (node.getTreeNodeType() == 100) {
                KDBasicQuery kdBasicQry = (KDBasicQuery)node.getUserObject();
                this.objBottomResult = new ResultPanel(19, node, this);
                ResultPanel objResult = new ResultPanel(node.getTreeNodeType(), node, this, kdBasicQry instanceof KDQuery);
                this.changeContent(objResult, this.objBottomResult);
                if (!(kdBasicQry instanceof KDQuery)) {
                    this.objBottomResult.getTxtAreaResult().setText(null);
                }
                objResult.setTitle(KDDataWizard.getMLS("query", "\u67e5\u8be2\u5bf9\u8c61\u7ba1\u7406"));
                this.objBottomResult.setTitle(KDDataWizard.getMLS("preview", "\u5bf9\u8c61\u6587\u672c\u9884\u89c8"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public KDDataWizardTreeNode getTreeSystemNode() {
        return this.treeSystemNode;
    }

    public void setTreeSystemNode(KDDataWizardTreeNode treeSystemNode) {
        this.treeSystemNode = treeSystemNode;
    }

    public KDDataWizardTreeNode getTreeCustomerNode() {
        return this.treeCustomerNode;
    }

    public void setTreeCustomerNode(KDDataWizardTreeNode treeCustomerNode) {
        this.treeCustomerNode = treeCustomerNode;
    }

    public KDDataWizardTreeNode getTreeRootNode() {
        return this.treeRootNode;
    }

    public void setTreeRootNode(KDDataWizardTreeNode treeRootNode) {
        this.treeRootNode = treeRootNode;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        KDDataWizardTreeNode node = (KDDataWizardTreeNode)((Object)event.getPath().getLastPathComponent());
        if (node.getChildCount() > 0) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj instanceof QueryDir) {
            QueryDir dir = (QueryDir)obj;
            Iterator it = dir.iterator();
            while (it.hasNext()) {
                Object objTemp = it.next();
                if (objTemp instanceof QueryDir) {
                    this.addDirSingle(objTemp, node, 23);
                    continue;
                }
                if (!(objTemp instanceof KDBasicQuery)) continue;
                this.addNode((KDBasicQuery)objTemp, node);
            }
        }
    }

    private static String getMLS(String key, String defaultValue) {
        return CtrlKDFMessages.getMLS(key, defaultValue);
    }

    public static String getQueryTypeString(int queryType) {
        switch (queryType) {
            case 0: {
                return "(BOS)";
            }
            case 1: {
                return " (DB)";
            }
            case 2: {
                return " (CSV)";
            }
            case 3: {
                return " (XML)";
            }
            case 4: {
                return " (OBJ)";
            }
        }
        return "";
    }

    public static int msgBox(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return MessageDialog.show((Component)parentComponent, (Object)message, (String)title, (int)optionType, (int)messageType);
    }

    static {
        int i;
        logger = LogUtil.getPackageLogger(KDDataWizard.class);
        DEFAULT_TEXTAREA_BACKCOLOR = Color.decode("#EFEFED");
        DEFAULT_BORDERCOLOR = Color.decode("#A2A2A2");
        IMG_QUERY = Icons.getIcon("datawizard/tbtn_wizardquery.gif");
        IMG_TABLE = Icons.getIcon("datawizard/tbtn_wizardtable.gif");
        IMG_FIELD = Icons.getIcon("datawizard/tbtn_wizardfield.gif");
        IMG_JOIN = Icons.getIcon("datawizard/tbtn_wizardjoin.gif");
        IMG_SORT = Icons.getIcon("datawizard/tbtn_wizardsort.gif");
        IMG_GROUP = Icons.getIcon("datawizard/tbtn_wizardgroup.gif");
        IMG_FILTER = Icons.getIcon("datawizard/tbtn_wizardfilter.gif");
        IMG_PARAMETER = Icons.getIcon("datawizard/tbtn_wizardparameter.gif");
        IMG_DATASOURCE = Icons.getIcon("datawizard/tbtn_wizarddatasource.gif");
        IMG_ON = Icons.getIcon("datawizard/tbtn_wizardon.gif");
        IMG_OFF = Icons.getIcon("datawizard/tbtn_wizardoff.gif");
        IMG_ASC = Icons.getIcon("datawizard/tbtn_wizardasc.gif");
        IMG_DESC = Icons.getIcon("datawizard/tbtn_wizarddesc.gif");
        IMG_DIR = Icons.getIcon("datawizard/tbtn_wizarddir.gif");
        INVALID_STRING = new String[]{"~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "+", "=", "|", "\\", "{", "}", "[", "]", ";", ":", "'", "\"", " ", "<", ">", ",", ".", "?", "/"};
        VALID_STRING = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        VEC_VALIDSTRING = new Vector(VALID_STRING.length);
        VEC_INVALIDSTRING = new Vector(INVALID_STRING.length);
        for (i = 0; i < VALID_STRING.length; ++i) {
            VEC_VALIDSTRING.add(VALID_STRING[i]);
        }
        for (i = 0; i < INVALID_STRING.length; ++i) {
            VEC_INVALIDSTRING.add(INVALID_STRING[i]);
        }
    }
}

