/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.excel;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.excel.model.PrintSetupWrapper;
import com.kingdee.cosmic.ctrl.kdf.form.Row;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import java.awt.Color;
import java.awt.Image;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public abstract class AbstractDataWrapper {
    private static final Logger logger = LogUtil.getPackageLogger(AbstractDataWrapper.class);
    public static final String MID_END = ")";
    public static final String MID_PRFIX = "mid(\"";
    public static final String STR_SEPERATOR = "\"&\"";
    protected int _sheetCount;
    protected int _currentSheetIndex;
    static MergeBlock block = new MergeBlock(0, 0, 0, 0);
    static EmbedObject eo = new EmbedObject();
    public static final int UNKONW_ROW_COUNT = -1;
    public static final short CELL_TYPE_NUMERIC = 0;
    public static final short CELL_TYPE_STRING = 1;
    public static final short CELL_TYPE_FORMULA = 2;
    public static final short CELL_TYPE_BOOLEAN = 4;
    public static final short CELL_TYPE_ERROR = 5;
    public static final short CELL_TYPE_BLANK = 3;
    public static final short CELL_TYPE_DATE = 6;
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_FORMULA_SPLIT = "_@_";
    protected boolean _exportCustomFormulas = false;
    protected boolean _exportFormula = true;
    protected boolean _exportMergeBlocks = true;
    protected boolean _exportHideRows = false;
    protected boolean _exportHideCols = false;
    protected boolean _exportSelect = false;
    protected boolean _showValue = true;
    private static final int DEFAULT_PAGE_SIZE = 50;
    private boolean isExportBigData = false;
    private boolean isExportProtect = true;
    private boolean isMergeHeadRowsExport = false;
    private boolean isBooleanValueToStrOnExport = false;

    public AbstractDataWrapper(int sheetCount) {
        this._sheetCount = sheetCount;
        this._currentSheetIndex = 0;
    }

    public abstract Object valueAt(int var1, int var2);

    public String textAt(int row, int col) {
        return null;
    }

    public HyperLink hyperLinkAt(int row, int col) {
        return null;
    }

    public PrintSetupWrapper getPrintSetup(String name) throws SyntaxErrorException {
        return null;
    }

    public Color getSheetTabColor(String sheetName) throws SyntaxErrorException {
        return null;
    }

    public boolean isExportGridLine() {
        return true;
    }

    public abstract short valueTypeAt(int var1, int var2);

    public abstract boolean isRowEnd(int var1);

    public abstract boolean isColEnd(int var1);

    public abstract int sheetCount();

    public abstract int rowCount();

    public abstract int colCount();

    public abstract int rowHeightAt(int var1);

    public abstract int colWidthAt(int var1);

    public abstract ShareStyleAttributes SSAAt(int var1, int var2);

    public abstract MergeBlock getMergeBlock(int var1, int var2);

    public abstract void dataSourceMemeryCallback(int var1, int var2);

    public abstract String sheetName(int var1);

    public abstract boolean isHideRow(int var1);

    public abstract boolean isHideCol(int var1);

    public boolean isHideSheet(int index) {
        return false;
    }

    public int getActiveSheetIndex() {
        return 0;
    }

    public int getFirstVisibleSheetIndex() {
        return 1;
    }

    public abstract boolean isBookProtected();

    public abstract boolean isCurrentSheetProtected();

    public abstract int getEmbedObjectsCount();

    public abstract EmbedObject getEmbedObject(int var1);

    protected abstract String getFormula(int var1, int var2);

    public String booleanValue(Boolean bool) {
        String result = String.valueOf(bool);
        if (this.isBooleanValueToStrOnExport) {
            result = bool.equals(Boolean.TRUE) ? CtrlKDFMessages.getMLS("BooleanValueTrue", "\u662f") : CtrlKDFMessages.getMLS("BooleanValueFalse", "\u5426");
        }
        return result;
    }

    public void setExportFormula(boolean exportFormula) {
        this._exportFormula = exportFormula;
    }

    public boolean isExportFormula() {
        return this._exportFormula;
    }

    public final void setExportMergeBlocks(boolean exportMergeBlocks) {
        this._exportMergeBlocks = exportMergeBlocks;
    }

    public final boolean isExportMergeBlocks() {
        return this._exportMergeBlocks;
    }

    public final void setExportCustomerFomulas(boolean exportCustomerFormulas) {
        this._exportCustomFormulas = exportCustomerFormulas;
    }

    public final boolean isExportCustomerFormulas() {
        return this._exportCustomFormulas;
    }

    public final void setExportHideRows(boolean exportHideRows) {
        this._exportHideRows = exportHideRows;
    }

    public final boolean isExportHideRows() {
        return this._exportHideRows;
    }

    public final void setExportHideCols(boolean exportHideCols) {
        this._exportHideCols = exportHideCols;
    }

    public final boolean isExportHideCols() {
        return this._exportHideCols;
    }

    public final void setExportSelect(boolean exportSelect) {
        this._exportSelect = exportSelect;
    }

    public final boolean isExportSelect() {
        return this._exportSelect;
    }

    public final void setShowValue(boolean showValue) {
        this._showValue = showValue;
    }

    public final boolean isShowValue() {
        return this._showValue;
    }

    public boolean isExportBigData() {
        return this.isExportBigData;
    }

    public void setExportBigData(boolean isExportBigData) {
        this.isExportBigData = isExportBigData;
    }

    public boolean isMergeHeadRowsExport() {
        return this.isMergeHeadRowsExport;
    }

    public void setMergeHeadRowsExport(boolean isMergeHeadRowsExport) {
        this.isMergeHeadRowsExport = isMergeHeadRowsExport;
    }

    protected final String convertFormulaSpecialString(String formula) {
        formula = formula.replace(KD_DOUBLE_COMMA, KD_SINGLE_COMMA);
        formula = formula.replace("\"", KD_DOUBLE_COMMA);
        return formula;
    }

    public abstract String formulaAt(int var1, int var2);

    public void configSourceRepaint(boolean isOpen) {
    }

    protected static short getValueType(Object value) {
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Number) {
            return 0;
        }
        if (value instanceof Date || value instanceof Calendar) {
            return 0;
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                return 3;
            }
            if (((String)value).charAt(0) == '0') {
                return 1;
            }
            if (StringUtil.isExcelNumber((String)((String)value))) {
                try {
                    Variant.getBufferedDecimal((String)value.toString());
                    return 0;
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
            }
            return 1;
        }
        if (value instanceof Image) {
            return 3;
        }
        if (value instanceof Icon) {
            return 3;
        }
        if (value != null) {
            return 1;
        }
        return 3;
    }

    public int getSheetCount() {
        return this._sheetCount;
    }

    public int getCurrentSheetIndex() {
        return this._currentSheetIndex;
    }

    public void setCurrentSheetIndex(int currentSheetIndex) {
        this._currentSheetIndex = currentSheetIndex;
    }

    protected static MergeBlock getMergeBlock(int row, int col, int row2, int col2) {
        AbstractDataWrapper.block.row = row;
        AbstractDataWrapper.block.col = col;
        AbstractDataWrapper.block.row2 = row2;
        AbstractDataWrapper.block.col2 = col2;
        return block;
    }

    protected static EmbedObject getEmbedObject(byte[] datas, int row, int col, int row2, int col2, int sheetIndex) {
        AbstractDataWrapper.eo.imageDatas = datas;
        AbstractDataWrapper.eo.row = row;
        AbstractDataWrapper.eo.row2 = row2;
        AbstractDataWrapper.eo.col = col;
        AbstractDataWrapper.eo.col2 = col2;
        AbstractDataWrapper.eo.sheetIndex = sheetIndex;
        return eo;
    }

    protected static EmbedObject getEmbedObject(byte[] datas, int dx1, int dy1, int dx2, int dy2, int row, int col, int row2, int col2, int sheetIndex) {
        EmbedObject eo = AbstractDataWrapper.getEmbedObject(datas, row, col, row2, col2, sheetIndex);
        eo.dx1 = dx1;
        eo.dy1 = dy1;
        eo.dx2 = dx2;
        eo.dy2 = dy2;
        return eo;
    }

    @Deprecated
    public void setGroupRow(XSSFSheet sheet, XSSFRow xRow) {
    }

    @Deprecated
    public void setGroupCol(Sheet sheet, int colNum) {
    }

    public void addGroupRow(Sheet sheet, Row row, int rowIndex) {
    }

    public static CTWorksheet getCtWorksheet(Sheet sheet) {
        CTWorksheet ctWorkbook = null;
        try {
            Field field = sheet.getClass().getDeclaredField("_sh");
            ReflectUtil.makeAccessible((Field)field);
            XSSFSheet xssfSheet = (XSSFSheet)field.get(sheet);
            ctWorkbook = xssfSheet.getCTWorksheet();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return ctWorkbook;
    }

    public void setOutlineGroupDir(XSSFSheet sheet) {
    }

    public KDSSheetPrintSetup getPrintSetUp() {
        return null;
    }

    public void addPrintSetup(Sheet xssfSheet) {
    }

    public String getPrintArea() {
        return null;
    }

    public String getPassWd() {
        return null;
    }

    public int getExportPageRowCount() {
        return 50;
    }

    public abstract int getTopGroupColIndex();

    public abstract String getCellValue(int var1, int var2);

    public abstract int getLastGroupColIndex();

    public boolean isGroupCol(int col) {
        return true;
    }

    public boolean isMergeCol(int col) {
        return true;
    }

    public boolean isExportProtect() {
        return this.isExportProtect;
    }

    public void setExportProtect(boolean isExportProtect) {
        this.isExportProtect = isExportProtect;
    }

    public boolean isExportHeadRow(int curRowNum) {
        return false;
    }

    public int getHeadNumber() {
        return 0;
    }

    public boolean isShowHoriLines() {
        return true;
    }

    public boolean isShowVertLines() {
        return true;
    }

    public void addGroupInfo(Sheet sheet) {
    }

    public boolean hasGroupInfo() {
        return true;
    }

    public int setRowOutLineLevel(SXSSFRow xrow, CTWorksheet ctWorksheet, int maxGroupLevel, int outLineGroupLevel) {
        int result = 0;
        try {
            Method m = xrow.getClass().getDeclaredMethod("setOutlineLevel", Integer.TYPE);
            ReflectUtil.makeAccessible((Method)m);
            m.invoke((Object)xrow, outLineGroupLevel);
            result = Math.max(maxGroupLevel, outLineGroupLevel);
            CTSheetFormatPr pr = ctWorksheet.isSetSheetFormatPr() ? ctWorksheet.getSheetFormatPr() : ctWorksheet.addNewSheetFormatPr();
            pr.setOutlineLevelRow((short)result);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return result;
    }

    public void addFreezeLine(Sheet xssfSheet) {
    }

    public void addProtection(Sheet xssfSheet) {
    }

    public void setSheetView(Sheet xssfSheet) {
    }

    public static class EmbedObject {
        byte[] imageDatas;
        int row;
        int col;
        int row2;
        int col2;
        int sheetIndex;
        int dx1 = 1023;
        int dy1 = 255;
        int dx2 = 0;
        int dy2 = 0;

        private EmbedObject() {
        }

        public byte[] getImageDatas() {
            return this.imageDatas;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow2() {
            return this.row2;
        }

        public int getCol2() {
            return this.col2;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public int getDx1() {
            return this.dx1;
        }

        public int getDy1() {
            return this.dy1;
        }

        public int getDx2() {
            return this.dx2;
        }

        public int getDy2() {
            return this.dy2;
        }
    }

    public static class MergeBlock {
        int row;
        int col;
        int row2;
        int col2;
        private String group;
        private static final String DEFAULT_GROUP_STRING = "";

        private MergeBlock(int row, int col, int row2, int col2) {
            this.row = row;
            this.col = col;
            this.row2 = row2;
            this.col2 = col2;
            this.group = DEFAULT_GROUP_STRING;
        }

        private MergeBlock(int row, int col, int row2, int col2, String group) {
            this.row = row;
            this.col = col;
            this.row2 = row2;
            this.col2 = col2;
            this.group = group;
        }

        public boolean contains(int arow, int acol) {
            return arow >= this.row && arow <= this.row2 && acol >= this.col && acol <= this.col2;
        }

        public boolean contains(int arow1, int acol1, int arow2, int acol2) {
            return arow1 >= this.row && arow1 <= this.row2 && acol1 >= this.col && acol1 <= this.col2 && arow2 >= this.row && arow2 <= this.row2 && acol2 >= this.col && acol2 <= this.col2;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow2() {
            return this.row2;
        }

        public int getCol2() {
            return this.col2;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public void setRow2(int row2) {
            this.row2 = row2;
        }

        public void setCol2(int col2) {
            this.col2 = col2;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public MergeBlock merge(MergeBlock block) {
            MergeBlock newBlock = new MergeBlock(0, 0, 0, 0, this.group);
            newBlock.setCol(this.col < block.getCol() ? this.col : block.getCol());
            newBlock.setCol2(this.col2 > block.getCol2() ? this.col2 : block.getCol2());
            newBlock.setRow(this.row < block.getRow() ? this.row : block.getRow());
            newBlock.setRow2(this.row2 > block.getRow2() ? this.row2 : block.getRow2());
            return newBlock;
        }

        public boolean equals(Object b) {
            if (null == b) {
                return false;
            }
            if (this.getClass() != b.getClass()) {
                return false;
            }
            MergeBlock block = (MergeBlock)b;
            return this.col == block.getCol() && this.col2 == block.getCol2() && this.row == block.getRow() && this.row2 == block.getRow2();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("x1=").append(this.row).append(" y1=").append(this.col).append(" x2=").append(this.row2).append(" y2=").append(this.col2).append(" group=").append(this.group);
            return sb.toString();
        }

        public MergeBlock(MergeBlock block) {
            this.row = block.row;
            this.col = block.col;
            this.row2 = block.row2;
            this.col2 = block.col2;
            this.group = block.group;
        }
    }
}

