/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.excel.ui;

import com.kingdee.cosmic.ctrl.common.CtrlUIEnv;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.EventQueue;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.ExportDialog;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.cosmic.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.cosmic.ctrl.swing.util.JVM;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Excel2007ExportController {
    private static final Logger logger = LogUtil.getPackageLogger(Excel2007ExportController.class);
    static ExportDialog dialog;
    static final boolean isSystemTraySupported;

    public static void export(String filePath, AbstractDataWrapper dataSource) {
        Excel2007ExportController.export(filePath, dataSource, true);
    }

    public static final void export(String filePath, AbstractDataWrapper dataSource, boolean showExportDialog) {
        Excel2007ExportController.export(filePath, dataSource, showExportDialog, null);
    }

    public static final void export(final String filePath, final AbstractDataWrapper dataSource, final boolean showExportDialog, final ExportListener[] listeners) {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w instanceof Dialog) {
            w = SwingUtilities.getWindowAncestor(w);
        }
        dialog = w instanceof Dialog ? new ExportDialog(false, (Dialog)w) : new ExportDialog(false, (Frame)w);
        if (showExportDialog) {
            dialog.show();
        }
        Thread t = new Thread("excel2007 export thread exporting :" + filePath){

            @Override
            public void run() {
                if (isSystemTraySupported && showExportDialog) {
                    Excel2007ExportController.addSystemTray(dialog);
                }
                EventQueue queue = new EventQueue();
                try {
                    if (showExportDialog) {
                        Excel2007ExportController.dialog.progressPane.close.setText("open file!");
                        Excel2007ExportController.dialog.progressPane.open = true;
                        queue.registListener(dialog);
                    }
                    if (listeners != null) {
                        int len = listeners.length;
                        for (int i = 0; i < len; ++i) {
                            queue.registListener(listeners[i]);
                        }
                    }
                    if (dataSource.isExportBigData()) {
                        Excel2007ExportController.BigDataExportInterface(filePath, dataSource, queue);
                    } else {
                        Excel2007ExportController.ExportInterface(filePath, dataSource, queue);
                    }
                }
                catch (Exception ex) {
                    Excel2007ExportController.dialog.progressPane.close.setText("close dialog!");
                    Excel2007ExportController.dialog.progressPane.open = false;
                    queue.complete(new ExportEvent(ExportEvent.STEP_NAME_ERROR, "error export aborted! cause by : " + ex.getMessage()));
                    dialog.toFront();
                    logger.error((Object)"err", (Throwable)ex);
                }
            }
        };
        if (!showExportDialog) {
            t.start();
        } else {
            Excel2007ExportController.dialog.configPane.showValue.setSelected(dataSource.isShowValue());
            Excel2007ExportController.dialog.configPane.exportSelect.setSelected(dataSource.isExportSelect());
            Excel2007ExportController.dialog.configPane.exportMergeBlocks.setSelected(dataSource.isExportMergeBlocks());
            Excel2007ExportController.dialog.configPane.exportHideRows.setSelected(dataSource.isExportHideRows());
            Excel2007ExportController.dialog.configPane.exportHideCols.setSelected(dataSource.isExportHideCols());
            Excel2007ExportController.dialog.configPane.exportFormula.setSelected(dataSource.isExportFormula());
            Excel2007ExportController.dialog.configPane.exportCustomFormulas.setSelected(dataSource.isExportCustomerFormulas());
            Excel2007ExportController.dialog.exportThread = t;
            Excel2007ExportController.dialog.datas = dataSource;
        }
    }

    private static void addSystemTray(final ExportDialog dialog) {
        try {
            Class<?> SystemTrayClass = Class.forName("java.awt.SystemTray");
            if (((Boolean)SystemTrayClass.getMethod("isSupported", null).invoke(null, null)).booleanValue()) {
                Object tray = SystemTrayClass.getMethod("getSystemTray", null).invoke(null, null);
                Image image = Toolkit.getDefaultToolkit().getImage("C:\\excel.png");
                final Object trayIcon = Class.forName("java.awt.TrayIcon").getConstructor(Image.class, String.class).newInstance(image, "export excel2007");
                trayIcon.getClass().getDeclaredMethod("setImageAutoSize", Boolean.TYPE).invoke(trayIcon, Boolean.TRUE);
                if (dialog != null) {
                    dialog.trayIcon = trayIcon;
                }
                trayIcon.getClass().getMethod("addActionListener", ActionListener.class).invoke(trayIcon, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (dialog != null) {
                            dialog.toFront();
                        }
                    }
                });
                trayIcon.getClass().getMethod("addMouseListener", MouseListener.class).invoke(trayIcon, new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.setSource(dialog);
                        if (e.getClickCount() == 1) {
                            try {
                                Field f = Class.forName("java.awt.TrayIcon$MessageType").getDeclaredFields()[3];
                                ReflectUtil.makeAccessible((Field)f);
                                trayIcon.getClass().getMethod("displayMessage", String.class, String.class, Class.forName("java.awt.TrayIcon$MessageType")).invoke(trayIcon, "tip", "export mission is running,you can reshow exporting dialog by double click here!", f.get(null));
                            }
                            catch (InvocationTargetException ex) {
                                logger.error((Object)"err", (Throwable)ex);
                            }
                            catch (IllegalAccessException ex) {
                                logger.error((Object)"err", (Throwable)ex);
                            }
                            catch (NoSuchMethodException ex) {
                                logger.error((Object)"err", (Throwable)ex);
                            }
                            catch (ClassNotFoundException ex) {
                                logger.error((Object)"err", (Throwable)ex);
                            }
                        }
                    }
                });
                SystemTrayClass.getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(tray, trayIcon);
            }
        }
        catch (Throwable th) {
            logger.error((Object)"err", th);
        }
    }

    static void removeSystemTray(ExportDialog dialog) {
        try {
            Class<?> SystemTrayClass = Class.forName("java.awt.SystemTray");
            if (((Boolean)SystemTrayClass.getMethod("isSupported", null).invoke(null, null)).booleanValue()) {
                Object tray = SystemTrayClass.getMethod("getSystemTray", null).invoke(null, null);
                tray.getClass().getMethod("remove", Class.forName("java.awt.TrayIcon")).invoke(tray, dialog.trayIcon);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void ExportInterface(String filePath, AbstractDataWrapper dataSource, EventQueue queue) throws Exception {
        Excel2007ExportController.dialog.progressPane.filePath = filePath;
        if (queue != null) {
            queue.enQueue(new ExportEvent("export file :", filePath, 0L));
            queue.enQueue(new ExportEvent("prepare datas", "create DataWrapper", 0L));
        }
        SXSSFExportWrapper book = new SXSSFExportWrapper(dataSource);
        if (queue != null) {
            book.setQueue(queue);
            queue.enQueue(new ExportEvent("export workbook", "start fill datas"));
        }
        book.write(filePath);
    }

    private static void ExportXssfInterface(String filePath, AbstractDataWrapper dataSource, EventQueue queue) throws Exception {
        Excel2007ExportController.dialog.progressPane.filePath = filePath;
        if (queue != null) {
            queue.enQueue(new ExportEvent("prepare datas", "create DataWrapper", 0L));
        }
        SXSSFExportWrapper book = new SXSSFExportWrapper(dataSource);
        if (queue != null) {
            book.setQueue(queue);
            queue.enQueue(new ExportEvent("export workbook", "start fill datas"));
        }
        book.write(filePath);
    }

    private static void BigDataExportInterface(String filePath, AbstractDataWrapper dataSource, EventQueue queue) throws Exception {
        Excel2007ExportController.dialog.progressPane.filePath = filePath;
        if (queue != null) {
            queue.enQueue(new ExportEvent("prepare datas", "create DataWrapper", 0L));
        }
        SXSSFExportWrapper book = new SXSSFExportWrapper(dataSource);
        if (queue != null) {
            book.setQueue(queue);
            queue.enQueue(new ExportEvent("export workbook", "start fill datas"));
        }
        book.write(filePath);
    }

    static void openFileInExcel(String file) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + file + "\"");
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        ExportDialog d = new ExportDialog(true, (Dialog)null);
        d.remove((Component)((Object)d.configPane));
        d.add((Component)((Object)d.progressPane));
        d.show();
    }

    static {
        isSystemTraySupported = JVM.current().isOverOneDotFive();
    }
}

