/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export;

import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.export.AbstractExporter;
import com.kingdee.cosmic.ctrl.kdf.export.CsvExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.kds.ICells;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;

public final class CsvExporter
extends AbstractExporter {
    private PrintableBook printkds = null;
    private String delimiter = null;
    private Writer writer = null;
    private int index = 0;
    private boolean[] isRowUsed = null;
    private boolean[] isColUsed = null;

    @Override
    public void export() {
        StringBuffer sb;
        this.printkds = (PrintableBook)this.parameters.get(ExporterParameter.KD_Print);
        if (this.printkds == null) {
            throw new RuntimeException(CtrlKDFMessages.getMLS("noOutputSource", "\u672a\u8bbe\u7f6e\u8f93\u51fa\u6e90\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8981\u8f93\u51fa\u7684\u6587\u6863"));
        }
        Integer IntIndex = (Integer)this.parameters.get(CsvExporterParameter.SHEET_INDEXED);
        this.index = IntIndex == null ? 0 : IntIndex;
        String encoding = (String)this.parameters.get(ExporterParameter.CHARACTER_ENCODING);
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        this.delimiter = (String)this.parameters.get(CsvExporterParameter.FIELD_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        if ((sb = (StringBuffer)this.parameters.get(ExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportToWriter();
                sb.append(this.writer);
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to StringBuffer writer : ", e);
            }
        }
        this.writer = (Writer)this.parameters.get(ExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to writer : ", e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to OutputStream writer : ", e);
            }
        }
        File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(FilenameUtils.normalize((String)fileName));
            } else {
                throw new RuntimeException("No output specified for the exporter.");
            }
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to file writer : ", e);
            }
            finally {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (null != os) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error close file writer : ", e);
        }
    }

    private void exportToWriter() throws IOException {
        KDSSheet kdssheet = this.printkds.getBook().getSheet(this.index);
        this.exportPage(kdssheet);
        this.writer.flush();
    }

    private void exportPage(KDSSheet sheet) throws IOException {
        this.layoutGrid(sheet);
        StringBuffer rowbuffer = null;
        ICells cells = sheet.getCells();
        String text = null;
        boolean isFirstColumn = true;
        int iRows = sheet.getExpandedRows();
        int iCols = sheet.getExpandedColumns();
        for (int y = 0; y <= iRows; ++y) {
            rowbuffer = new StringBuffer();
            if (!this.isRowUsed[y]) continue;
            isFirstColumn = true;
            for (int x = 0; x <= iCols; ++x) {
                if (cells.getCell(y, x, false) != null) {
                    KDSCell element = cells.getCell(y, x, false);
                    text = element.getText();
                    if (text == null) {
                        text = "";
                    }
                    if (!isFirstColumn) {
                        rowbuffer.append(this.delimiter);
                    }
                    rowbuffer.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!this.isColUsed[x]) continue;
                if (!isFirstColumn) {
                    rowbuffer.append(this.delimiter);
                }
                isFirstColumn = false;
            }
            if (rowbuffer.length() <= 0) continue;
            this.writer.write(rowbuffer.toString());
            this.writer.write("\n");
        }
    }

    private String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = false;
            if (source.indexOf(this.delimiter) >= 0) {
                putQuotes = true;
            }
            StringBuilder sbuffer = new StringBuilder();
            StringTokenizer tkzer = new StringTokenizer(source, ",\"\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (",".equals(token)) {
                    putQuotes = true;
                    sbuffer.append(',');
                    continue;
                }
                if ("\"".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(token)) {
                    sbuffer.append(' ');
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
            if (putQuotes) {
                str = "\"" + str + "\"";
            }
        }
        return str;
    }

    private void layoutGrid(KDSSheet sheet) {
        int xCellCount = sheet.getExpandedColumns();
        int yCellCount = sheet.getExpandedRows();
        this.isRowUsed = new boolean[yCellCount + 1];
        this.isColUsed = new boolean[xCellCount + 1];
        for (int x = 0; x <= xCellCount; ++x) {
            for (int y = 0; y <= yCellCount; ++y) {
                if (sheet.getCell(x, y, false) == null) continue;
                this.isRowUsed[y] = true;
                this.isColUsed[x] = true;
            }
        }
    }
}

