/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export;

import com.kingdee.cosmic.ctrl.kdf.export.CsvExporter;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.HtmlExporter;
import com.kingdee.cosmic.ctrl.kdf.export.POIExportException;
import com.kingdee.cosmic.ctrl.kdf.export.POIXlsExporter;
import com.kingdee.cosmic.ctrl.kdf.export.PdfExporter;
import com.kingdee.cosmic.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.direct.ImageExporter;
import com.kingdee.cosmic.ctrl.kdf.export.direct.PdfExporter2;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import java.awt.print.Printable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public final class ExportManager {
    HashMap parametermap = new HashMap();
    private boolean noPrint = false;

    public void setExporterParmeter(ExporterParameter parameter, Object ob) {
        this.parametermap.put(parameter, ob);
    }

    public void CleanExporterParmeter() {
        this.parametermap.clear();
    }

    public void exportToPdfFile(PrintableBook book, String destFileName) {
        PdfExporter exporter = new PdfExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        exporter.export();
    }

    public void exportToPdfStream(PrintableBook book, OutputStream outputStream) {
        PdfExporter exporter = new PdfExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.export();
    }

    public void exportToPdfFile2(Printable printable, String destFileName) {
        PdfExporter2 exporter = new PdfExporter2();
        exporter.setParameter(ExporterParameter.PRINTABLE, printable);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.export();
    }

    public void exportToExcel(PrintableBook book, String destName) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        try {
            exporter.export();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exportToExcelStream(PrintableBook book, OutputStream outputStream) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        try {
            exporter.export();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
    }

    public void exportToExcelStream(KDSBook book, OutputStream outputStream) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KDS_BOOK, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        try {
            exporter.exportKDS();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
    }

    public void exportToExcel(KDSBook book, String destName) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KDS_BOOK, book);
        this.noPrint = true;
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        try {
            exporter.exportKDS();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
        this.noPrint = false;
    }

    public boolean isetPrintInfo() {
        return this.noPrint;
    }

    public void exportToCsv(PrintableBook book, String destName) {
        CsvExporter exporter = new CsvExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        exporter.setParameter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);
        exporter.export();
    }

    public void exportToCsvStream(PrintableBook book, OutputStream outputStream) {
        CsvExporter exporter = new CsvExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.setParameter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);
        exporter.export();
    }

    public byte[] exportToPdf(PrintableBook book) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfExporter exporter = new PdfExporter();
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, baos);
        exporter.export();
        return baos.toByteArray();
    }

    public String[] exportToHtmlFile(PrintableBook book, String destFileName) {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.export();
        return (String[])exporter.getParameter(ExporterParameter.IMAGE_FILE_NAMES);
    }

    public void exportToImageFile(Printable printable, String destFileName) {
        ImageExporter exporter = new ImageExporter();
        exporter.setParameter(ExporterParameter.PRINTABLE, printable);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (Map.Entry entry : this.parametermap.entrySet()) {
            exporter.setParameter((ExporterParameter)entry.getKey(), entry.getValue());
        }
        exporter.export();
    }
}

