/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.export.AbstractExporter;
import com.kingdee.cosmic.ctrl.kdf.export.EmbedObjectRectangle;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.IExportObject;
import com.kingdee.cosmic.ctrl.kdf.export.POIExportException;
import com.kingdee.cosmic.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.kds.ICells;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSAttributeSpan;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSColumn;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class POIXlsExporter
extends AbstractExporter {
    private static final Logger log = LogUtil.getPackageLogger(POIXlsExporter.class);
    public static boolean DEBUG = false;
    long startExport;
    long startExportToStream;
    long startExportPage;
    long startILoopRow;
    long startExportKDS;
    private PrintableBook printkds = null;
    private HSSFWorkbook workbook = null;
    private HSSFDataFormat format = null;
    private HSSFSheet sheet = null;
    private HSSFRow row = null;
    private HSSFCell cell = null;
    private HSSFCellStyle emptyCellStyle = null;
    private List loadedFonts = new ArrayList();
    private HashMap loadedCellStyles = new HashMap();
    private boolean isOnePagePerSheet = true;
    private boolean isRemoveEmptySpace = false;
    private boolean memoryCallback = false;
    private boolean[] isRowNotEmpty = null;
    private List xCuts = null;
    private String booleanValueTrue;
    private String booleanValueFalse;
    public static final String NULL_FORMULA = "ATTR(semiVolatile)";
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_FORMULA_SPLIT = "_@_";
    private boolean exportStringAsString = true;
    private String excelFormulas = "";
    boolean exportFormula = false;
    boolean exportMergeBlocks = true;
    boolean exportContinue = true;
    boolean exportFormulaValue = false;
    boolean exportFormat = true;
    boolean exportCustomFormula = false;
    boolean exportStyle = true;
    boolean exportHidedRows = true;
    private static final String IGNORE_SHEET_PROTECTION = "IGNORE_SHEET_PROTECTION";
    private ArrayList patriarchCache = new ArrayList();
    private List hidedRows = new ArrayList();
    private List hidedCols = new ArrayList();

    public void setExcelFormulas(String formulas) {
        this.excelFormulas = formulas;
    }

    public String getExcelFormulas() {
        return this.excelFormulas;
    }

    public void addExcelFormulas(String formula) {
        this.excelFormulas = this.excelFormulas + formula + ",";
    }

    public void setDefaultExcelFormulas() {
        this.excelFormulas = "or,and,not,true,false,if,now,year,month,day,hour,minute,second,yearday,weekday,datevalue,days,hours,milliseconds,minutes,ticks,totaldays,totalhours,totalmilliseconds,totalminutes,totalseconds,sign,abs,round,fix,sort,int,ln,log,log10,exp,power,mod,pi,rand,degrees,radians,sin,asin,cos,acos,tan,atan,len,lower,upper,trim,left,right,rept,concatenate,text,find,dec2hex,vlookup,sum,max,min,count,counta,average,subtotal,product,stdev,var,sumif,countif,iferror,";
    }

    public POIXlsExporter() {
        this.setDefaultExcelFormulas();
    }

    @Override
    public void export() {
        OutputStream os;
        Boolean isWhitePageBackgroundParameter;
        Boolean isRemoveEmptySpaceParameter;
        if (DEBUG) {
            this.startExport = System.currentTimeMillis();
            log.info((Object)("==========export startTime: " + this.startExport));
        }
        this.printkds = (PrintableBook)this.parameters.get(ExporterParameter.KD_Print);
        if (this.printkds == null) {
            throw new POIExportException("NO_OUTPUT_SOURCE");
        }
        Boolean isOnePagePerSheetParameter = (Boolean)this.parameters.get(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET);
        if (isOnePagePerSheetParameter != null) {
            this.isOnePagePerSheet = isOnePagePerSheetParameter;
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(XlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(XlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
            // empty if block
        }
        if ((os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM)) != null) {
            try {
                this.exportToStream(this.printkds.getBook(), os);
            }
            catch (POIExportException e) {
                throw new POIExportException(e.getMessage(), e.getCause());
            }
        }
        File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(FilenameUtils.normalize((String)fileName));
            } else {
                throw new POIExportException("NO_OUTPUT_FILENAME");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.exportToStream(this.printkds.getBook(), os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw new POIExportException("EXPORT_OCCUR_ERROR", e);
        }
        catch (POIExportException e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
        if (DEBUG) {
            log.info((Object)("==========export consuming: " + (System.currentTimeMillis() - this.startExport)));
        }
    }

    public void exportKDS() {
        OutputStream os;
        String exportHidedRowObject;
        Boolean isWhitePageBackgroundParameter;
        KDSBook book;
        if (DEBUG) {
            this.startExportKDS = System.currentTimeMillis();
            log.info((Object)("==========exportKDS startTime: " + this.startExportKDS));
        }
        if ((book = (KDSBook)this.parameters.get(ExporterParameter.KDS_BOOK)) == null) {
            throw new POIExportException("NO_OUTPUT_SOURCE");
        }
        this.isOnePagePerSheet = true;
        Boolean isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(XlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS);
        if (isRemoveEmptySpaceParameter != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isWhitePageBackgroundParameter = (Boolean)this.parameters.get(XlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
            // empty if block
        }
        if ((exportHidedRowObject = (String)this.parameters.get(ExporterParameter.EXPORT_HIDED_ROWS_COLUMNS)) != null) {
            this.exportHidedRows = Boolean.parseBoolean(exportHidedRowObject);
        }
        if ((os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM)) != null) {
            try {
                this.exportToStream(book, os);
            }
            catch (POIExportException e) {
                throw new POIExportException(e.getMessage(), e.getCause());
            }
        }
        File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(FilenameUtils.normalize((String)fileName));
            } else {
                throw new POIExportException("NO_OUTPUT_FILENAME");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.exportToStream(book, os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw new POIExportException("EXPORT_OCCUR_ERROR", e);
        }
        catch (POIExportException e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
        if (DEBUG) {
            log.info((Object)("==========exportKDS consuming: " + (System.currentTimeMillis() - this.startExportKDS)));
        }
    }

    private void createEmptyCellStyle() {
        if (this.emptyCellStyle == null) {
            this.emptyCellStyle = this.workbook.createCellStyle();
            this.emptyCellStyle.setFillPattern(FillPatternType.NO_FILL);
            this.emptyCellStyle.setFillForegroundColor((short)0);
            this.emptyCellStyle.setFillBackgroundColor(IndexedColors.WHITE.index);
            this.emptyCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.emptyCellStyle.setHidden(false);
            this.emptyCellStyle.setLocked(false);
            this.emptyCellStyle.setBorderLeft(BorderStyle.NONE);
            this.emptyCellStyle.setBorderRight(BorderStyle.NONE);
            this.emptyCellStyle.setBorderTop(BorderStyle.NONE);
            this.emptyCellStyle.setBorderBottom(BorderStyle.NONE);
            short backColorIndex = IndexedColors.BLACK.index;
            this.emptyCellStyle.setBottomBorderColor(backColorIndex);
            this.emptyCellStyle.setTopBorderColor(backColorIndex);
            this.emptyCellStyle.setLeftBorderColor(backColorIndex);
            this.emptyCellStyle.setRightBorderColor(backColorIndex);
            this.emptyCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(CtrlKDFMessages.getMLS("fontSimSun", "\u5b8b\u4f53"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.emptyCellStyle.setFont(defaultFont);
        }
    }

    private void initParameter() {
        String sExportStringAsString;
        String sExportStyle;
        String sExportCustomFormula;
        String sExportFormat;
        String sExportFormulaValue;
        String sExportContinue;
        String sExportMergeBlocks;
        String sBooleanValueTrue = (String)this.parameters.get(ExporterParameter.BOOLEAN_VALUE_TRUE);
        String sBooleanValueFalse = (String)this.parameters.get(ExporterParameter.BOOLEAN_VALUE_FALSE);
        String sExportFormula = (String)this.parameters.get(ExporterParameter.EXPORT_FORMULA);
        if (!StringUtil.isEmptyString((String)sExportFormula)) {
            this.exportFormula = Boolean.parseBoolean(sExportFormula);
        }
        if (!StringUtil.isEmptyString((String)(sExportMergeBlocks = (String)this.parameters.get(ExporterParameter.EXPORT_MERGE_BLOCKS)))) {
            this.exportMergeBlocks = Boolean.parseBoolean(sExportMergeBlocks);
        }
        if (!StringUtil.isEmptyString((String)(sExportContinue = (String)this.parameters.get(ExporterParameter.EXPORT_FORMULA_TOO_LENGTH_CONTINUE)))) {
            this.exportContinue = Boolean.parseBoolean(sExportContinue);
        }
        if (!StringUtil.isEmptyString((String)(sExportFormulaValue = (String)this.parameters.get(ExporterParameter.EXPORT_FORMULA_VALUE)))) {
            this.exportFormulaValue = Boolean.parseBoolean(sExportFormulaValue);
        }
        if (!StringUtil.isEmptyString((String)(sExportFormat = (String)this.parameters.get(ExporterParameter.EXPORT_FORMAT)))) {
            this.exportFormat = Boolean.parseBoolean(sExportFormat);
        }
        if (!StringUtil.isEmptyString((String)(sExportCustomFormula = (String)this.parameters.get(ExporterParameter.EXPORT_CUSTOM_FORMULA)))) {
            this.exportCustomFormula = Boolean.parseBoolean(sExportCustomFormula);
        }
        if (!StringUtil.isEmptyString((String)(sExportStyle = (String)this.parameters.get(ExporterParameter.EXPORT_STYLE)))) {
            this.exportStyle = Boolean.parseBoolean(sExportStyle);
        }
        if (!StringUtil.isEmptyString((String)(sExportStringAsString = (String)this.parameters.get(ExporterParameter.EXPORT_STRING_AS_STRING)))) {
            this.exportStringAsString = Boolean.parseBoolean(sExportStringAsString);
        }
        if (!StringUtil.isEmptyString((String)sBooleanValueTrue)) {
            this.booleanValueTrue = sBooleanValueTrue;
        }
        if (!StringUtil.isEmptyString((String)sBooleanValueFalse)) {
            this.booleanValueFalse = sBooleanValueFalse;
        }
    }

    private void exportToStream(KDSBook book, OutputStream os) {
        block25: {
            int i;
            if (DEBUG) {
                this.startExportToStream = System.currentTimeMillis();
                log.info((Object)("========exportToStream startTime: " + this.startExportToStream));
            }
            this.workbook = new HSSFWorkbook();
            this.format = this.workbook.createDataFormat();
            this.initBooleanValue();
            this.initParameter();
            this.createEmptyCellStyle();
            int count = book.getSheetCount();
            int rowCount = 0;
            for (i = 0; i < count; ++i) {
                KDSSheet sheet = book.getSheet(i);
                rowCount += sheet.getRowCount();
            }
            if (rowCount > 7000) {
                this.setMemoryCallback(true);
            }
            try {
                if (this.printkds != null) {
                    ArrayList pages = this.printkds.getIndexedPagesNoSavePaper();
                    if (pages != null && pages.size() > 0) {
                        IndexedPage page = null;
                        if (this.isOnePagePerSheet) {
                            int i2;
                            for (i2 = 0; i2 < pages.size(); ++i2) {
                                this.workbook.createSheet();
                            }
                            for (i2 = 0; i2 < pages.size(); ++i2) {
                                if (Thread.currentThread().isInterrupted()) {
                                    throw new POIExportException("CURRENT_THREAD_INTERRUPTED");
                                }
                                page = (IndexedPage)pages.get(i2);
                                this.sheet = this.workbook.getSheetAt(i2);
                                this.printSetup(book.getSheet(i2), this.sheet);
                                this.exportPage(page, i2);
                            }
                        } else {
                            this.createWorkSheet(this.workbook, book);
                            for (int i3 = 0; i3 < book.getSheetCount(); ++i3) {
                                KDSSheet kdssheet = book.getSheet(i3);
                                IndexedPage indexpage = new IndexedPage(kdssheet, 0, kdssheet.getExpandedRows() + 1, 0, kdssheet.getExpandedColumns() + 1);
                                this.sheet = this.workbook.getSheetAt(i3);
                                this.printSetup(book.getSheet(i3), this.sheet);
                                this.exportPage(indexpage, i3);
                            }
                        }
                    }
                    this.exportPlainEmbedObjects(book);
                    this.workbook.write(os);
                    break block25;
                }
                this.createWorkSheet(this.workbook, book);
                for (i = 0; i < book.getSheetCount(); ++i) {
                    KDSSheet kdssheet = book.getSheet(i);
                    IndexedPage indexpage = new IndexedPage(kdssheet, 0, kdssheet.getExpandedRows() + 1, 0, kdssheet.getExpandedColumns() + 1);
                    this.sheet = this.workbook.getSheetAt(i);
                    this.printSetup(book.getSheet(i), this.sheet);
                    try {
                        this.exportPage(indexpage, i);
                        this.exportFlashChartEmbedObject(kdssheet);
                    }
                    catch (POIExportException poie) {
                        throw new POIExportException("EXPORT_FORUMULA_TOO_LENGTH", poie);
                    }
                    this.exportGroup(kdssheet);
                }
                this.exportPlainEmbedObjects(book);
                this.workbook.write(os);
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
                throw new POIExportException("EXPORT_OCCUR_ERROR", e);
            }
            finally {
                if (null != os) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (DEBUG) {
            log.info((Object)("========exportToStream consuming: " + (System.currentTimeMillis() - this.startExportToStream)));
        }
    }

    private void exportGroup(KDSSheet kdssheet) {
        this.exportGroupRow(kdssheet);
        this.exportGroupCol(kdssheet);
    }

    private void exportGroupRow(KDSSheet kdssheet) {
        List rowSpans = kdssheet.getRowSpans();
        if (rowSpans == null || rowSpans.isEmpty()) {
            return;
        }
        if (kdssheet.isAboveOfOutlineGroup()) {
            this.sheet.setRowSumsBelow(false);
        }
        for (KDSAttributeSpan attrSpan : rowSpans) {
            for (int level = 0; level < attrSpan.getOutlineGroupLevel(); ++level) {
                this.sheet.groupRow(attrSpan.getStart(), attrSpan.getEnd());
            }
        }
    }

    private void exportGroupCol(KDSSheet kdssheet) {
        List colSpans = kdssheet.getColSpans();
        if (colSpans == null || colSpans.isEmpty()) {
            return;
        }
        if (kdssheet.isLeftToOulineGroup()) {
            this.sheet.setAlternativeFormula(false);
        }
        for (KDSAttributeSpan attrSpan : colSpans) {
            for (int level = 0; level < attrSpan.getOutlineGroupLevel(); ++level) {
                this.sheet.groupColumn(attrSpan.getStart(), attrSpan.getEnd());
            }
        }
    }

    private void exportPlainEmbedObjects(KDSBook book) {
        ArrayList kdsImages = book.getImages();
        if (kdsImages != null) {
            for (int i = 0; i < kdsImages.size(); ++i) {
                KDSBook.KDSImage kdsImage = (KDSBook.KDSImage)kdsImages.get(i);
                byte[] binaryImage = kdsImage.getBinaryImage();
                int picIndex = this.workbook.addPicture(binaryImage, kdsImage.getFileType());
                HSSFPatriarch patriarch = this.preparePatriarch(kdsImage);
                if (patriarch == null) continue;
                int width = kdsImage.getWidth();
                int height = kdsImage.getHeight();
                if (width == -1 || height == -1) {
                    ImageIcon imageIcon = new ImageIcon(binaryImage);
                    width = imageIcon.getIconWidth();
                    height = imageIcon.getIconHeight();
                }
                patriarch.createPicture(new HSSFClientAnchor(kdsImage.getDx1(), kdsImage.getDy1(), kdsImage.getDx2(), kdsImage.getDy2(), (short)kdsImage.getLeft(), kdsImage.getTop(), (short)kdsImage.getRight(), kdsImage.getBottom()), picIndex);
            }
        }
    }

    private HSSFPatriarch preparePatriarch(KDSBook.KDSImage kdsImage) {
        HSSFPatriarch patriarch = null;
        HSSFSheet sheet = this.workbook.getSheet(kdsImage.getSheetName());
        if (sheet != null) {
            int index = this.patriarchCache.indexOf(sheet);
            if (index > -1) {
                patriarch = (HSSFPatriarch)this.patriarchCache.get(index + 1);
            }
            if (patriarch == null) {
                patriarch = sheet.createDrawingPatriarch();
                this.patriarchCache.add(sheet);
                this.patriarchCache.add(patriarch);
            }
        }
        return patriarch;
    }

    private void exportFlashChartEmbedObject(KDSSheet kdssheet) {
        ArrayList list = kdssheet.getEmbedhLayer();
        int size = list.size();
        if (size > 0) {
            HSSFPatriarch patriarch = null;
            int index = this.patriarchCache.indexOf(this.sheet);
            if (index > -1) {
                patriarch = (HSSFPatriarch)this.patriarchCache.get(index + 1);
            }
            if (patriarch == null) {
                patriarch = this.sheet.createDrawingPatriarch();
                this.patriarchCache.add(this.sheet);
                this.patriarchCache.add(patriarch);
            }
            for (int i = 0; i < size; i += 2) {
                Object bounds;
                byte[] arr = (byte[])list.get(i);
                EmbedObjectRectangle position = (EmbedObjectRectangle)list.get(i + 1);
                HSSFClientAnchor anchor = null;
                if (position instanceof EmbedObjectRectangle) {
                    bounds = position;
                    anchor = new HSSFClientAnchor(((EmbedObjectRectangle)bounds).dx1, ((EmbedObjectRectangle)bounds).dy1, ((EmbedObjectRectangle)bounds).dx2, ((EmbedObjectRectangle)bounds).dy2, (short)((EmbedObjectRectangle)bounds).col1, ((EmbedObjectRectangle)bounds).row1, (short)((EmbedObjectRectangle)bounds).col2, ((EmbedObjectRectangle)bounds).row2);
                } else if (position instanceof Rectangle) {
                    bounds = (Rectangle)((Object)position);
                    anchor = new HSSFClientAnchor(1023, 255, 0, 0, (short)((Rectangle)bounds).y, ((Rectangle)bounds).x, (short)((Rectangle)bounds).height, ((Rectangle)bounds).width);
                }
                if (anchor == null) continue;
                patriarch.createPicture(anchor, this.workbook.addPicture(arr, 6));
            }
        }
    }

    private void printSetup(KDSSheet kdssheet, HSSFSheet sheet) {
        KDSSheetPrintSetup printInfo = kdssheet.getPrintSetup();
        if (printInfo != null) {
            try {
                int i;
                int iLength;
                List l;
                HSSFSheet temp;
                HSSFHeader header = sheet.getHeader();
                if (printInfo.getHeaderLeft() != null) {
                    header.setLeft(printInfo.getHeaderLeft());
                }
                if (printInfo.getHeaderCenter() != null) {
                    header.setCenter(printInfo.getHeaderCenter());
                }
                if (printInfo.getHeaderRight() != null) {
                    header.setRight(printInfo.getHeaderRight());
                }
                HSSFFooter footer = sheet.getFooter();
                if (printInfo.getFooterLeft() != null) {
                    footer.setLeft(printInfo.getFooterLeft());
                }
                if (printInfo.getFooterCenter() != null) {
                    footer.setCenter(printInfo.getFooterCenter());
                }
                if (printInfo.getFooterRight() != null) {
                    footer.setRight(printInfo.getFooterRight());
                }
                HSSFPrintSetup printSetup = sheet.getPrintSetup();
                if (printInfo.isUsePage()) {
                    printSetup.setUsePage(true);
                    printSetup.setPageStart(printInfo.getStartPage());
                }
                printSetup.setScale(printInfo.getScale());
                printSetup.setCopies(printInfo.getCopies());
                printSetup.setLandscape(printInfo.isLandScape());
                printSetup.setDraft(printInfo.isDraft());
                printSetup.setLeftToRight(printInfo.isRowToCol());
                printSetup.setNoColor(printInfo.isNoColor());
                printSetup.setNotes(printInfo.isHasNotes());
                printSetup.setPaperSize(printInfo.getPageSize());
                printSetup.setFitWidth(printInfo.getWidthFit());
                printSetup.setFitHeight(printInfo.getHeightFit());
                printSetup.setFooterMargin((double)printInfo.getFootDis());
                printSetup.setHeaderMargin((double)printInfo.getHeadDis());
                sheet.setMargin((short)3, (double)printInfo.getBottom());
                sheet.setMargin((short)0, (double)printInfo.getLeft());
                sheet.setMargin((short)1, (double)printInfo.getRight());
                sheet.setMargin((short)2, (double)printInfo.getTop());
                sheet.setHorizontallyCenter(printInfo.isHorizontalAlign());
                sheet.setVerticallyCenter(printInfo.isVerticalAlign());
                sheet.setPrintGridlines(printInfo.isPrintGridLine());
                int sheetIndex = 0;
                int i2 = 0;
                while ((temp = this.workbook.getSheetAt(i2)) != null) {
                    if (temp == sheet) {
                        sheetIndex = 0;
                        break;
                    }
                    ++i2;
                }
                if ((l = printInfo.getPrintArea()) != null) {
                    int length = l.size();
                    for (int k = 0; k < length; ++k) {
                        ITableForPrint.IBlock block = (ITableForPrint.IBlock)l.get(k);
                        this.workbook.setPrintArea(sheetIndex, block.getCol(), block.getCol2(), block.getRow(), block.getRow2());
                    }
                }
                List l1 = printInfo.getPrintLeftTitleArea();
                List l2 = printInfo.getPrintTopTitleArea();
                if (l1 != null && l2 != null) {
                    int size1 = l1.size();
                    int size2 = l2.size();
                    int length = Math.max(size1, size2);
                    for (int k = 0; k < length; ++k) {
                        ITableForPrint.IBlock block1 = k >= size1 ? null : (ITableForPrint.IBlock)l1.get(k);
                        ITableForPrint.IBlock block2 = k >= size2 ? null : (ITableForPrint.IBlock)l2.get(k);
                        HSSFSheet hssfSheet = this.workbook.getSheetAt(sheetIndex);
                        hssfSheet.setRepeatingColumns(new CellRangeAddress(block1 == null ? -1 : block1.getCol(), block1 == null ? -1 : block1.getCol2(), block2 == null ? -1 : block2.getRow(), block2 == null ? -1 : block2.getRow2()));
                        hssfSheet.setRepeatingRows(new CellRangeAddress(block1 == null ? -1 : block1.getCol(), block1 == null ? -1 : block1.getCol2(), block2 == null ? -1 : block2.getRow(), block2 == null ? -1 : block2.getRow2()));
                    }
                }
                short[] colBreaks = printInfo.getColBreaks();
                short[] rowBreaks = printInfo.getRowBreaks();
                if (printInfo.isAutoFit()) {
                    sheet.setAutobreaks(true);
                    if (colBreaks != null && colBreaks.length > 0) {
                        printSetup.setFitWidth((short)colBreaks.length);
                    }
                    if (rowBreaks != null && rowBreaks.length > 0) {
                        printSetup.setFitHeight((short)rowBreaks.length);
                    }
                }
                int n = iLength = rowBreaks != null ? rowBreaks.length : 0;
                for (i = 0; i < iLength; ++i) {
                    sheet.setRowBreak((int)rowBreaks[i]);
                }
                int n2 = iLength = colBreaks != null ? colBreaks.length : 0;
                for (i = 0; i < iLength; ++i) {
                    sheet.setColumnBreak((int)colBreaks[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean isBookProtected() {
        Object obj = this.parameters.get(ExporterParameter.BOOK_LOCKED);
        if (obj instanceof Boolean) {
            return Boolean.TRUE.equals(obj);
        }
        return false;
    }

    private void initBooleanValue() {
        this.booleanValueTrue = CtrlKDFMessages.getMLS("BooleanValueTrue", "true");
        this.booleanValueFalse = CtrlKDFMessages.getMLS("BooleanValueFalse", "false");
    }

    public boolean isMemoryCallback() {
        return this.memoryCallback;
    }

    public void setMemoryCallback(boolean memoryCallback) {
        this.memoryCallback = memoryCallback;
    }

    private void exportPage(IndexedPage page, int sheetIndex) {
        if (DEBUG) {
            this.startExportPage = System.currentTimeMillis();
            log.info((Object)("======exportPage startTime: " + this.startExportPage));
        }
        this.hidedRows.clear();
        this.hidedCols.clear();
        this.layoutGrid(page);
        IndexedPage.PageBlock pb = (IndexedPage.PageBlock)page.getListBlocks().get(0);
        KDSSheet kdssheet = pb.getSheet();
        ICells cells = kdssheet.getCells();
        float width = 0.0f;
        int iSize = this.xCuts.size();
        int iBeginRow = pb.getBeginRow();
        int iLoopRow = pb.getEndRow() - iBeginRow;
        int iBeginCol = pb.getBeginCol();
        short iEndCol = (short)pb.getEndCol();
        short iLoopCol = (short)(iEndCol - iBeginCol);
        int realCol = 1;
        for (int i = 1; i < iSize; ++i) {
            width = kdssheet.getColumns().getColumnWidth(iBeginCol + realCol - 1);
            if (ArrayUtil.isEqual((Float)Float.valueOf(width), (Float)Float.valueOf(0.0f)) && !this.exportHidedRows) continue;
            if (!ArrayUtil.isEqual((Float)Float.valueOf(width), (Float)Float.valueOf(0.0f)) && width < 0.2f) {
                width = 0.2f;
            }
            this.sheet.setColumnWidth((int)((short)(realCol - 1)), (int)((short)(width * 140.0f)));
            ++realCol;
        }
        HSSFCell emptyCell = null;
        boolean keepHideRow = true;
        boolean keepHideCol = true;
        int realRowIndex = 0;
        short realColIndex = 0;
        for (int y = 0; y < iLoopRow; ++y) {
            if (DEBUG) {
                this.startILoopRow = System.currentTimeMillis();
                log.info((Object)("====iLoopRow startTime: " + this.startILoopRow));
            }
            realColIndex = 0;
            if (this.hidedRows.contains(y)) {
                keepHideRow = false;
            }
            if (keepHideRow && (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace)) {
                this.row = this.sheet.createRow(realRowIndex);
                float lastRowHeight = kdssheet.getRows().getRowHeight(y + iBeginRow);
                float tempHeight = (short)StyleUtil.lomToPt((double)(lastRowHeight * 10.0f));
                if (ArrayUtil.isEqual((Float)Float.valueOf(tempHeight), (Float)Float.valueOf(0.0f))) {
                    this.row.setZeroHeight(true);
                }
                tempHeight = ArrayUtil.isEqual((Float)Float.valueOf(tempHeight), (Float)Float.valueOf(0.0f)) ? 14.0f : tempHeight;
                this.row.setHeight((short)(tempHeight * 20.0f));
                short x = 0;
                for (x = 0; x < iLoopCol; x = (short)(x + 1)) {
                    KDSCell element = cells.getCell(y + iBeginRow, x + iBeginCol, false);
                    if (!this.exportHidedRows && pb.getSheet().getColumnWidth(x + iBeginCol) == 0.0f) {
                        keepHideCol = false;
                        element = null;
                    }
                    if (element != null) {
                        try {
                            this.exportCell(element, realColIndex, realRowIndex, page, sheetIndex, x, y);
                        }
                        catch (POIExportException poie) {
                            throw new POIExportException("EXPORT_FORUMULA_TOO_LENGTH", poie);
                        }
                        if (this.isMemoryCallback()) {
                            if (!this.exportMergeBlocks && element.isMerged()) {
                                realColIndex = (short)(realColIndex + 1);
                                continue;
                            }
                            kdssheet.removeCell(y + iBeginRow, x + iBeginCol, element);
                        }
                        realColIndex = (short)(realColIndex + 1);
                        continue;
                    }
                    if (!keepHideCol) {
                        keepHideCol = true;
                        continue;
                    }
                    emptyCell = this.row.createCell((int)x);
                    emptyCell.setCellStyle(this.emptyCellStyle);
                    realColIndex = (short)(realColIndex + 1);
                }
                ++realRowIndex;
            } else {
                if (!keepHideRow) {
                    keepHideRow = true;
                    continue;
                }
                this.row = this.sheet.createRow(y);
                this.row.setHeight((short)0);
                for (int x = iBeginCol; x < iEndCol; ++x) {
                    emptyCell = this.row.createCell((int)((short)x));
                    emptyCell.setCellStyle(this.emptyCellStyle);
                }
                ++realRowIndex;
            }
            if (this.isMemoryCallback()) {
                kdssheet.removeRow(y + iBeginRow);
            }
            if (!DEBUG) continue;
            log.info((Object)("====iLoopRow: " + y + "=consuming: " + (System.currentTimeMillis() - this.startILoopRow)));
        }
        if (DEBUG) {
            log.info((Object)("======exportPage consuming: " + (System.currentTimeMillis() - this.startExportPage)));
        }
    }

    private void exportCellValue(KDSCell element, Object cellValue, boolean noformat, String formatString) {
        if (element != null && element.getSSA() != null && "@".equals(element.getSSA().getNumberFormat())) {
            this.setCellValue(element.getText());
            return;
        }
        if (cellValue instanceof String) {
            this.setCellValue((String)cellValue);
        } else if (cellValue instanceof Number) {
            if (cellValue instanceof Float) {
                this.cell.setCellValue(Double.parseDouble(String.valueOf(cellValue)));
            } else {
                this.cell.setCellValue(((Number)cellValue).doubleValue());
            }
        } else if (cellValue instanceof Boolean) {
            boolean b = (Boolean)cellValue;
            String value = b ? this.booleanValueTrue : this.booleanValueFalse;
            this.setCellValue(value);
            this.cell.setCellType(CellType.STRING);
        } else if (cellValue instanceof Date || cellValue instanceof Calendar) {
            if (noformat) {
                String value = null;
                Calendar cal = null;
                if (cellValue instanceof Date) {
                    Date dateValue = (Date)cellValue;
                    cal = Calendar.getInstance();
                    cal.setTime(dateValue);
                } else {
                    cal = (Calendar)cellValue;
                }
                DateFormat dateFormat = CtrlFormatUtilities.getDateFormat();
                DateFormat timeFormat = CtrlFormatUtilities.getTimeFormat();
                value = dateFormat != null ? dateFormat.format(cal.getTime()) : cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    value = timeFormat != null ? value + " " + timeFormat.format(cal.getTime()) : value + " " + cal.get(11) + ":" + cal.get(12);
                }
                this.setCellValue(value);
            } else if (cellValue instanceof Date) {
                Date d = (Date)cellValue;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                cal.get(11);
                if (cal.get(11) == 23 && cal.get(12) == 59 && cal.get(13) == 59 && cal.get(14) > 499) {
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 0);
                    cal.get(11);
                    this.cell.setCellValue(cal.getTime());
                } else {
                    this.cell.setCellValue(d);
                }
            } else {
                Calendar cal = (Calendar)cellValue;
                cal.get(11);
                if (cal.get(11) == 23 && cal.get(12) == 59 && cal.get(13) == 59 && cal.get(14) > 499) {
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 0);
                    cal.get(11);
                }
                this.cell.setCellValue(cal);
            }
        } else if (cellValue instanceof Image) {
            this.setCellValue("");
        } else if (cellValue instanceof Icon) {
            this.setCellValue("");
        } else if (cellValue != null) {
            if (element == null) {
                log.error((Object)"KDSCell no exist");
                return;
            }
            this.exportCellAsString(element, cellValue.toString(), formatString);
        }
    }

    private void exportCellAsString(KDSCell element, String sV, String formatString) {
        if (!StringUtil.isEmptyString((String)sV)) {
            String numberFormat = null;
            numberFormat = StringUtil.isEmptyString((String)formatString) ? element.getStyle().getNumberFormat() : formatString;
            if (sV != null && !sV.equals("0") && sV.startsWith("0") && sV.indexOf(46) < 0) {
                this.setCellValue(element.getText());
            } else if (sV != null && "@".equals(numberFormat)) {
                this.setCellValue(element.getText());
            } else if (this.exportStringAsString) {
                this.exportCellTextWithFormat(numberFormat, sV);
            } else {
                this.exportCellTextAsNumber(sV);
            }
        }
    }

    private void exportCell(KDSCell element, short realColIndex, int realRowIndex, IndexedPage page, int sheetIndex, short x, int y) {
        HSSFCellStyle cellStyle;
        block26: {
            boolean noformat;
            IndexedPage.PageBlock pb = (IndexedPage.PageBlock)page.getListBlocks().get(0);
            KDSSheet kdssheet = pb.getSheet();
            short x2 = x;
            int y2 = y;
            if (element.isMerged()) {
                int iBeginRow = pb.getBeginRow();
                short iBeginCol = (short)pb.getBeginCol();
                KDSMergeBlock merge = element.getMergeBlock();
                if (this.exportMergeBlocks || kdssheet.isHeader(merge.row)) {
                    x2 = (short)(realColIndex + merge.getWidth() - 1);
                    y2 = realRowIndex + merge.getHeight() - 1;
                    int w = merge.getCol2();
                    for (int c = merge.col; c <= w; ++c) {
                        if (!this.hidedCols.contains(c)) continue;
                        x2 = (short)(x2 - 1);
                    }
                    int h = merge.getRow2();
                    for (int r = merge.row; r <= h; ++r) {
                        if (!this.hidedRows.contains(r)) continue;
                        --y2;
                    }
                    this.addMerge(realRowIndex, realColIndex, x2, y2);
                } else if (!this.exportMergeBlocks && !kdssheet.isHeader(merge.row)) {
                    element = kdssheet.getCell(merge.row, merge.col, false);
                }
            }
            Object cellValue = element.getValue();
            String formatString = null;
            if (cellValue instanceof Variant) {
                cellValue = ((Variant)cellValue).getValue();
            }
            if (cellValue instanceof IExportObject) {
                IExportObject eo = (IExportObject)cellValue;
                cellValue = eo.getContent();
                formatString = eo.getFormatString();
            }
            if (cellValue == null || StringUtil.isEmptyString((String)cellValue.toString())) {
                cellValue = element.getText();
            }
            String formula = element.getFormula();
            ShareStyleAttributes ssa = this.mergeSAs(kdssheet, realColIndex, realRowIndex);
            this.cell = this.row.createCell((int)realColIndex);
            if (this.exportFormula && !StringUtil.isEmptyString((String)formula) || cellValue instanceof String && StringUtil.isExcelFormula((String)cellValue.toString())) {
                formatString = "@";
            }
            cellStyle = this.getLoadedCellStyle(ssa, element, formatString);
            boolean bl = noformat = StringUtil.isEmptyString((String)formatString) && StringUtil.isEmptyString((String)ssa.getNumberFormat());
            if (StringUtil.isEmptyString((String)formula)) {
                this.exportCellValue(element, cellValue, noformat, formatString);
            } else if (this.exportFormula) {
                String sV;
                String string = sV = cellValue != null ? cellValue.toString() : "";
                if (sV == null) {
                    sV = "";
                }
                formula = this.convertFormula(formula, sV, sheetIndex, cellValue instanceof Number);
                CellType oldType = this.cell.getCellType();
                if (!formula.equals("")) {
                    try {
                        this.cell.setCellFormula(formula);
                    }
                    catch (Exception e) {
                        if (this.exportContinue) {
                            this.cell.setCellType(oldType);
                            this.exportCellValue(element, cellValue, noformat, formatString);
                        }
                        throw new POIExportException("EXPORT_OCCUR_FORMULA_ERROR:" + formula, e);
                    }
                    try {
                        Object value = element.getValue();
                        if (value instanceof Number) {
                            double d = 0.0;
                            d = ((Number)value).doubleValue();
                            this.cell.setCellValue(d);
                            break block26;
                        }
                        String text = element.getText();
                        double d = 0.0;
                        d = Double.parseDouble(text);
                        this.cell.setCellValue(d);
                    }
                    catch (Exception value) {}
                } else {
                    this.exportCellValue(element, cellValue, noformat, formatString);
                }
            } else {
                this.exportCellValue(element, cellValue, noformat, formatString);
            }
        }
        this.cell.setCellStyle(cellStyle);
        if (element.getHyperLink() != null && !"".equals(element.getHyperLink().getLinkTo())) {
            HSSFHyperlink hyperlink;
            String linkTo = element.getHyperLink().getLinkTo();
            if (linkTo.indexOf(33) != -1) {
                hyperlink = this.workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
                String suffix = linkTo.substring(linkTo.indexOf(33));
                linkTo = linkTo.substring(1, linkTo.indexOf(33));
                linkTo = KD_DOUBLE_COMMA + linkTo + KD_DOUBLE_COMMA + suffix;
            } else {
                hyperlink = this.workbook.getCreationHelper().createHyperlink(HyperlinkType.URL);
            }
            hyperlink.setLabel(element.getHyperLink().getText());
            hyperlink.setAddress(linkTo);
            this.cell.setHyperlink((Hyperlink)hyperlink);
        }
    }

    private void addMerge(int realRowIndex, int realColIndex, int x2, int y2) {
        if (this.sheet.getNumMergedRegions() <= 0) {
            this.sheet.addMergedRegion(new CellRangeAddress(realRowIndex, y2, realColIndex, x2));
        } else {
            boolean contain = false;
            for (int i = this.sheet.getNumMergedRegions() - 1; i >= 0; --i) {
                if (this.sheet.getMergedRegion(i).getFirstRow() > realRowIndex || realRowIndex > this.sheet.getMergedRegion(i).getLastRow() || this.sheet.getMergedRegion(i).getFirstColumn() > realColIndex || this.sheet.getMergedRegion(i).getLastColumn() < realColIndex) continue;
                contain = true;
                break;
            }
            if (!contain) {
                this.sheet.addMergedRegion(new CellRangeAddress(realRowIndex, y2, realColIndex, x2));
            }
        }
    }

    public String convertFormula(String formula, String cellValue, int sheetIndex, boolean isNum) {
        boolean userDefine = this.isUserDefineFormula(formula);
        if (userDefine) {
            if (this.exportCustomFormula) {
                cellValue = this.convertFormulaSpecialString(cellValue);
                int beginIndex = 0;
                int endIndex = 0;
                formula = this.convertFormulaSpecialString(formula);
                String convertedFormula = StringUtil.concateString((String)formula, (int)127, (String)"&");
                if (!this.exportFormulaValue) {
                    beginIndex = 1;
                    endIndex = formula.length();
                    formula = "mid(" + convertedFormula + "&\"" + KD_FORMULA_SPLIT + "\"&\"" + cellValue + "\"," + beginIndex + "," + endIndex + ")";
                } else {
                    beginIndex = 1 + formula.length() + KD_FORMULA_SPLIT.length();
                    endIndex = cellValue.length();
                    formula = "mid(" + convertedFormula + "&\"" + KD_FORMULA_SPLIT + "\"&\"" + cellValue + "\"," + beginIndex + "," + endIndex + ")";
                    if (isNum) {
                        formula = "value(" + formula + ")";
                    }
                }
            } else {
                formula = "";
            }
        }
        return formula;
    }

    public String convertFormulaSpecialString(String formula) {
        formula = formula.replaceAll(KD_DOUBLE_COMMA, KD_SINGLE_COMMA);
        formula = formula.replaceAll("\"", KD_DOUBLE_COMMA);
        return formula;
    }

    public boolean isUserDefineFormula(String formula) {
        String funcName = "";
        String[] allFunc = formula.split("\\(");
        String curChar = "";
        int iLen = allFunc.length;
        int i = 0;
        int j = 0;
        for (i = 0; i < iLen - 1; ++i) {
            funcName = allFunc[i].trim().toLowerCase(Locale.ENGLISH);
            for (j = funcName.length() - 1; j > 0; --j) {
                curChar = funcName.substring(j, j + 1);
                if (" ".equals(curChar) || "+".equals(curChar) || "-".equals(curChar) || "*".equals(curChar) || "/".equals(curChar) || "%".equals(curChar) || ",".equals(curChar) || "^".equals(curChar) || ":".equals(curChar) || "!".equals(curChar)) {
                    funcName = funcName.substring(j + 1, funcName.length());
                }
                if (this.excelFormulas.indexOf(funcName + ",") != -1) continue;
                return true;
            }
        }
        return false;
    }

    private void layoutGrid(IndexedPage page) {
        int i;
        IndexedPage.PageBlock pb = (IndexedPage.PageBlock)page.getListBlocks().get(0);
        KDSSheet kdssheet = pb.getSheet();
        int size = pb.getEndCol() - pb.getBeginCol() + 1;
        this.xCuts = new ArrayList(size);
        this.xCuts.add(0);
        float tempCur = 0.0f;
        for (i = pb.getBeginCol(); i < pb.getEndCol(); ++i) {
            float colwidth = kdssheet.getColumnWidth(i);
            this.xCuts.add(Float.valueOf(tempCur += colwidth));
        }
        tempCur = 0.0f;
        for (i = pb.getBeginRow(); i < pb.getEndRow(); ++i) {
            float rowHeight = kdssheet.getRowHeight(i);
            tempCur += rowHeight;
        }
        this.isRowNotEmpty = new boolean[pb.getEndRow() - pb.getBeginRow()];
        block2: for (i = 0; i < pb.getEndRow() - pb.getBeginRow(); ++i) {
            if (!this.exportHidedRows && kdssheet.getRowHeight(i + pb.getBeginRow()) == 0.0f) {
                this.hidedRows.add(i);
                continue;
            }
            int j = 0;
            while (i < pb.getEndCol() - pb.getBeginCol()) {
                if (kdssheet.getCells().getCell(i + pb.getBeginRow(), j + pb.getBeginCol(), false) != null) {
                    this.isRowNotEmpty[i] = true;
                    continue block2;
                }
                ++i;
            }
        }
        for (i = 0; i < pb.getEndCol() - pb.getBeginCol(); ++i) {
            if (this.exportHidedRows || kdssheet.getColumnWidth(i + pb.getBeginCol()) != 0.0f) continue;
            this.hidedCols.add(i);
        }
    }

    private static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = null;
        Map triplets = HSSFColor.getTripletHash();
        triplets.put(HSSFColor.HSSFColorPredefined.TAN.getHexString(), HSSFColor.HSSFColorPredefined.TAN.getColor());
        Set entrySet = triplets.entrySet();
        if (!entrySet.isEmpty()) {
            Object var4_4 = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            for (Map.Entry entry : entrySet) {
                crtColor = (HSSFColor)entry.getValue();
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
        }
        if (color == null) {
            throw new RuntimeException("HSSFColor " + CtrlKDFMessages.getMLS("getFailed", "\u83b7\u53d6\u5931\u8d25"));
        }
        return color;
    }

    private HSSFFont getLoadedFont(ShareStyleAttributes ssa) {
        HSSFFont cellFont = null;
        short forecolor = POIXlsExporter.getNearestColor(ssa.getFontColor()).getIndex();
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            HSSFFont cf = null;
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                cf = (HSSFFont)this.loadedFonts.get(i);
                if (!cf.getFontName().equals(ssa.getFontName()) || cf.getColor() != forecolor || cf.getFontHeight() != (short)(ssa.getFontSize() * 20) || !(cf.getUnderline() == 1 ? ssa.isUnderline() : !ssa.isUnderline()) || cf.getStrikeout() != ssa.isStrikeThrough() || !(cf.getBold() ? ssa.isBold() : !ssa.isBold()) || cf.getItalic() != ssa.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(forecolor);
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        cellFont.setCharSet((byte)1);
        return cellFont;
    }

    private ShareStyleAttributes mergeSAs(KDSSheet kdssheet, int x, int y) {
        KDSColumn col;
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[4];
        ssas[0] = kdssheet.getCellStyleAttributes(y, x);
        KDSRow row = kdssheet.getRow(y, false);
        if (row != null) {
            ssas[1] = row.getSSA();
        }
        if ((col = kdssheet.getColumn(x, false)) != null) {
            ssas[2] = col.getSSA();
        }
        ssas[3] = kdssheet.getSSA();
        return Styles.mergeSSA((ShareStyleAttributes[])ssas);
    }

    private HSSFCellStyle getLoadedCellStyle(ShareStyleAttributes ssa, KDSCell cell, String formatString) {
        String numberFormat;
        HSSFCellStyle cellStyle = null;
        HashMap loadedFormatStyles = null;
        if (this.exportStyle && ssa.isEmpty()) {
            return this.emptyCellStyle;
        }
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0 && this.loadedCellStyles.containsKey(cell.getStyle()) && (loadedFormatStyles = (HashMap)this.loadedCellStyles.get(cell.getStyle())) != null && loadedFormatStyles.size() > 0 && loadedFormatStyles.containsKey(formatString)) {
            cellStyle = (HSSFCellStyle)loadedFormatStyles.get(formatString);
        }
        if (loadedFormatStyles == null) {
            loadedFormatStyles = new HashMap();
        }
        Style stl = cell.getStyle();
        String string = numberFormat = StringUtil.isEmptyString((String)formatString) ? stl.getNumberFormat() : formatString;
        if (cellStyle == null || DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
            cellStyle = this.workbook.createCellStyle();
            if (this.exportStyle) {
                HSSFFont f = this.getLoadedFont((ShareStyleAttributes)stl);
                cellStyle.setFont(f);
                FillPatternType pattern = this.getHssfPattern((ShareStyleAttributes)stl);
                if (pattern.getCode() == 0) {
                    cellStyle.setFillPattern(FillPatternType.NO_FILL);
                } else if (pattern.getCode() == 1) {
                    short color;
                    Color clr = stl.getBackground();
                    if (Color.WHITE.equals(clr)) {
                        cellStyle.setFillPattern(FillPatternType.NO_FILL);
                    } else {
                        color = POIXlsExporter.getNearestColor(stl.getBackground()).getIndex();
                        cellStyle.setFillForegroundColor(color);
                        cellStyle.setFillPattern(pattern);
                    }
                    color = POIXlsExporter.getNearestColor(stl.getFontColor()).getIndex();
                    cellStyle.setFillBackgroundColor(color);
                } else {
                    cellStyle.setFillBackgroundColor(POIXlsExporter.getNearestColor(stl.getBackground()).getIndex());
                    cellStyle.setFillForegroundColor(POIXlsExporter.getNearestColor(stl.getFontColor()).getIndex());
                    cellStyle.setFillPattern(pattern);
                }
                Styles.Position p = Styles.Position.LEFT;
                if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
                    cellStyle.setBorderLeft(this.getHssfBorder((ShareStyleAttributes)stl, p));
                    cellStyle.setLeftBorderColor(POIXlsExporter.getNearestColor(stl.getBorderColor(p)).getIndex());
                }
                if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
                    cellStyle.setBorderRight(this.getHssfBorder((ShareStyleAttributes)stl, p));
                    cellStyle.setRightBorderColor(POIXlsExporter.getNearestColor(stl.getBorderColor(p)).getIndex());
                }
                if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
                    cellStyle.setBorderTop(this.getHssfBorder((ShareStyleAttributes)stl, p));
                    cellStyle.setTopBorderColor(POIXlsExporter.getNearestColor(stl.getBorderColor(p)).getIndex());
                }
                if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
                    cellStyle.setBorderBottom(this.getHssfBorder((ShareStyleAttributes)stl, p));
                    cellStyle.setBottomBorderColor(POIXlsExporter.getNearestColor(stl.getBorderColor(p)).getIndex());
                }
                cellStyle.setAlignment(this.getHorizontalAlignment((ShareStyleAttributes)stl));
                cellStyle.setVerticalAlignment(this.getVerticalAlignment((ShareStyleAttributes)stl));
                cellStyle.setWrapText(stl.isWrapText());
                cellStyle.setShrinkToFit(stl.isShrinkText());
                cellStyle.setRotation((short)(0 - (short)stl.getRotation()));
                cellStyle.setIndention((short)stl.getIndentation());
                if (this.isBookProtected()) {
                    cellStyle.setLocked(true);
                } else {
                    cellStyle.setLocked(stl.isLocked());
                }
                cellStyle.setHidden(stl.isHided());
            }
            if (this.exportFormat && numberFormat.length() != 0 && !this.isKDTableFormatStr(numberFormat)) {
                if (!"000000".equals(numberFormat) && DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
                    numberFormat = cell.getText().replaceAll("\\.", "\\\\.");
                    numberFormat = numberFormat + ";" + numberFormat;
                    numberFormat = numberFormat.replaceAll("^-", "");
                }
                if (this.isScience(numberFormat)) {
                    numberFormat = numberFormat.substring(0, numberFormat.length() - 3) + "E+0";
                }
                numberFormat = numberFormat.replaceAll("!", "\\\\");
                short builtInFormat = this.format.getFormat(numberFormat);
                cellStyle.setDataFormat(builtInFormat);
            }
            loadedFormatStyles.put(formatString, cellStyle);
            this.loadedCellStyles.put(stl, loadedFormatStyles);
        }
        return cellStyle;
    }

    private boolean isScience(String numberFormat) {
        String science = "(0|0(.0){1}[0]*){1}e00";
        return numberFormat.toLowerCase(Locale.ENGLISH).matches(science);
    }

    public String convertFormat(String numberFormat) {
        String sFmt = null;
        try {
            sFmt = new String(numberFormat.getBytes(StandardCharsets.UTF_8), "ISO8859_1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sFmt;
    }

    private boolean isKDTableFormatStr(String str) {
        if (str.startsWith("%")) {
            return true;
        }
        if (str.startsWith("$L") || str.startsWith("$U") || str.startsWith("$P")) {
            return true;
        }
        if (str.startsWith("@") && str.length() > 1) {
            return true;
        }
        return this.getCharCount(str, ';') > 3;
    }

    private int getCharCount(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    HorizontalAlignment getHorizontalAlignment(ShareStyleAttributes ssa) {
        short align = (short)ssa.getHorizontalAlign().getValue();
        HorizontalAlignment horizontalAlignment = align == HorizontalAlignment.LEFT.getCode() ? HorizontalAlignment.LEFT : (align == HorizontalAlignment.CENTER.getCode() ? HorizontalAlignment.CENTER : (align == HorizontalAlignment.RIGHT.getCode() ? HorizontalAlignment.RIGHT : HorizontalAlignment.GENERAL));
        return horizontalAlignment;
    }

    VerticalAlignment getVerticalAlignment(ShareStyleAttributes ssa) {
        short align = (short)ssa.getVerticalAlign().getValue();
        VerticalAlignment verticalAlignment = align == VerticalAlignment.TOP.getCode() ? VerticalAlignment.TOP : (align == VerticalAlignment.CENTER.getCode() ? VerticalAlignment.CENTER : (align == VerticalAlignment.BOTTOM.getCode() ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    BorderStyle getHssfBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    FillPatternType getHssfPattern(ShareStyleAttributes ssa) {
        FillPatternType sret;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    private void createWorkSheet(HSSFWorkbook workBook, KDSBook book) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            KDSSheet kdssheet = book.getSheet(i);
            this.sheet = this.workbook.createSheet();
            this.workbook.setSheetHidden(i, kdssheet.getSheetStyleAttributes().isHided());
            this.workbook.setSheetName(i, kdssheet.getName());
            if (this.workbook.getActiveSheetIndex() != 0 || !this.workbook.isSheetHidden(0) || this.workbook.isSheetHidden(i)) continue;
            this.workbook.setActiveSheet(i);
            this.workbook.setFirstVisibleTab(i);
        }
    }

    private boolean isTextStyle(String numberFormat) {
        return numberFormat != null && numberFormat.length() > 1 && (numberFormat.equals("@") || numberFormat.equals("%l{@}s"));
    }

    private void exportCellTextWithFormat(String numberFormat, String text) {
        if (this.isTextStyle(numberFormat)) {
            this.setCellValue(text);
        } else {
            this.exportCellTextAsNumber(text);
        }
    }

    private void exportCellTextAsNumber(String text) {
        try {
            Double d = Double.valueOf(text);
            this.cell.setCellValue(((Number)d).doubleValue());
        }
        catch (NumberFormatException e) {
            this.setCellValue(text);
        }
    }

    private void setCellValue(String text) {
        if (!StringUtil.isEmptyString((String)text)) {
            this.cell.setCellValue(text);
        }
    }
}

