/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.SystemPropertyUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.export.AbstractExporter;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.io.KDFontMapper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class PdfExporter
extends AbstractExporter {
    private static final Logger logger = LogUtil.getPackageLogger(PdfExporter.class);
    private PrintableBook printkds = null;
    private Document document = null;
    private PdfContentByte pdfContentByte = null;
    public static KDFontMapper DEFAULT_FONTMAPPER = new KDFontMapper();
    private static final float[] staticDashs3 = new float[]{5.0f, 5.0f, 15.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
    private static final float[] staticDashs4 = new float[]{5.0f, 5.0f, 15.0f, 5.0f};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void export() {
        this.printkds = (PrintableBook)this.parameters.get(ExporterParameter.KD_Print);
        if (this.printkds == null) {
            throw new RuntimeException(CtrlKDFMessages.getMLS("noOutputSource", "\u672a\u8bbe\u7f6e\u8f93\u51fa\u6e90\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8981\u8f93\u51fa\u7684\u6587\u6863"));
        }
        OutputStream os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            this.exportToStream(os);
            return;
        }
        File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new RuntimeException("No output specified for the exporter.");
            destFile = new File(FilenameUtils.normalize((String)fileName));
        }
        try {
            os = new FileOutputStream(destFile);
            this.exportToStream(os);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error trying to export to file : " + destFile, e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{os});
    }

    private void exportToStream(OutputStream os) {
        float[] pagesize;
        float[] papersize = pagesize = this.printkds.getPaperSize();
        Rectangle rc = new Rectangle((float)StyleUtil.lomToPt((double)(pagesize[0] * 10.0f)), (float)StyleUtil.lomToPt((double)(pagesize[1] * 10.0f)));
        KDSSheetPrintSetup printSetup = this.printkds.getBook().getSheet(0).getPrintSetup();
        float bottom = printSetup.getBottom();
        float top = printSetup.getTop();
        float left = printSetup.getLeft();
        float right = printSetup.getRight();
        short scale = printSetup.getScale();
        this.document = new Document(rc, (float)StyleUtil.lomToPt((double)((double)left * 25.4 * 10.0)), (float)StyleUtil.lomToPt((double)((double)right * 25.4 * 10.0)), (float)StyleUtil.lomToPt((double)((double)top * 25.4 * 10.0)), (float)StyleUtil.lomToPt((double)((double)bottom * 25.4 * 10.0)));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            BaseFont fontChinese = null;
            try {
                String prefixFont = "";
                String osn = SystemPropertyUtil.getProperties().getProperty("os.name");
                prefixFont = osn.startsWith("win") || osn.startsWith("Win") ? "C:\\Windows\\Fonts" + File.separator : "/usr/share/fonts/chinese" + File.separator;
                fontChinese = BaseFont.createFont((String)(prefixFont + "simsun.ttc,0"), (String)"Identity-H", (boolean)false);
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
            Font chinese = new Font(fontChinese, 10.0f, 0);
            HeaderFooter header = new HeaderFooter(new Phrase(printSetup.getHeaderLeft() + printSetup.getHeaderCenter() + printSetup.getHeaderRight(), chinese), false);
            header.setAlignment(1);
            header.setBorder(0);
            this.document.setHeader(header);
            HeaderFooter footer = new HeaderFooter(new Phrase(printSetup.getFooterLeft() + printSetup.getFooterCenter() + printSetup.getFooterRight(), chinese), false);
            footer.setBorder(0);
            footer.setAlignment(1);
            this.document.setFooter(footer);
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
            ArrayList pages = this.printkds.getIndexedPagesNoSavePaper();
            for (int i = 0; i < pages.size(); ++i) {
                IndexedPage page = (IndexedPage)pages.get(i);
                PdfTemplate pdftemplate = this.pdfContentByte.createTemplate((float)StyleUtil.lomToPt((double)(papersize[0] * 10.0f)), (float)StyleUtil.lomToPt((double)(papersize[1] * 10.0f)));
                Graphics2D graphics2d = pdftemplate.createGraphics((float)StyleUtil.lomToPt((double)(papersize[0] * 10.0f)), (float)StyleUtil.lomToPt((double)(papersize[1] * 10.0f)), (FontMapper)DEFAULT_FONTMAPPER);
                java.awt.Rectangle sp = new java.awt.Rectangle((int)StyleUtil.lomToPt((double)((double)left * 25.4 * 10.0)), (int)StyleUtil.lomToPt((double)((double)top * 25.4 * 10.0)), (int)StyleUtil.lomToPt((double)((double)pagesize[0] - (double)left * 25.4 - (double)right * 25.4)) * 10, (int)StyleUtil.lomToPt((double)((double)pagesize[1] - (double)top * 25.4 - (double)bottom * 25.4)) * 10);
                graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi() * (double)scale / 100.0, 72.0 / (double)KDToolkit.getCurrentDpi() * (double)scale / 100.0);
                this.printkds.getPageRender(page).draw(graphics2d, sp);
                ArrayList listBlocks = page.getListBlocks();
                int size = listBlocks.size();
                for (int j = 0; j < size; ++j) {
                    Object obj = listBlocks.get(j);
                    if (!(obj instanceof IndexedPage.PageBlock)) continue;
                    try {
                        IndexedPage.PageBlock block = (IndexedPage.PageBlock)obj;
                        KDSSheet kdssheet = block.getSheet();
                        ArrayList layer = kdssheet.getEmbedhLayer();
                        int len = layer.size();
                        for (int k = 0; k < len; k += 2) {
                            int l;
                            int y;
                            int l2;
                            byte[] data = (byte[])layer.get(k);
                            java.awt.Rectangle bounds = (java.awt.Rectangle)layer.get(k + 1);
                            boolean leftTop = block.contains(kdssheet, bounds.x, bounds.y);
                            boolean leftBottom = block.contains(kdssheet, bounds.width, bounds.y);
                            boolean rightTop = block.contains(kdssheet, bounds.x, bounds.height);
                            boolean rightBottom = block.contains(kdssheet, bounds.width, bounds.height);
                            int width = 0;
                            int height = 0;
                            int startX = 0;
                            int startY = 0;
                            BufferedImage source = ImageIO.read(new ByteArrayInputStream(data));
                            int sourceWidth = source.getWidth();
                            int sourceHeight = source.getHeight();
                            int startColumn = 0;
                            int startRow = 0;
                            if (leftTop) {
                                if (rightTop) {
                                    for (l2 = bounds.y; l2 < bounds.height; ++l2) {
                                        width = (int)((float)width + kdssheet.getColumnWidth(l2));
                                    }
                                } else {
                                    for (l2 = bounds.y; l2 < block.getEndCol(); ++l2) {
                                        width = (int)((float)width + kdssheet.getColumnWidth(l2));
                                    }
                                }
                                if (leftBottom) {
                                    for (l2 = bounds.x; l2 < bounds.width; ++l2) {
                                        height = (int)((float)height + kdssheet.getRowHeight(l2));
                                    }
                                } else {
                                    for (l2 = bounds.x; l2 < block.getEndRow(); ++l2) {
                                        height = (int)((float)height + kdssheet.getRowHeight(l2));
                                    }
                                }
                                for (l2 = block.getBeginCol(); l2 < bounds.y; ++l2) {
                                    startColumn = (int)((float)startColumn + kdssheet.getColumnWidth(l2));
                                }
                                for (l2 = block.getBeginRow(); l2 < bounds.x; ++l2) {
                                    startRow = (int)((float)startRow + kdssheet.getRowHeight(l2));
                                }
                            } else if (rightTop) {
                                for (l2 = block.getBeginCol(); l2 < bounds.height + 1; ++l2) {
                                    width = (int)((float)width + kdssheet.getColumnWidth(l2));
                                }
                                if (rightBottom) {
                                    for (l2 = bounds.x; l2 < bounds.width; ++l2) {
                                        height = (int)((float)height + kdssheet.getRowHeight(l2));
                                    }
                                } else {
                                    for (l2 = bounds.x; l2 < block.getEndRow(); ++l2) {
                                        height = (int)((float)height + kdssheet.getRowHeight(l2));
                                    }
                                }
                                startX = sourceWidth - (int)((double)(width * 96) / 25.4) + 100;
                                for (l2 = block.getBeginRow(); l2 < bounds.x; ++l2) {
                                    startRow = (int)((float)startRow + kdssheet.getRowHeight(l2));
                                }
                            } else if (leftBottom) {
                                for (l2 = block.getBeginRow(); l2 < bounds.width; ++l2) {
                                    height = (int)((float)height + kdssheet.getRowHeight(l2));
                                }
                                y = 0;
                                for (l = bounds.x; l < block.getBeginRow(); ++l) {
                                    y = (int)((float)y + kdssheet.getRowHeight(l));
                                }
                                startY = (int)((double)(y * 96) / 25.4);
                                if (rightBottom) {
                                    for (l = bounds.y; l < bounds.height; ++l) {
                                        width = (int)((float)width + kdssheet.getColumnWidth(l));
                                    }
                                } else {
                                    for (l = bounds.y; l < block.getEndCol(); ++l) {
                                        width = (int)((float)width + kdssheet.getColumnWidth(l));
                                    }
                                }
                                for (l = block.getBeginCol(); l < bounds.y; ++l) {
                                    startColumn = (int)((float)startColumn + kdssheet.getColumnWidth(l));
                                }
                            } else if (rightBottom) {
                                for (l2 = block.getBeginCol(); l2 < bounds.height; ++l2) {
                                    width = (int)((float)width + kdssheet.getColumnWidth(l2));
                                }
                                for (l2 = block.getBeginRow(); l2 < bounds.width; ++l2) {
                                    height = (int)((float)height + kdssheet.getRowHeight(l2));
                                }
                                y = 0;
                                for (l = bounds.y; l < block.getBeginCol(); ++l) {
                                    y = (int)((float)y + kdssheet.getColumnWidth(l));
                                }
                                startX = (int)((double)(y * 96) / 25.4);
                                y = 0;
                                for (l = bounds.x; l < block.getBeginRow(); ++l) {
                                    y = (int)((float)y + kdssheet.getRowHeight(l));
                                }
                                startY = (int)((double)(y * 96) / 25.4);
                            }
                            if (height <= 0 || width <= 0) continue;
                            height = (int)((double)(height * 96) / 25.4);
                            width = (int)((double)(width * 96) / 25.4);
                            int marginLeft = (int)StyleUtil.lomToPt((double)((double)left * 25.4 * 10.0));
                            int marginTop = (int)StyleUtil.lomToPt((double)((double)top * 25.4 * 10.0));
                            BufferedImage paintImage = new BufferedImage(width, height, 2);
                            int dx = startX + width;
                            int dy = startY + height;
                            paintImage.getGraphics().drawImage(source, 0, 0, width, height, startX, startY, dx > sourceWidth ? sourceWidth : dx, dy > sourceHeight ? sourceHeight : dy, null);
                            this.printkds.getPageRender(page).getImageRender().draw((Graphics)graphics2d, (Shape)new java.awt.Rectangle(marginLeft + (int)((double)(startColumn * 96) / 25.4), marginTop + (int)((double)(startRow * 96) / 25.4), width, height), (Object)paintImage, Styles.getDefaultStyle());
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"err", (Throwable)ex);
                    }
                }
                graphics2d.dispose();
                pdftemplate.setWidth((float)StyleUtil.lomToPt((double)(papersize[0] * 10.0f)));
                pdftemplate.setHeight((float)StyleUtil.lomToPt((double)(papersize[1] * 10.0f)));
                this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
                this.document.newPage();
            }
            this.document.close();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error : ", e);
        }
    }

    float[] getdash(int style) {
        switch (style) {
            case 2: {
                float[] dash = new float[]{5.0f};
                return dash;
            }
            case 3: {
                float[] dash2 = new float[]{1.5f};
                return dash2;
            }
            case 4: {
                float[] dash3 = staticDashs3;
                return dash3;
            }
            case 5: {
                float[] dash4 = staticDashs4;
                return dash4;
            }
        }
        return null;
    }
}

