/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export.direct;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.export.AbstractExporter;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.direct.HtmlPageExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.util.CellImageCreator;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class HtmlPageExporter
extends AbstractExporter {
    private static final Logger logger = LogUtil.getPackageLogger(HtmlPageExporter.class);
    private Page page;
    private Writer writer;
    private StringBuffer sb = new StringBuffer();
    private String encoding;
    private int imageCount;
    private String imageDir;
    private String imageRelativeDir;

    @Override
    public void export() {
        this.imageCount = 0;
        this.page = (Page)this.parameters.get(HtmlPageExporterParameter.PAGE);
        if (this.page == null) {
            throw new RuntimeException("kdf page required");
        }
        this.encoding = (String)this.parameters.get(ExporterParameter.CHARACTER_ENCODING);
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.writer = (Writer)this.parameters.get(ExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to writer : ", e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, this.encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to OutputStream writer : ", e);
            }
        }
        File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(FilenameUtils.normalize((String)fileName));
                if (!destFile.exists()) {
                    this.recursiveCreateDir(destFile);
                }
            } else {
                throw new RuntimeException("No output specified for the exporter.");
            }
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.writer = new OutputStreamWriter(os, this.encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating to file writer : ", e);
            }
            finally {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error close file : ", e);
        }
    }

    private void recursiveCreateDir(File file) {
        File pf = file.getParentFile();
        if (!pf.exists()) {
            pf.mkdirs();
        }
    }

    private void exportReportToWriter() throws IOException {
        this.exportHeadAndBody();
        this.writer.write(this.sb.toString());
        this.writer.flush();
    }

    void exportHeadAndBody() throws IOException {
        this.sb.append("<html ");
        this.sb.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\r\n");
        this.sb.append("<head>\r\n\t<meta http-equiv=Content-Type content=\"text/html; charset=").append(this.encoding).append("\">\r\n");
        this.sb.append("</head>\r\n");
        this.save_HtmlBody();
        this.sb.append("</html>\r\n");
    }

    private void save_HtmlBody() throws IOException {
        this.sb.append("<body>\r\n<div ");
        this.sb.append("style='position:absolute;");
        this.sb.append("top:").append((double)this.page.getTop().getInteger() / 10.0).append("mm;");
        this.sb.append("left:").append((double)this.page.getLeft().getInteger() / 10.0).append("mm;");
        this.sb.append("width:").append((double)(this.page.getRight().getInteger() - this.page.getLeft().getInteger()) / 10.0).append("mm;");
        this.sb.append("height:").append((double)(this.page.getBottom().getInteger() - this.page.getTop().getInteger()) / 10.0).append("mm;");
        this.save_HtmlStyle(HtmlPageExporter.getContainerSSA(this.page));
        this.sb.append("'/>\r\n");
        Iterator itr = this.page.iterator();
        while (itr.hasNext()) {
            Container cont = (Container)itr.next();
            this.save_HtmlContainer(cont);
        }
        this.sb.append("</body>\r\n");
    }

    public static ShareStyleAttributes getContainerSSA(Container e) {
        ArrayList<ShareStyleAttributes> lssa = new ArrayList<ShareStyleAttributes>();
        do {
            lssa.add(e.getCustomStyles().getStyleAttributes());
            lssa.add(e.getStyles());
        } while ((e = e.getParent()) != null);
        ShareStyleAttributes[] assa = new ShareStyleAttributes[lssa.size()];
        lssa.toArray(assa);
        return Styles.mergeSSA((ShareStyleAttributes[])assa);
    }

    private void save_HtmlStyle(ShareStyleAttributes ssa) throws IOException {
        if (ssa == null || ssa.isEmpty()) {
            return;
        }
        String m_cs = this.get_Html_Align(ssa);
        if (m_cs.length() > 0) {
            this.sb.append(m_cs);
        }
        if (ssa.hasBordersAttributes()) {
            if (ssa.hasBorderAttributes(Styles.Position.LEFT)) {
                m_cs = this.get_Html_Line(Styles.Position.LEFT, ssa);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.TOP)) {
                m_cs = this.get_Html_Line(Styles.Position.TOP, ssa);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.RIGHT)) {
                m_cs = this.get_Html_Line(Styles.Position.RIGHT, ssa);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.BOTTOM)) {
                m_cs = this.get_Html_Line(Styles.Position.BOTTOM, ssa);
                this.sb.append(m_cs);
            }
        }
        if (ssa.hasFontAttributes()) {
            m_cs = this.get_Html_Font(ssa);
            this.sb.append(m_cs);
        }
        if (ssa.hasAttributes(ShareStyleAttributes.BACKGROUND_COLOR)) {
            m_cs = "background:" + StyleParser.colorToHex((Color)ssa.getBackground()) + ";";
            this.sb.append(m_cs);
        }
    }

    private void save_HtmlContainer(Container cont) throws IOException {
        this.sb.append("<div ");
        ShareStyleAttributes ssa = HtmlPageExporter.getContainerSSA(cont);
        boolean bwraptext = false;
        if (ssa.hasAttributes(ShareStyleAttributes.WRAP_TEXT)) {
            bwraptext = ssa.isWrapText();
        }
        if (!bwraptext) {
            this.sb.append("nowrap ");
        }
        this.sb.append("style='position:absolute;");
        this.sb.append("top:").append((double)Math.min(cont.getTop().getInteger(), cont.getBottom().getInteger()) / 10.0).append("mm;");
        this.sb.append("left:").append((double)Math.min(cont.getLeft().getInteger(), cont.getRight().getInteger()) / 10.0).append("mm;");
        this.sb.append("width:").append((double)Math.abs(cont.getRight().getInteger() - cont.getLeft().getInteger()) / 10.0).append("mm;");
        this.sb.append("height:").append((double)Math.abs(cont.getBottom().getInteger() - cont.getTop().getInteger()) / 10.0).append("mm;");
        this.save_HtmlStyle(ssa);
        this.sb.append("'>\r\n");
        if (cont instanceof Cell && ((Cell)cont).getData() != null) {
            Data data = ((Cell)cont).getData();
            Image img = CellImageCreator.getImageOf((Cell)cont);
            if (img != null) {
                String href = this.saveImage(img);
                if (href != null) {
                    this.sb.append(href);
                }
            } else {
                this.sb.append(this.escape(data.getFormat()));
            }
        }
        this.sb.append("</div>\r\n");
        Iterator itr = cont.iterator();
        while (itr.hasNext()) {
            this.save_HtmlContainer((Container)itr.next());
        }
    }

    private String escape(String src) {
        if (src != null) {
            String str = src.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            return str;
        }
        return "";
    }

    private String saveImage(Image img) {
        if (img != null) {
            if (this.imageDir == null) {
                File fl = null;
                String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
                fl = fileName == null ? (File)this.parameters.get(ExporterParameter.OUTPUT_FILE) : new File(FilenameUtils.normalize((String)fileName));
                if (fl != null) {
                    String path = fl.getParent();
                    String name = fl.getName();
                    int i = name.lastIndexOf(46);
                    name = i < 0 ? name + "_images" : name.substring(0, i) + "_images";
                    File dir = new File(FilenameUtils.normalize((String)(path = path + File.separator + name)));
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    this.imageDir = path;
                    this.imageRelativeDir = name;
                }
            }
            if (this.imageDir != null) {
                ++this.imageCount;
                String imgName = this.imageDir + File.separator + "image" + String.valueOf(this.imageCount) + ".png";
                try {
                    BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                    bi.getGraphics().drawImage(img, 0, 0, null);
                    if (ImageIO.write((RenderedImage)bi, "png", new File(FilenameUtils.normalize((String)imgName)))) {
                        return "<img src='" + this.imageRelativeDir + "/image" + String.valueOf(this.imageCount) + ".png'/>";
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }
        }
        return null;
    }

    private String get_Html_Align(ShareStyleAttributes ssa) {
        String csProp = "";
        StringBuilder sbtemp = new StringBuilder();
        if (ssa.hasAttributes(ShareStyleAttributes.HORIZONTAL_ALIGN)) {
            csProp = this.get_AlignStr(ssa.getHorizontalAlign());
            sbtemp.append(" text-align:").append(csProp).append(";");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_ALIGN)) {
            csProp = this.get_VertAlignStr(ssa.getVerticalAlign());
            sbtemp.append(" vertical-align:").append(csProp).append(";");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.WRAP_TEXT) && ssa.isWrapText()) {
            sbtemp.append("word-break:normal;word-wrap:break-word;");
        } else {
            sbtemp.append(" word-break:keep-all;word-wrap:normal;");
        }
        return sbtemp.toString();
    }

    private String get_Html_Font(ShareStyleAttributes ssa) {
        StringBuilder sbtemp = new StringBuilder();
        if (ssa.hasAttributes(ShareStyleAttributes.FONT_NAME)) {
            sbtemp.append(" font-family:").append(ssa.getFontName()).append(";");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.FONT_SIZE)) {
            sbtemp.append(" font-size:").append(ssa.getFontSize()).append("pt;");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.FONT_WEIGHT)) {
            sbtemp.append(" font-weight:").append(ssa.getWeight()).append(";");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.FONT_ITALIC) && ssa.isItalic()) {
            sbtemp.append(" font-style:italic;");
        }
        if (ssa.hasAttributes(ShareStyleAttributes.FONT_COLOR)) {
            sbtemp.append(" color:").append(StyleParser.colorToHex((Color)ssa.getFontColor())).append(";");
        }
        return sbtemp.toString();
    }

    private String get_Html_Line(Styles.Position pos, ShareStyleAttributes ssa) {
        StringBuilder sbtemp = new StringBuilder();
        LineStyle ls = ssa.getBorderLineStyle(pos);
        if (!LineStyle.isNull((LineStyle)ls)) {
            switch (pos.getIndex()) {
                case 0: {
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_LEFT_PENSTYLE)) {
                        sbtemp.append("border-left-style:").append(this.get_Html_Style(ssa.getBorderPenStyle(pos))).append(";");
                    }
                    sbtemp.append("border-left-width:").append(ls.getWidth()).append(";");
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_LEFT_COLOR)) {
                        sbtemp.append("border-left-color:").append(StyleParser.colorToHex((Color)ssa.getBorderColor(pos))).append(";");
                    }
                }
                case 1: {
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_TOP_PENSTYLE)) {
                        sbtemp.append("border-top-style:").append(this.get_Html_Style(ssa.getBorderPenStyle(pos))).append(";");
                    }
                    sbtemp.append("border-top-width:").append(ls.getWidth()).append(";");
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_TOP_COLOR)) {
                        sbtemp.append("border-top-color:").append(StyleParser.colorToHex((Color)ssa.getBorderColor(pos))).append(";");
                    }
                }
                case 2: {
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_PENSTYLE)) {
                        sbtemp.append("border-right-style:").append(this.get_Html_Style(ssa.getBorderPenStyle(pos))).append(";");
                    }
                    sbtemp.append("border-right-width:").append(ls.getWidth()).append(";");
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_COLOR)) {
                        sbtemp.append("border-right-color:").append(StyleParser.colorToHex((Color)ssa.getBorderColor(pos))).append(";");
                    }
                }
                case 3: {
                    if (ssa.hasAttributes(ShareStyleAttributes.BORDER_BOTTOM_PENSTYLE)) {
                        sbtemp.append("border-bottom-style:").append(this.get_Html_Style(ssa.getBorderPenStyle(pos))).append(";");
                    }
                    sbtemp.append("border-bottom-width:").append(ls.getWidth()).append(";");
                    if (!ssa.hasAttributes(ShareStyleAttributes.BORDER_BOTTOM_COLOR)) break;
                    sbtemp.append("border-bottom-color:").append(StyleParser.colorToHex((Color)ssa.getBorderColor(pos))).append(";");
                }
            }
        }
        return sbtemp.toString();
    }

    private String get_Html_Style(PenStyle ps) {
        String ret = ps == PenStyle.PS_SOLID ? "solid" : (ps == PenStyle.PS_CONTINUOUS ? "dotted" : "dashed");
        return ret;
    }

    private String get_AlignStr(Styles.HorizontalAlignment align) {
        return align.toString();
    }

    private String get_VertAlignStr(Styles.VerticalAlignment align) {
        return align.toString();
    }
}

