/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form;

import com.kingdee.cosmic.ctrl.kdf.form.EntityInfo;
import com.kingdee.cosmic.ctrl.kdf.form.Group;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.form.PropertyCollection;
import com.kingdee.cosmic.ctrl.kdf.form.Style;
import com.kingdee.cosmic.ctrl.kdf.form.StyleCollection;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Container
implements Serializable,
Comparable {
    private String id;
    private EntityInfo left;
    private EntityInfo right;
    private EntityInfo top;
    private EntityInfo bottom;
    private Page page;
    private ShareStyleAttributes styles = Styles.getEmptySSA();
    private StyleCollection customStyles = StyleCollection.getEmptyStyleCollection();
    private PropertyCollection properties = PropertyCollection.getEmptyPropertyCollection();
    private String aliasName;
    private String userAlias;
    private String layer;
    private String preSteps;
    private String postSteps;
    private String anchor;
    private String hint;
    private EntityInfo holdPlace;
    private EntityInfo visibility;
    private Container source;
    private Object userObject;
    private int priority;
    protected Container parent;

    public int compareTo(Object o) {
        if (o instanceof Container) {
            Container ct = (Container)o;
            if (this.priority < ct.priority) {
                return 1;
            }
            if (this.priority == ct.priority) {
                return 0;
            }
        }
        return -1;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Container getSource() {
        return this.source;
    }

    public void setSource(Container source) {
        this.source = source;
    }

    public Container() {
        this.left = new EntityInfo();
        this.right = new EntityInfo();
        this.top = new EntityInfo();
        this.bottom = new EntityInfo();
        this.holdPlace = new EntityInfo();
        this.visibility = new EntityInfo();
        this.source = this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String val) {
        this.id = val;
    }

    public void copyInteger(Container cont) {
        if (cont != null) {
            this.left.setInteger(cont.getLeft().getInteger());
            this.right.setInteger(cont.getRight().getInteger());
            this.top.setInteger(cont.getTop().getInteger());
            this.bottom.setInteger(cont.getBottom().getInteger());
        }
    }

    protected void copyOriginString(Container cont) {
        if (cont != null) {
            this.left.setOriginString(cont.getLeft().getOriginString());
            this.right.setOriginString(cont.getRight().getOriginString());
            this.top.setOriginString(cont.getTop().getOriginString());
            this.bottom.setOriginString(cont.getBottom().getOriginString());
            this.left.setString(this.left.getOriginString());
            this.right.setString(this.right.getOriginString());
            this.top.setString(this.top.getOriginString());
            this.bottom.setString(this.bottom.getOriginString());
        }
    }

    protected void syncOriginString(Container lastParent, Container parent) {
        if (lastParent != null && parent != null) {
            String oname = "(?:\\[\\s*)" + lastParent.getId() + ".";
            String nname = "[" + parent.getId() + ".";
            if (this.left.getOriginString() != null) {
                this.left.setOriginString(this.left.getOriginString().replaceAll(oname, nname));
            }
            if (this.right.getOriginString() != null) {
                this.right.setOriginString(this.right.getOriginString().replaceAll(oname, nname));
            }
            if (this.top.getOriginString() != null) {
                this.top.setOriginString(this.top.getOriginString().replaceAll(oname, nname));
            }
            if (this.bottom.getOriginString() != null) {
                this.bottom.setOriginString(this.bottom.getOriginString().replaceAll(oname, nname));
            }
        }
    }

    protected void syncOriginString() {
        this.left.setOriginString(this.left.getString());
        this.right.setOriginString(this.right.getString());
        this.top.setOriginString(this.top.getString());
        this.bottom.setOriginString(this.bottom.getString());
    }

    public void syncOriginStringFromInt() {
        this.left.setOriginString(String.valueOf(this.left.getInteger()));
        this.right.setOriginString(String.valueOf(this.right.getInteger()));
        this.top.setOriginString(String.valueOf(this.top.getInteger()));
        this.bottom.setOriginString(String.valueOf(this.bottom.getInteger()));
        this.left.setString(null);
        this.right.setString(null);
        this.top.setString(null);
        this.bottom.setString(null);
        if (this.holdPlace.getInteger() == 1 || this.holdPlace.getOriginString() == null) {
            this.holdPlace.setOriginString(null);
        } else {
            this.holdPlace.setOriginString(String.valueOf(this.holdPlace.getInteger()));
        }
        this.holdPlace.setString(null);
        if (this.visibility.getInteger() == 1 || this.visibility.getOriginString() == null) {
            this.visibility.setOriginString(null);
        } else {
            this.visibility.setOriginString(String.valueOf(this.visibility.getInteger()));
        }
        this.visibility.setString(null);
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Container cont = (Container)itr.next();
            cont.syncOriginStringFromInt();
        }
    }

    private int resovleInt(String str, int def) {
        if (str != null) {
            return Integer.parseInt(str);
        }
        return def;
    }

    public void syncDataForSnap() {
        this.left.setInteger(this.resovleInt(this.left.getOriginString(), 0));
        this.right.setInteger(this.resovleInt(this.right.getOriginString(), 0));
        this.top.setInteger(this.resovleInt(this.top.getOriginString(), 0));
        this.bottom.setInteger(this.resovleInt(this.bottom.getOriginString(), 0));
        this.holdPlace.setInteger(this.resovleInt(this.holdPlace.getOriginString(), 1));
        this.visibility.setInteger(this.resovleInt(this.visibility.getOriginString(), 1));
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Container cont = (Container)itr.next();
            cont.syncDataForSnap();
        }
    }

    public void restoreOriginString() {
        this.left.setString(this.left.getOriginString());
        this.right.setString(this.right.getOriginString());
        this.top.setString(this.top.getOriginString());
        this.bottom.setString(this.bottom.getOriginString());
        this.left.setInteger(0);
        this.right.setInteger(0);
        this.top.setInteger(0);
        this.bottom.setInteger(0);
        this.holdPlace.setString(this.holdPlace.getOriginString());
        this.holdPlace.setInteger(0);
        this.visibility.setString(this.visibility.getOriginString());
        this.visibility.setInteger(0);
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Container cont = (Container)itr.next();
            cont.restoreOriginString();
        }
    }

    public EntityInfo getLeft() {
        return this.left;
    }

    public void setLeft(EntityInfo val) {
        if (val != null) {
            this.left.setString(val.getString());
            this.left.setOriginString(val.getOriginString());
            this.left.setInteger(val.getInteger());
        } else {
            this.left = null;
        }
    }

    public EntityInfo getRight() {
        return this.right;
    }

    public void setRight(EntityInfo val) {
        if (val != null) {
            this.right.setString(val.getString());
            this.right.setOriginString(val.getOriginString());
            this.right.setInteger(val.getInteger());
        } else {
            this.right = null;
        }
    }

    public EntityInfo getTop() {
        return this.top;
    }

    public void setTop(EntityInfo val) {
        if (val != null) {
            this.top.setString(val.getString());
            this.top.setOriginString(val.getOriginString());
            this.top.setInteger(val.getInteger());
        } else {
            this.top = null;
        }
    }

    public EntityInfo getBottom() {
        return this.bottom;
    }

    public void setBottom(EntityInfo val) {
        if (val != null) {
            this.bottom.setString(val.getString());
            this.bottom.setOriginString(val.getOriginString());
            this.bottom.setInteger(val.getInteger());
        } else {
            this.bottom = null;
        }
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container val) {
        if (val instanceof Page) {
            this.page = (Page)val;
        } else if (val != null) {
            this.page = val.getPage();
        }
        this.parent = val;
    }

    public abstract boolean addChild(Container var1);

    public abstract boolean deleteChild(Container var1);

    public abstract Iterator iterator();

    protected abstract ArrayList innerList();

    public abstract Group group();

    public abstract Container nextCopy();

    public abstract Container copy(boolean var1);

    public abstract Container copyTo(Container var1, boolean var2);

    public Page getPage() {
        return this.page;
    }

    public StyleCollection getCustomStyles() {
        return this.customStyles;
    }

    protected void setCustomStyles(StyleCollection styles) {
        this.customStyles = styles;
    }

    public ShareStyleAttributes getStyles() {
        return this.styles;
    }

    public void setStyles(ShareStyleAttributes ssas) {
        this.styles = ssas != null ? ssas : Styles.getEmptySSA();
    }

    public String getFullName() {
        if (this.page == null) {
            return this.getId();
        }
        return this.page.getId() + "." + this.getId();
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public String getAliasName() {
        if (this.aliasName == null) {
            return this.getFullName();
        }
        return this.aliasName;
    }

    public EntityInfo getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EntityInfo val) {
        if (val != null) {
            this.visibility.setString(val.getString());
            this.visibility.setOriginString(val.getOriginString());
            this.visibility.setInteger(val.getInteger());
        } else {
            this.visibility = null;
        }
    }

    public EntityInfo getHoldPlace() {
        return this.holdPlace;
    }

    public void setHoldPlace(EntityInfo val) {
        if (val != null) {
            this.holdPlace.setString(val.getString());
            this.holdPlace.setOriginString(val.getOriginString());
            this.holdPlace.setInteger(val.getInteger());
        } else {
            this.holdPlace = null;
        }
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String string) {
        this.layer = string;
    }

    public String getPostSteps() {
        return this.postSteps;
    }

    public String getPreSteps() {
        return this.preSteps;
    }

    public void setPostSteps(String string) {
        this.postSteps = string;
    }

    public void setPreSteps(String string) {
        this.preSteps = string;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    protected void setProperties(PropertyCollection collection) {
        this.properties = collection;
    }

    public void copyCustomStyles(StyleCollection collection) {
        this.customStyles = this.customStyles.clone(collection);
    }

    public void addCustomStyle(Style style) {
        this.customStyles = this.customStyles.add(style);
    }

    public void removeCustomStyle(Style style) {
        this.customStyles = this.customStyles.remove(style);
    }

    public void copyProperties(PropertyCollection collection) {
        this.properties = this.properties.clone(collection);
    }

    public void addProperty(Property prop) {
        this.properties = this.properties.add(prop);
    }

    public void removeProperty(Property prop) {
        this.properties = this.properties.remove(prop);
    }

    public String getUserAlias() {
        return this.userAlias;
    }

    public void setUserAlias(String string) {
        this.userAlias = string;
    }

    public String getUsableAlias() {
        if (this.userAlias == null) {
            return this.getId();
        }
        return this.userAlias;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String toString() {
        return "id=" + this.getId() + " alias=" + this.getAliasName() + " x=" + this.getLeft().getInteger() + " y=" + this.getTop().getInteger() + " cx=" + (this.getRight().getInteger() - this.getLeft().getInteger()) + " cy=" + (this.getBottom().getInteger() - this.getTop().getInteger());
    }
}

