/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions;

import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.BrowserInitializableAction;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.ExitAction;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.OpenKDFAction;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.ContextEventListener;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.CurrentPageContextChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.VisibleContextChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.VisibleLayerChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootDesignerAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ActionInitializer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.DoPrintAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.DoSetupPrintAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.GotoNextPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.InitializableAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.StartMarginAdjustAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.util.FloatingButtonEnabler;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolbarBuilder
implements ActionInitializer,
ContextEventListener {
    transient FloatingButtonEnabler fbEnabler = new FloatingButtonEnabler();
    private transient ClientCore clientCore;
    ArrayList managedActions = new ArrayList();

    public ToolbarBuilder(ClientCore clientCore) {
        this.clientCore = clientCore;
        this.disableAllProvidersAction();
    }

    public JToolBar createFileButtons() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.createButton(new OpenKDFAction()));
        return toolbar;
    }

    private AbstractButton createButton(AbstractAction action) {
        Icon icon = (Icon)action.getValue("ICON24");
        AbstractButton button = null;
        Object isToggle = action.getValue("ISTOGGLE");
        if (isToggle != null && ((Boolean)isToggle).booleanValue()) {
            button = new JToggleButton(action);
            button.setIcon(icon);
            button.setText(null);
            button.setMargin(new Insets(0, 0, 0, 0));
            this.fbEnabler.addButton(button);
        } else {
            button = new JButton(action);
            button.setIcon(icon);
            button.setText(null);
            button.setMargin(new Insets(0, 0, 0, 0));
            this.fbEnabler.addButton(button);
        }
        Object isDefaultEnable = action.getValue("DEFAULT_ENABLE");
        if (isDefaultEnable != null) {
            button.setEnabled((Boolean)isDefaultEnable);
        }
        return button;
    }

    @Override
    public void initializeObject(InitializableAction actionObj) {
        this.managedActions.add(actionObj);
        if (actionObj instanceof BrowserInitializableAction) {
            ((BrowserInitializableAction)actionObj).setClientCore(this.clientCore);
        }
    }

    public ArrayList getManagedActions() {
        return this.managedActions;
    }

    @Override
    public void currentPageChanged(CurrentPageChangedEvent event) {
    }

    @Override
    public void currentPageContextChanged(CurrentPageContextChangedEvent event) {
    }

    @Override
    public void uiStateChanged(UIStateChangedEvent event) {
        if (event.getState() == 1) {
            for (AbstractAction aa : this.managedActions) {
                Object val = aa.getValue("ENABLE_UNTIL_DATACOMPLETED");
                if (val == null || !((Boolean)val).booleanValue() || aa instanceof GotoNextPageAction) continue;
                aa.setEnabled(false);
            }
            this.enanbleActionsForCompleteData(false);
        } else if (event.getState() == 0) {
            for (AbstractAction aa : this.managedActions) {
                Object val = aa.getValue("ENABLE_UNTIL_DATACOMPLETED");
                if (val == null || !((Boolean)val).booleanValue()) continue;
                aa.setEnabled(true);
            }
            this.enanbleActionsForCompleteData(true);
        }
    }

    @Override
    public void visibleContextChanged(VisibleContextChangedEvent event) {
    }

    @Override
    public void visibleLayerChanged(VisibleLayerChangedEvent event) {
    }

    public void disableAllProvidersAction() {
        ArrayList providerbuttons = this.clientCore.getPrintService().getBaseComponent().getToolbarManager().getManagedButtons();
        for (AbstractButton ab : providerbuttons) {
            if (ab.getAction() instanceof OpenKDFAction || ab.getAction() instanceof ExitAction) continue;
            ab.setEnabled(false);
        }
    }

    public void enanbleActionsForCompleteData(boolean dataCompleted) {
        ArrayList providerbuttons = this.clientCore.getPrintService().getBaseComponent().getToolbarManager().getManagedButtons();
        for (AbstractButton ab : providerbuttons) {
            if (!(ab.getAction() instanceof DoPrintAction) && !(ab.getAction() instanceof DoSetupPrintAction) && !(ab.getAction() instanceof StartMarginAdjustAction) && !(ab.getAction() instanceof HeadFootDesignerAction)) continue;
            ab.setEnabled(dataCompleted);
        }
    }
}

