/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.DefaultFormPageRetriver;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.DefaultPhysicalPageManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.FormPainter;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.LayerManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.PhysicalPageManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.UIDelegate;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.VirtualPrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.ContextEventListener;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.CurrentPageContextChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.VisibleContextChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.events.context.VisibleLayerChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.editing.IFormObjectEditContext;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.DefaultPreviewPane;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.log4j.Logger;

public class ContextOfBrowser
implements Serviceable {
    private static Logger logger = LogUtil.getPackageLogger(ContextOfBrowser.class);
    private KDPrintService printserv;
    private UIDelegate uiDelegate;
    private DefaultFormPageRetriver rawpageCollector;
    private LayerManager layerMgr;
    private EventListenerList listenerList = null;
    private boolean isfirstPageReady = false;
    private boolean isAdjustingMargin = false;
    private boolean isEditing = false;
    boolean isUpdating = false;
    private IFormObjectEditContext editContext;
    public static final int OPER_SCOPE_GLOBAL = 2;
    public static final int OPER_SCOPE_PAGE = 1;
    public static final int OPER_SCOPE_OBJECT = 0;
    public ContextOfPreview activePreviewContext;
    private PhysicalPageManager activePageMgr;
    private PhysicalPageManager realPhyPageMgr;
    private PhysicalPageManager virtualPhyPageMgr;
    public VirtualPrinterAttrManager virtualPrinterAttrMgr = new VirtualPrinterAttrManager();
    public ContextOfPreview contextOfVirtualPage;
    public static final int VIEWMODE_VIRTUALPAGE = 0;
    public static final int VIEWMODE_PHYSICALPAGE = 1;
    private int viewMode = 1;
    private AbstractPreviewPane vPagePreviewPane;
    private AbstractPreviewPane realPreviewPane;
    private PrintCompContainer virtualCompContainer;

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int mode) {
        this.viewMode = mode;
        switch (mode) {
            case 1: {
                this.activePreviewContext = this.printserv.getPreviewContext();
                this.activePageMgr = this.realPhyPageMgr;
                this.SetContextForActions(this.printserv);
                break;
            }
            case 0: {
                this.activePreviewContext = this.getContextOfVirtualPage();
                this.activePageMgr = this.virtualPhyPageMgr;
                this.printserv.getBaseComponent().setPreviewPane(this.vPagePreviewPane);
                this.SetContextForActions(this.getVirtualCompContainer());
                int target = Math.max(0, this.activePreviewContext.getCurrentPage());
                this.activePreviewContext.Goto(target);
                this.activePreviewContext.updateView();
                this.printserv.getBaseComponent().getPreviewPaneHolder().invalidate();
                this.printserv.getBaseComponent().getPreviewPaneHolder().updateUI();
                break;
            }
        }
    }

    private void SetContextForActions(PrintCompContainer container) {
        ArrayList as = this.printserv.getBaseComponent().getCompositeActions();
        CompositableAction[] cas = as.toArray(new CompositableAction[0]);
        for (int i = 0; i < cas.length; ++i) {
            cas[i].setCompContainer(container);
        }
    }

    public AbstractPreviewPane getRealPreviewPane() {
        if (this.realPreviewPane == null) {
            this.realPreviewPane = new DefaultPreviewPane(this.printserv.getPrinterAttrManager(), this.printserv.getPainter(), this.printserv.getHeaderFooterPainter(), this.printserv.getPreviewContext());
        }
        return this.realPreviewPane;
    }

    public PrintCompContainer getVirtualCompContainer() {
        if (this.virtualCompContainer == null) {
            this.virtualCompContainer = new PrintCompContainer();
            this.virtualCompContainer.setPreviewContext(this.contextOfVirtualPage);
            this.virtualCompContainer.setPrinterAttrmgr(this.virtualPrinterAttrMgr);
            this.virtualCompContainer.innerSetBaseComponent(this.printserv.getBaseComponent());
            this.virtualCompContainer.getManager().put("KDPrintService", this.printserv);
            this.virtualCompContainer.getManager().put("BasePreviewContext", this.contextOfVirtualPage);
        }
        return this.virtualCompContainer;
    }

    public ContextOfPreview getContextOfVirtualPage() {
        if (this.contextOfVirtualPage == null) {
            this.contextOfVirtualPage = new ContextOfPreview();
        }
        if (this.contextOfVirtualPage.getDocInfoProvider() == null && this.printserv != null) {
            try {
                this.contextOfVirtualPage.service(this.printserv.getManager());
                this.contextOfVirtualPage.setDocInfoProvider((DefaultPhysicalPageManager)this.virtualPhyPageMgr);
            }
            catch (ServiceException e) {
                this.contextOfVirtualPage = null;
                logger.error((Object)"Exception occurred.", (Throwable)e);
            }
        }
        return this.contextOfVirtualPage;
    }

    public PrinterAttrManager getPrinterAttrMgr() {
        PrinterAttrManager result = null;
        switch (this.viewMode) {
            case 1: {
                result = this.printserv.getPrinterAttrManager();
                break;
            }
            case 0: {
                result = this.virtualPrinterAttrMgr;
                break;
            }
        }
        return result;
    }

    public void closeDocument() {
        if (this.rawpageCollector.getRawPageCount() != 0) {
            this.realPhyPageMgr.clear();
            this.virtualPhyPageMgr.clear();
            this.layerMgr.clear();
            this.rawpageCollector.clear();
            this.uiDelegate.doRepaint();
            this.activePreviewContext.setAdjustingMargin(false);
        }
    }

    public int getCurrentPage() {
        return this.activePreviewContext.getCurrentPage();
    }

    public int getTotalPageCount() {
        return this.activePreviewContext.getTotalPageCount();
    }

    public boolean Goto(int target) {
        this.editContext.selectedObjectClear();
        return this.activePreviewContext.Goto(target);
    }

    public synchronized void beginDataUpdate() {
        this.isUpdating = true;
        this.activePreviewContext.beginDataUpdate();
        this.isfirstPageReady = false;
        this.fireUIStateChanged(new UIStateChangedEvent(this.activePreviewContext, 1));
    }

    public void setDataUpdated(boolean b) {
        if (!b) {
            this.printserv.getBaseComponent().getToolbarManager().disableButtonsExceptOpen();
            return;
        }
        this.activePreviewContext.setDataUpdated(b);
        IPainter painter = this.printserv.getPainter();
        if (painter instanceof FormPainter) {
            ((FormPainter)painter).setAvailable(this.activePageMgr);
        }
        if (this.uiDelegate.isUIAvailable()) {
            this.uiDelegate.doRepaint();
        }
        this.fireUIStateChanged(new UIStateChangedEvent(this.activePreviewContext, 1));
        if (!this.isfirstPageReady) {
            this.isfirstPageReady = this.activePreviewContext.Goto(0);
        }
    }

    public void finishDataUpdate() {
        this.isUpdating = false;
        if (this.activePreviewContext.getCurrentPage() > this.activePageMgr.count() - 1) {
            this.activePreviewContext.Goto(this.activePageMgr.count() - 1);
        }
        this.fireUIStateChanged(new UIStateChangedEvent(this.activePreviewContext, 0));
        this.fireCurrentPageContextChanged(new CurrentPageContextChangedEvent());
        this.activePreviewContext.finishDataUpdate();
        if (this.uiDelegate.isUIAvailable()) {
            this.uiDelegate.getBaseComponent().doLayout();
        }
    }

    public void service(ServiceManager servmgr) throws ServiceException {
        this.printserv = (KDPrintService)servmgr.lookup("PrintService");
        this.realPhyPageMgr = (PhysicalPageManager)servmgr.lookup("PhysicalPageManager");
        this.virtualPhyPageMgr = (PhysicalPageManager)servmgr.lookup("VirtualPageManager");
        this.activePageMgr = this.realPhyPageMgr;
        this.uiDelegate = (UIDelegate)servmgr.lookup("UIDELEGATE");
        this.rawpageCollector = (DefaultFormPageRetriver)servmgr.lookup("FormPageRetriver");
        this.activePreviewContext = this.printserv.getPreviewContext();
        this.editContext = (IFormObjectEditContext)servmgr.lookup("ObjectEditContext");
        this.layerMgr = (LayerManager)servmgr.lookup("LayerManager");
        this.vPagePreviewPane = (DefaultPreviewPane)servmgr.lookup("VirtualPagePreviewPane");
        if (this.printserv.innerGetBaseComponent() != null && this.printserv.innerGetBaseComponent().getPreviewPane() != this.vPagePreviewPane) {
            this.realPreviewPane = this.printserv.innerGetBaseComponent().getPreviewPane();
        }
    }

    public boolean isAdjustingMargin() {
        return this.isAdjustingMargin;
    }

    public void setOperScope(int scope) {
    }

    public void setEditMode(boolean b) {
        this.isAdjustingMargin = b;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void addContextEventListener(ContextEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ContextEventListener.class, listener);
    }

    public void removeContextEventListener(ContextEventListener listener) {
        this.listenerList.remove(ContextEventListener.class, listener);
    }

    public void fireCurrentPageChanged(CurrentPageChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).currentPageChanged(event);
        }
    }

    public void fireUIStateChanged(UIStateChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).uiStateChanged(event);
        }
    }

    public void fireVisibleContextChanged(VisibleContextChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).visibleContextChanged(event);
        }
    }

    public void fireVisibleLayerChanged(VisibleLayerChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).visibleLayerChanged(event);
        }
    }

    public void fireCurrentPageContextChanged(CurrentPageContextChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContextEventListener.class) continue;
            ((ContextEventListener)listeners[i + 1]).currentPageContextChanged(event);
        }
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }
}

