/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.headfootdesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.KDFHeaderFooterPainter;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;

public class HeadFootPreviewPane
extends KDPanel {
    private static final long serialVersionUID = -5615343528549387104L;
    private HeadFootModel headModel;
    private HeadFootModel footModel;
    private ExtVarProvider varProv;
    private int currentPage = 0;
    private int totalPage = 999;

    public HeadFootPreviewPane() {
        this.installComponents();
        this.setBackground(new Color(0xD9D9D0));
    }

    private void installComponents() {
        InnerPane panPreviewHead = new InnerPane(true);
        InnerPane panPreviewFoot = new InnerPane(false);
        KDLabel labHead = new KDLabel(this.getMLS("head", "\u9875\u7709"));
        KDLabel labFoot = new KDLabel(this.getMLS("foot", "\u9875\u811a"));
        KDScrollPane scpHead = new KDScrollPane((Component)((Object)panPreviewHead));
        KDScrollPane scpFoot = new KDScrollPane((Component)((Object)panPreviewFoot));
        scpHead.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        scpFoot.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        scpHead.setOpaque(false);
        scpFoot.setOpaque(false);
        scpHead.getViewport().setOpaque(false);
        scpFoot.getViewport().setOpaque(false);
        this.add((Component)labHead);
        this.add((Component)scpHead);
        this.add((Component)labFoot);
        this.add((Component)scpFoot);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 620, 220));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 0, 600, 20);
        cons.anchor = 13;
        labHead.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 20, 600, 90);
        cons.anchor = 77;
        scpHead.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 110, 600, 90);
        cons.anchor = 46;
        scpFoot.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 200, 600, 20);
        cons.anchor = 14;
        labFoot.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
    }

    public void setVarProv(ExtVarProvider provider) {
        this.varProv = provider;
    }

    public void setFootModel(HeadFootModel model) {
        this.footModel = model;
    }

    public void setHeadModel(HeadFootModel model) {
        this.headModel = model;
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlPrintMessages.getMLS((String)key, (String)defaultValue);
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    private class InnerPane
    extends KDPanel {
        private static final long serialVersionUID = 9062876788114666249L;
        private KDFHeaderFooterPainter hfPainter;
        private KDF kdf = new KDF();
        private boolean isHead;

        public InnerPane(boolean isHead) {
            this.isHead = isHead;
            this.setBackground(Color.WHITE);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Page page = this.isHead ? HeadFootParser.parseModel2HeadFootPage(HeadFootPreviewPane.this.headModel) : HeadFootParser.parseModel2HeadFootPage(HeadFootPreviewPane.this.footModel);
            if (page == null) {
                return;
            }
            page.getRight().setString(String.valueOf(2010));
            page.getRight().setOriginString(String.valueOf(2010));
            double pageHeight = Double.parseDouble(page.getBottom().getOriginString());
            int height = (int)(pageHeight / 254.0 * 72.0);
            this.setPreferredSize(new Dimension(570, height));
            this.revalidate();
            String id = page.getId();
            this.kdf.removeHeader(id);
            this.kdf.addHeader(page);
            this.hfPainter = new KDFHeaderFooterPainter(this.kdf, id, "", null);
            if (HeadFootPreviewPane.this.varProv != null) {
                this.hfPainter.setExtVarProv(HeadFootPreviewPane.this.varProv);
            }
            this.hfPainter.paintHeader((Graphics2D)g, HeadFootPreviewPane.this.currentPage, HeadFootPreviewPane.this.totalPage);
        }
    }
}

