/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.headfootdesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlPrintMessages;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.ExtendButtonAction;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootDesignerPane;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IExSetup;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IPrintCompositable;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.KDFHeaderFooterPainter;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeadFootSetupPane
extends JPanel
implements IPrintCompositable,
IExSetup {
    private static final long serialVersionUID = 3151562257306380231L;
    private HeadFootDesignerPane headPane;
    private HeadFootDesignerPane footPane;
    private HeadFootPreviewPane previewPane;
    private HeadFootModel headModel;
    private HeadFootModel footModel;
    private HeadFootModel headModelforChanged;
    private HeadFootModel footModelforChanged;
    private String headId = null;
    private String footId = null;
    private KDF kdf;
    private KDFHeaderFooterPainter hfPainter;
    private transient PrintCompContainer container;

    public HeadFootSetupPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(1, 0, 0));
        int w = 425;
        int h = 350;
        Dimension size = new Dimension(w, h);
        this.headPane = new HeadFootDesignerPane();
        this.footPane = new HeadFootDesignerPane();
        this.previewPane = new HeadFootPreviewPane();
        KDTabbedPane tabPane = new KDTabbedPane();
        tabPane.addTab(this.getMLS("head", "\u9875\u7709"), (Component)this.headPane);
        tabPane.addTab(this.getMLS("foot", "\u9875\u811a"), (Component)this.footPane);
        tabPane.addTab(this.getMLS("preview", "\u9884\u89c8"), (Component)((Object)this.previewPane));
        tabPane.setPreferredSize(size);
        tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((KDTabbedPane)e.getSource()).getSelectedIndex() == 2) {
                    HeadFootSetupPane.this.previewPane.setHeadModel(HeadFootSetupPane.this.headPane.getModel());
                    HeadFootSetupPane.this.previewPane.setFootModel(HeadFootSetupPane.this.footPane.getModel());
                }
            }
        });
        this.add((Component)tabPane);
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlPrintMessages.getMLS((String)key, (String)defaultValue);
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
        this.container = container;
    }

    @Override
    public String getName() {
        return CtrlKDFMessages.getMLS("headerFooterSetting", "\u9875\u7709\u9875\u811a\u8bbe\u7f6e");
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void commit() {
        if (!this.headModelforChanged.equals((Object)this.headModel)) {
            Page headPage = HeadFootParser.parseModel2HeadFootPage(this.headModel);
            if (this.headId == null) {
                this.headId = headPage.getId();
            }
            this.kdf.removeHeader(this.headId);
            if (this.headModel.getRowsCount() > 0) {
                this.kdf.addHeader(headPage);
            }
        }
        if (!this.footModelforChanged.equals((Object)this.footModel)) {
            Page footPage = HeadFootParser.parseModel2HeadFootPage(this.footModel);
            if (this.footId == null) {
                this.footId = footPage.getId();
            }
            this.kdf.removeFooter(this.footId);
            if (this.footModel.getRowsCount() > 0) {
                this.kdf.addFooter(footPage);
            }
        }
        if (this.hfPainter == null) {
            this.hfPainter = new KDFHeaderFooterPainter(this.kdf, this.headId, this.footId, this.container.getPrinterAttrManager());
            this.hfPainter.setExtVarProv(this.container.getHeaderFooterPainter().getExtVarProvider());
            this.container.setHeaderFooterPainter(this.hfPainter, 50, 50);
        }
        this.hfPainter.setKDF(this.kdf);
        this.container.getBaseComponent().getPreviewPane().doRepaint();
    }

    @Override
    public void onShow() {
        if (this.container.getHeaderFooterPainter() instanceof KDFHeaderFooterPainter) {
            this.hfPainter = (KDFHeaderFooterPainter)this.container.getHeaderFooterPainter();
            this.kdf = this.hfPainter.getKdf();
        } else {
            this.kdf = new KDF();
        }
        Page headPage = null;
        Page footPage = null;
        if (this.kdf.getHeaders().length != 0) {
            headPage = this.kdf.getHeaders()[0];
            this.headId = headPage.getId();
        }
        if (this.kdf.getFooters().length != 0) {
            footPage = this.kdf.getFooters()[0];
            this.footId = footPage.getId();
        }
        this.headModel = HeadFootParser.parseHeadFootPage2Model(headPage);
        this.footModel = HeadFootParser.parseHeadFootPage2Model(footPage);
        if (this.headModel == null) {
            this.headModel = new HeadFootModel();
        }
        if (this.footModel == null) {
            this.footModel = new HeadFootModel();
        }
        this.headModelforChanged = (HeadFootModel)this.headModel.clone();
        this.footModelforChanged = (HeadFootModel)this.footModel.clone();
        this.previewPane.setCurrentPage(this.container.getPreviewContext().getCurrentPage());
        this.previewPane.setTotalPage(this.container.getPreviewContext().getTotalPageCount());
        this.headPane.setModel(this.headModel);
        this.footPane.setModel(this.footModel);
    }

    public void addExtendButton(ExtendButtonAction action) {
        this.headPane.addExtendButton(action);
        this.footPane.addExtendButton(action);
    }
}

