/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.kdprint.GraphicLayer;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PagesLayoutManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class KDPPreviewPane
extends JPanel
implements MouseMotionListener,
ComponentListener {
    private static final Logger logger = LogUtil.getPackageLogger(KDPPreviewPane.class);
    private static final long serialVersionUID = -3923640582606975186L;
    private PagesLayoutManager lnkPageslayoutManager;
    private KDPrintbase base;
    static final double factor = 2.8346456692913384;
    public BufferedImage paneGraphicCache = null;
    boolean flag = true;
    GraphicLayerManager graphicLayerMgr = new GraphicLayerManager();

    public KDPPreviewPane(KDPrintbase printbase) {
        this.base = printbase;
        this.lnkPageslayoutManager = printbase.getPageLayoutManager();
        Dimension size = (Dimension)this.base.getPrinterAttrManager().getPrintPage().getPageSize();
        ((Dimension2D)size).setSize((int)(((Dimension2D)size).getWidth() * 2.8346456692913384) + 20, (int)(((Dimension2D)size).getHeight() * 2.8346456692913384) + 40);
        this.setPreferredSize(size);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void FlushPaneGraphicCache() {
        this.paneGraphicCache = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.flag) {
            this.base.getZoomSelect().getEditor().setItem("100%");
            this.base.zoomSelect.setSelectedIndex(3);
            this.FlushPaneGraphicCache();
            this.repaint();
            this.flag = false;
            return;
        }
        Graphics2D g2org = (Graphics2D)g;
        if (this.paneGraphicCache == null) {
            Graphics2D g2;
            if (this.getWidth() > 4500 || this.getHeight() > 4500) {
                this.paneGraphicCache = null;
                g2 = g2org;
            } else {
                this.paneGraphicCache = g2org.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
                g2 = this.paneGraphicCache.createGraphics();
            }
            super.paintComponent(g2);
            g2.setColor(Color.BLACK);
            Rectangle2D[] posOfPages = this.lnkPageslayoutManager.getPosOfPages();
            int cSpaceReady = this.base.getPageLayoutManager().getPageRows() * this.base.getPageLayoutManager().getPageCols();
            int cPageToDraw = this.base.getPrinterAttrManager().getPageCount() > cSpaceReady ? cSpaceReady : this.base.getPrinterAttrManager().getPageCount();
            for (int i = 0; i < cPageToDraw && i < posOfPages.length && posOfPages[i] != null; ++i) {
                g2.setColor(Color.WHITE);
                g2.fill(posOfPages[i]);
                g2.setColor(Color.BLACK);
                g2.draw(posOfPages[i]);
            }
            if (cPageToDraw != 0) {
                double PAPERBORDER_PIXEL = 12.0 * this.base.getPageLayoutManager().getScale();
                int activePage = this.base.getPageLayoutManager().isSinglePageMode() ? 0 : this.base.getActivePage();
                Rectangle2D.Double southborder = new Rectangle2D.Double(posOfPages[activePage].getX() + PAPERBORDER_PIXEL - 2.0, posOfPages[activePage].getY() + posOfPages[activePage].getHeight() + 1.0, posOfPages[activePage].getWidth(), PAPERBORDER_PIXEL);
                g2.setPaint(UIManager.getColor("controlShadow"));
                g2.fill(southborder);
                Rectangle2D.Double eastborder = new Rectangle2D.Double(posOfPages[activePage].getX() + posOfPages[activePage].getWidth() + 1.0, posOfPages[activePage].getY() + PAPERBORDER_PIXEL + 1.0, PAPERBORDER_PIXEL, posOfPages[activePage].getHeight());
                g2.fill(eastborder);
            }
            KDPrintable.AreaInfo areaInfo = new KDPrintable.AreaInfo();
            for (int j = 0; j < cPageToDraw && j < posOfPages.length && posOfPages[j] != null && this.base.getPreviewStartPage() + j + 1 <= this.base.getPrinterAttrManager().getPageCount(); ++j) {
                areaInfo.area.width = (int)((double)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaW() * 2.8346456692913384);
                areaInfo.area.height = (int)((double)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 2.8346456692913384);
                areaInfo.area.x = (int)(posOfPages[j].getX() / this.base.getPageLayoutManager().getScale() + (double)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaX() * 2.8346456692913384);
                areaInfo.area.y = (int)(posOfPages[j].getY() / this.base.getPageLayoutManager().getScale() + (double)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaY() * 2.8346456692913384);
                try {
                    g2.scale(this.base.getPageLayoutManager().getScale(), this.base.getPageLayoutManager().getScale());
                    g2.setClip(areaInfo.area);
                    this.base.getPageGraphics().getPrintable().print(g2, areaInfo, j + this.base.getPreviewStartPage() + (this.base.getPageLayoutManager().isSinglePageMode() ? 0 : this.base.getActivePage()));
                    g2.scale(1.0 / this.base.getPageLayoutManager().getScale(), 1.0 / this.base.getPageLayoutManager().getScale());
                    continue;
                }
                catch (PrinterException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }
        }
        if (this.paneGraphicCache != null) {
            g2org.drawImage(this.paneGraphicCache, new AffineTransformOp(g2org.getDeviceConfiguration().getDefaultTransform(), g2org.getRenderingHints()), 0, 0);
            if (this.graphicLayerMgr.isNeedPaint()) {
                this.graphicLayerMgr.paintAll(g2org);
            }
            this.base.pageCountTip.setText(String.format(CtrlKDFMessages.getMLS("currentPage", "\u7b2c%d\u9875 (\u5171%d\u9875)"), this.base.getPreviewStartPage() + 1, this.base.getPrinterAttrManager().getPageCount()));
        } else {
            super.paintComponent(g);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.paneGraphicCache = null;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public GraphicLayerManager getGraphicLayerMgr() {
        return this.graphicLayerMgr;
    }

    protected static class GraphicLayerManager {
        protected ArrayList layerList = new ArrayList();

        protected void appendLayer(GraphicLayer layer) {
            this.layerList.add(layer);
        }

        protected void removeLayer(Object layer) {
            this.layerList.remove(layer);
        }

        void paintAll(Graphics2D g2) {
            Object[] layers = this.layerList.toArray();
            for (int i = 0; i < layers.length; ++i) {
                GraphicLayer layer = (GraphicLayer)layers[i];
                if (!layer.isNeedPaint()) continue;
                layer.paint(g2);
            }
        }

        boolean isNeedPaint() {
            return this.layerList.size() != 0;
        }
    }
}

