/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.export.ExportManager;
import com.kingdee.cosmic.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPPreviewProxy;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintException;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.cosmic.ctrl.kdf.kdprint.MultiPageChooseDialog;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PageGraphicsProxy;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PagesLayoutManager;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PaperEdgeEditer;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrinterRecoverManager;
import com.kingdee.cosmic.ctrl.kdf.kdprint.RepaginationListener;
import com.kingdee.cosmic.ctrl.kdf.kdprint.Select2Zoom;
import com.kingdee.cosmic.ctrl.kdf.kdprint.ZoomModeSwapper;
import com.kingdee.cosmic.ctrl.kdf.kdprint.resources.KDPrintResources;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.ExtensionFilter;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.FloatingButtonEnabler;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.JSliderEx;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.KDPrintConfiguration;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.MyServiceUI;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.TransForm;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.log4j.Logger;

public class KDPrintbase
implements Serializable {
    private static final Logger logger = LogUtil.getPackageLogger(KDPrintbase.class);
    private static final long serialVersionUID = -8085435602985546101L;
    transient PageGraphicsProxy pageGraphics = null;
    transient KDPPreviewPane previewPane;
    transient KDPPreviewProxy previewProxy;
    private transient PagesLayoutManager pageLayoutManager;
    private transient PrinterAttrManager printerAttrManager;
    private transient PrinterRecoverManager printerRecoverManager;
    private transient PrintPage printPage;
    transient IXmlElement oldStorage = null;
    transient KDF kdf;
    public transient PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    public transient PrintService[] services;
    public transient PrintService selServ;
    transient DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    transient JComponent baseComponent;
    transient JToolBar toolbar;
    boolean largeIconsEnabled = true;
    transient JPanel previewPaneHolder;
    transient JLabel statusHolder;
    transient JPanel scrollPaneHolder;
    boolean InitializedGUI = false;
    transient JLabel pageCountTip = new JLabel("pages ");
    protected transient JComboBox zoomSelect;
    private static final float[] ZOOM_FACTORS = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 3.0f, 4.0f};
    private static final int DEFAULT_ZOOM_INDEX = 3;
    public static final String BASE_RESOURCE_CLASS = "com.kingdee.cosmic.ctrl.kdf.kdprint.resources.KDPrintResources";
    private transient KDPrintResources resources;
    transient Form form;
    private int previewStartPage = 0;
    transient ZoomInAction zoomInAction = new ZoomInAction();
    transient ZoomOutAction zoomOutAction = new ZoomOutAction();
    transient GridBagConstraints c0 = new GridBagConstraints();
    transient GridBagConstraints c1 = new GridBagConstraints();
    transient GridBagConstraints c2 = new GridBagConstraints();
    transient GridBagConstraints c3 = new GridBagConstraints();
    int activePage = 0;
    private transient JScrollPane scrollPane;
    private transient JSliderEx sliderH;
    private transient JSliderEx sliderV;
    private transient JPanel statuBar;
    private transient JPanel s0;

    protected JPanel getScrollPaneHolder() {
        return this.scrollPaneHolder;
    }

    public KDPrintbase(KDPrintable kdprintable, KDPPreviewProxy kdpreviewProxy) throws KDPrintException {
        this.getResources();
        this.printerRecoverManager = new PrinterRecoverManager(this);
        this.pageGraphics = new PageGraphicsProxy(kdprintable, this);
        this.previewProxy = kdpreviewProxy;
        this.init();
    }

    private void init() throws KDPrintException {
        this.printerAttrManager = this.preparePrinterAttr();
        if (this.printerAttrManager == null) {
            throw new KDPrintException("Printer or Printer Driver was not install in this machine(" + CtrlKDFMessages.getMLS("printerNotInstalled", "\u6253\u5370\u673a\u672a\u5b89\u88c5") + ")");
        }
        this.oldStorage = this.printerRecoverManager.getStorage();
    }

    public void InitGUI() {
        if (this.InitializedGUI) {
            return;
        }
        this.InitializedGUI = true;
        this.pageLayoutManager = new PagesLayoutManager(this);
        this.baseComponent = new JPanel();
        this.scrollPaneHolder = new JPanel();
        this.previewPaneHolder = new JPanel();
        this.previewPane = new KDPPreviewPane(this);
        this.previewPane.setVisible(false);
        this.baseComponent.setLayout(new BorderLayout());
        this.previewPaneHolder.add(this.previewPane);
        this.previewPaneHolder.setDoubleBuffered(false);
        this.previewPaneHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scrollPane = new JScrollPane(this.previewPaneHolder);
        this.scrollPane.setDoubleBuffered(false);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.addComponentListener(this.pageLayoutManager);
        this.scrollPaneHolder.setLayout(new BorderLayout());
        this.scrollPaneHolder.add((Component)this.scrollPane, "Center");
        this.scrollPaneHolder.setDoubleBuffered(false);
        this.statuBar = this.createStatusBar();
        this.scrollPaneHolder.add((Component)this.statuBar, "South");
        this.baseComponent.add(this.scrollPaneHolder);
        this.toolbar = this.createToolBar(true);
        this.baseComponent.add((Component)this.toolbar, "North");
        KeyStrokeAction keyStrokeAction = new KeyStrokeAction();
        this.baseComponent.addKeyListener(keyStrokeAction);
        this.applyDefinedDimension(KDPrintConfiguration.getGlobalConfig());
        this.previewPane.setVisible(true);
    }

    public void InitGUI1() {
        if (this.InitializedGUI) {
            return;
        }
        this.InitializedGUI = true;
        this.pageLayoutManager = new PagesLayoutManager(this);
        this.baseComponent = new JPanel();
        this.scrollPaneHolder = new JPanel();
        this.previewPaneHolder = new JPanel();
        this.previewPane = new KDPPreviewPane(this);
        this.previewPane.setVisible(false);
        this.baseComponent.setLayout(new BorderLayout());
        this.previewPaneHolder.add(this.previewPane);
        this.previewPaneHolder.setDoubleBuffered(false);
        this.previewPaneHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scrollPane = new JScrollPane(this.previewPaneHolder);
        this.scrollPane.setDoubleBuffered(false);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.addComponentListener(this.pageLayoutManager);
        BoundedRangeModel[] models = new DefaultBoundedRangeModel[]{new DefaultBoundedRangeModel(10, 0, 0, 100), new DefaultBoundedRangeModel(50, 0, 0, 100)};
        JSliderEx s = new JSliderEx(models);
        s.setMajorTickSpacing(20);
        s.setMinorTickSpacing(2);
        s.setPaintTicks(true);
        s.setPaintLabels(true);
        s.setBorder(new EmptyBorder(0, 0, 0, 0));
        JSliderEx s2 = new JSliderEx(models);
        s2.setOrientation(1);
        s2.setMajorTickSpacing(20);
        s2.setMinorTickSpacing(2);
        s2.setInverted(true);
        s2.setPaintTicks(true);
        s2.setPaintLabels(true);
        JPanel s0 = new JPanel();
        s0.setSize(s.getHeight(), s.getHeight());
        GridBagConstraints c0 = new GridBagConstraints();
        c0.fill = 1;
        c0.gridx = 0;
        c0.gridy = 0;
        c0.gridwidth = 1;
        c0.gridheight = 1;
        c0.weightx = 1.0;
        c0.weighty = 0.0;
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.gridx = 1;
        c1.gridy = 0;
        c1.gridwidth = 1;
        c1.gridheight = 1;
        c1.weightx = 0.0;
        c1.weighty = 0.0;
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 3;
        c2.gridx = 0;
        c2.gridy = 1;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 1;
        c3.gridx = 1;
        c3.gridy = 1;
        c3.gridwidth = 1;
        c3.gridheight = 1;
        c3.weightx = 1.0;
        c3.weighty = 1.0;
        GridBagConstraints c4 = new GridBagConstraints();
        c4.fill = 2;
        c4.gridx = 0;
        c4.gridy = 2;
        c4.gridwidth = 2;
        c4.gridheight = 1;
        c4.weightx = 1.0;
        c4.weighty = 0.0;
        this.scrollPaneHolder.setDoubleBuffered(false);
        this.scrollPaneHolder.setLayout(new GridBagLayout());
        this.scrollPaneHolder.add((Component)s0, c0);
        this.scrollPaneHolder.add((Component)s, c1);
        this.scrollPaneHolder.add((Component)s2, c2);
        this.scrollPaneHolder.add((Component)this.scrollPane, c3);
        this.scrollPaneHolder.add((Component)this.createStatusBar(), c4);
        this.baseComponent.add(this.scrollPaneHolder);
        this.toolbar = this.createToolBar(true);
        this.baseComponent.add((Component)this.toolbar, "North");
        KeyStrokeAction keyStrokeAction = new KeyStrokeAction();
        this.baseComponent.addKeyListener(keyStrokeAction);
        this.applyDefinedDimension(KDPrintConfiguration.getGlobalConfig());
        this.previewPane.setVisible(true);
    }

    private PrinterAttrManager preparePrinterAttr() {
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        if (this.services.length > 0) {
            this.selServ = this.services[0];
            PrinterAttrManager attrMgr = new PrinterAttrManager(this.services[0]);
            return attrMgr;
        }
        return null;
    }

    public void print() {
        if (this.services.length > 0) {
            PrinterAttrManager.PrintRequestAttrSetWithNotify requestAttrSet = this.printerAttrManager.getPrintRequestAttrSetWithNotify();
            PrintService newService = ServiceUI.printDialog(null, 200, 200, this.services, this.selServ, this.flavor, requestAttrSet);
            if (newService == null) {
                return;
            }
            if (newService != this.selServ) {
                this.selServ = newService;
                this.printerAttrManager.UpdateSelectedServ(this.selServ);
            }
            this.getPageGraphics().FlushPageGraphics();
            this.getPageLayoutManager().Update();
            PrintRequestAttributeSet as = this.printerAttrManager.getPrintRequestAttributeSet();
            DocPrintJob pj = this.selServ.createPrintJob();
            try {
                SimpleDoc doc = new SimpleDoc(this.pageGraphics, this.flavor, null);
                pj.print(doc, as);
            }
            catch (PrintException printException) {
                // empty catch block
            }
        }
    }

    protected PageGraphicsProxy getPageGraphics() {
        return this.pageGraphics;
    }

    public PrintService getSelectedPrintServ() {
        return this.selServ;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        statusPane.add((Component)this.pageCountTip, "East");
        return statusPane;
    }

    protected JLabel getStatusHolder() {
        return this.statusHolder;
    }

    protected JToolBar createToolBar(boolean floatable) {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(floatable);
        toolbar.add(this.createButton(new PrintAction()));
        toolbar.add(this.createButton(new ExportAction()));
        toolbar.addSeparator(new Dimension(5, 20));
        toolbar.add(this.createButton(new FirstPageAction()));
        toolbar.add(this.createButton(new PrevPageAction()));
        toolbar.add(this.createButton(new NextPageAction()));
        toolbar.add(this.createButton(new LastPageAction()));
        toolbar.addSeparator(new Dimension(5, 20));
        toolbar.add(this.createZoomPane());
        toolbar.add(this.createButton(this.zoomInAction));
        toolbar.add(this.createButton(this.zoomOutAction));
        toolbar.addSeparator(new Dimension(5, 20));
        toolbar.add(Box.createHorizontalStrut(20));
        toolbar.addSeparator(new Dimension(5, 20));
        toolbar.add(this.createButton(new ShowMultiPagePaneAction()));
        toolbar.add(this.createButton(new PrintPageSetupAction()));
        toolbar.add(Box.createHorizontalStrut(Integer.MAX_VALUE));
        return toolbar;
    }

    public boolean isLargeIconsEnabled() {
        return this.largeIconsEnabled;
    }

    protected JButton createButton(Action action) {
        Icon icon;
        JButton button = new JButton(action);
        if (this.isLargeIconsEnabled() && (icon = (Icon)action.getValue("ICON24")) != null) {
            button.setIcon(icon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(null);
        FloatingButtonEnabler.getInstance().addButton(button);
        return button;
    }

    protected JToggleButton createToggleButton(Action action) {
        Icon icon;
        JToggleButton button = new JToggleButton(action);
        if (this.isLargeIconsEnabled() && (icon = (Icon)action.getValue("ICON24")) != null) {
            button.setIcon(icon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(null);
        FloatingButtonEnabler.getInstance().addButton(button);
        return button;
    }

    protected JComponent createZoomPane() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < ZOOM_FACTORS.length; ++i) {
            model.addElement(String.valueOf((int)(ZOOM_FACTORS[i] * 100.0f)) + " %");
        }
        this.zoomSelect = new JComboBox(model);
        this.zoomSelect.setEditable(true);
        this.zoomSelect.setBorder(new BasicBorders.MarginBorder());
        this.zoomSelect.setActionCommand("ZoomSelect");
        this.zoomSelect.setSelectedIndex(3);
        this.zoomSelect.addActionListener(new ZoomSelectAction());
        this.zoomSelect.setAlignmentX(1.0f);
        JPanel zoomPane = new JPanel();
        zoomPane.setLayout(new FlowLayout(0));
        zoomPane.add(this.zoomSelect);
        return zoomPane;
    }

    protected KDPrintResources getResources() {
        if (this.resources == null) {
            this.resources = (KDPrintResources)ResourceBundle.getBundle(BASE_RESOURCE_CLASS);
        }
        return this.resources;
    }

    public void setKDForm(Form form) {
        this.form = form;
    }

    void LayoutPreviewPaneHolderWithMetrics() {
        this.previewPane.setVisible(false);
        BoundedRangeModel[] models = new DefaultBoundedRangeModel[]{new DefaultBoundedRangeModel(10, 0, 0, 100), new DefaultBoundedRangeModel(90, 0, 0, 100)};
        if (this.sliderH == null) {
            this.sliderH = new JSliderEx(models);
        }
        this.sliderH.setMajorTickSpacing(20);
        this.sliderH.setMinorTickSpacing(2);
        this.sliderH.setPaintTicks(true);
        this.sliderH.setPaintLabels(true);
        this.sliderH.setBorder(new EmptyBorder(0, 0, 0, this.getPageLayoutManager().getXOffset()));
        double pagew = this.getPrintPage().getPrintPageW();
        this.sliderH.setMinimum((int)(-((double)this.previewPane.getX() + this.getPageLayoutManager().getPosOfPages()[0].getX() + (double)this.sliderH.getHeight()) * 25.4 / 72.0), 0);
        this.sliderH.setMaximum((int)((double)this.scrollPane.getWidth() * 25.4 / 72.0), 0);
        this.sliderH.setMinimum(this.sliderH.getMinimum(0), 1);
        this.sliderH.setMaximum(this.sliderH.getMaximum(0), 1);
        this.sliderH.setValue(0, 0);
        this.sliderH.setValue((int)pagew, 1);
        if (this.sliderV == null) {
            this.sliderV = new JSliderEx(models);
        }
        this.sliderV.setOrientation(1);
        this.sliderV.setMajorTickSpacing(20);
        this.sliderV.setMinorTickSpacing(2);
        this.sliderV.setInverted(true);
        this.sliderV.setPaintTicks(true);
        this.sliderV.setPaintLabels(true);
        this.sliderV.addComponentListener(new ComponentAdapter(){
            protected Dimension size = null;

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.size == null) {
                    this.size = ((JComponent)e.getSource()).getSize();
                } else if (((JComponent)e.getSource()).getSize() != this.size) {
                    KDPrintbase.this.sliderV.setSize(this.size);
                }
            }
        });
        this.s0 = new JPanel();
        this.s0.setSize(this.sliderH.getHeight(), this.sliderH.getHeight());
        this.c0.fill = 1;
        this.c0.gridx = 0;
        this.c0.gridy = 0;
        this.c0.gridwidth = 1;
        this.c0.gridheight = 1;
        this.c0.weightx = 0.0;
        this.c0.weighty = 0.0;
        this.c1.fill = 2;
        this.c1.gridx = 1;
        this.c1.gridy = 0;
        this.c1.gridwidth = 1;
        this.c1.gridheight = 1;
        this.c1.weightx = 0.0;
        this.c1.weighty = 0.0;
        this.c2.fill = 3;
        this.c2.gridx = 0;
        this.c2.gridy = 1;
        this.c2.gridwidth = 1;
        this.c2.gridheight = 1;
        this.c2.weightx = 0.0;
        this.c2.weighty = 1.0;
        this.c3.fill = 1;
        this.c3.gridx = 1;
        this.c3.gridy = 1;
        this.c3.gridwidth = 1;
        this.c3.gridheight = 1;
        this.c3.weightx = 1.0;
        this.c3.weighty = 1.0;
        GridBagConstraints c4 = new GridBagConstraints();
        c4.fill = 2;
        c4.gridx = 0;
        c4.gridy = 2;
        c4.gridwidth = 2;
        c4.gridheight = 1;
        c4.weightx = 1.0;
        c4.weighty = 0.0;
        this.scrollPaneHolder.removeAll();
        this.scrollPaneHolder.setLayout(new GridBagLayout());
        this.scrollPaneHolder.add((Component)this.s0, this.c0);
        this.scrollPaneHolder.add((Component)this.sliderH, this.c1);
        this.scrollPaneHolder.add((Component)this.sliderV, this.c2);
        this.scrollPaneHolder.add((Component)this.scrollPane, this.c3);
        this.scrollPaneHolder.add((Component)this.statuBar, c4);
        this.previewPane.setVisible(true);
    }

    protected Dimension fit2Container(Dimension2D rect, Dimension2D container) {
        double scale = rect.getWidth() / rect.getHeight() < container.getWidth() / container.getHeight() ? container.getHeight() / rect.getHeight() : container.getWidth() / rect.getWidth();
        Dimension dim = new Dimension();
        dim.setSize(rect.getWidth() * scale, rect.getHeight() * scale);
        return dim;
    }

    private Rectangle2D fit2Container(Rectangle2D rect, Rectangle2D container) {
        int yoff;
        int xoff;
        double scale;
        if (rect.getWidth() / rect.getHeight() < container.getWidth() / container.getHeight()) {
            scale = container.getHeight() / rect.getHeight();
            xoff = (int)(0.5 * (container.getWidth() - scale * rect.getWidth()));
            yoff = 0;
        } else {
            scale = container.getWidth() / rect.getWidth();
            xoff = 0;
            yoff = (int)(0.5 * (container.getHeight() - scale * rect.getHeight()));
        }
        return new Rectangle2D.Double(container.getX() + (double)xoff, container.getY() + (double)yoff, rect.getWidth() * scale, rect.getHeight() * scale);
    }

    protected void UpdateMulitPage(int showRows, int showCols) {
        Dimension dim = this.previewPaneHolder.getParent().getSize();
        dim.setSize(dim.width - 20, dim.height - 20);
        Dimension prefDim = this.fit2Container(this.getPageLayoutManager().caculateDrawArea((Dimension)this.getPrintPage().getPageSize(), showRows, showCols), dim);
        this.getPreviewPane().setPreferredSize(prefDim);
        this.getPreviewPane().revalidate();
        this.getPageGraphics().FlushPageGraphics();
        this.getPageLayoutManager().setRowAndCol(showRows, showCols, prefDim);
        this.getPreviewPane().FlushPaneGraphicCache();
        this.getPreviewPane().repaint();
        this.getZoomSelect().setSelectedItem(String.valueOf((int)(this.getPageLayoutManager().getScale() * 100.0)) + "%");
    }

    private void applyDefinedDimension(KDPrintConfiguration config) {
        Dimension2D dim = this.getPrinterAttrManager().getPrintPage().getPageSize();
        double h = Math.min(700.0, dim.getHeight() * 72.0 / 25.4 + 20.0);
        dim.setSize(dim.getWidth() * 72.0 / 25.4 + 30.0, h);
        this.baseComponent.setPreferredSize((Dimension)dim);
    }

    protected PagesLayoutManager getPageLayoutManager() {
        return this.pageLayoutManager;
    }

    protected KDPPreviewPane getPreviewPane() {
        return this.previewPane;
    }

    protected PrinterAttrManager getPrinterAttrManager() {
        return this.printerAttrManager;
    }

    public PrintPage getPrintPage() {
        if (this.printPage == null) {
            this.printPage = new PrintPage(this.printerAttrManager.getPrintPage());
        }
        return this.printPage;
    }

    public void addRePaginationListener(RepaginationListener l) {
        this.printerAttrManager.addRepaginationListener(l);
    }

    public void removeRePaginationListener(RepaginationListener l) {
        this.printerAttrManager.addRepaginationListener(l);
    }

    public IXmlElement getStorage() {
        return this.printerRecoverManager.getStorage();
    }

    protected void setPreviewProxy(KDPPreviewProxy proxy) {
        this.previewProxy = proxy;
    }

    protected int getPreviewStartPage() {
        return this.previewStartPage;
    }

    protected void setPreviewStartPage(int val) {
        this.previewStartPage = val;
    }

    protected int getActivePage() {
        return this.activePage;
    }

    protected void setActivePage(int val) {
        this.activePage = val;
    }

    protected JComboBox getZoomSelect() {
        return this.zoomSelect;
    }

    public void setPageRange(int startPage, int endPage) {
        this.printerAttrManager.setPageRange(startPage, endPage);
    }

    public JComponent getBaseCompoment() {
        return this.baseComponent;
    }

    class KeyStrokeAction
    extends KeyAdapter {
        Component[] components = null;
        NextPageAction pagedownAction;
        PrevPageAction pageupAction;
        FirstPageAction homeAction;
        LastPageAction endAction;

        public KeyStrokeAction() {
            KDPrintbase.this.baseComponent.setFocusable(true);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.components == null) {
                this.components = KDPrintbase.this.toolbar.getComponents();
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i].getClass() != JButton.class) continue;
                    Action act = ((JButton)this.components[i]).getAction();
                    if (act.getClass() == NextPageAction.class) {
                        this.pagedownAction = (NextPageAction)act;
                        continue;
                    }
                    if (act.getClass() == PrevPageAction.class) {
                        this.pageupAction = (PrevPageAction)act;
                        continue;
                    }
                    if (act.getClass() == FirstPageAction.class) {
                        this.homeAction = (FirstPageAction)act;
                        continue;
                    }
                    if (act.getClass() != LastPageAction.class) continue;
                    this.endAction = (LastPageAction)act;
                }
            }
            switch (e.getKeyCode()) {
                case 34: {
                    if (this.pagedownAction == null) break;
                    this.pagedownAction.actionPerformed(null);
                    break;
                }
                case 33: {
                    if (this.pageupAction == null) break;
                    this.pageupAction.actionPerformed(null);
                    break;
                }
                case 36: {
                    if (this.homeAction == null) break;
                    this.homeAction.actionPerformed(null);
                    break;
                }
                case 35: {
                    if (this.endAction == null) break;
                    this.endAction.actionPerformed(null);
                    break;
                }
            }
        }
    }

    class ShowMultiPagePaneAction
    extends AbstractAction {
        private static final long serialVersionUID = 8767669L;

        public ShowMultiPagePaneAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.multipage.name"));
            this.putValue("ShortDescription", res.getString("action.multipage.description"));
            this.putValue("MnemonicKey", res.getObject("action.multipage.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.multipage.small-icon"));
            this.putValue("ICON24", res.getObject("action.multipage.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            MultiPageChooseDialog dlg = new MultiPageChooseDialog(KDPrintbase.this, (Frame)((Object)KDPrintbase.this.previewProxy), 3, 3, 9);
            dlg.setUndecorated(true);
            dlg.pack();
            int x = button.getLocation().x;
            int y = button.getLocation().y + (int)button.getSize().getHeight();
            for (Container cont = button.getParent(); cont != null && !cont.getClass().isInstance(JFrame.class); cont = cont.getParent()) {
                x += cont.getLocation().x;
                y += cont.getLocation().y;
            }
            dlg.setLocation(x, y);
            dlg.setVisible(true);
            if (!dlg.isCancel()) {
                int a = dlg.getSelRows() + 1;
                int b = dlg.getSelCols() + 1;
                KDPrintbase.this.setPreviewStartPage(0);
                KDPrintbase.this.UpdateMulitPage(a, b);
            }
        }
    }

    class EditEdgeAction2
    extends AbstractAction {
        private static final long serialVersionUID = -3421188724905068849L;
        boolean enable = false;
        transient PaperEdgeEditer edgeEditer;

        public EditEdgeAction2() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.editedge.name"));
            this.putValue("ShortDescription", res.getString("action.editedge.description"));
            this.putValue("MnemonicKey", res.getObject("action.editedge.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.editedge.small-icon"));
            this.putValue("ICON24", res.getObject("action.editedge.icon"));
            this.edgeEditer = new PaperEdgeEditer(KDPrintbase.this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (((JToggleButton)event.getSource()).isSelected()) {
                KDPrintbase.this.LayoutPreviewPaneHolderWithMetrics();
            } else {
                this.edgeEditer.disable();
                KDPrintbase.this.getPreviewPane().getGraphicLayerMgr().removeLayer(this.edgeEditer.getGraphicLayer());
                KDPrintbase.this.getPreviewPane().repaint();
            }
            this.enable = !this.enable;
        }
    }

    class EditEdgeAction
    extends AbstractAction {
        private static final long serialVersionUID = 4047849703823730414L;
        boolean enable = false;
        transient PaperEdgeEditer edgeEditer;

        public EditEdgeAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.editedge.name"));
            this.putValue("ShortDescription", res.getString("action.editedge.description"));
            this.putValue("MnemonicKey", res.getObject("action.editedge.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.editedge.small-icon"));
            this.putValue("ICON24", res.getObject("action.editedge.icon"));
            this.edgeEditer = new PaperEdgeEditer(KDPrintbase.this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.enable) {
                KDPrintbase.this.getPreviewPane().getGraphicLayerMgr().appendLayer(this.edgeEditer.getGraphicLayer());
                this.edgeEditer.enable();
                this.edgeEditer.getGraphicLayer().setNeedPaint(true);
                KDPrintbase.this.getPreviewPane().repaint();
            } else {
                this.edgeEditer.disable();
                KDPrintbase.this.getPreviewPane().getGraphicLayerMgr().removeLayer(this.edgeEditer.getGraphicLayer());
                KDPrintbase.this.getPreviewPane().repaint();
            }
            this.enable = !this.enable;
        }
    }

    class ZoomRegionAction
    extends AbstractAction {
        private static final long serialVersionUID = 889877L;
        boolean enable = false;
        transient Select2Zoom select2Zoom = new Select2Zoom();

        public ZoomRegionAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.zoomRegion.name"));
            this.putValue("ShortDescription", res.getString("action.zoomRegion.description"));
            this.putValue("SmallIcon", res.getObject("action.zoomRegion.small-icon"));
            this.putValue("ICON24", res.getObject("action.zoomRegion.icon"));
            this.select2Zoom.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource().getClass() == Select2Zoom.class) {
                Select2Zoom select2Zoom = (Select2Zoom)event.getSource();
                Rectangle bounds = KDPrintbase.this.getPreviewPane().getParent().getParent().getBounds();
                Rectangle2D target = KDPrintbase.this.fit2Container(select2Zoom.getSelectedRect(), bounds);
                double scale0 = KDPrintbase.this.getPageLayoutManager().getScale();
                double scale = target.getWidth() / select2Zoom.getSelectedRect().getWidth();
                Rectangle rectScroll2 = new Rectangle((int)(select2Zoom.getSelectedRect().getX() * scale - (double)KDPrintbase.this.getPageLayoutManager().getXOffset() * scale / scale0) + 10, (int)(select2Zoom.getSelectedRect().getY() * scale - (double)KDPrintbase.this.getPageLayoutManager().getYOffset() * scale / scale0) + 10, (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight());
                KDPrintbase.this.getPageLayoutManager().setScale4SinglePage(scale * scale0);
                KDPrintbase.this.getPreviewPane().repaint();
                ((JViewport)KDPrintbase.this.getPreviewPane().getParent().getParent()).scrollRectToVisible(rectScroll2);
            } else {
                if (!this.enable) {
                    KDPrintbase.this.getPreviewPane().getGraphicLayerMgr().appendLayer(this.select2Zoom.getGraphicLayer());
                    this.select2Zoom.enable(KDPrintbase.this);
                } else {
                    KDPrintbase.this.getPreviewPane().getGraphicLayerMgr().removeLayer(this.select2Zoom.getGraphicLayer());
                    this.select2Zoom.disable();
                    KDPrintbase.this.getPreviewPane().repaint();
                }
                this.enable = !this.enable;
            }
        }
    }

    class ZoomOutAction
    extends AbstractAction {
        private static final long serialVersionUID = -1401237564658841860L;

        public ZoomOutAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.zoomOut.name"));
            this.putValue("ShortDescription", res.getString("action.zoomOut.description"));
            this.putValue("MnemonicKey", res.getObject("action.zoomOut.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.zoomOut.small-icon"));
            this.putValue("ICON24", res.getObject("action.zoomOut.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (KDPrintbase.this.zoomSelect.getSelectedIndex() != -1 && KDPrintbase.this.zoomSelect.getSelectedIndex() > 0) {
                KDPrintbase.this.zoomSelect.setSelectedIndex(KDPrintbase.this.zoomSelect.getSelectedIndex() - 1);
            }
            if (KDPrintbase.this.zoomSelect.getSelectedIndex() == -1) {
                int i;
                double scale = KDPrintbase.this.getPageLayoutManager().getScale();
                for (i = ZOOM_FACTORS.length - 1; i > 0 && !(scale > (double)ZOOM_FACTORS[i]); --i) {
                }
                KDPrintbase.this.zoomSelect.setSelectedIndex(i);
            }
        }
    }

    class ZoomInAction
    extends AbstractAction {
        private static final long serialVersionUID = 6440602108698091938L;

        public ZoomInAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.zoomIn.name"));
            this.putValue("ShortDescription", res.getString("action.zoomIn.description"));
            this.putValue("MnemonicKey", res.getObject("action.zoomIn.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.zoomIn.small-icon"));
            this.putValue("ICON24", res.getObject("action.zoomIn.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (KDPrintbase.this.zoomSelect.getSelectedIndex() != -1 && KDPrintbase.this.zoomSelect.getSelectedIndex() < KDPrintbase.this.zoomSelect.getItemCount() - 1) {
                KDPrintbase.this.zoomSelect.setSelectedIndex(KDPrintbase.this.zoomSelect.getSelectedIndex() + 1);
            } else if (KDPrintbase.this.zoomSelect.getSelectedIndex() == -1) {
                int i;
                double scale = KDPrintbase.this.getPageLayoutManager().getScale();
                for (i = 0; i < ZOOM_FACTORS.length && !(scale < (double)ZOOM_FACTORS[i]); ++i) {
                }
                KDPrintbase.this.zoomSelect.setSelectedIndex(i);
            }
        }
    }

    class ZoomModeAction
    extends AbstractAction {
        private static final long serialVersionUID = 4956980010407212379L;
        transient ZoomModeSwapper zoomModeSwapper;

        public ZoomModeAction() {
            this.zoomModeSwapper = new ZoomModeSwapper(KDPrintbase.this);
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.ZoomMode.name"));
            this.putValue("ShortDescription", res.getString("action.ZoomMode.description"));
            this.putValue("MnemonicKey", res.getObject("action.ZoomMode.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.ZoomMode.small-icon"));
            this.putValue("ICON24", res.getObject("action.ZoomMode.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.zoomModeSwapper.isZoomMode()) {
                KDPrintbase.this.statusHolder.setText(CtrlKDFMessages.getMLS("clickToZoom", "\u70b9\u51fb\u653e\u5927/\u7f29\u5c0f"));
                this.zoomModeSwapper.SetZoomMode();
            } else {
                this.zoomModeSwapper.UnsetZoomMode();
                KDPrintbase.this.statusHolder.setText("");
            }
        }
    }

    class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = -6180934943070185931L;

        public PrintAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.print.name"));
            this.putValue("ShortDescription", res.getString("action.print.description"));
            this.putValue("MnemonicKey", res.getObject("action.print.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.print.small-icon"));
            this.putValue("ICON24", res.getObject("action.print.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KDPrintbase.this.print();
        }
    }

    class PrintPageSetupAction
    extends AbstractAction {
        private static final long serialVersionUID = 8893227L;

        public PrintPageSetupAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.page-setup.name"));
            this.putValue("ShortDescription", res.getString("action.page-setup.description"));
            this.putValue("MnemonicKey", res.getObject("action.page-setup.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.page-setup.small-icon"));
            this.putValue("ICON24", res.getObject("action.page-setup.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PrinterAttrManager.PrintRequestAttrSetWithNotify requestAttrSet = KDPrintbase.this.printerAttrManager.getPrintRequestAttrSetWithNotify();
            PrintService newService = MyServiceUI.printDialog(null, 200, 200, KDPrintbase.this.services, KDPrintbase.this.selServ, KDPrintbase.this.flavor, requestAttrSet);
            if (newService != null && newService != KDPrintbase.this.selServ) {
                KDPrintbase.this.selServ = newService;
                KDPrintbase.this.printerAttrManager.UpdateSelectedServ(KDPrintbase.this.selServ);
            }
            KDPrintbase.this.getPageGraphics().FlushPageGraphics();
            KDPrintbase.this.getPageLayoutManager().Update();
            KDPrintbase.this.previewPane.FlushPaneGraphicCache();
            KDPrintbase.this.previewPane.repaint();
        }
    }

    class PrevPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 8832556L;

        public PrevPageAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.back.name"));
            this.putValue("ShortDescription", res.getString("action.back.description"));
            this.putValue("MnemonicKey", res.getObject("action.back.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.back.small-icon"));
            this.putValue("ICON24", res.getObject("action.back.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KDPrintbase.this.statusHolder.setText("");
            if (KDPrintbase.this.getPageLayoutManager().isSinglePageMode()) {
                if (KDPrintbase.this.previewStartPage - 1 >= 0) {
                    KDPrintbase.this.previewStartPage = KDPrintbase.this.previewStartPage - 1;
                    KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                    KDPrintbase.this.getPreviewPane().repaint();
                } else {
                    KDPrintbase.this.statusHolder.setText(CtrlKDFMessages.getMLS("firstPage", " \u5df2\u7ecf\u5230\u7b2c\u4e00\u9875 "));
                }
            } else {
                int cPagePerPane = KDPrintbase.this.getPageLayoutManager().getPageCols() * KDPrintbase.this.getPageLayoutManager().getPageRows();
                if (KDPrintbase.this.previewStartPage - cPagePerPane >= 0) {
                    KDPrintbase.this.previewStartPage = KDPrintbase.this.previewStartPage - cPagePerPane;
                    KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                    KDPrintbase.this.getPreviewPane().repaint();
                } else {
                    KDPrintbase.this.statusHolder.setText(CtrlKDFMessages.getMLS("firstScreen", " \u5df2\u7ecf\u5230\u7b2c\u4e00\u5c4f "));
                }
            }
        }
    }

    protected class NextPageAction
    extends AbstractAction {
        private static final long serialVersionUID = -4207077261122846542L;

        public NextPageAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.forward.name"));
            this.putValue("ShortDescription", res.getString("action.forward.description"));
            this.putValue("MnemonicKey", res.getObject("action.forward.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.forward.small-icon"));
            this.putValue("ICON24", res.getObject("action.forward.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KDPrintbase.this.statusHolder.setText("");
            if (KDPrintbase.this.getPageLayoutManager().isSinglePageMode()) {
                if (KDPrintbase.this.previewStartPage + 1 < KDPrintbase.this.getPrinterAttrManager().getPageCount()) {
                    KDPrintbase.this.previewStartPage = KDPrintbase.this.previewStartPage + 1;
                    KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                    KDPrintbase.this.getPreviewPane().repaint();
                } else {
                    KDPrintbase.this.statusHolder.setText(CtrlKDFMessages.getMLS("lastPage", " \u5df2\u7ecf\u5230\u6700\u540e\u4e00\u9875 "));
                }
            } else {
                int cPagePerPane = KDPrintbase.this.getPageLayoutManager().getPageCols() * KDPrintbase.this.getPageLayoutManager().getPageRows();
                if (KDPrintbase.this.previewStartPage + cPagePerPane < KDPrintbase.this.getPrinterAttrManager().getPageCount()) {
                    KDPrintbase.this.previewStartPage = KDPrintbase.this.previewStartPage + cPagePerPane;
                    KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                    KDPrintbase.this.getPreviewPane().repaint();
                } else {
                    KDPrintbase.this.statusHolder.setText(CtrlKDFMessages.getMLS("lastScreen", " \u5df2\u7ecf\u5230\u6700\u540e\u4e00\u5c4f "));
                }
            }
        }
    }

    class LastPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 6618670157335701493L;

        public LastPageAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.lastpage.name"));
            this.putValue("ShortDescription", res.getString("action.lastpage.description"));
            this.putValue("MnemonicKey", res.getObject("action.lastpage.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.lastpage.small-icon"));
            this.putValue("ICON24", res.getObject("action.lastpage.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KDPrintbase.this.statusHolder.setText("");
            if (KDPrintbase.this.getPageLayoutManager().isSinglePageMode()) {
                if (KDPrintbase.this.getPrinterAttrManager().getPageCount() > 0) {
                    KDPrintbase.this.previewStartPage = KDPrintbase.this.getPrinterAttrManager().getPageCount() - 1;
                    KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                    KDPrintbase.this.getPreviewPane().repaint();
                    KDPrintbase.this.statusHolder.setText(" OK  ");
                }
            } else {
                int cPagePerPane = KDPrintbase.this.getPageLayoutManager().getPageCols() * KDPrintbase.this.getPageLayoutManager().getPageRows();
                KDPrintbase.this.previewStartPage = cPagePerPane * ((KDPrintbase.this.getPrinterAttrManager().getPageCount() - 1) / cPagePerPane);
                KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                KDPrintbase.this.getPreviewPane().repaint();
            }
        }
    }

    class FirstPageAction
    extends AbstractAction {
        private static final long serialVersionUID = -8345733919669439480L;

        public FirstPageAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.firstpage.name"));
            this.putValue("ShortDescription", res.getString("action.firstpage.description"));
            this.putValue("MnemonicKey", res.getObject("action.firstpage.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.firstpage.small-icon"));
            this.putValue("ICON24", res.getObject("action.firstpage.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KDPrintbase.this.statusHolder.setText("");
            KDPrintbase.this.previewStartPage = 0;
            KDPrintbase.this.activePage = KDPrintbase.this.previewStartPage;
            KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
            KDPrintbase.this.getPreviewPane().repaint();
        }
    }

    class ExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 2746130493916444542L;
        transient Object[] ExportTypes = new Object[]{"PDF", "EXCEL", CtrlKDFMessages.getMLS("excelPageBreak", "EXCEL(\u6309\u8868\u9875\u5206\u9875\uff09"), "WORD", CtrlKDFMessages.getMLS("wordNonTableMode", "WORD\uff08\u4e0d\u5e26\u8868\u683c\uff09"), "HTML"};
        String[] Subfixs = new String[]{".pdf", ".xls", ".xls", ".rtf", ".rtf", ".html"};

        public ExportAction() {
            KDPrintResources res = KDPrintbase.this.getResources();
            this.putValue("Name", res.getString("action.export-to.name"));
            this.putValue("ShortDescription", res.getString("action.export-to.description"));
            this.putValue("MnemonicKey", res.getObject("action.export-to.mnemonic"));
            this.putValue("SmallIcon", res.getObject("action.export-to.small-icon"));
            this.putValue("ICON24", res.getObject("action.export-to.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object exportType = JOptionPane.showInputDialog(KDPrintbase.this.baseComponent, CtrlKDFMessages.getMLS("selectOutputFormat", "\u9009\u62e9\u8f93\u51fa\u683c\u5f0f"), CtrlKDFMessages.getMLS("outputToFile", "\u8f93\u51fa\u5230\u6587\u4ef6"), 1, null, this.ExportTypes, this.ExportTypes[0]);
            if (exportType == null) {
                return;
            }
            String path = this.getSavePath(exportType.toString());
            if (path != null && KDPrintbase.this.form != null) {
                KDSBook book = TransForm.toBook(KDPrintbase.this.form);
                PrintableBook ptbook = new PrintableBook(book);
                ExportManager exp = new ExportManager();
                if (exportType == this.ExportTypes[0]) {
                    exp.exportToPdfFile(ptbook, path);
                } else if (exportType == this.ExportTypes[1]) {
                    exp.exportToExcel(ptbook, path);
                } else if (exportType == this.ExportTypes[2]) {
                    exp.setExporterParmeter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);
                    exp.exportToExcel(ptbook, path);
                } else if (exportType != this.ExportTypes[3] && exportType == this.ExportTypes[5]) {
                    exp.exportToHtmlFile(ptbook, path);
                }
            }
        }

        private String getSavePath(String exportType) {
            String path;
            String subfix = "";
            for (int i = 0; i < this.ExportTypes.length; ++i) {
                if (exportType != this.ExportTypes[i]) continue;
                subfix = this.Subfixs[i];
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(CtrlKDFMessages.getMLS("outputToFile", "\u8f93\u51fa\u5230\u6587\u4ef6"));
            FileFilter[] filters = new FileFilter[]{new ExtensionFilter(exportType, new String[]{subfix})};
            chooser.setFileFilter(filters[0]);
            chooser.showSaveDialog(KDPrintbase.this.baseComponent);
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null && (path = selectedFile.getPath()) != null) {
                char[] last4 = new char[4];
                path.getChars(path.length() - 4, path.length(), last4, 0);
                if (!subfix.equals(new String(last4))) {
                    path = path + subfix;
                }
                return path;
            }
            return null;
        }
    }

    class ZoomSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 8847157173435382997L;
        int count = 0;

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = KDPrintbase.this.zoomSelect.getSelectedIndex();
            if (selectedIndex != -1) {
                KDPrintbase.this.getPageLayoutManager().setScale4SinglePage(ZOOM_FACTORS[selectedIndex]);
                if (this.count++ == 0) {
                    KDPrintbase.this.getPageGraphics().FlushPageGraphics();
                }
                KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                KDPrintbase.this.getPreviewPane().repaint();
            } else if (KDPrintbase.this.getPageLayoutManager().isSinglePageMode()) {
                String strScale = KDPrintbase.this.zoomSelect.getSelectedItem().toString();
                if (strScale.endsWith("%")) {
                    strScale = strScale.substring(0, strScale.length() - 1);
                }
                float iscale = Float.parseFloat(strScale);
                KDPrintbase.this.getPageLayoutManager().setScale4SinglePage(iscale / 100.0f);
                KDPrintbase.this.getPreviewPane().FlushPaneGraphicCache();
                KDPrintbase.this.getPreviewPane().repaint();
            }
        }
    }
}

