/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.kdprint.RepaginationListener;
import com.kingdee.cosmic.ctrl.kdf.kdprint.util.MyDimension2D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.QueuedJobCount;
import org.apache.log4j.Logger;

public class PrinterAttrManager {
    private static final Logger logger = LogUtil.getPackageLogger(PrinterAttrManager.class);
    int defaultUnit = 1000;
    private PrintRequestAttrSetWithNotify thePrintRequestAttrSetWithNotify = new PrintRequestAttrSetWithNotify();
    public PrintRequestAttributeSet requestAttrSet = new HashPrintRequestAttributeSet();
    private PrintPage printPage;
    public PrintService printService;
    private String aJobName = "My job";
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private int cPages = 0;
    PrintService selServ;
    private static final Class[] staticServiceAttributeCls = new Class[]{ColorSupported.class, PagesPerMinute.class, PagesPerMinuteColor.class, PDLOverrideSupported.class, PrinterIsAcceptingJobs.class, PrinterInfo.class, PrinterLocation.class, PrinterMessageFromOperator.class, PrinterMakeAndModel.class, PrinterMoreInfo.class, PrinterMoreInfoManufacturer.class, PrinterName.class, PrinterState.class, QueuedJobCount.class};
    private ArrayList repaginationListeners;
    private Object[] repaginationListenersCache;

    public PrintRequestAttrSetWithNotify getPrintRequestAttrSetWithNotify() {
        return this.thePrintRequestAttrSetWithNotify;
    }

    public void UpdateSelectedServ(PrintService selectedServ) {
        this.selServ = selectedServ;
        Attribute[] oldReqAttrs = this.requestAttrSet.toArray();
        this.requestAttrSet.clear();
        for (int i = 0; i < oldReqAttrs.length; ++i) {
            if (!selectedServ.isAttributeCategorySupported(oldReqAttrs[i].getClass())) continue;
            this.requestAttrSet.add(oldReqAttrs[i]);
        }
    }

    public void UpdatePrintRequestAttrSet(PrintRequestAttributeSet updatedReqAttrSet) {
        this.requestAttrSet.clear();
        Attribute[] attrs = updatedReqAttrSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            if (!this.selServ.isAttributeCategorySupported(attrs[i].getClass())) continue;
            this.requestAttrSet.add(attrs[i]);
        }
    }

    public PrinterAttrManager(PrintService selectedServ) {
        this.selServ = selectedServ;
        if (this.selServ != null) {
            Class<?>[] cls = this.selServ.getSupportedAttributeCategories();
            Attribute[] defAttrs = new Attribute[cls.length];
            for (int i = 0; i < cls.length; ++i) {
                defAttrs[i] = (Attribute)this.selServ.getDefaultAttributeValue(cls[i]);
            }
            Class[] serviceAttributeCls = staticServiceAttributeCls;
            PrintServiceAttribute[] serAttrs = new PrintServiceAttribute[serviceAttributeCls.length];
            for (int i = 0; i < serviceAttributeCls.length; ++i) {
                serAttrs[i] = this.selServ.getAttribute(serviceAttributeCls[i]);
            }
        }
        this.init();
    }

    public void init() {
        this.printPage = new OrientationPrintPage(MediaSizeName.ISO_A4);
        this.requestAttrSet.add(MediaSizeName.ISO_A4);
        if (this.selServ == null) {
            return;
        }
        if (this.selServ.isAttributeCategorySupported(JobName.class)) {
            this.requestAttrSet.add(new JobName(this.aJobName, null));
        }
        if (this.selServ.isAttributeCategorySupported(OrientationRequested.class)) {
            this.requestAttrSet.add(OrientationRequested.PORTRAIT);
        }
        if (this.selServ.isAttributeCategorySupported(PrinterResolution.class)) {
            this.requestAttrSet.add(PrintQuality.HIGH);
            PrinterResolution pa = (PrinterResolution)this.selServ.getDefaultAttributeValue(PrinterResolution.class);
            this.requestAttrSet.add(pa);
            this.selServ.getSupportedAttributeCategories();
        }
        this.getRequestAttribute();
    }

    void getRequestAttribute() {
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.requestAttrSet;
    }

    public PrintRequestAttributeSet Recover() {
        return null;
    }

    public void addRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.repaginationListeners == null) {
            this.repaginationListeners = new ArrayList(5);
        }
        this.repaginationListenersCache = null;
        this.repaginationListeners.add(l);
        this.cPages = l.PrintPageUpdated(new com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage(this.printPage));
    }

    public void removeRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.repaginationListeners == null) {
            this.repaginationListeners = new ArrayList(5);
        }
        this.repaginationListenersCache = null;
        this.repaginationListeners.remove(l);
    }

    public PrintPage getPrintPage() {
        return this.printPage;
    }

    public MediaSizeName setProperPrintArea(Dimension2D area) {
        double l = area.getHeight();
        double s = area.getWidth();
        if (area.getHeight() < area.getWidth()) {
            s = area.getHeight();
            l = area.getWidth();
        }
        MediaSizeName[] msn = new MediaSizeName[]{MediaSizeName.ISO_A5, MediaSizeName.ISO_A4, MediaSizeName.ISO_A3, MediaSizeName.ISO_A2, MediaSizeName.ISO_A1, MediaSizeName.ISO_A0};
        double samllestEdge = ((MediaPrintableArea[])this.selServ.getSupportedAttributeValues(MediaPrintableArea.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, new HashPrintServiceAttributeSet()))[0].getX(1000);
        MediaSizeName properMediaSizeName = null;
        for (int i = 0; i < msn.length; ++i) {
            MediaSize size = MediaSize.getMediaSizeForName(msn[i]);
            if (!((double)size.getX(1000) > s + 2.0 * samllestEdge) || !((double)size.getY(1000) > l + 2.0 * samllestEdge)) continue;
            properMediaSizeName = msn[i];
            this.printPage.leftEdge = (this.printPage.rightEdge = (float)((double)size.getX(1000) - s) / 2.0f);
            this.printPage.topEdge = (this.printPage.bottomEdge = (float)((double)size.getY(1000) - l) / 2.0f);
            this.requestAttrSet.add(this.printPage.getMediaPrintableArea());
            this.printPage.setPage(properMediaSizeName);
            break;
        }
        return properMediaSizeName;
    }

    public int getPageCount() {
        return this.cPages;
    }

    public int getPageStart() {
        PageRanges pageRanges = (PageRanges)this.requestAttrSet.get(PageRanges.class);
        return pageRanges.getMembers()[0][0];
    }

    public void setPageRange(int startPage, int endPage) {
        PageRanges pageRanges = new PageRanges(startPage, endPage);
        this.requestAttrSet.add(pageRanges);
    }

    static /* synthetic */ Object[] access$202(PrinterAttrManager x0, Object[] x1) {
        x0.repaginationListenersCache = x1;
        return x1;
    }

    protected class OrientationPrintPage
    extends PrintPage {
        public OrientationPrintPage(MediaSizeName media) {
            super(media);
        }

        @Override
        public float getBottomEdge() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                return super.getRightEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getLeftEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                return super.getTopEdge();
            }
            return super.getBottomEdge();
        }

        @Override
        public float getRightEdge() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                return super.getTopEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getBottomEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                return super.getLeftEdge();
            }
            return super.getRightEdge();
        }

        @Override
        public float getTopEdge() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                return super.getLeftEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getRightEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                return super.getBottomEdge();
            }
            return super.getTopEdge();
        }

        @Override
        public float getLeftEdge() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                return super.getBottomEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getTopEdge();
            }
            if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                return super.getRightEdge();
            }
            return super.getLeftEdge();
        }

        @Override
        public float getFooterHeight() {
            return super.getFooterHeight();
        }

        @Override
        public float getHeaderHeight() {
            return super.getHeaderHeight();
        }

        @Override
        public Dimension2D getPageSize() {
            return new Dimension((int)this.getPrintPageW(), (int)this.getPrintPageH());
        }

        @Override
        public float getPrintableAreaH() {
            return this.getPrintPageH() - this.getTopEdge() - this.getBottomEdge();
        }

        @Override
        public float getPrintableAreaW() {
            return this.getPrintPageW() - this.getRightEdge() - this.getLeftEdge();
        }

        @Override
        public float getPrintableAreaX() {
            return this.getLeftEdge();
        }

        @Override
        public float getPrintableAreaY() {
            return this.getTopEdge();
        }

        @Override
        public float getPrintPageH() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE || this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getPrintPageW();
            }
            return super.getPrintPageH();
        }

        @Override
        public float getPrintPageW() {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE || this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                return super.getPrintPageH();
            }
            return super.getPrintPageW();
        }

        @Override
        public void setBottomEdge(float f) {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                super.setRightEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                super.setLeftEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                super.setTopEdge(f);
            } else {
                super.setBottomEdge(f);
            }
        }

        @Override
        public void setLeftEdge(float f) {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                super.setBottomEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                super.setTopEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                super.setRightEdge(f);
            } else {
                super.setLeftEdge(f);
            }
        }

        @Override
        public void setRightEdge(float f) {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                super.setTopEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                super.setBottomEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                super.setLeftEdge(f);
            } else {
                super.setRightEdge(f);
            }
        }

        @Override
        public void setTopEdge(float f) {
            if (this.getOrientation() == OrientationRequested.LANDSCAPE) {
                super.setLeftEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_LANDSCAPE) {
                super.setRightEdge(f);
            } else if (this.getOrientation() == OrientationRequested.REVERSE_PORTRAIT) {
                super.setBottomEdge(f);
            } else {
                super.setTopEdge(f);
            }
        }

        @Override
        public void setFooterHeight(float f) {
            super.setFooterHeight(f);
        }

        @Override
        public void setHeaderHeight(float f) {
            super.setHeaderHeight(f);
        }

        @Override
        public void setPage(MediaSizeName media) {
            super.setPage(media);
        }

        @Override
        public void setPagePrintableArea(MediaPrintableArea printableArea) {
            super.setPagePrintableArea(printableArea);
        }
    }

    protected class PrintPage {
        MediaSizeName mediaSizeName;
        private MediaSize paperSize;
        private double PrintPageW;
        private double PrintPageH;
        private double headerHeight;
        private float footerHeight;
        private double topEdge = 25.0;
        private double bottomEdge = 25.0;
        private double leftEdge = 19.0;
        private double rightEdge = 19.0;
        private static final String namePaginationInfo = "PageSetup";
        private static final String namePaperSizeName = "PaperSizeName";
        private static final String nameCustomizePaperSize = "CustomizePaperSize";
        private static final String namePaperPrintableArea = "PageMargin";
        private static final String nameOrientation = "Orientation";
        private final String[] myStringTable = new String[]{"iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "na-letter", "na-legal", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "japanese-postcard", "oufuko-postcard", "a", "b", "c", "d", "e", "iso-designated-long", "italian-envelope", "monarch-envelope", "personal-envelope", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "na-5x7", "na-8x10"};
        private final MediaSizeName[] myMediaSizeNameTable = new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10};

        public PrintPage(MediaSizeName media) {
            this.setPage(media);
        }

        public void setPage(MediaSizeName media) {
            this.mediaSizeName = media;
            this.paperSize = MediaSize.getMediaSizeForName(media);
            PrinterAttrManager.this.requestAttrSet.add(this.mediaSizeName);
            this.PrintPageW = this.paperSize.getX(PrinterAttrManager.this.defaultUnit);
            this.PrintPageH = this.paperSize.getY(PrinterAttrManager.this.defaultUnit);
            this.notifyRepaginationListener();
        }

        public void UpdatePrintableArea2AttrSet() {
            PrinterAttrManager.this.requestAttrSet.add(this.getMediaPrintableArea());
        }

        private void notifyRepaginationListener() {
            this.UpdatePrintableArea2AttrSet();
            if (PrinterAttrManager.this.repaginationListeners != null) {
                if (PrinterAttrManager.this.repaginationListenersCache == null) {
                    PrinterAttrManager.access$202(PrinterAttrManager.this, PrinterAttrManager.this.repaginationListeners.toArray());
                }
                for (int i = 0; i < PrinterAttrManager.this.repaginationListenersCache.length; ++i) {
                    RepaginationListener l = (RepaginationListener)PrinterAttrManager.this.repaginationListenersCache[i];
                    PrinterAttrManager.this.cPages = l.PrintPageUpdated(new com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage(this));
                }
            }
        }

        public void setPagePrintableArea(MediaPrintableArea printableArea) {
            this.leftEdge = printableArea.getX(PrinterAttrManager.this.defaultUnit);
            this.topEdge = printableArea.getY(PrinterAttrManager.this.defaultUnit);
            this.rightEdge = this.PrintPageW - (double)printableArea.getWidth(PrinterAttrManager.this.defaultUnit) - this.leftEdge;
            this.bottomEdge = this.PrintPageH - (double)printableArea.getHeight(PrinterAttrManager.this.defaultUnit) - this.topEdge;
            this.notifyRepaginationListener();
        }

        public MediaPrintableArea getMediaPrintableArea() {
            return new MediaPrintableArea((float)this.leftEdge, (float)this.topEdge, (float)(ArrayUtil.isEqual((Double)this.PrintPageW, (Double)-1.0) ? 3.4028234663852886E38 : this.PrintPageW - this.rightEdge - this.leftEdge), (float)(ArrayUtil.isEqual((Double)this.PrintPageH, (Double)-1.0) ? 3.4028234663852886E38 : this.PrintPageH - this.topEdge - this.bottomEdge), PrinterAttrManager.this.defaultUnit);
        }

        public float getPrintableAreaW() {
            if (ArrayUtil.isEqual((Double)this.PrintPageW, (Double)-1.0)) {
                return -1.0f;
            }
            if (this.PrintPageW - this.rightEdge - this.leftEdge < 0.0) {
                return 0.0f;
            }
            return (float)(this.PrintPageW - this.rightEdge - this.leftEdge);
        }

        public float getPrintableAreaH() {
            if (ArrayUtil.isEqual((Double)this.PrintPageH, (Double)-1.0)) {
                return -1.0f;
            }
            if (this.PrintPageH - this.topEdge - this.bottomEdge < 0.0) {
                return 0.0f;
            }
            return (float)(this.PrintPageH - this.topEdge - this.bottomEdge);
        }

        public float getPrintableAreaX() {
            return (float)this.leftEdge;
        }

        public float getPrintableAreaY() {
            return (float)this.topEdge;
        }

        public float getPrintPageH() {
            return (float)this.PrintPageH;
        }

        public float getPrintPageW() {
            return (float)this.PrintPageW;
        }

        public void setPrintPageH(float f) {
            this.PrintPageH = f;
            this.notifyRepaginationListener();
        }

        public void setPrintPageW(float f) {
            this.PrintPageW = f;
            this.notifyRepaginationListener();
        }

        public float getHeaderHeight() {
            return (float)this.headerHeight;
        }

        public void setHeaderHeight(float f) {
            this.headerHeight = f;
            this.notifyRepaginationListener();
        }

        public float getFooterHeight() {
            return this.footerHeight;
        }

        public void setFooterHeight(float f) {
            this.footerHeight = f;
            this.notifyRepaginationListener();
        }

        public void setBottomEdge(float f) {
            this.bottomEdge = f;
            this.notifyRepaginationListener();
        }

        public void setLeftEdge(float f) {
            this.leftEdge = f;
            this.notifyRepaginationListener();
        }

        public void setRightEdge(float f) {
            this.rightEdge = f;
            this.notifyRepaginationListener();
        }

        public void setTopEdge(float f) {
            this.topEdge = f;
            this.notifyRepaginationListener();
        }

        public OrientationRequested getOrientation() {
            return PrinterAttrManager.this.orient;
        }

        public void UpdateOrientationReq() {
            PrinterAttrManager.this.requestAttrSet.add(this.getOrientation());
        }

        public void setOrientation(OrientationRequested orientation) {
            PrinterAttrManager.this.orient = orientation;
            this.UpdateOrientationReq();
            this.notifyRepaginationListener();
        }

        public void setOrient(OrientationRequested orientation) {
            PrinterAttrManager.this.orient = orientation;
        }

        public Dimension2D getPageSize() {
            return new Dimension((int)this.getPrintPageW(), (int)this.getPrintPageH());
        }

        protected void recoverPrintPage(IXmlElement paginationElt) {
            IXmlElement orientation;
            if (paginationElt == null || !paginationElt.getName().equals(namePaginationInfo)) {
                return;
            }
            IXmlElement customizePaperSize = paginationElt.getChild(nameCustomizePaperSize);
            if (customizePaperSize != null) {
                this.PrintPageW = Double.parseDouble(customizePaperSize.getAttribute("width"));
                this.PrintPageH = Double.parseDouble(customizePaperSize.getAttribute("height"));
                float a5_sizex = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A5).getX(1000);
                float a4_sizex = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4).getX(1000);
                float a3_sizex = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A3).getX(1000);
                float a2_sizex = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A2).getX(1000);
                float a5_sizey = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A5).getY(1000);
                float a4_sizey = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4).getY(1000);
                float a3_sizey = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A3).getY(1000);
                float a2_sizey = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A2).getY(1000);
                if (ArrayUtil.isEqual((Double)this.PrintPageW, (Double)-1.0) && !ArrayUtil.isEqual((Double)this.PrintPageH, (Double)-1.0)) {
                    this.PrintPageW /= 10.0;
                    this.PrintPageH /= 10.0;
                    if ((double)a5_sizey > this.PrintPageH) {
                        this.PrintPageW = a5_sizex;
                        this.PrintPageH = a5_sizey;
                    } else if ((double)a5_sizey < this.PrintPageH && this.PrintPageW <= (double)a4_sizey) {
                        this.PrintPageW = a4_sizex;
                        this.PrintPageH = a4_sizey;
                    } else if ((double)a4_sizey < this.PrintPageH && this.PrintPageW <= (double)a3_sizey) {
                        this.PrintPageW = a3_sizex;
                        this.PrintPageH = a3_sizey;
                    } else if ((double)a3_sizey < this.PrintPageH) {
                        this.PrintPageW = a2_sizex;
                        this.PrintPageH = a2_sizey;
                    }
                } else if (!ArrayUtil.isEqual((Double)this.PrintPageW, (Double)-1.0) && ArrayUtil.isEqual((Double)this.PrintPageH, (Double)-1.0)) {
                    this.PrintPageW /= 10.0;
                    this.PrintPageH /= 10.0;
                    if ((double)a5_sizex > this.PrintPageW) {
                        this.PrintPageW = a5_sizex;
                        this.PrintPageH = a5_sizey;
                    } else if ((double)a5_sizex < this.PrintPageW && this.PrintPageW <= (double)a4_sizex) {
                        this.PrintPageW = a4_sizex;
                        this.PrintPageH = a4_sizey;
                    } else if ((double)a4_sizex < this.PrintPageW && this.PrintPageW <= (double)a3_sizex) {
                        this.PrintPageW = a3_sizex;
                        this.PrintPageH = a3_sizey;
                    } else if ((double)a3_sizex < this.PrintPageW) {
                        this.PrintPageW = a2_sizex;
                        this.PrintPageH = a2_sizey;
                    }
                } else if (ArrayUtil.isEqual((Double)this.PrintPageW, (Double)-1.0) && ArrayUtil.isEqual((Double)this.PrintPageH, (Double)-1.0)) {
                    this.PrintPageW = a4_sizex;
                    this.PrintPageH = a4_sizey;
                }
            } else {
                IXmlElement paperSizeName = paginationElt.getChild(namePaperSizeName);
                if (paperSizeName != null) {
                    int i;
                    String mediaSizeName = paperSizeName.getText();
                    for (i = 0; i < this.myStringTable.length; ++i) {
                        if (!mediaSizeName.equals(this.myStringTable[i])) continue;
                        this.setPage(this.myMediaSizeNameTable[i]);
                        break;
                    }
                    if (i == this.myStringTable.length) {
                        this.setPage(MediaSizeName.ISO_A4);
                    }
                }
            }
            IXmlElement printArea = paginationElt.getChild(namePaperPrintableArea);
            if (printArea != null) {
                this.setLeftEdge(Float.parseFloat(printArea.getAttribute("left")) / 10.0f);
                this.setRightEdge(Float.parseFloat(printArea.getAttribute("right")) / 10.0f);
                this.setTopEdge(Float.parseFloat(printArea.getAttribute("top")) / 10.0f);
                this.setBottomEdge(Float.parseFloat(printArea.getAttribute("bottom")) / 10.0f);
            }
            if ((orientation = paginationElt.getChild(nameOrientation)) != null) {
                if ("LANDSCAPE".equals(orientation.getText())) {
                    PrinterAttrManager.this.orient = OrientationRequested.LANDSCAPE;
                } else {
                    PrinterAttrManager.this.orient = OrientationRequested.PORTRAIT;
                }
            }
        }

        public Dimension2D caculatePrintableAreaForNode(IXmlElement printElt) {
            MyDimension2D theArea = new MyDimension2D(0.0, 0.0);
            if (printElt == null || !printElt.getName().equals(namePaginationInfo)) {
                return null;
            }
            double PrintPageW = 0.0;
            double PrintPageH = 0.0;
            IXmlElement customizePaperSize = printElt.getChild(nameCustomizePaperSize);
            if (customizePaperSize != null) {
                PrintPageW = Double.parseDouble(customizePaperSize.getAttribute("width"));
                PrintPageH = Double.parseDouble(customizePaperSize.getAttribute("height"));
            } else {
                IXmlElement paperSizeName = printElt.getChild(namePaperSizeName);
                if (paperSizeName != null) {
                    String mediaSizeName = paperSizeName.getText();
                    for (int i = 0; i < this.myStringTable.length; ++i) {
                        if (!mediaSizeName.equals(this.myStringTable[i])) continue;
                        MediaSize.getMediaSizeForName(this.myMediaSizeNameTable[i]);
                        break;
                    }
                }
            }
            double leftEdge = this.leftEdge;
            double rightEdge = this.rightEdge;
            double topEdge = this.topEdge;
            double bottomEdge = this.bottomEdge;
            IXmlElement printArea = printElt.getChild(namePaperPrintableArea);
            if (printArea != null) {
                leftEdge = Double.parseDouble(printArea.getAttribute("leftEdge"));
                rightEdge = Double.parseDouble(printArea.getAttribute("rightEdge"));
                topEdge = Double.parseDouble(printArea.getAttribute("topEdge"));
                bottomEdge = Double.parseDouble(printArea.getAttribute("bottomEdge"));
            }
            if (ArrayUtil.isEqual((Double)PrintPageW, (Double)-1.0)) {
                theArea.setWidth(-1.0);
            } else if (PrintPageW - rightEdge - leftEdge < 0.0) {
                theArea.setWidth(0.0);
            } else {
                theArea.setWidth(PrintPageW - rightEdge - leftEdge);
            }
            if (ArrayUtil.isEqual((Double)PrintPageH, (Double)-1.0)) {
                theArea.setHeight(-1.0);
            } else if (PrintPageH - topEdge - bottomEdge < 0.0) {
                theArea.setHeight(0.0);
            } else {
                theArea.setHeight(PrintPageH - topEdge - bottomEdge);
            }
            return theArea;
        }

        protected IXmlElement getPrintPageStorage() {
            IXmlElement paperSizeName = XmlUtil.createNode((String)namePaperSizeName);
            paperSizeName.addCData(this.mediaSizeName.toString());
            IXmlElement printableArea = XmlUtil.createNode((String)namePaperPrintableArea);
            printableArea.setAttribute("leftEdge", String.valueOf(this.leftEdge));
            printableArea.setAttribute("rightEdge", String.valueOf(this.rightEdge));
            printableArea.setAttribute("topEdge", String.valueOf(this.topEdge));
            printableArea.setAttribute("bottomEdge", String.valueOf(this.bottomEdge));
            printableArea.setAttribute("unit", PrinterAttrManager.this.defaultUnit == 1000 ? "MM" : "INCH");
            IXmlElement orientation = XmlUtil.createNode((String)nameOrientation);
            orientation.addCData(PrinterAttrManager.this.orient == OrientationRequested.PORTRAIT ? "PORTRAIT" : "LANDSCAPE");
            IXmlElement retElt = XmlUtil.createNode((String)namePaginationInfo);
            retElt.addChild(paperSizeName);
            retElt.addChild(printableArea);
            retElt.addChild(orientation);
            return retElt;
        }

        public float getLeftEdge() {
            return (float)this.leftEdge;
        }

        public float getBottomEdge() {
            return (float)this.bottomEdge;
        }

        public float getRightEdge() {
            return (float)this.rightEdge;
        }

        public float getTopEdge() {
            return (float)this.topEdge;
        }
    }

    public class PrintRequestAttrSetWithNotify
    implements PrintRequestAttributeSet {
        @Override
        public boolean add(Attribute attribute) {
            Attribute oldValue = PrinterAttrManager.this.requestAttrSet.get(attribute.getCategory());
            if (!attribute.equals(oldValue)) {
                this.PrintRequestAttrChanged(attribute);
            }
            return PrinterAttrManager.this.requestAttrSet.add(attribute);
        }

        @Override
        public boolean addAll(AttributeSet attributes) {
            Attribute[] attrs = attributes.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                Attribute newValue = attrs[i];
                Attribute oldValue = PrinterAttrManager.this.requestAttrSet.get(newValue.getCategory());
                if (newValue.equals(oldValue)) continue;
                this.PrintRequestAttrChanged(newValue);
            }
            return PrinterAttrManager.this.requestAttrSet.addAll(attributes);
        }

        private void PrintRequestAttrChanged(Attribute attribute) {
            if (attribute.getClass() == MediaPrintableArea.class) {
                PrinterAttrManager.this.printPage.setPagePrintableArea((MediaPrintableArea)attribute);
            } else if (attribute.getClass() == OrientationRequested.class) {
                PrinterAttrManager.this.printPage.setOrientation((OrientationRequested)attribute);
            } else if (attribute.getClass() == MediaSizeName.class) {
                PrinterAttrManager.this.printPage.setPage((MediaSizeName)attribute);
            } else if (attribute.getClass() == PageRanges.class) {
                // empty if block
            }
        }

        @Override
        public void clear() {
            PrinterAttrManager.this.requestAttrSet.clear();
        }

        public boolean containsKey(Class category) {
            return PrinterAttrManager.this.requestAttrSet.containsKey(category);
        }

        @Override
        public boolean containsValue(Attribute attribute) {
            return PrinterAttrManager.this.requestAttrSet.containsValue(attribute);
        }

        @Override
        public boolean equals(Object obj) {
            return PrinterAttrManager.this.requestAttrSet.equals(obj);
        }

        public Attribute get(Class category) {
            return PrinterAttrManager.this.requestAttrSet.get(category);
        }

        @Override
        public int hashCode() {
            return PrinterAttrManager.this.requestAttrSet.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return PrinterAttrManager.this.requestAttrSet.isEmpty();
        }

        public boolean remove(Class category) {
            return PrinterAttrManager.this.requestAttrSet.remove(category);
        }

        @Override
        public boolean remove(Attribute attribute) {
            return PrinterAttrManager.this.requestAttrSet.remove(attribute);
        }

        @Override
        public int size() {
            return PrinterAttrManager.this.requestAttrSet.size();
        }

        @Override
        public Attribute[] toArray() {
            return PrinterAttrManager.this.requestAttrSet.toArray();
        }

        public String toString() {
            return PrinterAttrManager.this.requestAttrSet.toString();
        }
    }
}

