/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import java.awt.geom.Dimension2D;
import java.io.Serializable;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class PrinterRecoverManager {
    static final int RECOVER_SUCCEEDED = 0;
    static final int RECOVER_FAILED = 1;
    static final int RECOVER_NOT_SUPPORT_ALL__ATTR = 2;
    KDPrintbase base;
    private static final String namePrinter = "PrintInfo";
    private static final String namePaginationInfo = "PageSetup";
    private static final String namePrinterParam = "PrinterParam";

    public PrinterRecoverManager(KDPrintbase printbase) {
        this.base = printbase;
    }

    public int RecoverFrom(IXmlElement printElt) {
        IXmlElement pageInfo;
        HashPrintRequestAttributeSet reqAttrSet = new HashPrintRequestAttributeSet();
        if (printElt.getChild(namePrinterParam) != null) {
            List elts = printElt.getChild(namePrinterParam).getChildren();
            Attribute[] decrAttrs = new Attribute[elts.size()];
            for (int i = 0; i < elts.size(); ++i) {
                decrAttrs[i] = (Attribute)Base64.decodeToObject((String)((IXmlElement)elts.get(i)).getText());
                reqAttrSet.add(decrAttrs[i]);
            }
        }
        if ((pageInfo = printElt.getChild(namePaginationInfo)) != null) {
            this.base.getPrinterAttrManager().getPrintPage().recoverPrintPage(pageInfo);
        }
        return 0;
    }

    public Dimension2D caculatePrintableAreaForNode(IXmlElement printElt) {
        IXmlElement pageInfo = printElt.getChild(namePaginationInfo);
        if (pageInfo != null) {
            return this.base.getPrinterAttrManager().getPrintPage().caculatePrintableAreaForNode(pageInfo);
        }
        return null;
    }

    public IXmlElement getStorage() {
        IXmlElement printerElt = XmlUtil.createNode((String)namePrinter);
        IXmlElement printerParam = XmlUtil.createNode((String)namePrinterParam);
        IXmlElement paginationInfo = this.base.getPrinterAttrManager().getPrintPage().getPrintPageStorage();
        printerElt.addChild(paginationInfo);
        printerElt.addChild(printerParam);
        PrintRequestAttributeSet reqAttrSet = this.base.getPrinterAttrManager().getPrintRequestAttributeSet();
        Attribute[] rAttrs = reqAttrSet.toArray();
        for (int i = 0; i < rAttrs.length; ++i) {
            if (rAttrs[i] == null) continue;
            IXmlElement elt = XmlUtil.createNode((String)rAttrs[i].getName());
            elt.addCData(Base64.encodeObject((Serializable)rAttrs[i]));
            printerParam.addChild(elt);
        }
        return printerElt;
    }
}

