/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.event.MouseInputAdapter;

public class ZoomModeSwapper
extends MouseInputAdapter {
    KDPrintbase base;
    int prevMultiPageRow = 1;
    int prevMultiPageCol = 1;
    private boolean isZoomMode = false;
    Cursor zoomModeCursor;
    Cursor savedCursor = null;

    public ZoomModeSwapper(KDPrintbase printbase) {
        this.base = printbase;
        URL in = this.getClass().getClassLoader().getResource(this.base.getResources().getString("zoomModeSwapper.zoomInCursor"));
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Image img = defaultToolkit.getImage(in);
        this.zoomModeCursor = defaultToolkit.createCustomCursor(img, new Point(0, 0), "zoom");
    }

    public void SetZoomMode() {
        this.prevMultiPageRow = 1;
        this.prevMultiPageCol = 1;
        this.savedCursor = null;
        this.isZoomMode = true;
        this.base.getPreviewPane().addMouseListener(this);
        this.base.getPreviewPane().addMouseMotionListener(this);
    }

    public void UnsetZoomMode() {
        this.isZoomMode = false;
        this.base.getPreviewPane().removeMouseListener(this);
        this.base.getPreviewPane().removeMouseMotionListener(this);
        if (this.base.getPreviewPane().getCursor() == this.zoomModeCursor) {
            this.base.getPreviewPane().setCursor(this.savedCursor);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int startPage = this.getPageClicked(e);
        if (startPage >= 0) {
            if (!this.base.getPageLayoutManager().isSinglePageMode()) {
                if (startPage != this.base.getActivePage()) {
                    this.base.setActivePage(startPage);
                    this.savedCursor = this.base.getPreviewPane().getCursor();
                    this.base.getPreviewPane().setCursor(this.zoomModeCursor);
                    this.base.getPreviewPane().FlushPaneGraphicCache();
                    this.base.getPreviewPane().repaint();
                } else {
                    this.prevMultiPageRow = this.base.getPageLayoutManager().getPageRows();
                    this.prevMultiPageCol = this.base.getPageLayoutManager().getPageCols();
                    this.base.UpdateMulitPage(1, 1);
                    this.base.getPageLayoutManager().setScale4SinglePage(1.0);
                }
            } else if (this.prevMultiPageRow != 1 && this.prevMultiPageCol != 1) {
                this.base.UpdateMulitPage(this.prevMultiPageRow, this.prevMultiPageCol);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isConatined = this.base.getPageLayoutManager().getPosOfPages()[this.base.getActivePage()].contains(e.getPoint());
        if (isConatined && this.base.getPreviewPane().getCursor() != this.zoomModeCursor) {
            this.savedCursor = this.base.getPreviewPane().getCursor();
            this.base.getPreviewPane().setCursor(this.zoomModeCursor);
        }
        if (!isConatined && this.base.getPreviewPane().getCursor() == this.zoomModeCursor && this.base.getPreviewPane().getCursor() != this.savedCursor) {
            this.base.getPreviewPane().setCursor(this.savedCursor);
        }
    }

    protected int getPageClicked(MouseEvent e) {
        Rectangle2D[] rects = this.base.getPageLayoutManager().getPosOfPages();
        for (int i = 0; i < rects.length; ++i) {
            if (rects[i] == null || !rects[i].contains(e.getPoint())) continue;
            return i;
        }
        return -1;
    }

    public boolean isZoomMode() {
        return this.isZoomMode;
    }
}

