/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kds;

public class KDSMergeBlock {
    public static final KDSMergeBlock NULL_MERGE = new KDSMergeBlock(-1, -1, -1, -1);
    private long paintID = -1L;
    public int col;
    public int row;
    private int width;
    private int height;

    public KDSMergeBlock(int row, int col, int row2, int col2) {
        assert (row >= 0 && col >= 0 && row2 >= 0 && col2 >= 0);
        this.col = Math.min(col, col2);
        this.width = Math.max(col, col2) - this.col;
        this.row = Math.min(row, row2);
        this.height = Math.max(row, row2) - this.row;
    }

    public boolean isNullMergeBlock() {
        return this == NULL_MERGE;
    }

    public int getCol2() {
        return this.col + this.width;
    }

    public int getRow2() {
        return this.row + this.height;
    }

    public boolean include(int row, int col) {
        int w = this.width;
        int h = this.height;
        if ((w | h) < 0) {
            return false;
        }
        int x = this.col;
        int y = this.row;
        if (col < x || row < y) {
            return false;
        }
        h += y;
        return !((w += x) >= x && w < col || h >= y && h < row);
    }

    public boolean include(KDSMergeBlock merge) {
        return this.include(merge.row, merge.col) && this.include(merge.getRow2(), merge.getCol2());
    }

    public boolean cross(KDSMergeBlock r) {
        int tw = this.width;
        int th = this.height;
        int rw = r.width;
        int rh = r.height;
        int tx = this.col;
        int ty = this.row;
        int rx = r.col;
        int ry = r.row;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw < tx || rh >= ry && rh < ty || tw >= tx && tw < rx || th >= ty && th < ry);
    }

    public long getPaintID() {
        return this.paintID;
    }

    public void setPaintID(long paintID) {
        this.paintID = paintID;
    }

    public boolean isWholeRow() {
        return this.col == 0 && this.width == Integer.MAX_VALUE;
    }

    public boolean isWholeColumn() {
        return this.row == 0 && this.height == Integer.MAX_VALUE;
    }

    public boolean isWholeSheetBlock() {
        return this.isWholeRow() && this.isWholeColumn();
    }

    public int getWidth() {
        return this.width + 1;
    }

    public int getHeight() {
        return this.height + 1;
    }
}

