/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IDocInfoProvider;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IExSetup;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrData;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ActionInitializer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.conf.ConfManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.ExSetupDialog;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.ExSetupManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.PrintServiceUI;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.BaseComponent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.HeaderFooterManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.headerfooter.KDFHeaderFooterPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.log4j.Logger;

public class KDPrintService
extends PrintCompContainer {
    private static final Logger logger = LogUtil.getLogger(KDPrintService.class);
    public static float JavaScreenResoluction = 72.0f;
    private PrintHelper printHelper = new PrintHelper();
    private ExSetupDialog exSetupDlg;
    private ExSetupManager exSetupMgr;
    private HeaderFooterManager hfMgr;
    private JDialog previewDlg;
    public static boolean isTempForForm;

    public KDPrintService() {
        try {
            super.getManager().put("KDPrintService", this);
            this.initialize();
            this.hfMgr = new HeaderFooterManager();
            this.hfMgr.setupForPrintService(this);
        }
        catch (ServiceException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public PrinterAttrData showPrinterSetupSimpleDialog() {
        return this.showPrinterSetupSimpleDialog(null);
    }

    public PrinterAttrData showPrinterSetupSimpleDialog(Window owner) {
        try {
            return this.printHelper.showSimpleSetup(this.printerAttrMgr, owner);
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)"err", (Throwable)e);
            logger.error((Object)" Printer Not Found ");
            KDOptionPane.showMessageDialog((Component)this.innerGetBaseComponent(), (Object)Resources.LOCAL_STR("PrinterNotFound"));
            return null;
        }
    }

    public boolean printDirect(PrinterAttrData padata) {
        return this.printHelper.printDirect(padata);
    }

    public boolean printDirect() {
        try {
            this.printHelper.printDirect(this.printerAttrMgr);
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)" Printer Not Found ");
            logger.error((Object)"err", (Throwable)e);
            KDOptionPane.showMessageDialog((Component)this.innerGetBaseComponent(), (Object)Resources.LOCAL_STR("PrinterNotFound"));
            return false;
        }
        return true;
    }

    public boolean print() {
        return this.print(null);
    }

    public boolean print(Window owner) {
        try {
            this.printHelper.print(this.printerAttrMgr, owner);
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)" Printer Not Found ");
            logger.error((Object)"err", (Throwable)e);
            KDOptionPane.showMessageDialog((Component)this.innerGetBaseComponent(), (Object)Resources.LOCAL_STR("PrinterNotFound"));
            return false;
        }
        return true;
    }

    public boolean showPrinterSetupDialog(Dialog owner) {
        return this.showPrinterSetupDialog((Container)owner);
    }

    public boolean showPrinterSetupDialog(Frame owner) {
        ExSetupDialog dlg;
        this.getExSetupMgr().preBuildTree(ConfManager.getDefaultInstance().getConf().getSetupTreeNode());
        try {
            dlg = new ExSetupDialog(owner, Resources.LOCAL_STR("Config"), true, this.getExSetupMgr(), (PrintCompContainer)this);
        }
        catch (PrinterNotFoundException ex) {
            logger.error((Object)"err", (Throwable)ex);
            KDOptionPane.showMessageDialog((Component)this.innerGetBaseComponent(), (Object)Resources.LOCAL_STR("PrinterNotFound"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            return false;
        }
        return this.ShowExDlg(dlg);
    }

    public boolean showPrinterSetupDialog(Container owner) {
        ExSetupDialog dlg = this.getPrinterSetupDialog(owner);
        boolean result = this.ShowExDlg(dlg);
        return result;
    }

    public boolean showPrinterSetupDialog() {
        ExSetupDialog dlg = this.getPrinterSetupDialog();
        boolean result = dlg == null ? false : this.ShowExDlg(dlg);
        return result;
    }

    private boolean ShowExDlg(ExSetupDialog exdlg) {
        exdlg.pack();
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        exdlg.setLocation((defaultToolkit.getScreenSize().width - exdlg.getWidth()) / 2, (defaultToolkit.getScreenSize().height - exdlg.getHeight()) / 2);
        PrintService newService = exdlg.printDialog(this.getPrinterAttrManager());
        if (newService != null) {
            this.printerAttrMgr.setCurrentService(newService);
            this.getBaseComponent().getPreviewPane().doRepaint();
            this.getPreviewContext().updateView();
            this.updateStatus();
        }
        return newService != null;
    }

    public void updateStatus() {
        String totalPage = this.getPreviewContext().isDataIncomplete() ? "..." : "" + this.getPreviewContext().getTotalPageCount();
        this.getBaseComponent().getStausbar().setLeftInfo(BaseComponent.resources.getString("tip.the") + (this.getPreviewContext().getCurrentPage() + 1) + BaseComponent.resources.getString("tip.page/total") + totalPage + BaseComponent.resources.getString("tip.page"));
    }

    public void previewInDefaultDialog(Dialog owner, boolean isModel) {
        this.previewDlg = owner != null ? new JDialog(owner, isModel) : new JDialog();
        this.previewDlg.setContentPane(this.getBaseComponent());
        this.previewDlg.pack();
        try {
            this.getPreviewContext().Goto(0);
            this.getBaseComponent().getPreviewPane().doRepaint();
        }
        catch (RuntimeException re) {
            logger.error((Object)"err", (Throwable)re);
            return;
        }
        this.previewDlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                KDPrintService.this.getPreviewContext().clear();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                KDPrintService.this.getPreviewContext().Goto(0);
            }
        });
        this.getBaseComponent().getPreviewPaneHolder().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.previewDlg.setSize(dim.width, dim.height - 25);
        this.getPreviewContext().setPaneFitStyle(4);
        this.previewDlg.setVisible(true);
    }

    public void previewInDefaultDialog(Frame owner, boolean isModel) {
        KDDialog dlg = owner != null ? new KDDialog(owner, isModel) : new KDDialog();
        dlg.setContentPane(this.getBaseComponent());
        dlg.pack();
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                KDPrintService.this.getPreviewContext().clear();
            }
        });
        try {
            this.getPreviewContext().Goto(0);
            this.getBaseComponent().getPreviewPane().doRepaint();
        }
        catch (RuntimeException re) {
            logger.error((Object)"err", (Throwable)re);
            return;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dlg.setSize(dim.width, dim.height - 25);
        dlg.setLocation(0, 0);
        this.getPreviewContext().setPaneFitStyle(4);
        dlg.setVisible(true);
    }

    public void previewInDefaultDialog() {
        this.previewInDefaultDialog(new JFrame(), false);
    }

    public ExSetupDialog getPrinterSetupDialog(Container parent) {
        if (this.exSetupDlg == null) {
            this.getExSetupMgr().preBuildTree(ConfManager.getDefaultInstance().getConf().getSetupTreeNode());
            try {
                Dialog dlg;
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
                this.exSetupDlg = frame != null ? new ExSetupDialog(frame, Resources.LOCAL_STR("Config"), true, this.getExSetupMgr(), (PrintCompContainer)this) : ((dlg = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent)) != null ? new ExSetupDialog(dlg, Resources.LOCAL_STR("Config"), true, this.getExSetupMgr(), (PrintCompContainer)this) : new ExSetupDialog((Frame)null, Resources.LOCAL_STR("Config"), true, this.getExSetupMgr(), (PrintCompContainer)this));
            }
            catch (PrinterNotFoundException ex) {
                logger.error((Object)"err", (Throwable)ex);
                KDOptionPane.showMessageDialog((Component)this.innerGetBaseComponent(), (Object)Resources.LOCAL_STR("PrinterNotFound"));
                this.exSetupDlg = null;
                return null;
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
                return null;
            }
            this.exSetupDlg.setModal(true);
        }
        return this.exSetupDlg;
    }

    public ExSetupDialog getPrinterSetupDialog() {
        return this.getPrinterSetupDialog(this.getBaseComponent());
    }

    public void addSetupPane(String title, JPanel setupPane) {
        this.getExSetupMgr().addSetupPane(title, setupPane);
    }

    public void addExSetup(IExSetup exSetup) {
        this.getExSetupMgr().addExsetup(exSetup);
    }

    public void removeSetupPane(JPanel setupPane) {
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printerAttrMgr.getRequestAttrSet();
    }

    public ExSetupManager getExSetupMgr() {
        if (this.exSetupMgr == null) {
            this.exSetupMgr = new ExSetupManager(this, this.printerAttrMgr);
        }
        return this.exSetupMgr;
    }

    public Printable getPrintable() {
        return this.printHelper;
    }

    public void setActionInitializer(ActionInitializer ai) {
        this.getBaseComponent().setActionInitializer(ai);
    }

    public void setDocInfoProvider(IDocInfoProvider docInfoProvider) {
        this.getPreviewContext().setDocInfoProvider(docInfoProvider);
    }

    public KDF getKDFForExtendFeatures() {
        if (this.getHeaderFooterPainter() != null && this.getHeaderFooterPainter() instanceof KDFHeaderFooterPainter) {
            return ((KDFHeaderFooterPainter)this.getHeaderFooterPainter()).getKdf();
        }
        return null;
    }

    public void setKDFForExtendFeatures(KDF kdf, ExtVarProvider evp) {
        if (kdf == null) {
            logger.warn((Object)"setKDFForExtendFeatures() -- kdf == null ");
            return;
        }
        KDFHeaderFooterPainter hfpainter = this.setKDFForExtendFeatures(kdf);
        hfpainter.setExtVarProv(evp);
    }

    public void setExtVarProvider(ExtVarProvider evp) {
        this.getHeaderFooterPainter().setExtVarProv(evp);
    }

    public void SetScreenMapRatio(float r) {
        isTempForForm = ArrayUtil.isEqual((Float)Float.valueOf(r), (Float)Float.valueOf(1.0f));
        if (this.printerAttrMgr != null) {
            this.printerAttrMgr.screenMapRatio = r;
        }
    }

    public KDFHeaderFooterPainter setKDFForExtendFeatures(KDF kdf) {
        String headerid = null;
        String footerid = null;
        int hHeader = kdf.getPrintInfo().getHeaderMargin();
        int hFooter = kdf.getPrintInfo().getFooterMargin();
        if (kdf.getForms().size() > 0) {
            Form form = (Form)kdf.getForms().iterator().next();
            headerid = form.getHeaderID();
            footerid = form.getFooterID();
        } else {
            if (kdf.getHeaders().length > 0) {
                headerid = kdf.getHeaders()[0].getId();
            }
            if (kdf.getFooters().length > 0) {
                footerid = kdf.getFooters()[0].getId();
            }
        }
        KDFHeaderFooterPainter hfpainter = null;
        hfpainter = new KDFHeaderFooterPainter(kdf, headerid, footerid, this.getPrinterAttrManager());
        this.setHeaderFooterPainter(hfpainter, hHeader, hFooter, kdf);
        return hfpainter;
    }

    private class PrintHelper
    implements Printable {
        int pi = -1;

        private PrintHelper() {
        }

        private PrintService getPrintService(PrinterAttrManager attrmgr, Window owner) throws PrinterNotFoundException {
            if (owner == null) {
                owner = SwingUtilities.getWindowAncestor(KDPrintService.this.getBaseComponent());
            }
            return PrintServiceUI.printDialog(owner, null, 200, 200, attrmgr.getPrintServices(), attrmgr.getCurrentService(), DocFlavor.SERVICE_FORMATTED.PRINTABLE, attrmgr.getRequestAttrSet());
        }

        private boolean print(PrinterAttrManager attrmgr, Window owner) throws PrinterNotFoundException {
            float ySize;
            float xSize;
            PrintService newService;
            MediaPrintableArea printableArea = (MediaPrintableArea)attrmgr.getRequestAttrSet().get(MediaPrintableArea.class);
            if (printableArea != null && !attrmgr.isPortrait()) {
                MediaPrintableArea printableAreaNew = new MediaPrintableArea(printableArea.getX(25400), printableArea.getY(25400), printableArea.getHeight(25400), printableArea.getWidth(25400), 25400);
                attrmgr.disableSpy = true;
                attrmgr.getRequestAttrSet().add(printableAreaNew);
                attrmgr.disableSpy = false;
            }
            if ((newService = this.getPrintService(attrmgr, owner)) == null) {
                attrmgr.setCurrentService(newService);
                attrmgr.getRequestAttrSet().add(printableArea);
                return true;
            }
            PrinterResolution r = (PrinterResolution)newService.getDefaultAttributeValue(PrinterResolution.class);
            if (r != null) {
                attrmgr.getRequestAttrSet().add(r);
            }
            HashPrintRequestAttributeSet reqas = new HashPrintRequestAttributeSet(attrmgr.getRequestAttrSet());
            MediaSize mediaSize = attrmgr.getMediaSize();
            if (mediaSize != null) {
                xSize = mediaSize.getX(1000);
                ySize = mediaSize.getY(1000);
            } else {
                xSize = 2.1474836E9f;
                ySize = 2.1474836E9f;
            }
            MediaPrintableArea area = new MediaPrintableArea(0.0f, 0.0f, xSize, ySize, 1000);
            reqas.add(area);
            attrmgr.getRequestAttrSet().add(printableArea);
            DocPrintJob job = attrmgr.getCurrentService().createPrintJob();
            SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            try {
                job.print(doc, reqas);
            }
            catch (PrintException e) {
                logger.error((Object)"err", (Throwable)e);
                return false;
            }
            return true;
        }

        private boolean printDirect(PrinterAttrManager attrmgr) throws PrinterNotFoundException {
            PrinterResolution r = (PrinterResolution)attrmgr.getCurrentService().getDefaultAttributeValue(PrinterResolution.class);
            attrmgr.getRequestAttrSet().add(r);
            DocPrintJob job = attrmgr.getCurrentService().createPrintJob();
            SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            try {
                job.print(doc, attrmgr.getRequestAttrSet());
            }
            catch (PrintException e) {
                logger.error((Object)"err", (Throwable)e);
                return false;
            }
            return true;
        }

        private PrinterAttrData showSimpleSetup(PrinterAttrManager attrmgr, Window owner) throws PrinterNotFoundException {
            PrinterAttrData result = null;
            PrintRequestAttributeSet attrset = attrmgr.getRequestAttrSet();
            PrintService newService = this.getPrintService(attrmgr, owner);
            if (newService != null) {
                attrset = new HashPrintRequestAttributeSet(attrset);
                PrinterResolution r = (PrinterResolution)newService.getDefaultAttributeValue(PrinterResolution.class);
                attrset.add(r);
                result = new PrinterAttrData(newService, attrset);
            }
            return result;
        }

        private boolean printDirect(PrinterAttrData attrData) {
            DocPrintJob job = attrData.getService().createPrintJob();
            SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            try {
                job.print(doc, attrData.getAttrSet());
            }
            catch (PrintException e) {
                logger.error((Object)"err", (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex >= KDPrintService.this.getPreviewContext().getTotalPageCount() && !KDPrintService.this.getPreviewContext().isDataIncomplete()) {
                this.pi = -1;
                return 1;
            }
            if (this.pi == pageIndex) {
                ((Graphics2D)graphics).scale(1.0f / KDPrintService.this.printerAttrMgr.screenMapRatio, 1.0f / KDPrintService.this.printerAttrMgr.screenMapRatio);
                KDPrintService.this.getBaseComponent().getPreviewPane().draw((Graphics2D)graphics, pageIndex);
                ((Graphics2D)graphics).scale(KDPrintService.this.printerAttrMgr.screenMapRatio, KDPrintService.this.printerAttrMgr.screenMapRatio);
                return 0;
            }
            this.pi = pageIndex;
            return 0;
        }
    }
}

