/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs;

import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.PrintConfigDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import sun.print.SunAlternateMedia;

public class PrintServiceUI
extends ServiceUI {
    public static PrintService printDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        int defaultIndex = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals(defaultService)) continue;
                defaultIndex = i;
                break;
            }
            if (defaultIndex < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            defaultIndex = 0;
        }
        PrintConfigDialog dialog = new PrintConfigDialog((Frame)null);
        dialog.init(gc, x, y, services, defaultIndex, flavor, attributes);
        dialog.show();
        if (dialog.getStatus() == 1) {
            PrintServiceUI.approveDialog(dialog, flavor, attributes);
        }
        return dialog.getPrintService();
    }

    public static PrintService printDialog(Window owner, GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        int defaultIndex = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals(defaultService)) continue;
                defaultIndex = i;
                break;
            }
            if (defaultIndex < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            defaultIndex = 0;
        }
        PrintConfigDialog dialog = owner instanceof Frame ? new PrintConfigDialog((Frame)owner) : (owner instanceof Dialog ? new PrintConfigDialog((Dialog)owner) : new PrintConfigDialog((Frame)null));
        dialog.init(gc, x, y, services, defaultIndex, flavor, attributes);
        dialog.setLocationRelativeTo(null);
        dialog.show();
        if (dialog.getStatus() == 1) {
            PrintServiceUI.approveDialog(dialog, flavor, attributes);
        }
        return dialog.getPrintService();
    }

    static void approveDialog(PrintConfigDialog dialog, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        PrintRequestAttributeSet newas = dialog.getAttributes();
        Class<Destination> dstCategory = Destination.class;
        Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
        Class<Fidelity> fdCategory = Fidelity.class;
        if (attributes.containsKey(dstCategory) && !newas.containsKey(dstCategory)) {
            attributes.remove(dstCategory);
        }
        if (attributes.containsKey(amCategory) && !newas.containsKey(amCategory)) {
            attributes.remove(amCategory);
        }
        attributes.addAll(newas);
        Fidelity fd = (Fidelity)attributes.get(fdCategory);
        if (fd != null && fd == Fidelity.FIDELITY_TRUE) {
            PrintServiceUI.removeUnsupportedAttributes(dialog.getPrintService(), flavor, attributes);
        }
    }

    private static void removeUnsupportedAttributes(PrintService ps, DocFlavor flavor, AttributeSet aset) {
        AttributeSet asUnsupported = ps.getUnsupportedAttributes(flavor, aset);
        if (asUnsupported != null) {
            Attribute[] usAttrs = asUnsupported.toArray();
            for (int i = 0; i < usAttrs.length; ++i) {
                Class<? extends Attribute> category = usAttrs[i].getCategory();
                if (ps.isAttributeCategorySupported(category)) {
                    Attribute attr = (Attribute)ps.getDefaultAttributeValue(category);
                    if (attr != null) {
                        aset.add(attr);
                        continue;
                    }
                    aset.remove(category);
                    continue;
                }
                aset.remove(category);
            }
        }
    }
}

