/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.gui;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IHeaderFooterPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class DefaultPreviewPane
extends AbstractPreviewPane {
    private static final long serialVersionUID = -8226426894308805185L;
    Rectangle bodyArea = new Rectangle();
    Rectangle headerArea = new Rectangle();
    Rectangle footerArea = new Rectangle();
    BufferedImage image = null;

    public DefaultPreviewPane(PrinterAttrManager printerattr, IPainter paintProxy, IHeaderFooterPainter hfPainter, ContextOfPreview context) {
        super(printerattr, paintProxy, context);
        this.hfPainter = hfPainter;
        this.setDoubleBuffered(true);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.GRAY);
        ((Graphics2D)g).fill(this.getBounds());
        double scale = this.context.getZoomFactor();
        if (this.context.getCurrentPage() < 0) {
            g.setColor(Color.GRAY);
            ((Graphics2D)g).fill(new Rectangle2D.Double(0.0, 0.0, (int)((double)this.printerattr.getPaperWidth() * scale * (double)this.context.getPageColsInView()), (int)((double)this.printerattr.getPaperHeight() * scale * (double)this.context.getPageRowsInView())));
            return;
        }
        if (this.buffer == null) {
            int totalWidth = (int)((double)this.printerattr.getPaperWidth() * scale * (double)this.context.getPageColsInView() + (double)(this.context.span * this.context.getPageColsInView()));
            int totalHeight = (int)((double)this.printerattr.getPaperHeight() * scale * (double)this.context.getPageRowsInView() + (double)(this.context.span * this.context.getPageRowsInView()));
            this.buffer = this.getCompatibleImage((Graphics2D)g, totalWidth, totalHeight);
            Graphics2D g2 = this.buffer.createGraphics();
            super.paint(g2);
            g2.setColor(Color.GRAY);
            g2.fill(new Rectangle2D.Double(0.0, 0.0, totalWidth, totalHeight));
            int pageIdx = this.context.getCurrentPage();
            int cPagesInView = this.context.getPageRowsInView() * this.context.getPageColsInView();
            if (this.context.getPaneFitStyle() == 3 && cPagesInView > 1) {
                int startPage;
                int cPages = this.context.getTotalPageCount();
                if (cPages == -1 && this.context.getCurrentPage() >= 0) {
                    cPages = Integer.MAX_VALUE;
                }
                for (int i = startPage = pageIdx / cPagesInView * cPagesInView; i < startPage + cPagesInView && i < cPages; ++i) {
                    Point pagePos = this.context.getBeginOfPage(i);
                    g2.translate(pagePos.x, pagePos.y);
                    this.context.setGraphics(g2);
                    if (i == pageIdx) {
                        g2.setColor(Color.BLACK);
                        g2.fillRect(6, 8, (int)(this.printerattr.getPaperWidth() / this.printerattr.screenMapRatio), (int)(this.printerattr.getPaperHeight() / this.printerattr.screenMapRatio));
                    }
                    g2.scale(1.0f / this.printerattr.screenMapRatio, 1.0f / this.printerattr.screenMapRatio);
                    this.draw(g2, i);
                    g2.scale(this.printerattr.screenMapRatio, this.printerattr.screenMapRatio);
                    this.context.resetGraphics(g2);
                    g2.translate(-pagePos.x, -pagePos.y);
                }
            } else {
                this.context.setGraphics(g2);
                g2.scale(1.0f / this.printerattr.screenMapRatio, 1.0f / this.printerattr.screenMapRatio);
                this.draw(g2, pageIdx);
                g2.scale(this.printerattr.screenMapRatio, this.printerattr.screenMapRatio);
                this.context.resetGraphics(g2);
            }
        }
        try {
            ((Graphics2D)g).drawImage(this.buffer, new AffineTransformOp(((Graphics2D)g).getDeviceConfiguration().getDefaultTransform(), ((Graphics2D)g).getRenderingHints()), this.context.getBeginOfPages().x, this.context.getBeginOfPages().y);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.context.isAdjustingMargin()) {
            this.drawMarginLines((Graphics2D)g);
        }
        if (this.context.getCurrentPage() == 0 && !this.context.isDataIncomplete()) {
            this.context.updateStatus();
        }
    }

    @Override
    public int draw(Graphics2D g2, int pageIdx) {
        KDFont.setTableMode((!ArrayUtil.isEqual((Float)Float.valueOf(this.printerattr.screenMapRatio), (Float)Float.valueOf(1.0f)) ? 1 : 0) != 0);
        PrinterAttrManager.textCoding = this.printerattr.getTextCoding();
        Color saveColor = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, this.printerattr.getPaperWidth(), this.printerattr.getPaperHeight()));
        g2.setColor(saveColor);
        this.headerArea.setBounds((int)this.printerattr.getBodyX(), (int)this.printerattr.getHeaderMargin(), (int)this.printerattr.getBodyW(), (int)this.printerattr.getPrintableH() - (int)this.printerattr.getHeaderMargin());
        int footerH = this.printerattr.getFooterPreferHeight();
        int footerY = (int)((double)this.printerattr.getPaperHeight() - (double)this.printerattr.getFooterMargin() - (double)footerH);
        this.footerArea.setBounds((int)this.printerattr.getBodyX(), footerY, (int)this.printerattr.getBodyW(), footerH);
        this.bodyArea.setBounds((int)this.printerattr.getBodyX(), (int)this.printerattr.getBodyY(), (int)this.printerattr.getBodyW(), (int)this.printerattr.getBodyH());
        Shape savedClip = g2.getClip();
        Rectangle clip = new Rectangle(this.headerArea.x - 1, this.headerArea.y - 1, this.headerArea.width + 4, this.headerArea.height + 2);
        g2.setClip(clip);
        this.hfPainter.paintHeader(g2, pageIdx, this.context.getTotalPageCount());
        g2.setClip(this.footerArea);
        this.hfPainter.paintFooter(g2, pageIdx, this.context.getTotalPageCount());
        g2.setClip(this.bodyArea);
        float scaleFactor = this.printerattr.getScaleFactor();
        g2.scale(scaleFactor, scaleFactor);
        this.painter.paintBody(g2, pageIdx);
        scaleFactor = 1.0f / scaleFactor;
        g2.scale(scaleFactor, scaleFactor);
        g2.setClip(savedClip);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(0.0f));
        g2.draw(new Rectangle2D.Double(0.0, 0.0, this.printerattr.getPaperWidth(), this.printerattr.getPaperHeight()));
        g2.setColor(saveColor);
        KDFont.setTableMode((boolean)false);
        return 0;
    }

    BufferedImage getCompatibleImage(Graphics2D g, int width, int height) {
        if (this.image == null || width > this.image.getWidth() || height > this.image.getHeight()) {
            this.image = g.getDeviceConfiguration().createCompatibleImage(width, height);
        }
        return this.image;
    }
}

