/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.gui;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.HeadlessException;
import javax.print.DocFlavor;
import javax.print.attribute.standard.MediaPrintableArea;
import org.apache.log4j.Logger;

class PrintPaperMeasureWithZoom {
    private static final Logger logger = LogUtil.getPackageLogger(PrintPaperMeasureWithZoom.class);
    boolean recalacing = false;
    AbstractPreviewPane pane;
    PrinterAttrManager attrmgr;
    ContextOfPreview context;
    float extremeLeft = 5.0f;
    float extremeRight = 5.0f;
    float extremeTop = 5.0f;
    float extremeBottom = 5.0f;

    public float getScreenMapRatio() {
        return this.attrmgr.screenMapRatio;
    }

    public boolean isPortrait() {
        return this.attrmgr.isPortrait();
    }

    public float getExtremeBottom() {
        return (float)((double)this.extremeBottom * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getExtremeLeft() {
        return (float)((double)this.extremeLeft * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getExtremeRight() {
        return (float)((double)this.extremeRight * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getExtremeTop() {
        return (float)((double)this.extremeTop * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public void recalc() {
        if (this.recalacing) {
            return;
        }
        this.recalacing = true;
        try {
            if (this.attrmgr.getCurrentService() == null) {
                return;
            }
            MediaPrintableArea[] mpa = (MediaPrintableArea[])this.attrmgr.getCurrentService().getSupportedAttributeValues(MediaPrintableArea.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.attrmgr.getRequestAttrSet());
            if (mpa != null && mpa.length == 1) {
                float dpi = 72.0f;
                float dta = 0.08f * dpi;
                if (this.isPortrait()) {
                    this.extremeLeft = mpa[0].getX(25400) * dpi + dta;
                    this.extremeTop = mpa[0].getY(25400) * dpi + dta;
                    this.extremeRight = this.attrmgr.getPaperWidth() - this.extremeLeft - mpa[0].getWidth(25400) * dpi + dta;
                    this.extremeBottom = this.attrmgr.getPaperHeight() - this.extremeTop - mpa[0].getHeight(25400) * dpi + dta;
                } else {
                    this.extremeLeft = mpa[0].getY(25400) * dpi + dta;
                    this.extremeTop = mpa[0].getY(25400) * dpi + dta;
                    this.extremeRight = this.attrmgr.getPaperWidth() - this.extremeLeft - mpa[0].getHeight(25400) * dpi + dta;
                    this.extremeBottom = this.attrmgr.getPaperHeight() - this.extremeBottom - mpa[0].getWidth(25400) * dpi + dta;
                }
            }
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)"err", (Throwable)e);
            if (!PrinterAttrManager.NotifyUserThatPrinterNotExist) {
                this.recalacing = false;
                return;
            }
            Object[] selections = new String[]{Resources.LOCAL_STR("OptContinueAndNotShowNextTime"), Resources.LOCAL_STR("OptContinueAndShowNextTime")};
            Object sel = null;
            try {
                sel = KDOptionPane.showInputDialog((Component)this.pane, (Object)(Resources.LOCAL_STR("PrinterNotFound") + Resources.LOCAL_STR("PleaseSelect")), (String)Resources.LOCAL_STR("PrinterNotFound"), (int)1, null, (Object[])selections, (Object)selections[0]);
            }
            catch (HeadlessException e1) {
                logger.error((Object)"err", (Throwable)e1);
            }
            if (selections[0] == sel) {
                PrinterAttrManager.NotifyUserThatPrinterNotExist = false;
            }
            if (selections[1] == sel) {
                // empty if block
            }
        }
        this.recalacing = false;
    }

    public PrintPaperMeasureWithZoom(PrinterAttrManager attrmgr, ContextOfPreview ctx, AbstractPreviewPane pane) {
        this.pane = pane;
        this.attrmgr = attrmgr;
        this.context = ctx;
    }

    public float getBottom() {
        return (float)((double)this.attrmgr.getBottom() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getLeft() {
        return (float)((double)this.attrmgr.getLeft() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getPaperHeight() {
        return (float)((double)this.attrmgr.getPaperHeight() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getPaperWidth() {
        return (float)((double)this.attrmgr.getPaperWidth() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getRight() {
        return (float)((double)this.attrmgr.getRight() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getTop() {
        return (float)((double)this.attrmgr.getTop() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getFooterMargin() {
        return (float)((double)this.attrmgr.getFooterMargin() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public float getHeaderMargin() {
        return (float)((double)this.attrmgr.getHeaderMargin() * this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio);
    }

    public void setFooterMargin(int fh) {
        this.attrmgr.setFooterMargin((int)((double)fh / this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio));
    }

    public void setHeaderMargin(int hh) {
        this.attrmgr.setHeaderMargin((int)((double)hh / this.context.getZoomFactor() / (double)this.attrmgr.screenMapRatio));
    }

    public void setMediaPrintableArea(MediaPrintableArea areaNew) {
        MediaPrintableArea mpa = new MediaPrintableArea((float)((double)areaNew.getX(1000) / this.context.getZoomFactor()), (float)((double)areaNew.getY(1000) / this.context.getZoomFactor()), (float)((double)areaNew.getWidth(1000) / this.context.getZoomFactor()), (float)((double)areaNew.getHeight(1000) / this.context.getZoomFactor()), 1000);
        this.attrmgr.setMediaPrintableArea(mpa);
    }
}

