/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.proxy;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.cosmic.ctrl.kdf.data.impl.JDBCDataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.FormPrintHelper;
import com.kingdee.cosmic.ctrl.kdf.proxy.JavaDataInput;
import com.kingdee.cosmic.ctrl.kdf.proxy.JavaDataOutput;
import com.kingdee.cosmic.ctrl.kdf.proxy.SocketDataVisitor;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SocketProxy
extends Thread {
    private static Logger log = LogUtil.getPackageLogger(SocketProxy.class);
    static final short CALL_RETURN = 0;
    static final short CALL_EXCEPTION = -1;
    static final short FIRE_requestData = 10;
    static final short FIRE_executeQuery = 11;
    static final short FIRE_nextRecord = 12;
    static final short CALL_loadKDF = 21;
    static final short CALL_getPageNO = 22;
    static final short CALL_getPageCount = 23;
    static final short CALL_getPageHTML = 24;
    private Socket n_sktClient;
    private JavaDataInput n_jdIn;
    private JavaDataOutput n_jdOut;
    private Form n_form;
    private int n_iPageNO = -1;
    private boolean n_isPlugin = false;

    public SocketProxy(Socket sktClient) throws IOException {
        this.n_sktClient = sktClient;
        this.n_jdIn = new JavaDataInput(this.n_sktClient.getInputStream());
        this.n_jdOut = new JavaDataOutput(this.n_sktClient.getOutputStream());
    }

    @Override
    public void run() {
        try {
            this.n_jdOut.writeShort(0);
            this.syncRemoteCall();
        }
        catch (Exception e) {
            log.error((Object)"err", (Throwable)e);
        }
    }

    public void call_getPageNO() throws IOException {
        this.n_jdOut.writeShort(0);
        this.n_jdOut.writeInt(this.n_iPageNO);
    }

    public void call_getPageHTML() throws IOException {
        int iPageNO = this.n_jdIn.readInt();
        StringBuilder sPageHTML = new StringBuilder("<DIV>Page").append(iPageNO).append("</DIV>");
        this.n_jdOut.writeShort(0);
        this.n_jdOut.writeString(sPageHTML.toString());
    }

    public void call_getPageCount() throws IOException {
        this.n_jdOut.writeShort(0);
        this.n_jdOut.writeInt(this.n_form == null ? -1 : this.n_form.getOutputPages().size());
    }

    public void call_loadKDF() throws IOException {
        String sKDF = this.n_jdIn.readString();
        try {
            KDF kdf = new KDF(new ByteArrayInputStream(sKDF.getBytes("UNICODE")));
            this.hookKDF(kdf);
            FormPrintHelper formPrintHelper = new FormPrintHelper();
            formPrintHelper.print(kdf, true, null, null);
            this.n_form = (Form)kdf.getForms().iterator().next();
        }
        catch (Exception ex) {
            log.error((Object)"errmsg", (Throwable)ex);
            this.n_jdOut.writeShort(-1);
        }
        if (!this.n_isPlugin) {
            this.n_jdOut.writeShort(0);
        }
    }

    private void syncRemoteCall() throws IOException, InterruptedException {
        block8: while (true) {
            switch (this.n_jdIn.readShort()) {
                case 0: {
                    return;
                }
                case 22: {
                    this.call_getPageNO();
                    continue block8;
                }
                case 23: {
                    this.call_getPageCount();
                    continue block8;
                }
                case 24: {
                    this.call_getPageHTML();
                    continue block8;
                }
                case 21: {
                    this.call_loadKDF();
                    return;
                }
                case -1: {
                    continue block8;
                }
            }
            SocketProxy.sleep(20L);
        }
    }

    public void hookKDF(KDF kdf) throws IOException {
        DataSetWrapper[] dsws = kdf.getDataSets();
        for (int i = 0; i < dsws.length; ++i) {
            if (!(dsws[i].getDataSetVisitor() instanceof JDBCDataSetVisitor)) continue;
            dsws[i].changeDataSource(new SocketDataVisitor(i, this));
        }
        this.n_jdOut.writeByte(255);
    }

    boolean fire_executeQuery(SocketDataVisitor adv, String sName, String sQuery) {
        try {
            this.n_jdOut.writeShort(11);
            this.n_jdOut.writeInt(adv.m_idxID);
            this.n_jdOut.writeString(sName);
            this.n_jdOut.writeString(sQuery);
            this.syncRemoteCall();
            adv.m_iRecordCount = this.n_jdIn.readInt();
            adv.m_iFieldCount = this.n_jdIn.readInt();
            adv.m_asFieldName = new String[adv.m_iFieldCount];
            for (int i = 0; i < adv.m_iFieldCount; ++i) {
                adv.m_asFieldName[i] = this.n_jdIn.readString();
            }
            return adv.m_iRecordCount > 0;
        }
        catch (IOException e) {
            log.error((Object)"err", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.error((Object)"err", (Throwable)e);
            return false;
        }
    }

    boolean fire_nextRecord(SocketDataVisitor adv, ArrayList vctOut) {
        try {
            this.n_jdOut.writeShort(12);
            this.n_jdOut.writeInt(adv.m_idxID);
            this.syncRemoteCall();
            boolean hasNext = this.n_jdIn.readBoolean();
            int iFieldCount = this.n_jdIn.readInt();
            for (int i = 0; i < iFieldCount; ++i) {
                vctOut.set(i, this.n_jdIn.readVariant());
            }
            return hasNext;
        }
        catch (IOException e) {
            log.error((Object)"err", (Throwable)e);
            return true;
        }
        catch (InterruptedException e) {
            log.error((Object)"err", (Throwable)e);
            return true;
        }
    }
}

