/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.server;

import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.server.PageEvent;
import com.kingdee.cosmic.ctrl.kdf.server.PageEventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public final class FormContext {
    private static Map map = new HashMap();
    private EventListenerList listenerList = new EventListenerList();
    private int id;

    public static synchronized FormContext getInstance(int id) {
        Object instance = map.get(id);
        if (instance instanceof FormContext) {
            return (FormContext)instance;
        }
        return new FormContext(id);
    }

    public static synchronized void close(int id) {
        map.remove(id);
    }

    private FormContext(int id) {
        this.id = id;
        map.put(id, this);
    }

    public int getID() {
        return this.id;
    }

    public void addPageEventListener(PageEventListener pageEventListener) {
        this.listenerList.add(PageEventListener.class, pageEventListener);
    }

    public void obtainNewPage(int index, Page page) {
        PageEvent e = new PageEvent(this, index, page);
        this.firePageEvent(e);
    }

    private synchronized void firePageEvent(PageEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PageEventListener.class) continue;
            ((PageEventListener)listeners[i + 1]).doObtainPage(e);
        }
    }

    public synchronized void endFormOutput() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PageEventListener.class) continue;
            ((PageEventListener)listeners[i + 1]).endOutput();
        }
        map.remove(this.id);
    }
}

