/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.server;

import com.kingdee.cosmic.ctrl.kdf.server.FormContext;
import com.kingdee.cosmic.ctrl.kdf.server.FormPageInfo;
import com.kingdee.cosmic.ctrl.kdf.server.IForm;
import com.kingdee.cosmic.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.cosmic.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.cosmic.ctrl.kdf.server.LocalFormVisitor;
import com.kingdee.cosmic.ctrl.kdf.server.PageEventListener;
import com.kingdee.cosmic.ctrl.kdf.server.RemoteFormVisitor;
import java.io.InputStream;
import java.util.HashMap;

public class FormProxy {
    private int id;
    private FormContext context;
    private IForm form;
    private IVariantDataListener vdataListener;
    private Object userFuncObj;
    private HashMap params;

    public static synchronized FormProxy getLocalInstance() {
        FormProxy instance = new FormProxy();
        instance.setLocalMode();
        instance.id = instance.form.getKDFID();
        instance.context = FormContext.getInstance(instance.id);
        return instance;
    }

    public static synchronized FormProxy getRemoteInstance(String url) {
        FormProxy instance = new FormProxy();
        instance.setRemoteMode(url);
        instance.id = instance.form.getKDFID();
        instance.context = FormContext.getInstance(instance.id);
        return instance;
    }

    public static synchronized FormProxy getUserInstance(IForm form) {
        FormProxy instance = new FormProxy();
        instance.setUserMode(form);
        instance.id = instance.form.getKDFID();
        instance.context = FormContext.getInstance(instance.id);
        return instance;
    }

    private FormProxy() {
    }

    private void setLocalMode() {
        this.form = new LocalFormVisitor();
    }

    private void setRemoteMode(String url) {
        this.form = new RemoteFormVisitor(url);
    }

    private void setUserMode(IForm form) {
        this.form = form;
    }

    public int getID() {
        return this.id;
    }

    public void addPageEventListener(PageEventListener listener) {
        this.context.addPageEventListener(listener);
    }

    public void cancelJob(Thread worker) {
        this.form.cancelJob(worker);
    }

    public void setVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    public void setUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }

    public void setReportParams(HashMap params) {
        this.params = params;
    }

    public void makeForm(FormPageInfo info, InputStream kdfStream, IServerPluginParam[] plugins) {
        this.form.setPageInfo(info);
        this.form.setKDF(kdfStream);
        this.form.setVariantDataListener(this.vdataListener);
        this.form.setUserFunctionProvider(this.userFuncObj);
        this.form.setPlugins(plugins);
        this.form.setReportParams(this.params);
        this.form.makeForm();
    }

    public void makeForm(FormPageInfo info, byte[] kdf, IServerPluginParam[] plugins) {
        this.form.setPageInfo(info);
        this.form.setKDF(kdf);
        this.form.setVariantDataListener(this.vdataListener);
        this.form.setUserFunctionProvider(this.userFuncObj);
        this.form.setPlugins(plugins);
        this.form.setReportParams(this.params);
        this.form.makeForm();
    }
}

