/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDSourceQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryDir;
import com.kingdee.cosmic.ctrl.kdf.data.query.SqlType;
import com.kingdee.cosmic.ctrl.kdf.form.Area;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.Panel;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.util.AbstractK3File2KDFObj;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.kdf.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kdf.util.IKDRFile2KDFObj;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;

public class KDRFile2KDFObj
extends AbstractK3File2KDFObj
implements IKDRFile2KDFObj {
    static final String TAG_NODE = "NODE";
    private static final String TAG_NAME = "NAME";
    private static final String TAG_TEXT = "TEXT";
    private static final String TAG_TEXTDATA = "TEXTDATA";
    private static final String TAG_VALUE = "VALUE";
    private static final String TAG_FORMAT = "FORMAT";
    private static final String TAG_NOTE = "NOTE";
    private static final String TAG_FLAG = "FLAG";
    private static final String TAG_TYPE = "TYPE";
    private static final String TAG_RECT = "RECT";
    private static final String TAG_ALIGN = "ALIGN";
    private static final String TAG_FORECOLOR = "FORECOLOR";
    private static final String TAG_BACKCOLOR = "BACKCOLOR";
    private static final String TAG_FONT = "FONT";
    private static final String TAG_PEN = "PEN";
    private static final String TAG_IMAGE = "IMAGE";
    static final String TAG_BORDER = "BORDER";
    static final String TAG_COLOR = "COLOR";
    private static final String TAG_NO = "NO";
    private static final String TAG_DATATYPE = "DATA_TYPE";
    private static final String TAG_REPORT = "REPORT";
    private static final String TAG_ZONE = "ZONE";
    private static final String TAG_CELL = "CELL";
    private static final String TAG_CONTROL = "KDREPORT";
    private static final String TAG_FILE = "FILE";
    static final String TAG_FILE_TYPE = "TYPE";
    private static final String TAG_FILE_VERSION = "VERSION";
    static final String TAG_FILE_DATE = "DATE";
    static final String TAG_FILE_TIME = "TIME";
    static final String TAG_FILE_NAME = "NAME";
    private static final String TAG_PUBLIC = "PUBLIC";
    private static final String TAG_SQLDATA = "SQLDATA";
    static final String TAG_DESIGNER = "DESIGNER";
    static final String TAG_CREATOR = "CREATOR";
    static final String TAG_BROWSER = "BROWSER";
    private static final String TAG_PRINTER = "PRINTER";
    private static final String TAG_GDI_ID = "ID";
    private static final String TAG_GDI_PEN = "GDI_PEN";
    private static final String TAG_GDI_FONT = "GDI_FONT";
    private static final String TAG_GDI_IMAGE = "GDI_IMAGE";
    private static final String TAG_DSC_BASE = "DATABASE";
    private static final String TAG_DSC_GROUP = "GROUP";
    private static final String TAG_DSC_TABLE = "TABLE";
    private static final String TAG_DSC_TABLE_NAME = "TABLE_NAME";
    private static final String TAG_DSC_FIELD = "FIELD";
    private static final String TAG_DSC_FIELD_NAME = "FIELD_NAME";
    private static final String TAG_SQL_TABLE = "SQL_TABLE";
    private static final String TAG_SQL_FIELD = "SQL_FIELD";
    private static final String TAG_SQL_TJOIN = "SQL_JOIN";
    private static final String TAG_SQL_WHERE = "SQL_WHERE";
    private static final String TAG_SQL_ORDER = "SQL_ORDER";
    private static final String TAG_SQL_ORDBY = "BY";
    private static final String TAG_SQL_QUERY = "SQL_QUERY";
    private static final String TAG_SQL_PARAM = "SQL_PARAM";
    private static final String TAG_PENLEFT = "PENLEFT";
    private static final String TAG_PENTOP = "PENTOP";
    private static final String TAG_PENRIGHT = "PENRIGHT";
    private static final String TAG_PENBOTTOM = "PENBOTTOM";
    private static final String ALIGN_LEFTTOP = "2080";
    private static final String ALIGN_LEFTMID = "2084";
    private static final String ALIGN_LEFTDWN = "2088";
    private static final String ALIGN_MIDDLETOP = "2081";
    private static final String ALIGN_MIDDLEMID = "2085";
    private static final String ALIGN_MIDDLEDWN = "2089";
    private static final String ALIGN_RIGHTTOP = "2082";
    private static final String ALIGN_RIGHTMID = "2086";
    private static final String ALIGN_RIGHTDWN = "2090";
    private boolean DEBUG = false;
    private String _KDRFile;
    private KDF _kdf;
    private Form _form;
    private Page _page;
    private Page _headpage;
    private Page _footpage;
    private JDBCDataSource datasource = new JDBCDataSource("KDReportDataSource", "");
    private String grpField = null;
    private String _strErr;
    private InputStream source;
    private IXmlElement doc;
    private static long index = 0L;
    private int iLoopIndex;
    private HashMap hsStyle;
    private final String[] aStrFormat = new String[]{"0.00", "#,##0.00;-#,##0.00", "#,##0.00;(#,##0.00)", "#,##0.00;-(#,##0.00)", "#,##0.00;-#,##0.00;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"), "#,##0.00;-#,##0.00;\\\"\\\"", "\uffe50.00", "\uffe5#,##0.00;-\uffe50.00", "\uffe5#,##0.00;\uffe5(#,##0.00)", "\uffe5#,##0.00;\uffe5-(#,##0.00)", "\uffe5#,##0.00;\uffe5-#,##0.00;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"), "\uffe5#,##0.00;\uffe5-#,##0.00;\\\"\\\"", "0.00%", "#,##0.00%;-0.00%", "%#,##0.00;%(#,##0.00)", "%#,##0.00;%-(#,##0.00)", "#,##0.00%;-#,##0.00%;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"), "#,##0.00%;-#,##0.00%;\\\"\\\"", "0.00e+#", "0.000;-0.000E+#", "0.00E+00;(0.00E+00)", "0.00E+00;-(0.00E+00)", "0.00E+000;-0.00E+000;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"), "0.00E+000;-0.00E+000;\\\"\\\""};
    private Vector vecFormat = null;
    private static final String[] aStrKeyWord = new String[]{"IF", "THEN", "ELSE", "ELSEIF", "ENDIF", "AND", "OR", "MOD"};
    private static final String[] aStrVBFunc = new String[]{"ABS", "SQRT", "ROUND", "INT", "CELL", "FIELD", "MOD", "RGB", "DATE", "SIN", "ARCSIN", "COS", "ARCCOS", "TAN", "ARCTAN", "CTAN", "ARCCTAN", "LN", "LOG", "EXP", "PI", "LEN", "STR", "TRIM", "VAL", "SUBSTR", "LEFT", "RIGHT", "SPACE", "REPT", "FORMAT", "BEEP"};
    private HashMap hsKeyWord = null;
    private HashMap hsFuncVB = null;
    String m_strFormat;
    long m_lpszFormula = 0L;
    long m_lLength_CurWord = 0L;
    long m_lToken_CurWord = -1L;
    long m_lLength = 0L;
    String m_csWord;
    String m_csStr;
    String m_csVar;
    private HashMap noMetaField = new HashMap();
    private HashMap mapSubQrysName2ID = new HashMap();
    private HashMap mapSubQrysName2Obj = new HashMap();
    private DesignedDS designedDS = new DesignedDS();
    private Object[] metaTables;

    @Override
    public boolean translate(InputStream input) {
        this.source = input;
        return this.translate();
    }

    public boolean translate() {
        boolean ok = true;
        try {
            IXmlElement root = this.getElement();
            if (!root.getName().equals(TAG_CONTROL)) {
                throw new Exception(CtrlKDFMessages.getMLS("fileFormatError", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef"));
            }
            for (IXmlElement node : root.getChildren()) {
                String nodeName = node.getName();
                if (TAG_FILE.endsWith(nodeName)) {
                    this.translateFile(node);
                    continue;
                }
                if (TAG_PUBLIC.endsWith(nodeName)) {
                    this.translatePublic(node);
                    continue;
                }
                if (TAG_DSC_BASE.endsWith(nodeName)) {
                    this.translateDatabase(node);
                    continue;
                }
                if (TAG_SQLDATA.endsWith(nodeName)) {
                    this.translateSQLData(node);
                    continue;
                }
                if (TAG_REPORT.endsWith(nodeName)) {
                    this.translateReport(node);
                    continue;
                }
                if (TAG_PRINTER.endsWith(nodeName)) continue;
                this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 0);
            }
            if (this.DEBUG) {
                this._kdf.saveToFile(this.get_KDRFile() + ".kdf");
            }
        }
        catch (Exception ex) {
            ok = false;
            this._strErr = "Error: " + this.getKdf() + "\n" + ex + "\n";
        }
        return ok;
    }

    private void translateReport(IXmlElement reportRoot) {
        this.cout("", "===============in translateReport(begin)", 0);
        for (IXmlElement node : reportRoot.getChildren()) {
            String nodeName = node.getName();
            if (TAG_RECT.endsWith(nodeName)) {
                this.translateRect(node, 1);
                continue;
            }
            if (TAG_ZONE.endsWith(nodeName)) continue;
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 1);
        }
        List lstZone = reportRoot.searchChildren(TAG_ZONE);
        this.translateZones(lstZone, 1);
        this.cout("", "===============in translateReport(end)", 0);
    }

    private void translateZones(List lstZone, int inset) {
        Page pageQY = new Page();
        pageQY.setId("page" + index++);
        pageQY.setUserAlias(pageQY.getId());
        pageQY.setRepeat(1);
        Panel panelQY = new Panel();
        panelQY.setId("panel" + index++);
        panelQY.setUserAlias(panelQY.getId());
        IXmlElement nodeQY = (IXmlElement)lstZone.get(0);
        GDI_RECT rect = this.translateZone(nodeQY, inset, panelQY, pageQY.getId(), "0", false, true);
        if (nodeQY.searchChildren(TAG_CELL).size() != 0) {
            this.makeDesignedNode(panelQY, pageQY.getId(), rect.left, rect.right, rect.top, rect.bottom, true);
            pageQY.addChild(panelQY);
            this.getForm().getPages().add(pageQY);
        }
        int heightQY = Integer.parseInt(rect.bottom);
        Panel panelYM = new Panel();
        panelYM.setId("panel" + index++);
        panelYM.setUserAlias(panelYM.getId());
        GDI_RECT rectYM = this.translateZone((IXmlElement)lstZone.get(1), inset, panelYM, this.getHeadpage().getId(), "0", false, true);
        this.makeDesignedNode(panelYM, this.getHeadpage().getId(), rectYM.left, rectYM.right, rectYM.top, rectYM.bottom, true);
        this.getHeadpage().addChild(panelYM);
        int headerHeight = Integer.parseInt(rectYM.bottom);
        this.getKdf().getPrintInfo().setHeaderPreferHeight(headerHeight);
        this.makeDesignedPageNode(this.getHeadpage(), true, 0L, headerHeight);
        Panel panelYJ = new Panel();
        panelYJ.setId("panel" + index++);
        panelYJ.setUserAlias(panelYJ.getId());
        rect = this.translateZone((IXmlElement)lstZone.get(lstZone.size() - 1), inset, panelYJ, this.getFootpage().getId(), "0", false, true);
        this.makeDesignedNode(panelYJ, this.getFootpage().getId(), rect.left, rect.right, rect.top, rect.bottom, true);
        this.getFootpage().addChild(panelYJ);
        int footerHeight = Integer.parseInt(rect.bottom) - Integer.parseInt(rect.top);
        this.getKdf().getPrintInfo().setFooterPreferHeight(footerHeight);
        this.makeDesignedPageNode(this.getFootpage(), true, 0L, footerHeight);
        Panel panelBT = new Panel();
        panelBT.setId("panel" + index++);
        panelBT.setUserAlias(panelBT.getId());
        rect = this.translateZone((IXmlElement)lstZone.get(2), inset, panelBT, this.getPage().getId(), "0", false, true);
        this.makeDesignedNode(panelBT, this.getPage().getId(), rect.left, rect.right, rect.top, rect.bottom, true);
        this.getPage().addChild(panelBT);
        int heightPage = Integer.parseInt(rect.bottom);
        int iLoopCenter = (lstZone.size() - 2 - 3) / 2 + 3;
        this.iLoopIndex = 3;
        Area area = new Area();
        area.setId("area" + index++);
        area.setUserAlias(area.getId());
        rect = this.translateLoopZone(lstZone, inset, area, iLoopCenter, panelBT.getId(), "0", true, false);
        this.makeDesignedNode(area, panelBT.getId(), rect.left, rect.right, rect.top, rect.bottom, false);
        this.makeBottomSelfAdapt(area);
        this.getPage().addChild(area);
        heightPage += Integer.parseInt(rect.bottom);
        this.getForm().getPages().add(this.getPage());
        Page pageBZ = new Page();
        pageBZ.setId("page" + index++);
        pageBZ.setUserAlias(pageBZ.getId());
        pageBZ.setRepeat(1);
        Panel panelBZ = new Panel();
        panelBZ.setId("panel" + index++);
        panelBZ.setUserAlias(panelBZ.getId());
        IXmlElement nodeBZ = (IXmlElement)lstZone.get(lstZone.size() - 2);
        rect = this.translateZone(nodeBZ, inset, panelBZ, pageBZ.getId(), "0", false, true);
        if (nodeBZ.searchChildren(TAG_CELL).size() != 0) {
            this.makeDesignedNode(panelBZ, pageBZ.getId(), rect.left, rect.right, rect.top, rect.bottom, true);
            pageBZ.addChild(panelBZ);
            this.getForm().getPages().add(pageBZ);
        }
        int heightBZ = Integer.parseInt(rect.bottom);
        int w = Integer.parseInt(rect.right);
        int heightMax = Math.max(Math.max(heightQY, heightPage), heightBZ);
        this.makeDesignedPageNode(pageQY, false, w, heightMax);
        this.makeDesignedPageNode(this.getPage(), false, w, heightMax);
        this.makeDesignedPageNode(pageBZ, false, w, heightMax);
        this.getKdf().getPrintInfo().setCustomizePaperWidth(w += this.getKdf().getPrintInfo().getLeftMargin() + this.getKdf().getPrintInfo().getRightMargin());
    }

    private GDI_RECT translateLoopZone(List lstZone, int inset, Container container_Parent, int iLoopCenter, String sRelativeID, String sTop, boolean bFromBottom, boolean bHasBottom) {
        Panel panel_Parent = new Panel();
        panel_Parent.setId("panel" + index++);
        panel_Parent.setUserAlias(panel_Parent.getId());
        if (this.grpField != null && this.grpField.trim().length() > 0) {
            panel_Parent.group().setField(this.grpField);
            this.grpField = null;
        }
        panel_Parent.group().setDataSource(this.datasource.getID());
        container_Parent.addChild(panel_Parent);
        Panel panel_Son1 = new Panel();
        panel_Son1.setId("panel" + index++);
        panel_Son1.setUserAlias(panel_Son1.getId());
        GDI_RECT rect = this.translateZone((IXmlElement)lstZone.get(this.iLoopIndex++), inset, panel_Son1, panel_Parent.getId(), "0", false, true);
        this.makeDesignedNode(panel_Son1, panel_Parent.getId(), rect.left, rect.right, rect.top, rect.bottom, true);
        panel_Parent.addChild(panel_Son1);
        if (this.iLoopIndex <= iLoopCenter) {
            Area area_Son = new Area();
            if (this.iLoopIndex == 4) {
                area_Son.setNext(area_Son);
            }
            area_Son.setId("area" + index++);
            area_Son.setUserAlias(area_Son.getId());
            panel_Parent.addChild(area_Son);
            GDI_RECT rectArea = this.translateLoopZone(lstZone, inset, area_Son, iLoopCenter, panel_Son1.getId(), "0", true, false);
            this.makeDesignedNode(area_Son, panel_Son1.getId(), rectArea.left, rectArea.right, rectArea.top, rectArea.bottom, false);
            this.makeBottomSelfAdapt(area_Son);
            rect.addHeight(rectArea);
            Panel panel_Son2 = new Panel();
            panel_Son2.setId("panel" + index++);
            panel_Son2.setUserAlias(panel_Parent.getId());
            GDI_RECT rectPanel = this.translateZone((IXmlElement)lstZone.get(this.iLoopIndex++), inset, panel_Son2, area_Son.getId(), "0", true, true);
            this.makeDesignedNode(panel_Son2, area_Son.getId(), rectPanel.left, rectPanel.right, rectPanel.top, rectPanel.bottom, false);
            panel_Parent.addChild(panel_Son2);
            rect.addHeight(rectPanel);
        }
        container_Parent.getLeft().setOriginString(this.getRelativePos(sRelativeID, "left", "0"));
        container_Parent.getRight().setOriginString(this.getRelativePos(container_Parent.getId(), "left", String.valueOf(Integer.parseInt(rect.right))));
        panel_Parent.getLeft().setOriginString(this.getRelativePos(container_Parent.getId(), "left", "0"));
        panel_Parent.getRight().setOriginString(this.getRelativePos(panel_Parent.getId(), "left", String.valueOf(Integer.parseInt(rect.right))));
        if (bFromBottom) {
            container_Parent.getTop().setOriginString(this.getRelativePos(sRelativeID, "bottom", "0"));
        } else {
            container_Parent.getTop().setOriginString(this.getRelativePos(sRelativeID, "top", sTop));
        }
        panel_Parent.getTop().setOriginString(this.getRelativePos(container_Parent.getId(), "top", "0"));
        if (bHasBottom) {
            panel_Parent.getBottom().setOriginString(this.getRelativePos(panel_Parent.getId(), "top", String.valueOf(Integer.valueOf(rect.bottom))));
            container_Parent.getBottom().setOriginString(this.getRelativePos(container_Parent.getId(), "top", String.valueOf(Integer.valueOf(rect.bottom))));
        } else {
            panel_Parent.getBottom().setOriginString(null);
            container_Parent.getBottom().setOriginString(null);
        }
        this.makeDesignedNode(panel_Parent, container_Parent.getId(), rect.left, rect.right, rect.top, rect.bottom, true);
        this.makeBottomSelfAdapt(panel_Parent);
        return rect;
    }

    private String getRelativePos(String sRelativeID, String pos, String sDistance) {
        return "[" + sRelativeID + "." + pos + "]+" + sDistance;
    }

    private GDI_RECT translateZone(IXmlElement zooeRoot, int inset, Panel panel, String sRelativeID, String sTop, boolean bFromBottom, boolean bHasBottom) {
        this.cout("", "===============in translateZone(begin)", inset);
        Iterator it = zooeRoot.getChildren().iterator();
        StyleAttributes styleAtt = Styles.getEmptySA();
        GDI_RECT rect = null;
        boolean bVisible = true;
        while (it.hasNext()) {
            IXmlElement node = (IXmlElement)it.next();
            String nodeName = node.getName();
            if (TAG_RECT.endsWith(nodeName)) {
                rect = this.translateRect(node, inset + 1);
                rect.right = String.valueOf(Integer.parseInt(rect.right) - Integer.parseInt(rect.left));
                panel.getRight().setOriginString(this.getRelativePos(panel.getId(), "left", rect.right));
                rect.left = "0";
                panel.getLeft().setOriginString(this.getRelativePos(sRelativeID, "left", rect.left));
                rect.bottom = String.valueOf(Integer.parseInt(rect.bottom) - Integer.parseInt(rect.top));
                if (bHasBottom) {
                    if (bVisible) {
                        panel.getBottom().setOriginString(this.getRelativePos(panel.getId(), "top", rect.bottom));
                    } else {
                        panel.getBottom().setOriginString(panel.getTop().getOriginString());
                    }
                }
                if (sTop != null) {
                    rect.top = sTop;
                }
                if (bFromBottom) {
                    panel.getTop().setOriginString(this.getRelativePos(sRelativeID, "bottom", "0"));
                    continue;
                }
                panel.getTop().setOriginString(this.getRelativePos(sRelativeID, "top", rect.top));
                continue;
            }
            if (TAG_VALUE.endsWith(nodeName)) {
                String groupFld;
                this.grpField = groupFld = node.getText().trim();
                IXmlElement columnNode = this.getFieldNodeByName(groupFld);
                if (columnNode != null) {
                    String fieldID = columnNode.getAttribute("id");
                    String fieldText = columnNode.getChild("Formula").getText();
                    IXmlElement giNode = XmlUtil.createNode((String)"GroupItem");
                    giNode.setAttribute("id", fieldID);
                    giNode.setAttribute("name", fieldText);
                    giNode.setAttribute("desc", "false");
                    giNode.setAttribute("columnID", fieldID);
                    this.designedDS.groupNode.addChild(giNode);
                }
                this.cout(TAG_VALUE, groupFld, inset);
                continue;
            }
            if ("NAME".endsWith(nodeName)) {
                String name = node.getText().trim();
                panel.setUserAlias(name);
                this.cout("NAME", name, inset);
                continue;
            }
            if (TAG_TEXT.endsWith(nodeName)) {
                String text = node.getText().trim();
                this.cout(TAG_TEXT, text, inset);
                continue;
            }
            if (TAG_NO.endsWith(nodeName)) {
                this.cout(TAG_NO, node.getText().trim(), inset);
                continue;
            }
            if (TAG_FLAG.endsWith(nodeName)) {
                String flag = node.getText().trim();
                if (bHasBottom && flag.equals("1")) {
                    bVisible = false;
                }
                this.cout(TAG_FLAG, flag, inset);
                continue;
            }
            if (TAG_CELL.endsWith(nodeName)) {
                this.translateCell(node, inset + 1, panel);
                continue;
            }
            if (TAG_BACKCOLOR.endsWith(nodeName)) {
                String backColor = node.getText().trim();
                styleAtt.setBackground(this.getRightColor(backColor));
                this.cout(TAG_BACKCOLOR, this.getRightColor(backColor).toString(), inset);
                continue;
            }
            if (TAG_FONT.endsWith(nodeName)) {
                this.cout(TAG_FONT, node.getText().trim(), inset);
                continue;
            }
            if (TAG_PENLEFT.endsWith(nodeName)) {
                this.cout(TAG_PENLEFT, node.getText().trim(), inset);
                continue;
            }
            if (TAG_PENTOP.endsWith(nodeName)) {
                this.cout(TAG_PENTOP, node.getText().trim(), inset);
                continue;
            }
            if (TAG_PENRIGHT.endsWith(nodeName)) {
                this.cout(TAG_PENRIGHT, node.getText().trim(), inset);
                continue;
            }
            if (TAG_PENBOTTOM.endsWith(nodeName)) {
                this.cout(TAG_PENBOTTOM, node.getText().trim(), inset);
                continue;
            }
            if (TAG_FORECOLOR.endsWith(nodeName)) {
                this.cout(TAG_FORECOLOR, node.getText().trim(), inset);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        panel.setStyles((ShareStyleAttributes)styleAtt);
        this.cout("", "===============in translateZone(end)", inset);
        return rect;
    }

    private void translateCell(IXmlElement cellRoot, int inset, Panel panel) {
        this.cout("", "===============in translateCell(begin)", inset);
        Cell cell = new Cell();
        cell.setId("cell" + index++);
        cell.setUserAlias(cell.getId());
        panel.addChild(cell);
        StyleAttributes styleAtt = Styles.getEmptySA();
        styleAtt.setBackground(new Color(255, 255, 255, 0));
        this.setDefaultStyle(styleAtt);
        String type = "";
        for (IXmlElement node : cellRoot.getChildren()) {
            String penStyleID;
            String nodeName = node.getName();
            if ("TYPE".endsWith(nodeName)) {
                type = node.getText().trim();
                this.cout(node.getName(), type, inset);
                continue;
            }
            if (TAG_TEXT.endsWith(nodeName)) {
                String text = node.getText().trim();
                cell.setType("constant");
                Data dataText = new Data("string", text);
                cell.setData(dataText);
                this.cout(node.getName(), text, inset);
                continue;
            }
            if ("NAME".endsWith(nodeName)) {
                String name = node.getText().trim();
                cell.setAliasName(name);
                this.cout(node.getName(), name, inset);
                continue;
            }
            if (TAG_VALUE.endsWith(nodeName)) {
                String value = node.getText().trim();
                this.setCellTypeValue(cell, type, value);
                this.cout(node.getName(), value, inset);
                continue;
            }
            if (TAG_FORMAT.endsWith(nodeName)) {
                String format = node.getText().trim();
                if (format.trim().length() > 0) {
                    this.translateFormat(cell, format);
                }
                this.cout(node.getName(), format, 0);
                continue;
            }
            if (TAG_NO.endsWith(nodeName)) {
                this.cout(node.getName(), node.getText().trim(), inset);
                continue;
            }
            if (TAG_RECT.endsWith(nodeName)) {
                GDI_RECT rect = this.translateRect(node, inset + 1);
                String right = String.valueOf(Integer.parseInt(rect.right) - Integer.parseInt(rect.left));
                String bottom = String.valueOf(Integer.parseInt(rect.bottom) - Integer.parseInt(rect.top));
                cell.getLeft().setOriginString(this.getRelativePos(panel.getId(), "left", rect.left));
                cell.getTop().setOriginString(this.getRelativePos(panel.getId(), "top", rect.top));
                cell.getRight().setOriginString(this.getRelativePos(cell.getId(), "left", right));
                cell.getBottom().setOriginString(this.getRelativePos(cell.getId(), "top", bottom));
                this.makeDesignedNode(cell, panel.getId(), rect.left, right, rect.top, bottom, true);
                continue;
            }
            if (TAG_ALIGN.endsWith(nodeName)) {
                String align = node.getText().trim();
                this.setAlign(align, styleAtt);
                this.cout(node.getName(), align, inset);
                continue;
            }
            if (TAG_FONT.endsWith(nodeName)) {
                String fontID = node.getText().trim();
                this.setFont(fontID, styleAtt);
                this.cout(node.getName(), fontID, inset);
                continue;
            }
            if (TAG_PENLEFT.endsWith(nodeName)) {
                penStyleID = node.getText().trim();
                this.setPenStyle(penStyleID, styleAtt, Styles.Position.LEFT);
                this.cout(node.getName(), penStyleID, inset);
                continue;
            }
            if (TAG_PENTOP.endsWith(nodeName)) {
                penStyleID = node.getText().trim();
                this.setPenStyle(penStyleID, styleAtt, Styles.Position.TOP);
                this.cout(node.getName(), penStyleID, inset);
                continue;
            }
            if (TAG_PENRIGHT.endsWith(nodeName)) {
                penStyleID = node.getText().trim();
                this.setPenStyle(penStyleID, styleAtt, Styles.Position.RIGHT);
                this.cout(node.getName(), penStyleID, inset);
                continue;
            }
            if (TAG_PENBOTTOM.endsWith(nodeName)) {
                penStyleID = node.getText().trim();
                this.setPenStyle(penStyleID, styleAtt, Styles.Position.BOTTOM);
                this.cout(node.getName(), penStyleID, inset);
                continue;
            }
            if (TAG_FORECOLOR.endsWith(nodeName)) {
                String foreColor = node.getText().trim();
                styleAtt.setFontColor(this.getRightColor(foreColor));
                this.cout(node.getName(), this.getRightColor(foreColor).toString(), inset);
                continue;
            }
            if (TAG_BACKCOLOR.endsWith(nodeName)) {
                String backColor = node.getText().trim();
                styleAtt.setBackground(this.getRightColor(backColor));
                this.cout(node.getName(), this.getRightColor(backColor).toString(), inset);
                continue;
            }
            if (TAG_FLAG.endsWith(nodeName)) {
                String flag = node.getText().trim();
                if (flag.equals("1")) {
                    cell.getBottom().setOriginString(panel.getTop().getOriginString());
                }
                this.cout(node.getName(), flag, inset);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        cell.setStyles(Styles.getSSA((StyleAttributes)styleAtt));
        this.cout("", "===============in translateCell(end)", inset);
    }

    private void translateFormatString(Cell cell, String format) {
        if (format.equals("0.00") || format.equals("#,##0.00;-#,##0.00")) {
            cell.setDataFormat("\"%{##.00}f\"");
        } else if (format.equals("#,##0.00;(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))>=0,\"%{#,##0.00}f\",\"%_{!(#,##0.00!)}f\")");
        } else if (format.equals("#,##0.00;-(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))>=0,\"%{#,##0.00}f\",\"%_{!-!(#,##0.00!)}f\")");
        } else if (format.equals("#,##0.00;-#,##0.00;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"))) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00}f\",\"%{" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6") + "}f\")");
        } else if (format.equals("#,##0.00;-#,##0.00;\\\"\\\"")) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00}f\",\"%{''}f\")");
        } else if (format.equals("\uffe50.00") || format.equals("\uffe5#,##0.00;-\uffe50.00")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))<0,\"%_{!-!\uffe5#,##0.00}f\",\"%{\uffe5#,##0.00}f\")");
        } else if (format.equals("\uffe5#,##0.00;\uffe5(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))<0,\"%_{!\uffe5!(#,##0.00!)}f\",\"%{\uffe5#,##0.00}f\")");
        } else if (format.equals("\uffe5#,##0.00;\uffe5-(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))<0,\"%_{!\uffe5!-!(#,##0.00!)}f\",\"%{\uffe5#,##0.00}f\")");
        } else if (format.equals("\uffe5#,##0.00;\uffe5-#,##0.00;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"))) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{\uffe5#,##0.00}f\",\"%{" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6") + "}f\")");
        } else if (format.equals("\uffe5#,##0.00;\uffe5-#,##0.00;\\\"\\\"")) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{\uffe5#,##0.00}f\",\"%{''}f\")");
        } else if (format.equals("0.00%") || format.equals("#,##0.00%;-0.00%")) {
            cell.setDataFormat("\"%{##.00%}f\"");
        } else if (format.equals("%#,##0.00;%(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))<0,\"%_{!%!(#,##0.00!)}f\",\"%{!%#,##0.00}f\")");
        } else if (format.equals("%#,##0.00;%-(#,##0.00)")) {
            cell.setDataFormat("if($TONUMBER($GETOUTPUTVALUE(\"value\"))<0,\"%_{!%!-!(#,##0.00!)}f\",\"%{!%#,##0.00}f\")");
        } else if (format.equals("#,##0.00%;-#,##0.00%;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"))) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00%}f\",\"%{" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6") + "}f\")");
        } else if (format.equals("#,##0.00%;-#,##0.00%;\\\"\\\"")) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00%}f\",\"%{''}f\")");
        } else if (format.equals("0.00e+#") || format.equals("0.000;-0.000E+#")) {
            cell.setDataFormat("\"%{##.00}e\"");
        } else if (format.equals("0.00E+00;(0.00E+00)")) {
            cell.setDataFormat("\"%{##.00}e\"");
        } else if (format.equals("0.00E+00;-(0.00E+00)")) {
            cell.setDataFormat("\"%{##.00}e\"");
        } else if (format.equals("0.00E+000;-0.00E+000;" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6"))) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00}e\",\"%{" + CtrlKDFMessages.getMLS("zeroFormat", "\u96f6") + "}f\")");
        } else if (format.equals("0.00E+000;-0.00E+000;\\\"\\\"")) {
            cell.setDataFormat("if($TONUMBER(ABS($GETOUTPUTVALUE(\"value\")))>=0.000000001,\"%{#,##0.00}e\",\"%{''}f\")");
        }
    }

    private void translateFormat(Cell cell, String format) {
        if (this.getVecFormat().contains(format)) {
            this.translateFormatString(cell, format);
        }
        if (format.toUpperCase(Locale.ENGLISH).indexOf("IF") >= 0) {
            this.tanslateIFStatements(cell, format);
        }
    }

    private void tanslateIFStatements(Cell cell, String format) {
        this.m_strFormat = format.trim();
        this.m_lLength = this.m_strFormat.length();
        try {
            String s = this.Statement();
            this.cout(CtrlKDFMessages.getMLS("translatedFormula", "\u7ffb\u8bd1\u540e\u7684\u516c\u5f0f"), s, 0);
            cell.setPostSteps(s);
        }
        catch (Exception ex) {
            this.cout("", ex.toString(), 0);
        }
    }

    private String Statement() throws Exception {
        StringBuilder ret = new StringBuilder();
        while (this.Match(12L) || this.Match(13L)) {
            if (this.Match(12L)) {
                ret.append(this.varStatement());
                continue;
            }
            ret.append(this.ifStatement());
        }
        return ret.toString();
    }

    private String varStatement() throws Exception {
        String ret = "";
        this.m_csVar = this.GetVarName("[", "]");
        this.cout("m_csVar", this.m_csVar, 0);
        this.Advance();
        if (this.Match(5L)) {
            if (this.getHsFuncVB().containsKey(this.m_csVar)) {
                ret = this.FixedFunc(this.m_csVar) + ";\n";
            } else {
                this.UserDefFunc(this.m_csVar);
            }
        } else {
            ret = this.m_csVar;
            if (!this.Match(7L)) {
                throw new Exception(CtrlKDFMessages.getMLS("errorMissingEqual", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11'='"));
            }
            this.Advance();
            ret = ret + "=";
            ret = ret + this.Expression();
            ret = this.transVBFormat2KDFFormate(ret);
            ret = ret + ";\n";
        }
        return ret;
    }

    private String transVBFormat2KDFFormate(String strIn) {
        strIn = strIn.trim();
        String ret = "";
        String strTmp = "";
        int index = 0;
        if (strIn.startsWith(TAG_FORECOLOR) || strIn.startsWith(TAG_BACKCOLOR)) {
            index = strIn.indexOf("RGB");
            strTmp = strIn.substring(index + 3, strIn.length()).trim();
            strTmp = strTmp.substring(1, strTmp.length() - 1);
            String[] aStr = strTmp.split(",");
            strTmp = "\"#";
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < aStr.length; ++i) {
                String tmp = Integer.toHexString(Integer.parseInt(aStr[i]));
                if (tmp.equals("0")) {
                    stringBuilder.append("00");
                    continue;
                }
                stringBuilder.append(tmp);
            }
            strTmp = stringBuilder.insert(0, strTmp).toString();
            ret = strIn.startsWith(TAG_FORECOLOR) ? "$SetOutputValue(\"fontColor\"," + strTmp + "\")" : "$SetOutputValue(\"backgroundColor\"," + strTmp + "\")";
        } else if (strIn.startsWith(TAG_VALUE)) {
            index = strIn.indexOf(61);
            strTmp = strIn.substring(index + 1, strIn.length()).trim();
            ret = "$SetOutputValue(\"value\"," + strTmp + ")";
        } else if (strIn.startsWith(TAG_FORMAT)) {
            index = strIn.indexOf(61);
            strTmp = strIn.substring(index + 1, strIn.length() - 1).trim();
            ret = "$SetOutputValue(\"value\", $Format($GetOutputValue(\"value\"),\"%{" + strTmp.substring(1, strTmp.length()) + "}f\"))";
        }
        return ret;
    }

    private String ifStatement() throws Exception {
        StringBuilder ret = new StringBuilder();
        this.Advance();
        ret.append("if(");
        ret.append(this.Condition());
        if (!this.Match(14L)) {
            throw new Exception(CtrlKDFMessages.getMLS("errorMissingThen", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11THEN"));
        }
        this.Advance();
        ret.append("){\n");
        ret.append(this.Statement());
        while (this.Match(16L)) {
            this.Advance();
            ret.append("}\nelseif(");
            ret.append(this.Condition());
            if (!this.Match(14L)) {
                throw new Exception(CtrlKDFMessages.getMLS("errorMissingThen", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11THEN"));
            }
            this.Advance();
            ret.append("){\n");
            ret.append(this.Statement());
        }
        if (this.Match(15L)) {
            this.Advance();
            ret.append("}\nelse{\n");
            ret.append(this.Statement());
        }
        if (!this.Match(17L)) {
            throw new Exception(CtrlKDFMessages.getMLS("errorMissingEndif", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11ENDIF"));
        }
        this.Advance();
        ret.append("}");
        return ret.toString();
    }

    private String Condition() throws Exception {
        StringBuilder ret = new StringBuilder();
        ret.append(this.AndList());
        while (this.Match(19L)) {
            this.Advance();
            ret.append(" || ");
            ret.append(this.AndList());
        }
        return ret.toString();
    }

    private String AndList() throws Exception {
        StringBuilder ret = new StringBuilder();
        ret.append(this.RelExpr());
        while (this.Match(18L)) {
            this.Advance();
            ret.append(" && ");
            ret.append(this.AndList());
        }
        return ret.toString();
    }

    private String RelExpr() throws Exception {
        String ret = "";
        if (this.Match(5L)) {
            this.Advance();
            ret = "(";
            ret = ret + this.Condition();
            if (!this.Match(6L)) {
                throw new Exception(CtrlKDFMessages.getMLS("errorMissingRightParen", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11')'"));
            }
        } else {
            ret = this.Expression();
            String[] aStrTmp = ret.split(TAG_VALUE);
            StringBuilder strTmp = new StringBuilder();
            for (int i = 0; i < aStrTmp.length; ++i) {
                if (i != aStrTmp.length - 1) {
                    strTmp.append(aStrTmp[i]).append("$GetOutputValue(\"value\")");
                    continue;
                }
                strTmp.append(aStrTmp[i]);
            }
            if (aStrTmp.length > 0) {
                ret = strTmp.toString();
            }
            if (!this.Match(21L) && !this.Match(7L)) {
                return ret;
            }
            long lpszRelop = this.m_lpszFormula;
            long iRelop_len = this.m_lLength_CurWord;
            this.Advance();
            String ret2 = this.Expression();
            char ch = this.charNext(lpszRelop - 1L);
            switch (ch) {
                case '>': {
                    if (iRelop_len == 1L) {
                        return ret + ">" + ret2;
                    }
                    return ret + ">=" + ret2;
                }
                case '<': {
                    if (iRelop_len == 1L) {
                        return ret + "<" + ret2;
                    }
                    if (this.charNext(lpszRelop + 1L) == '=') {
                        return ret + "<=" + ret2;
                    }
                    return ret + "!=" + ret2;
                }
                case '=': {
                    return ret + "==" + ret2;
                }
            }
            throw new Exception(CtrlKDFMessages.getMLS("errorInvalidConditionExpression", "\u89e3\u91ca\u9519\u8bef:\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bef"));
        }
        ret = ")";
        this.Advance();
        return ret;
    }

    private String Expression() throws Exception {
        StringBuilder ret = new StringBuilder();
        ret.append(this.Term());
        while (this.Match(1L) || this.Match(2L)) {
            long iOp = this.m_lToken_CurWord;
            this.Advance();
            String ret2 = this.Term();
            if (iOp == 1L) {
                ret.append("+").append(ret2);
                continue;
            }
            ret.append("-").append(ret2);
        }
        return ret.toString();
    }

    private String Term() throws Exception {
        String ret = "";
        ret = this.Factor();
        while (this.Match(3L) || this.Match(4L) || this.Match(20L)) {
            long iOp = this.m_lToken_CurWord;
            this.Advance();
            String ret2 = this.Factor();
            if (iOp == 3L) {
                ret = ret + "*" + ret2;
                continue;
            }
            if (iOp == 4L) {
                ret = ret + "/" + ret2;
                continue;
            }
            ret = "MOD(" + ret + "," + ret2 + ")";
        }
        return ret;
    }

    private String Factor() throws Exception {
        String ret = "";
        if (this.Match(1L) || this.Match(2L)) {
            if (this.Match(2L)) {
                ret = "-";
            }
            this.Advance();
        }
        if (this.Match(11L)) {
            String num;
            ret = num = this.m_strFormat.substring((int)this.m_lpszFormula, (int)(this.m_lpszFormula + this.m_lLength_CurWord));
            this.Advance();
        } else if (this.Match(22L)) {
            ret = this.m_csStr = this.GetStrContent(this.m_lpszFormula, this.m_lLength_CurWord);
            this.Advance();
        } else if (this.Match(12L)) {
            ret = this.m_csVar = this.GetVarName("[", "]");
            this.Advance();
            if (this.Match(5L)) {
                if (this.getHsFuncVB().containsKey(this.m_csVar)) {
                    ret = this.FixedFunc(this.m_csVar);
                } else {
                    this.UserDefFunc(this.m_csVar);
                }
            } else {
                ret = this.m_csVar;
            }
        } else if (this.Match(5L)) {
            ret = "(";
            this.Advance();
            ret = ret + this.Expression();
            if (!this.Match(6L)) {
                throw new Exception(CtrlKDFMessages.getMLS("errorMissingRightParen", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11')'"));
            }
            ret = ret + ")";
            this.Advance();
        } else {
            throw new Exception(CtrlKDFMessages.getMLS("errorInvalidConditionFactor", "\u89e3\u91ca\u9519\u8bef:\u6761\u4ef6\u8868\u8fbe\u5f0f\u56e0\u5b50\u6709\u8bef"));
        }
        return ret;
    }

    private void UserDefFunc(String funcName) {
    }

    private String FixedFunc(String funcName) throws Exception {
        StringBuilder ret = new StringBuilder(funcName);
        this.Advance();
        ret.append("(");
        int iargs = 0;
        if (!this.Match(6L)) {
            if (this.Match(22L)) {
                this.m_csStr = this.GetStrContent(this.m_lpszFormula, this.m_lLength_CurWord);
                this.Advance();
                ret.append("\"").append(this.m_csStr).append("\"");
                ++iargs;
            } else {
                ret.append(this.Expression());
                ++iargs;
            }
            while (this.Match(8L)) {
                this.Advance();
                ret.append(",");
                if (this.Match(22L)) {
                    this.m_csStr = this.GetStrContent(this.m_lpszFormula, this.m_lLength_CurWord);
                    this.Advance();
                    ret.append("\"").append(this.m_csStr).append("\"");
                    ++iargs;
                    continue;
                }
                ret.append(this.Expression());
                ++iargs;
            }
        }
        if (!this.Match(6L)) {
            throw new Exception(CtrlKDFMessages.getMLS("errorMissingRightParen", "\u89e3\u91ca\u9519\u8bef:\u7f3a\u5c11')'"));
        }
        this.Advance();
        ret.append(")");
        return ret.toString();
    }

    private String GetVarName(String left_delim, String right_delim) {
        String str = this.m_strFormat.substring((int)this.m_lpszFormula, (int)(this.m_lpszFormula + this.m_lLength_CurWord));
        if (str.startsWith(left_delim)) {
            str = str.substring(1);
        }
        if (str.startsWith(right_delim)) {
            str = str.substring(0, str.length() - 2);
        }
        this.cout("GetVarName", str, 0);
        return str;
    }

    private String GetStrContent(long start, long length) {
        if (length < 2L || this.charNext(start) == '\"') {
            return "";
        }
        return this.m_strFormat.substring((int)start, (int)(start + length));
    }

    private boolean Match(long iToken) throws Exception {
        if (this.m_lToken_CurWord == -1L) {
            this.m_lToken_CurWord = this.Lex();
        }
        return iToken == this.m_lToken_CurWord;
    }

    private void Advance() throws Exception {
        this.m_lToken_CurWord = this.Lex();
        this.cout("m_lToken_CurWord=", String.valueOf(this.m_lToken_CurWord), 0);
    }

    private char charNext(long lpszCur) {
        return this.m_strFormat.charAt((int)lpszCur + 1);
    }

    private long Lex() throws Exception {
        block17: for (long lpszCur = this.m_lpszFormula + this.m_lLength_CurWord; lpszCur < this.m_lLength; ++lpszCur) {
            this.m_lpszFormula = lpszCur;
            this.m_lLength_CurWord = 1L;
            char ch = this.m_strFormat.charAt((int)lpszCur);
            switch (ch) {
                case '+': {
                    return 1L;
                }
                case '-': {
                    return 2L;
                }
                case '*': {
                    return 3L;
                }
                case '/': {
                    if (this.charNext(lpszCur) != '/') {
                        return 4L;
                    }
                    ch = this.m_strFormat.charAt((int)(++lpszCur));
                    while (ch != '\n' && ch != '\r' && lpszCur < this.m_lLength) {
                        ++lpszCur;
                    }
                    if (lpszCur == this.m_lLength) {
                        return 0L;
                    }
                }
                case '(': {
                    return 5L;
                }
                case ')': {
                    return 6L;
                }
                case '=': {
                    return 7L;
                }
                case ',': {
                    return 8L;
                }
                case ';': {
                    return 9L;
                }
                case '>': {
                    if (this.charNext(lpszCur) == '=') {
                        ++lpszCur;
                        ++this.m_lLength_CurWord;
                    }
                    return 21L;
                }
                case '<': {
                    if (this.charNext(lpszCur) == '=' || this.charNext(lpszCur) == '>') {
                        ++lpszCur;
                        ++this.m_lLength_CurWord;
                    }
                    return 21L;
                }
                case '[': {
                    ch = this.m_strFormat.charAt((int)(++lpszCur));
                    while (ch != ']' && lpszCur < this.m_lLength) {
                        ++lpszCur;
                    }
                    if (ch == ']') {
                        ++lpszCur;
                    }
                    this.m_lLength_CurWord = lpszCur - this.m_lpszFormula;
                    return 12L;
                }
                case '\"': {
                    ch = this.m_strFormat.charAt((int)(++lpszCur));
                    this.cout("ch", String.valueOf(ch), 0);
                    while (ch != '\"' && lpszCur < this.m_lLength) {
                        ch = this.charNext(lpszCur);
                        this.cout("ch", String.valueOf(ch), 0);
                        ++lpszCur;
                    }
                    if (ch == '\"') {
                        ++lpszCur;
                    }
                    this.m_lLength_CurWord = lpszCur - this.m_lpszFormula;
                    return 22L;
                }
                case '.': {
                    if (this._istdigit(this.charNext(lpszCur))) {
                        this._E_M_NUM(lpszCur);
                    }
                    return 10L;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block17;
                }
                default: {
                    ch = this.m_strFormat.charAt((int)lpszCur);
                    if (this._istalpha(ch)) {
                        while (this._istalnum(ch) && ++lpszCur < this.m_lLength) {
                            ch = this.m_strFormat.charAt((int)lpszCur);
                        }
                        this.m_lLength_CurWord = lpszCur - this.m_lpszFormula;
                        return this.GetWordType();
                    }
                    if (this._istdigit(ch) || ch == '.') {
                        return this._E_M_NUM(lpszCur);
                    }
                    throw new Exception(CtrlKDFMessages.getMLS("interpretationError", "\u89e3\u91ca\u9519\u8bef:") + this.m_strFormat.substring(0, (int)lpszCur));
                }
            }
        }
        return 0L;
    }

    private long GetWordType() {
        this.m_csWord = this.m_strFormat.substring((int)this.m_lpszFormula, (int)this.m_lpszFormula + (int)this.m_lLength_CurWord);
        this.cout("m_csWord", this.m_csWord, 0);
        if (this.getHsKeyWord().containsKey(this.m_csWord)) {
            return (Long)this.getHsKeyWord().get(this.m_csWord);
        }
        return 12L;
    }

    private boolean _istalnum(char ch) {
        return this._istalpha(ch) || this._istdigit(ch);
    }

    private boolean _istalpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private long _E_M_NUM(long lpszCur) throws Exception {
        boolean bSaw_dot;
        char ch = this.m_strFormat.charAt((int)lpszCur);
        boolean bl = bSaw_dot = ch == '.';
        do {
            if ((ch = this.m_strFormat.charAt((int)(++lpszCur))) != '.') continue;
            if (bSaw_dot) {
                throw new Exception(CtrlKDFMessages.getMLS("interpretationError", "\u89e3\u91ca\u9519\u8bef:") + this.m_strFormat.substring(0, (int)lpszCur));
            }
            bSaw_dot = true;
        } while (this._istdigit(ch) || ch == '.');
        this.m_lLength_CurWord = lpszCur - this.m_lpszFormula;
        return 11L;
    }

    private boolean _istdigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private void setCellTypeValue(Cell cell, String type, String value) {
        Data dataValue = new Data();
        cell.setData(dataValue);
        if (type.equals("16")) {
            cell.setType("field");
            cell.getData().setFormat(value);
        } else if (type.equals("15")) {
            cell.setType("variant");
            cell.getData().setFormat(value);
        } else if (type.equals("32")) {
            cell.setType("formula");
            cell.getData().setFormat(value);
        } else if (type.equals("130")) {
            cell.setType("variant");
            cell.getData().setFormat("page");
        } else if (type.equals("129")) {
            cell.setType("variant");
            cell.getData().setFormat("pageCount");
        } else if (type.equals("8")) {
            cell.setType("formula");
            cell.getData().setFormat("now()");
        } else if (type.equals("4")) {
            this.setImage(value, cell);
        } else if (type.equals("22")) {
            cell.setType("formula");
            cell.getData().setFormat("$GetOutputChildCount(\"$Parent.$Parent.$Children.1.$Children.0.$Children.1\")");
        } else if (!(type.equals("21") || type.equals("20") || type.equals("19"))) {
            if (type.equals("18")) {
                cell.setType("groupTotal");
                cell.getData().setFormat(value);
            } else {
                cell.setType("constant");
                cell.getData().setFormat(value);
            }
        }
    }

    private void setImage(String value, Cell cell) {
        int index2;
        int index = value.toLowerCase(Locale.ENGLISH).indexOf("image=");
        if (index >= 0 && (index2 = value.toLowerCase(Locale.ENGLISH).indexOf("flag=")) > index) {
            String id = value.substring(index + 6, index2).trim();
            GDI_IMAGE gdiImage = (GDI_IMAGE)this.getHsStyle().get(id);
            cell.getData().setFormat(Base64.encodeBytes((byte[])this.str2image(gdiImage.image)));
            cell.setType("constant");
            cell.addProperty(new Property("contentType", null, "embeddedImage"));
        }
    }

    private void setFont(String fontID, StyleAttributes styleAtt) {
        GDI_FONT font = (GDI_FONT)this.getHsStyle().get(fontID);
        styleAtt.setFontName(font.face);
        LOGFONT logFont = this.getLogFont(font.descriptioin);
        if (logFont == null) {
            return;
        }
        styleAtt.setFontSize((int)StyleUtil.pixelToPt((long)Math.abs(logFont.lfHeight)));
        if (logFont.lfItalic == 1) {
            styleAtt.setItalic(true);
        }
        if (logFont.lfUnderline == 1) {
            styleAtt.setUnderline(true);
        }
        if (logFont.lfStrikeOut == 1) {
            styleAtt.setStrikeThrough(true);
        }
        styleAtt.setWeight((float)logFont.lfWeight);
        if (logFont.lfWeight == 700L) {
            styleAtt.setBold(true);
        }
    }

    private LOGFONT getLogFont(String str) {
        if (str.trim().length() < 56) {
            return null;
        }
        LOGFONT logFont = new LOGFONT();
        int index = 0;
        logFont.lfHeight = this.str2long(str.substring(index, index + 8));
        index += 8;
        index += 8;
        index += 8;
        logFont.lfWeight = this.str2long(str.substring(index += 8, index + 8));
        logFont.lfItalic = this.str2byte(str.substring(index += 8, index + 2));
        logFont.lfUnderline = this.str2byte(str.substring(index += 2, index + 2));
        logFont.lfStrikeOut = this.str2byte(str.substring(index += 2, index + 2));
        index += 2;
        index += 2;
        index += 2;
        index += 2;
        index += 2;
        return logFont;
    }

    private byte str2byte(String str) {
        int iRet = 0;
        iRet = Integer.decode("0x" + str.trim()).byteValue() & 0xFF;
        return (byte)iRet;
    }

    private long str2long(String str) {
        long iRet = 0L;
        int index = 0;
        iRet |= (long)(Long.decode("0x" + str.substring(index, index + 2).trim()).byteValue() & 0xFF);
        iRet |= (long)(Long.decode("0x" + str.substring(index += 2, index + 2).trim()).byteValue() << 8 & 0xFF00);
        iRet |= (long)(Long.decode("0x" + str.substring(index += 2, index + 2).trim()).byteValue() << 16 & 0xFF0000);
        return iRet |= (long)(Long.decode("0x" + str.substring(index += 2, index + 2).trim()).byteValue() << 24 & 0xFF000000);
    }

    private byte[] str2image(String str) {
        byte[] b = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            b[i] = Integer.decode("0x" + str.substring(2 * i, 2 * (i + 1)).trim()).byteValue();
        }
        return b;
    }

    private void setAlign(String align, StyleAttributes styleAtt) {
        if (align.equals(ALIGN_LEFTTOP) || align.equals(ALIGN_LEFTMID) || align.equals(ALIGN_LEFTDWN)) {
            styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        }
        if (align.equals(ALIGN_MIDDLEDWN) || align.equals(ALIGN_MIDDLEMID) || align.equals(ALIGN_MIDDLETOP) || align.equals("37")) {
            styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
        if (align.equals(ALIGN_RIGHTTOP) || align.equals(ALIGN_RIGHTMID) || align.equals(ALIGN_RIGHTDWN) || align.equals("38")) {
            styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        if (align.equals(ALIGN_LEFTTOP) || align.equals(ALIGN_MIDDLETOP) || align.equals(ALIGN_RIGHTTOP)) {
            styleAtt.setVerticalAlign(Styles.VerticalAlignment.TOP);
        }
        if (align.equals(ALIGN_LEFTMID) || align.equals(ALIGN_MIDDLEMID) || align.equals(ALIGN_RIGHTDWN)) {
            styleAtt.setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        }
        if (align.equals(ALIGN_LEFTDWN) || align.equals(ALIGN_MIDDLEDWN) || align.equals(ALIGN_RIGHTDWN)) {
            styleAtt.setVerticalAlign(Styles.VerticalAlignment.BOTTOM);
        }
    }

    private Color getRightColor(String strColor) {
        long l = Long.parseLong(strColor);
        long lcolor = 0L;
        lcolor |= l << 16 & 0xFF0000L;
        lcolor |= l & 0xFF00L;
        return Color.decode("#" + Long.toHexString(lcolor |= l >> 16 & 0xFFL));
    }

    private void setDefaultStyle(StyleAttributes styleAtt) {
        styleAtt.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        styleAtt.setBorderColor(Styles.Position.LEFT, Color.BLACK);
        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        styleAtt.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        styleAtt.setBorderColor(Styles.Position.TOP, Color.BLACK);
        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        styleAtt.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        styleAtt.setBorderColor(Styles.Position.RIGHT, Color.BLACK);
        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        styleAtt.setBorderColor(Styles.Position.BOTTOM, Color.BLACK);
        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    private void setPenStyle(String penStyleID, StyleAttributes styleAtt, Styles.Position position) {
        GDI_PEN pen = (GDI_PEN)this.getHsStyle().get(penStyleID);
        styleAtt.setBorderLineStyle(position, Integer.parseInt(pen.width) == 1 ? LineStyle.SINGLE_LINE : LineStyle.DOUBLE_LINE_B);
        styleAtt.setBorderColor(position, this.getRightColor(pen.color));
        switch (Integer.parseInt(pen.style)) {
            case 0: {
                styleAtt.setBorderPenStyle(position, PenStyle.PS_SOLID);
                break;
            }
            case 1: {
                styleAtt.setBorderPenStyle(position, PenStyle.PS_DOT);
                break;
            }
            case 2: {
                styleAtt.setBorderPenStyle(position, PenStyle.PS_CONTINUOUS);
                break;
            }
            case 3: {
                styleAtt.setBorderPenStyle(position, PenStyle.PS_DASHDOTDOT);
                break;
            }
            case 4: {
                styleAtt.setBorderPenStyle(position, PenStyle.PS_DASHDOT);
                break;
            }
            case 5: {
                styleAtt.setBorderLineStyle(position, LineStyle.NULL_LINE);
                break;
            }
            default: {
                styleAtt.setBorderLineStyle(position, LineStyle.NULL_LINE);
            }
        }
    }

    private GDI_RECT translateRect(IXmlElement rectRoot, int inset) {
        this.cout("", "===============in translateRect(begin)", inset);
        GDI_RECT rect = new GDI_RECT();
        rect.left = rectRoot.getAttribute("left");
        rect.top = rectRoot.getAttribute("top");
        rect.right = rectRoot.getAttribute("right");
        rect.bottom = rectRoot.getAttribute("bottom");
        this.cout("left", rect.left, inset);
        this.cout("top", rect.top, inset);
        this.cout("right", rect.right, inset);
        this.cout("bottom", rect.bottom, inset);
        this.cout("", "===============in translateRect(end)", inset);
        return rect;
    }

    private void translateSQLData(IXmlElement sqlDataRoot) {
        this.cout("", "===============in translateSQLData(begin)", 0);
        for (IXmlElement node : sqlDataRoot.getChildren()) {
            String nodeName = node.getName();
            if (TAG_SQL_TABLE.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_TABLE(begin)", 1);
                this.translateSQLTable(node);
                this.translateSQLData2(node, 2);
                this.cout("", "===============in translateSQL_TABLE(end)", 1);
                continue;
            }
            if (TAG_SQL_FIELD.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_FIELD(begin)", 1);
                this.translateSQLField(node);
                this.translateSQLData2(node, 2);
                this.cout("", "===============in translateSQL_FIELD(end)", 1);
                continue;
            }
            if (TAG_SQL_ORDER.endsWith(nodeName)) {
                this.translateOrder(node, 2);
                continue;
            }
            if (TAG_SQL_PARAM.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_PARAM(begin)", 1);
                this.translateSQLData2(node, 2);
                this.cout("", "===============in translateSQL_PARAM(end)", 1);
                continue;
            }
            if (TAG_SQL_QUERY.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_QUERY(begin)", 1);
                this.designedDS.designedDSNode.setAttribute("isSelfDefine", "true");
                String sql = node.getText().trim();
                this.cout("<![CDATA[ ]]> ", sql, 1);
                this.datasource.setSource(sql);
                this.cout("", "===============in translateSQL_QUERY(end)", 1);
                continue;
            }
            if (TAG_SQL_TJOIN.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_TJOIN(begin)", 1);
                this.translateSQLJoin(node);
                this.translateSQLData2(node, 2);
                this.cout("", "===============in translateSQL_TJOIN(end)", 1);
                continue;
            }
            if (TAG_SQL_WHERE.endsWith(nodeName)) {
                this.cout("", "===============in translateSQL_WHERE(begin)", 1);
                this.translateSQLData2(node, 2);
                this.cout("", "===============in translateSQL_WHERE(end)", 1);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 1);
        }
        this.fireNoMeta(this.dataManager == null, this.getMetaTables().length == 0, this.noMetaField.size() != 0, this.noMetaField.keySet().toArray());
        this.cout("", "===============in translateSQLData(end)", 0);
    }

    private void translateSQLJoin(IXmlElement node) {
        String joinText = node.getChild(TAG_TEXT).getText().trim();
        String formula4SQL = this.parseFieldName2PrgID(joinText);
        int left1 = joinText.indexOf(91);
        int mid1 = joinText.indexOf("].[", left1 + 1);
        int left2 = joinText.indexOf(91, mid1 + 3);
        int mid2 = joinText.indexOf("].[", left2 + 1);
        String table1 = this.mapSubQrysName2ID.get(joinText.substring(left1 + 1, mid1)).toString();
        String table2 = this.mapSubQrysName2ID.get(joinText.substring(left2 + 1, mid2)).toString();
        IXmlElement joinNode = XmlUtil.createNode((String)"Join");
        joinNode.setAttribute("id", "queryJoin" + index);
        joinNode.setAttribute("name", "Join" + index++);
        joinNode.setAttribute("active", "true");
        joinNode.setAttribute("type", String.valueOf(0));
        joinNode.setAttribute("firstTableID", table1);
        joinNode.setAttribute("secondTableID", table2);
        IXmlElement formulaNode = XmlUtil.createNode((String)"Formula");
        formulaNode.addCData(joinText);
        IXmlElement formula4SqlNode = XmlUtil.createNode((String)"Formula4Sql");
        formula4SqlNode.addCData(formula4SQL);
        joinNode.addChild(formulaNode);
        joinNode.addChild(formula4SqlNode);
        this.designedDS.joinsNode.addChild(joinNode);
    }

    private IXmlElement getFieldNodeByName(String name) {
        for (IXmlElement node : this.designedDS.columnsNode.getChildren()) {
            if (!StringUtil.equals((String)name, (String)node.getAttribute("name"))) continue;
            return node;
        }
        return null;
    }

    private void translateSQLField(IXmlElement node) {
        String sqlFieldName = node.getChild("NAME").getText().trim();
        String sqlFieldText = node.getChild(TAG_TEXT).getText().trim();
        if (!StringUtil.isEmptyString((String)sqlFieldName) && !StringUtil.isEmptyString((String)sqlFieldText)) {
            String type = SqlType.STRING.toString();
            if (sqlFieldText.matches("^\\[.+\\]\\.\\[.+\\]$")) {
                QueryColumn col;
                int midIdx = sqlFieldText.indexOf("].[");
                String tableName = sqlFieldText.substring(1, midIdx);
                String fieldName = sqlFieldText.substring(midIdx + 3, sqlFieldText.length() - 1);
                KDSourceQuery sqry = (KDSourceQuery)this.mapSubQrysName2Obj.get(tableName);
                if (sqry != null && (col = sqry.getColumnByName(fieldName)) != null) {
                    type = col.getType().toString();
                }
            }
            String formula4SQL = this.parseFieldName2PrgID(sqlFieldText);
            IXmlElement colNode = XmlUtil.createNode((String)"Column");
            colNode.setAttribute("id", "queryColumn" + index++);
            colNode.setAttribute("name", sqlFieldName);
            colNode.setAttribute("fieldID", sqlFieldName);
            colNode.setAttribute("type", type);
            IXmlElement formulaNode = XmlUtil.createNode((String)"Formula");
            formulaNode.addCData(sqlFieldText);
            IXmlElement formula4SqlNode = XmlUtil.createNode((String)"Formula4Sql");
            formula4SqlNode.addCData(formula4SQL);
            colNode.addChild(formulaNode);
            colNode.addChild(formula4SqlNode);
            this.designedDS.columnsNode.addChild(colNode);
        }
    }

    private String parseFieldName2PrgID(String text) {
        String residualText = text;
        StringBuilder formula4SQL = new StringBuilder();
        while (residualText.matches("^.*\\[.+\\]\\.\\[.+\\].*$")) {
            int left = residualText.indexOf(91);
            int mid = residualText.indexOf("].[", left + 1);
            int right = residualText.indexOf(93, mid + 1);
            String tableName = residualText.substring(left + 1, mid);
            String fieldName = residualText.substring(mid + 3, right);
            KDSourceQuery sqry = (KDSourceQuery)this.mapSubQrysName2Obj.get(tableName);
            boolean isNoMeta = false;
            if (sqry != null) {
                QueryColumn col = sqry.getColumnByName(fieldName);
                if (col != null) {
                    formula4SQL.append(residualText.substring(0, mid + 3));
                    formula4SQL.append(col.getProgramID());
                } else {
                    isNoMeta = true;
                }
            } else {
                isNoMeta = true;
            }
            if (isNoMeta) {
                formula4SQL.append(residualText.substring(0, right));
                this.noMetaField.put(residualText.substring(left, right + 1), null);
            }
            residualText = residualText.substring(right);
        }
        formula4SQL.append(residualText);
        return formula4SQL.toString();
    }

    private void translateSQLTable(IXmlElement node) {
        String subQryName = node.getChild("NAME").getText().trim();
        String tableName = node.getChild(TAG_TEXT).getText().trim();
        if (!StringUtil.isEmptyString((String)subQryName) && !StringUtil.isEmptyString((String)tableName)) {
            IXmlElement subQryNode = XmlUtil.createNode((String)"SubQuery");
            String id = "queryTable" + index++;
            subQryNode.setAttribute("id", id);
            this.designedDS.subQuerysNode.addChild(subQryNode);
            subQryNode.setAttribute("name", subQryName);
            KDSourceQuery sq = this.getMetaTableByName(tableName);
            if (sq != null) {
                subQryNode.setAttribute("subQueryID", sq.getID());
            } else {
                subQryNode.setAttribute("subQueryID", tableName);
            }
            this.mapSubQrysName2ID.put(subQryName, id);
            this.mapSubQrysName2Obj.put(subQryName, sq);
        }
    }

    private void translateSQLData2(IXmlElement dataNode, int inset) {
        for (IXmlElement node : dataNode.getChildren()) {
            String nodeName = node.getName();
            if ("NAME".endsWith(nodeName)) {
                this.cout("NAME", node.getText().trim(), inset);
                continue;
            }
            if (TAG_TEXT.endsWith(nodeName)) {
                this.cout(TAG_TEXT, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DATATYPE.endsWith(nodeName)) {
                this.cout(TAG_DATATYPE, node.getText().trim(), inset);
                continue;
            }
            if (TAG_NO.endsWith(nodeName)) {
                this.cout(TAG_NO, node.getText().trim(), inset);
                continue;
            }
            if (TAG_TEXTDATA.endsWith(nodeName)) {
                this.cout(TAG_TEXTDATA, node.getText().trim(), inset);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
    }

    private void translateOrder(IXmlElement orderRoot, int inset) {
        this.cout("", "===============in translateSQL_ORDER(begin)", inset);
        for (IXmlElement node : orderRoot.getChildren()) {
            String nodeName = node.getName();
            if (TAG_SQL_ORDBY.endsWith(nodeName)) {
                this.cout("field", node.getAttribute("field"), inset);
                this.cout("order", node.getAttribute("order"), inset);
                this.cout("<![CDATA[ ]]> ", node.getText().trim(), inset);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        this.cout("", "===============in translateSQL_ORDER(end)", inset);
    }

    private void translateDatabase(IXmlElement databaseRoot) {
        this.cout("", "===============in translateDatabase(begin)", 0);
        for (IXmlElement node : databaseRoot.getChildren()) {
            String nodeName = node.getName();
            if (TAG_DSC_GROUP.endsWith(nodeName)) {
                this.translateGroup(node, 1);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 1);
        }
        this.cout("", "===============in translateDatabase(end)", 0);
    }

    private void translateGroup(IXmlElement groupRoot, int inset) {
        this.cout("", "===============in translateGroup(begin)", inset);
        for (IXmlElement node : groupRoot.getChildren()) {
            String nodeName = node.getName();
            if ("NAME".endsWith(nodeName)) {
                this.cout("NAME", node.getText().trim(), inset);
                continue;
            }
            if (TAG_NOTE.endsWith(nodeName)) {
                this.cout(TAG_NOTE, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DSC_TABLE.endsWith(nodeName)) {
                this.translateTable(node, inset + 1);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        this.cout("", "===============in translateGroup(end)", inset);
    }

    private void translateTable(IXmlElement tableRoot, int inset) {
        this.cout("", "===============in translateTable(begin)", inset);
        for (IXmlElement node : tableRoot.getChildren()) {
            String nodeName = node.getName();
            if ("NAME".endsWith(nodeName)) {
                this.cout("NAME", node.getText().trim(), inset);
                continue;
            }
            if (TAG_NOTE.endsWith(nodeName)) {
                this.cout(TAG_NOTE, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DSC_TABLE_NAME.endsWith(nodeName)) {
                this.cout(TAG_DSC_TABLE_NAME, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DSC_FIELD.endsWith(nodeName)) {
                this.translateField(node, inset + 1);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        this.cout("", "===============in translateTable(end)", inset);
    }

    private void translateField(IXmlElement fieldRoot, int inset) {
        this.cout("", "===============in translateField(begin)", inset);
        for (IXmlElement node : fieldRoot.getChildren()) {
            String nodeName = node.getName();
            if ("NAME".endsWith(nodeName)) {
                this.cout("NAME", node.getText().trim(), inset);
                continue;
            }
            if (TAG_NOTE.endsWith(nodeName)) {
                this.cout(TAG_NOTE, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DSC_FIELD_NAME.endsWith(nodeName)) {
                this.cout(TAG_DSC_FIELD_NAME, node.getText().trim(), inset);
                continue;
            }
            if (TAG_DATATYPE.endsWith(nodeName)) {
                this.cout(TAG_DATATYPE, node.getText().trim(), inset);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), inset);
        }
        this.cout("", "===============in translateField(end)", inset);
    }

    private void translatePublic(IXmlElement publicRoot) {
        this.cout("", "===============in translatePublic(begin)", 0);
        for (IXmlElement node : publicRoot.getChildren()) {
            IXmlElement content;
            String id;
            String nodeName = node.getName();
            if (TAG_GDI_PEN.endsWith(nodeName)) {
                this.cout("", "===============pen(begin)", 1);
                id = node.getChild(TAG_GDI_ID).getText().trim();
                this.cout(TAG_GDI_ID, id, 1);
                content = node.getChild(TAG_PEN);
                GDI_PEN pen = new GDI_PEN();
                pen.style = content.getAttribute("style");
                pen.width = content.getAttribute("width");
                pen.color = content.getAttribute("color");
                this.getHsStyle().put(id, pen);
                this.cout("style", pen.style, 1);
                this.cout("width", pen.width, 1);
                this.cout("color", pen.color, 1);
                this.cout("", "===============pen(end)", 1);
                continue;
            }
            if (TAG_GDI_FONT.endsWith(nodeName)) {
                this.cout("", "===============font(begin)", 1);
                id = node.getChild(TAG_GDI_ID).getText().trim();
                this.cout(TAG_GDI_ID, id, 1);
                content = node.getChild(TAG_FONT);
                GDI_FONT font = new GDI_FONT();
                font.face = content.getAttribute("face");
                font.descriptioin = content.getAttribute("desc");
                this.cout("face", font.face, 1);
                this.cout("desc", font.descriptioin, 1);
                this.getHsStyle().put(id, font);
                this.cout("", "===============font(end)", 1);
                continue;
            }
            if (TAG_GDI_IMAGE.endsWith(nodeName)) {
                this.cout("", "===============image(begin)", 1);
                id = node.getChild(TAG_GDI_ID).getText().trim();
                this.cout(TAG_GDI_ID, id, 1);
                GDI_IMAGE image = new GDI_IMAGE();
                image.image = node.getChild(TAG_IMAGE).getText().trim();
                this.getHsStyle().put(id, image);
                this.cout("", "===============image(end)", 1);
                continue;
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 1);
        }
        this.cout("", "===============in translatePublic(end)", 0);
    }

    private void translateFile(IXmlElement fileRoot) throws Exception {
        this.cout("", "===============in translateFile(begin)", 0);
        for (IXmlElement node : fileRoot.getChildren()) {
            String nodeName = node.getName();
            if ("TYPE".endsWith(nodeName)) {
                this.cout("TYPE", node.getText().trim(), 0);
                continue;
            }
            if ("NAME".endsWith(nodeName)) {
                this.cout("NAME", node.getText().trim(), 0);
                continue;
            }
            if (TAG_FILE_VERSION.endsWith(nodeName)) {
                String version = node.getText().trim();
                this.cout(TAG_FILE_VERSION, version, 0);
                if (version == null || version.length() <= 0 || !(Double.parseDouble(version) < 1.1)) continue;
                throw new Exception(CtrlKDFMessages.getMLS("fileVersionIncorrect", "\u6587\u4ef6\u7248\u672c\u4e0d\u6b63\u786e!"));
            }
            this.cout(CtrlKDFMessages.getMLS("noTranslatedText", "\u6ca1\u6709\u7ffb\u8bd1\u7684"), node.getName(), 0);
        }
        this.cout("", "===============in translateFile(end)", 0);
    }

    private void cout(String title, String value, int inset) {
        if (this.DEBUG) {
            String strInset = "\t";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inset; ++i) {
                sb.append(strInset);
            }
        }
    }

    private final IXmlElement getElement() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            this.doc = XmlUtil.loadRootElement((InputStream)this.source);
        }
        catch (IOException err) {
            throw new AssertionError((Object)(CtrlKDFMessages.getMLS("fileReadFailed", "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u7cfb\u7edf\u4fe1\u606f\uff1a") + err.getMessage()));
        }
        catch (XmlParsingException e) {
            throw new AssertionError((Object)(CtrlKDFMessages.getMLS("xmlParseError", "\u5206\u6790XML\u6e90\u51fa\u9519\uff0c\u7cfb\u7edf\u4fe1\u606f\uff1a") + e.getMessage()));
        }
        return this.doc;
    }

    public KDRFile2KDFObj() {
    }

    public KDRFile2KDFObj(String _KDRFile) throws FileNotFoundException {
        FileInputStream fis = null;
        try {
            this._KDRFile = _KDRFile;
            fis = new FileInputStream(FilenameUtils.normalize((String)this._KDRFile));
            this.source = fis;
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean debug) {
        this.DEBUG = debug;
    }

    public String get_KDRFile() {
        return this._KDRFile;
    }

    public void setKDRFile(String file) {
        this._KDRFile = file;
    }

    @Override
    public KDF getKdf() {
        if (this._kdf == null) {
            this._kdf = new KDF();
            this._kdf.setVersion("3.1");
            this._kdf.getPrintInfo().setCustomizedPaperSize(true);
            this._kdf.getPrintInfo().setCustomizePaperHeight(-1);
            this._kdf.addForm(this.getForm());
            this._kdf.addDataSource(this.datasource);
            this._kdf.addHeader(this.getHeadpage());
            this._kdf.addFooter(this.getFootpage());
        }
        return this._kdf;
    }

    public void setKdf(KDF kdf) {
        this._kdf = kdf;
    }

    public Form getForm() {
        if (this._form == null) {
            this._form = new Form();
            this._form.setId("form" + index++);
            this._form.setHeaderID(this.getHeadpage().getId());
            this._form.setFooterID(this.getFootpage().getId());
            this._form.setUserAlias(this._form.getId());
        }
        return this._form;
    }

    public void setForm(Form _form) {
        this._form = _form;
    }

    public Page getPage() {
        if (this._page == null) {
            this._page = new Page();
            this._page.setId("page" + index++);
            this._page.setRepeat(-1);
            this._page.setUserAlias(this._page.getId());
        }
        return this._page;
    }

    public void setPage(Page _page) {
        this._page = _page;
    }

    public String getStrErr() {
        return this._strErr;
    }

    public HashMap getHsStyle() {
        if (this.hsStyle == null) {
            this.hsStyle = new HashMap();
        }
        return this.hsStyle;
    }

    public Page getFootpage() {
        if (this._footpage == null) {
            this._footpage = new Page();
            this._footpage.setId("page" + index++);
            this._footpage.setRepeat(1);
            this._footpage.setUserAlias(this._footpage.getId());
        }
        return this._footpage;
    }

    public void setFootpage(Page _footpage) {
        this._footpage = _footpage;
    }

    public Page getHeadpage() {
        if (this._headpage == null) {
            this._headpage = new Page();
            this._headpage.setId("page" + index++);
            this._headpage.setRepeat(1);
            this._headpage.setUserAlias(this._headpage.getId());
        }
        return this._headpage;
    }

    public void setHeadpage(Page _headpage) {
        this._headpage = _headpage;
    }

    public Vector getVecFormat() {
        if (this.vecFormat == null) {
            this.vecFormat = new Vector(0);
            for (int i = 0; i < this.aStrFormat.length; ++i) {
                this.vecFormat.add(this.aStrFormat[i]);
            }
        }
        return this.vecFormat;
    }

    public void setVecFormat(Vector vecFormat) {
        this.vecFormat = vecFormat;
    }

    public HashMap getHsKeyWord() {
        if (this.hsKeyWord == null) {
            this.hsKeyWord = new HashMap();
            for (int i = 0; i < aStrKeyWord.length; ++i) {
                this.hsKeyWord.put(aStrKeyWord[i], 13L + (long)i);
            }
        }
        return this.hsKeyWord;
    }

    public void setHsKeyWord(HashMap hsKeyWord) {
        this.hsKeyWord = hsKeyWord;
    }

    public HashMap getHsFuncVB() {
        if (this.hsFuncVB == null) {
            this.hsFuncVB = new HashMap();
            for (int i = 0; i < aStrVBFunc.length; ++i) {
                this.hsFuncVB.put(aStrVBFunc[i], aStrVBFunc[i]);
            }
        }
        return this.hsFuncVB;
    }

    public void setHsFuncVB(HashMap hsFuncVB) {
        this.hsFuncVB = hsFuncVB;
    }

    private void makeDesignedPageNode(Page page, boolean isHeadFooter, long width, long height) {
        if (page == null) {
            return;
        }
        IXmlElement node = XmlUtil.createNode((String)"DesignedPage");
        node.setAttribute("objHeight", String.valueOf(height));
        if (!isHeadFooter) {
            node.setAttribute("paperSize", "Custom");
            node.setAttribute("objWidth", String.valueOf(width));
            node.setAttribute("widthLimitless", "false");
            node.setAttribute("heightLimitless", "true");
        }
        page.setUserObject(node);
    }

    private void makeDesignedNode(Container obj, String relativeId, String left, String right, String top, String bottom, boolean isAbs) {
        String tagName = "DesignedCell";
        if (obj instanceof Area) {
            tagName = "DesignedArea";
        } else if (obj instanceof Panel) {
            tagName = "DesignedPanel";
        }
        IXmlElement node = XmlUtil.createNode((String)tagName);
        node.setAttribute("locked", "false");
        node.setAttribute("leftLocationType", "relative");
        node.setAttribute("leftRelativeObjID", relativeId);
        node.setAttribute("leftRelativeBorder", "left");
        node.setAttribute("leftRelativeOffset", left);
        node.setAttribute("rightLocationType", "relative");
        node.setAttribute("rightRelativeObjID", obj.getId());
        node.setAttribute("rightRelativeBorder", "left");
        node.setAttribute("rightRelativeOffset", right);
        node.setAttribute("topLocationType", "relative");
        node.setAttribute("topRelativeObjID", relativeId);
        if (isAbs) {
            node.setAttribute("topRelativeBorder", "top");
        } else {
            node.setAttribute("topRelativeBorder", "bottom");
        }
        node.setAttribute("topRelativeOffset", top);
        node.setAttribute("bottomLocationType", "relative");
        node.setAttribute("bottomRelativeObjID", obj.getId());
        node.setAttribute("bottomRelativeBorder", "top");
        node.setAttribute("bottomRelativeOffset", bottom);
        obj.setUserObject(node);
    }

    private void makeBottomSelfAdapt(Container obj) {
        Object uo = obj.getUserObject();
        if (!(uo instanceof IXmlElement)) {
            return;
        }
        IXmlElement node = (IXmlElement)uo;
        node.setAttribute("bottomLocationType", "selfAdapt");
        obj.getBottom().setOriginString(null);
    }

    private KDSourceQuery getMetaTableByName(String tableName) {
        for (int i = 0; i < this.getMetaTables().length; ++i) {
            KDSourceQuery sourceQry = (KDSourceQuery)this.getMetaTables()[i];
            if (!StringUtil.equals((String)tableName, (String)sourceQry.getName())) continue;
            return sourceQry;
        }
        return null;
    }

    private Object[] getMetaTables() {
        if (this.dataManager == null) {
            return new Object[0];
        }
        if (this.metaTables == null) {
            this.metaTables = this.getSourceQrys(this.dataManager.getDirSystem()).toArray();
        }
        return this.metaTables;
    }

    private ArrayList getSourceQrys(QueryDir qd) {
        ArrayList listQrys = new ArrayList();
        Iterator it = qd.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (temp instanceof QueryDir) {
                listQrys.addAll(this.getSourceQrys((QueryDir)temp));
                continue;
            }
            if (!(temp instanceof KDSourceQuery)) continue;
            listQrys.add(temp);
        }
        return listQrys;
    }

    private static class GDI_IMAGE {
        String image;

        private GDI_IMAGE() {
        }
    }

    private static class GDI_FONT {
        String face;
        String descriptioin;

        private GDI_FONT() {
        }
    }

    private static class GDI_PEN {
        String style;
        String width;
        String color;

        private GDI_PEN() {
        }
    }

    private class DesignedDS {
        IXmlElement designedDSNode = XmlUtil.createNode((String)"DesignedDataSource");
        IXmlElement columnsNode;
        IXmlElement subQuerysNode;
        IXmlElement filtersNode;
        IXmlElement joinsNode;
        IXmlElement sortsNode;
        IXmlElement groupNode;

        private DesignedDS() {
            this.designedDSNode.setAttribute("id", KDRFile2KDFObj.this.datasource.getID());
            this.designedDSNode.setAttribute("name", KDRFile2KDFObj.this.datasource.getID());
            this.designedDSNode.setAttribute("queryType", String.valueOf(1));
            this.designedDSNode.setAttribute("objectClass", "KDQuery");
            this.designedDSNode.setAttribute("isLinked", String.valueOf(KDRFile2KDFObj.this.datasource.isLinked()));
            this.designedDSNode.setAttribute("isSelfDefine", "false");
            this.columnsNode = XmlUtil.createNode((String)"Columns");
            this.subQuerysNode = XmlUtil.createNode((String)"SubQuerys");
            this.filtersNode = XmlUtil.createNode((String)"Filters");
            this.joinsNode = XmlUtil.createNode((String)"Joins");
            this.sortsNode = XmlUtil.createNode((String)"Sorts");
            this.groupNode = XmlUtil.createNode((String)"Group");
            this.designedDSNode.addChild(this.columnsNode);
            this.designedDSNode.addChild(this.subQuerysNode);
            this.designedDSNode.addChild(this.filtersNode);
            this.designedDSNode.addChild(this.joinsNode);
            this.designedDSNode.addChild(this.sortsNode);
            this.designedDSNode.addChild(this.groupNode);
            KDRFile2KDFObj.this.datasource.setUserObject(this.designedDSNode);
        }
    }

    private static class GDI_RECT {
        String left = "0";
        String top = "0";
        String right = "0";
        String bottom = "0";

        private GDI_RECT() {
        }

        void setPos(Container container) {
            this.left = String.valueOf(Integer.parseInt(container.getLeft().getOriginString()));
            this.top = String.valueOf(Integer.parseInt(container.getTop().getOriginString()));
            this.right = String.valueOf(Integer.parseInt(container.getRight().getOriginString()));
            this.bottom = String.valueOf(Integer.parseInt(container.getBottom().getOriginString()));
        }

        void addHeight(GDI_RECT rect) {
            int iHeight = Integer.parseInt(rect.bottom);
            this.bottom = String.valueOf(Integer.parseInt(this.bottom) + iHeight);
        }
    }

    private static class LOGFONT {
        long lfHeight;
        long lfWeight;
        byte lfItalic;
        byte lfUnderline;
        byte lfStrikeOut;

        private LOGFONT() {
        }
    }
}

