/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.file;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.data.modal.IDataDef;
import com.kingdee.cosmic.ctrl.data.modal.io.SerialTool;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.cosmic.ctrl.kdf.data.config.DBInfo;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.cosmic.ctrl.kdf.data.event.RequestDataListener;
import com.kingdee.cosmic.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.cosmic.ctrl.kdf.data.param.ReportParam;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.BaseFormBuilder;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.FormXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeDataService;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeServiceProvider;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeStyleService;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintInfo;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintInfoParsingException;
import com.kingdee.cosmic.ctrl.kdf.util.ObjectLoadUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.ContentService;
import com.kingdee.cosmic.ctrl.kdf.util.file.IDObject;
import com.kingdee.cosmic.ctrl.kdf.util.file.IOService;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlWriter;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class KDF
implements IOService,
ContentService,
RuntimeServiceProvider,
RuntimeStyleService,
RuntimeDataService {
    private static final Logger logger = LogUtil.getPackageLogger(KDF.class);
    private DocInfo docInfo;
    private HashMap forms;
    private List tables;
    private HashMap headers;
    private HashMap footers;
    private HashMap dbConns;
    private HashMap styleCache;
    private HashMap styleCache2;
    private int styleID;
    private HashMap dataSources;
    private HashMap dataObjects;
    private HashMap params;
    private KDFXmlWriter writer;
    private KDFXmlReader reader;
    private DataSetWrapperFactory dsFactory;
    private PrintInfo printInfo;
    private boolean designMode = false;
    IXmlTrans tableSetTrans;
    private HashMap userObjects;
    private IXmlTrans tableTrans;
    private HashMap transMap = new HashMap();
    private Object tablePrintSets;
    private IXmlElement kdtablePrintConfigElement;

    public static synchronized String getDefaultID() {
        return "ID" + System.currentTimeMillis();
    }

    public KDF() {
        this(new KDFXmlReader());
    }

    public void loadFile(String fileName) throws KDFException {
        KDFXmlReader reder = new KDFXmlReader(fileName);
        this.init(reder);
    }

    public KDF(String fileName) throws KDFException {
        this(new KDFXmlReader(fileName));
    }

    public KDF(InputStream byteStream) throws KDFException {
        this(new KDFXmlReader(byteStream));
    }

    public KDF(Reader reader) throws KDFException {
        this(new KDFXmlReader(reader));
    }

    public KDF(KDFXmlReader reader) {
        this.init(reader);
    }

    public KDF(String fileName, boolean isDesignMode) throws KDFException {
        this(new KDFXmlReader(fileName), isDesignMode);
    }

    public KDF(InputStream byteStream, boolean isDesignMode) throws KDFException {
        this(new KDFXmlReader(byteStream), isDesignMode);
    }

    public KDF(Reader reader, boolean isDesignMode) throws KDFException {
        this(new KDFXmlReader(reader), isDesignMode);
    }

    public KDF(KDFXmlReader reader, boolean isDesignMode) {
        this.designMode = isDesignMode;
        this.init(reader);
    }

    private void init(KDFXmlReader reader) {
        this.reader = reader;
    }

    private DocInfo getDocInfo() {
        if (this.docInfo == null) {
            this.docInfo = new DocInfo();
            if (this.reader != null) {
                this.docInfo.setAuthors(this.reader.getAuthors());
                this.docInfo.setVersion(this.reader.getVersion());
                this.docInfo.setCreated(this.reader.getCreatedTime());
                this.docInfo.setLastModified(this.reader.getLastModified());
                this.docInfo.setCompany(this.reader.getCompany());
            }
        }
        return this.docInfo;
    }

    @Override
    public String getVersion() {
        return this.getDocInfo().getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.getDocInfo().setVersion(version);
    }

    @Override
    public String[] getAuthors() {
        return this.getDocInfo().getAuthors();
    }

    @Override
    public void setAuthors(String[] authors) {
        this.getDocInfo().setAuthors(authors);
    }

    @Override
    public String getCompany() {
        return this.getDocInfo().getCompany();
    }

    @Override
    public void setCompany(String company) {
        this.getDocInfo().setCompany(company);
    }

    @Override
    public String getCreatedTime() {
        return this.getDocInfo().getCreated();
    }

    @Override
    public String getModifiedTime() {
        return this.getDocInfo().getLastModified();
    }

    @Override
    public String getEncoding() {
        return this.getDocInfo().getEncoding();
    }

    @Override
    public ContentService load(Reader reader) {
        this.clearHistory();
        this.init(new KDFXmlReader(reader));
        return this;
    }

    @Override
    public boolean save(Writer writer) {
        try {
            this.getSaveObject().save(writer);
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean save(OutputStream out) {
        try {
            this.getSaveObject().save(out);
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
            return false;
        }
        return true;
    }

    public void update() {
        try {
            this.getSaveObject();
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    private void clearHistory() {
        this.forms = null;
        this.tables = null;
        this.headers = null;
        this.footers = null;
        this.docInfo = null;
        this.clearStyleCache();
        this.dataSources = null;
        this.dataObjects = null;
        this.printInfo = null;
        this.writer = null;
        this.reader = null;
        this.dsFactory = null;
    }

    private KDFXmlWriter getSaveObject() throws KDFException {
        KDFXmlWriter writer = new KDFXmlWriter(this.getReader());
        writer.removeAllFormNodes();
        writer.removeAllStyleNodes();
        IXmlTrans formTrans = this.getFormXmlTrans();
        Iterator iterForm = this.getForms().iterator();
        while (iterForm.hasNext()) {
            IXmlElement formNode = formTrans.writeToNode(iterForm.next(), this);
            writer.addFormNode(formNode);
        }
        writer.removeAllTableNodes();
        IXmlTrans tableTrans = this.getTableTrans();
        Collection tables = this.getAllTable();
        Iterator iterTable = tables.iterator();
        while (iterTable.hasNext()) {
            IXmlElement tableNode = tableTrans.writeToNode(iterTable.next(), this);
            writer.addTableNode(tableNode);
        }
        IXmlTrans tableSetTrans = this.getTableSetTrans();
        IXmlElement tablePrintSetNode = tableSetTrans.writeToNode(this.getTablePrintSets(), this);
        if (tablePrintSetNode != null) {
            writer.removeAllTableSet();
            writer.addTablePrintSetNode(tablePrintSetNode);
        }
        if (this.headers != null) {
            writer.removeAllHeaderNodes();
            for (Page hd : this.headers.values()) {
                IXmlElement hdNode;
                if (formTrans instanceof FormXmlTrans) {
                    hdNode = ((FormXmlTrans)formTrans).writeToCustomNode("Header", hd, this);
                    hdNode.setAttribute("version", "3.1");
                } else {
                    hdNode = formTrans.writeToNode(hd, this);
                    hdNode.setName("Header");
                }
                writer.addHeaderNode(hdNode);
            }
        }
        if (this.footers != null) {
            writer.removeAllFooterNodes();
            for (Page ft : this.footers.values()) {
                IXmlElement ftNode;
                if (formTrans instanceof FormXmlTrans) {
                    ftNode = ((FormXmlTrans)formTrans).writeToCustomNode("Footer", ft, this);
                    ftNode.setAttribute("version", "3.1");
                } else {
                    ftNode = formTrans.writeToNode(ft, this);
                    ftNode.setName("Footer");
                }
                writer.addFooterNode(ftNode);
            }
        }
        StyleParser.writeStyles((IXmlElement)writer.getStylesNode(), this.getStyleCache().entrySet().iterator());
        if (this.docInfo != null) {
            writer.setAuthors(this.docInfo.getAuthors());
            writer.setVersion(this.docInfo.getVersion());
            writer.setCreateTime(this.docInfo.getCreated());
            writer.setCompany(this.docInfo.getCompany());
            writer.setLastModified(new Date().toString());
        }
        if (this.dataSources != null) {
            IXmlElement dss = writer.getDataSourcesNode();
            dss.removeChild(dss.getChild("DataSource"));
            for (DataSource ds : this.dataSources.values()) {
                dss.addChild(ds.writeToNode());
            }
        }
        if (this.dataObjects != null) {
            IXmlElement elmDataObjects = writer.getDataObjectsNode();
            elmDataObjects.getChildren().clear();
            for (IDataDef dataObj : this.dataObjects.values()) {
                IXmlElement elmDataObj = SerialTool.dataObj2Xml((IDataDef)dataObj);
                elmDataObjects.addChild(elmDataObj);
            }
        }
        if (this.dbConns != null) {
            IXmlElement dbcs = writer.getDBConnectionsNode();
            dbcs.removeChild(dbcs.getChild("DBConnection"));
            for (DBInfo dbi : this.dbConns.values()) {
                dbcs.addChild(dbi.writeToNode());
            }
        }
        if (this.printInfo != null) {
            writer.setPrintInfo(this.printInfo.store());
        }
        if (this.userObjects != null) {
            writer.setUserObjects(this.getUserObjectsNode());
        }
        if (this.kdtablePrintConfigElement != null) {
            writer.addElement(this.kdtablePrintConfigElement);
        }
        return writer;
    }

    private IXmlTrans getTableSetTrans() {
        if (this.tableSetTrans == null) {
            this.tableSetTrans = KDF.getDefaultTablePrintSetXmlTrans();
        }
        return this.tableSetTrans;
    }

    public void saveToFile(String fileName) {
        try {
            this.getSaveObject().save(fileName);
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public KDFXmlReader getReader() {
        if (this.reader == null) {
            this.reader = new KDFXmlReader();
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addSSA(ShareStyleAttributes ssa) {
        this.getStyleCache();
        HashMap hashMap = this.styleCache;
        synchronized (hashMap) {
            String key = (String)this.styleCache2.get(ssa);
            if (key == null) {
                key = this.getStyleID();
                this.styleCache.put(key, ssa);
                this.styleCache2.put(ssa, key);
            }
            return key;
        }
    }

    public ShareStyleAttributes getSSA(String key) {
        IXmlElement node;
        KDFXmlReader reader;
        this.getStyleCache();
        ShareStyleAttributes ssa = (ShareStyleAttributes)this.styleCache.get(key);
        if (ssa == null && (reader = this.getReader()) != null && (node = reader.getStyleNodeByID(key)) != null) {
            StyleAttributes sa = StyleParser.parseSA((IXmlElement)node);
            ssa = Styles.getSSA((StyleAttributes)sa);
            this.styleCache.put(key, ssa);
            this.styleCache2.put(ssa, key);
        }
        return ssa;
    }

    public void removeStyleAttribute(String key) {
        this.removeStyleCache(key);
    }

    public void clearStyleAttributes() {
        this.clearStyleCache();
    }

    private List getTablesMap() {
        if (this.tables == null) {
            this.tables = new ArrayList();
            List tableNodes = this.getReader().getTableNodes();
            if (tableNodes.size() > 0) {
                IXmlTrans tableTrans = this.getTableTrans();
                int nodeCount = tableNodes.size();
                for (int i = 0; i < nodeCount; ++i) {
                    Object tb = tableTrans.readFromNode((IXmlElement)tableNodes.get(i), this);
                    this.tables.add(tb);
                }
            }
        }
        return this.tables;
    }

    @Override
    public Collection getAllTable() {
        return this.getTablesMap();
    }

    @Override
    public String addTable(IDObject table) {
        this.getTablesMap().add(table);
        return table.getID();
    }

    @Override
    public Form getForm(String id) {
        return (Form)this.getFormsMap().get(id);
    }

    private HashMap getFormsMap() {
        if (this.forms == null) {
            this.forms = new HashMap();
            List formNodes = this.getReader().getFormNodes();
            if (formNodes.size() > 0) {
                IXmlTrans trans = this.getFormXmlTrans();
                if (trans instanceof FormXmlTrans) {
                    FormXmlTrans formTrans = (FormXmlTrans)trans;
                    formTrans.setDesignMode(this.designMode);
                    if (this.getPrintInfo().isSnapShot()) {
                        formTrans.setSnapMode(true);
                    }
                }
                for (int i = formNodes.size() - 1; i >= 0; --i) {
                    Form fm = (Form)trans.readFromNode((IXmlElement)formNodes.get(i), this);
                    if (fm == null) continue;
                    this.forms.put(fm.getId(), fm);
                }
            }
        }
        return this.forms;
    }

    @Override
    public Form removeForm(String id) {
        return (Form)this.getFormsMap().remove(id);
    }

    @Override
    public Collection getForms() {
        return this.getFormsMap().values();
    }

    @Override
    public String addForm(Form form) {
        if (form != null) {
            this.getFormsMap().put(form.getId(), form);
            return form.getId();
        }
        return null;
    }

    @Override
    public int clearForms() {
        int count = this.getFormsMap().size();
        this.getFormsMap().clear();
        return count;
    }

    private DataSetWrapperFactory getDsFactory() {
        if (null == this.dsFactory) {
            if (this.reader != null) {
                this.dsFactory = new DataSetWrapperFactory(this.reader.getDataSourceNodes(), this.getDBConnections(), this);
                this.dsFactory.setCommonParams(this.getReportParams());
            } else {
                this.dsFactory = new DataSetWrapperFactory();
                this.dsFactory.setCommonParams(this.getReportParams());
                this.dsFactory.setExtraDBInfo(this.getDBConnections());
            }
        }
        return this.dsFactory;
    }

    @Override
    public DataSetWrapper getDataSet(String id) {
        return this.getDsFactory().getDataSetWrapper(id);
    }

    @Override
    public DataSetWrapper[] getDataSets() {
        return this.getDsFactory().getDataSetWrappers();
    }

    @Override
    public void resetDataSets() {
        if (this.reader != null) {
            this.dsFactory = new DataSetWrapperFactory(this.reader.getDataSourceNodes(), this.getDBConnections(), this);
            this.dsFactory.setCommonParams(this.getReportParams());
        } else {
            this.dsFactory = new DataSetWrapperFactory();
            this.dsFactory.setCommonParams(this.getReportParams());
            this.dsFactory.setExtraDBInfo(this.getDBConnections());
        }
    }

    @Override
    public Object getReportParamValue(String paramID) {
        ReportParam rp = this.getReportParam(paramID);
        if (rp != null) {
            return new Variant(rp.getValue());
        }
        return Variant.nullVariant;
    }

    public String setReportParamValue(String paramID, Object value) {
        ReportParam rp = this.getReportParam(paramID);
        if (rp != null && !rp.setValue(new Variant(value))) {
            return rp.getHint();
        }
        return null;
    }

    @Override
    public void registerRequesetDataListener(String id, RequestDataListener listener) {
        this.getDsFactory().addRequesetDataListener(id, listener);
    }

    @Override
    public ShareStyleAttributes getStyleAttributes(String id) {
        IXmlElement styleNode;
        Object o = this.getStyleCache().get(id);
        if (o != null) {
            return (ShareStyleAttributes)o;
        }
        if (this.reader != null && null != (styleNode = this.reader.getStyleNodeByID(id))) {
            return StyleParser.parseSA((IXmlElement)styleNode);
        }
        return Styles.getEmptySSA();
    }

    @Override
    public String addStyleAttributes(ShareStyleAttributes ssa) {
        return this.addSSA(ssa);
    }

    public Dimension getDesignPrintableArea() {
        if (this.reader != null) {
            return this.getPrintInfo().getPrintBodyArea();
        }
        return new Dimension(1720, 2400);
    }

    public IXmlElement getPrinterInfoNode() {
        return this.getReader().getPrintInfoNode();
    }

    @Override
    public RuntimeStyleService getRuntimeStyleService() {
        return this;
    }

    @Override
    public RuntimeDataService getRuntimeDataService() {
        return this;
    }

    private HashMap getDataSourcesMap() {
        if (this.dataSources == null) {
            this.dataSources = new HashMap();
            List dss = this.getReader().getDataSourceNodes();
            for (IXmlElement dselm : dss) {
                DataSource ds = DataSource.buildFromNode(dselm, this);
                this.dataSources.put(ds.getID(), ds);
            }
        }
        return this.dataSources;
    }

    @Override
    public DataSource getDataSource(String id) {
        return (DataSource)this.getDataSourcesMap().get(id);
    }

    @Override
    public DataSource[] getDataSources() {
        return this.getDataSourcesMap().values().toArray(new DataSource[0]);
    }

    @Override
    public void removeDataSource(String id) {
        this.getDataSourcesMap().remove(id);
    }

    @Override
    public void addDataSource(DataSource ds) {
        if (ds != null) {
            this.getDataSourcesMap().put(ds.getID(), ds);
        }
    }

    @Override
    public void clearDataSources() {
        this.getDataSourcesMap().clear();
    }

    private HashMap getDBConnectionsMap() {
        if (this.dbConns == null) {
            this.dbConns = new HashMap();
            IXmlElement ele = this.getReader().getDBConnectionsNode();
            DBInfo[] dbis = DBInfo.parse(ele);
            for (int i = 0; i < dbis.length; ++i) {
                this.dbConns.put(dbis[i].id, dbis[i]);
            }
        }
        return this.dbConns;
    }

    @Override
    public DBInfo getDBConnection(String id) {
        return (DBInfo)this.getDBConnectionsMap().get(id);
    }

    @Override
    public DBInfo[] getDBConnections() {
        return this.getDBConnectionsMap().values().toArray(new DBInfo[0]);
    }

    @Override
    public void removeDBConnection(String id) {
        this.getDBConnectionsMap().remove(id);
    }

    @Override
    public void addDBConnection(DBInfo dbi) {
        if (dbi != null) {
            this.getDBConnectionsMap().put(dbi.id, dbi);
        }
    }

    @Override
    public void clearDBConnections() {
        this.getDBConnectionsMap().clear();
    }

    private HashMap getStyleCache() {
        if (this.styleCache == null) {
            this.styleCache = new HashMap();
            this.styleCache2 = new HashMap();
            this.styleID = 0;
        }
        return this.styleCache;
    }

    private void removeStyleCache(String id) {
        if (this.styleCache != null) {
            Object ssa = this.styleCache.get(id);
            this.styleCache.remove(id);
            this.styleCache2.remove(ssa);
        }
    }

    private void clearStyleCache() {
        if (this.styleCache != null) {
            this.styleCache.clear();
            this.styleCache2.clear();
            this.styleID = 0;
        }
    }

    private String getStyleID() {
        return String.valueOf(this.styleID++);
    }

    @Override
    public PrintInfo getPrintInfo() {
        if (this.printInfo == null) {
            try {
                this.printInfo = new PrintInfo(this.getReader().getPrintInfoNode());
            }
            catch (PrintInfoParsingException e) {
                logger.error((Object)"err", (Throwable)e);
                this.printInfo = new PrintInfo();
            }
        }
        return this.printInfo;
    }

    public void setPrintInfo(PrintInfo info) {
        this.printInfo = info;
    }

    private HashMap getHeadersMap() {
        if (this.headers == null) {
            this.headers = new HashMap();
            List hds = this.getReader().getHeaderNodes();
            BaseFormBuilder bfb = new BaseFormBuilder();
            for (IXmlElement hdelm : hds) {
                Page hd = bfb.createPage(this, hdelm);
                this.headers.put(hd.getId(), hd);
            }
        }
        return this.headers;
    }

    @Override
    public Page getHeader(String id) {
        return (Page)this.getHeadersMap().get(id);
    }

    @Override
    public Page[] getHeaders() {
        return this.getHeadersMap().values().toArray(new Page[0]);
    }

    @Override
    public void removeHeader(String id) {
        this.getHeadersMap().remove(id);
    }

    @Override
    public void addHeader(Page header) {
        if (header != null) {
            this.getHeadersMap().put(header.getId(), header);
        }
    }

    @Override
    public void clearHeaders() {
        this.getHeadersMap().clear();
    }

    private HashMap getFootersMap() {
        if (this.footers == null) {
            this.footers = new HashMap();
            List fts = this.getReader().getFooterNodes();
            BaseFormBuilder bfb = new BaseFormBuilder();
            for (IXmlElement ftelm : fts) {
                Page ft = bfb.createPage(this, ftelm);
                this.footers.put(ft.getId(), ft);
            }
        }
        return this.footers;
    }

    @Override
    public Page getFooter(String id) {
        return (Page)this.getFootersMap().get(id);
    }

    @Override
    public Page[] getFooters() {
        return this.getFootersMap().values().toArray(new Page[0]);
    }

    @Override
    public void removeFooter(String id) {
        this.getFootersMap().remove(id);
    }

    @Override
    public void addFooter(Page footer) {
        if (footer != null) {
            this.getFootersMap().put(footer.getId(), footer);
        }
    }

    @Override
    public void clearFooters() {
        this.getFootersMap().clear();
    }

    public KDFXmlWriter getWriter() throws KDFException {
        if (this.writer == null) {
            this.writer = new KDFXmlWriter(this.reader);
        }
        return this.writer;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }

    public boolean isDesignMode() {
        return this.designMode;
    }

    public HashMap getUserObjects() {
        if (this.userObjects == null) {
            this.userObjects = new HashMap();
            IXmlElement userObjectsNode = this.getReader().getUserObjectsNode();
            this.putUserObjectsNode(userObjectsNode);
        }
        return this.userObjects;
    }

    public void addUserObject(String key, Object value) {
        this.getUserObjects().put(key, value);
    }

    public Object getUserObject(String key) {
        return this.getUserObjects().get(key);
    }

    public Object removeUserObject(String key) {
        return this.getUserObjects().remove(key);
    }

    private IXmlElement getUserObjectsNode() {
        if (this.userObjects == null) {
            return null;
        }
        IXmlElement pNode = XmlUtil.createNode((String)"UserObjects");
        for (Map.Entry entry : this.userObjects.entrySet()) {
            String value = ObjectUtil.objectToString(entry.getValue());
            if (value == null) continue;
            IXmlElement e = XmlUtil.createNode((String)"UserObject");
            e.setAttribute("key", (String)entry.getKey());
            e.addCData(value);
            pNode.addChild(e);
        }
        return pNode;
    }

    private void putUserObjectsNode(IXmlElement uosNode) {
        if (uosNode == null) {
            return;
        }
        for (IXmlElement uoNode : uosNode.searchChildren("UserObject")) {
            String key = uoNode.getAttribute("key");
            Object value = ObjectUtil.stringToObject((String)uoNode.getText());
            if (key == null || value == null) continue;
            this.addUserObject(key, value);
        }
    }

    public IXmlTrans getTableTrans() {
        if (this.tableTrans == null) {
            this.tableTrans = KDF.getDefaultTableXmlTrans();
        }
        return this.tableTrans;
    }

    public void setTableTrans(IXmlTrans tableTrans) {
        this.tableTrans = tableTrans;
    }

    public void registXmlTrans(String tagName, IXmlTrans trans) {
        this.transMap.put(tagName, trans);
    }

    public void removeXmlTrans(String tagName) {
        this.transMap.remove(tagName);
    }

    public IXmlTrans getXmlTrans(String tagName) {
        return (IXmlTrans)this.transMap.get(tagName);
    }

    private IXmlTrans getFormXmlTrans() {
        IXmlTrans trans = this.getXmlTrans("Form");
        if (trans == null) {
            trans = new FormXmlTrans();
        }
        return trans;
    }

    private HashMap getReportParamMap() {
        if (this.params == null) {
            this.params = new HashMap();
            for (IXmlElement elm : this.getReader().getParamNodes()) {
                ReportParam rp = ReportParam.readFromNode(elm);
                rp.setRuntimeDataService(this);
                this.params.put(rp.getId(), rp);
            }
        }
        return this.params;
    }

    @Override
    public ReportParam getReportParam(String id) {
        return (ReportParam)this.getReportParamMap().get(id);
    }

    @Override
    public ReportParam[] getReportParams() {
        return this.getReportParamMap().values().toArray(new ReportParam[0]);
    }

    @Override
    public void removeReportParam(String id) {
        this.getReportParamMap().remove(id);
    }

    @Override
    public void addReportParam(ReportParam param) {
        if (param != null) {
            param.setRuntimeDataService(this);
            this.getReportParamMap().put(param.getId(), param);
        }
    }

    @Override
    public void clearReprotParams() {
        this.getReportParamMap().clear();
    }

    public Object getTablePrintSets() {
        if (this.tablePrintSets == null) {
            this.tablePrintSets = KDF.getDefaultTablePrintSetsXmlTrans();
            IXmlElement root = this.getReader().getRoot();
            List tableprintNodes = root.searchChildren("TablePrintSets");
            if (tableprintNodes.size() > 0) {
                IXmlTrans tableTrans = this.getTableSetTrans();
                this.tablePrintSets = tableTrans.readFromNode((IXmlElement)tableprintNodes.get(0), this);
            }
        }
        return this.tablePrintSets;
    }

    private HashMap getDataObjectsMap() {
        if (this.dataObjects == null) {
            this.dataObjects = new HashMap();
            List dos = this.getReader().getDataObjectNodes();
            Iterator itr = dos.iterator();
            while (itr.hasNext()) {
                IDataDef dataObj = SerialTool.xml2DataObj((IXmlElement)((IXmlElement)itr.next()));
                if (dataObj == null) continue;
                this.dataObjects.put(dataObj.getName(), dataObj);
            }
        }
        return this.dataObjects;
    }

    public IDataDef getDataObject(String id) {
        return (IDataDef)this.getDataObjectsMap().get(id);
    }

    public IDataDef[] getDataObjects() {
        return this.getDataObjectsMap().values().toArray(new IDataDef[0]);
    }

    public void removeDataObject(String id) {
        this.getDataObjectsMap().remove(id);
    }

    public void addDataObject(IDataDef dataObj) {
        if (dataObj != null) {
            this.getDataObjectsMap().put(dataObj.getName(), dataObj);
        }
    }

    public void clearDataObjects() {
        this.getDataObjectsMap().clear();
    }

    public void setKDTableNewPrintConfig(IXmlElement element) {
        this.kdtablePrintConfigElement = element;
    }

    public IXmlElement getKDTableNewPrintConfig(String name) {
        if (this.kdtablePrintConfigElement == null) {
            this.kdtablePrintConfigElement = this.getReader().getElement(name);
        }
        return this.kdtablePrintConfigElement;
    }

    static IXmlTrans getDefaultTablePrintSetXmlTrans() {
        return (IXmlTrans)ObjectLoadUtil.loadObject("com.kingdee.cosmic.ctrl.kdf.table.KDTablePrintSetXmlTrans");
    }

    static IXmlTrans getDefaultTableXmlTrans() {
        return (IXmlTrans)ObjectLoadUtil.loadObject("com.kingdee.cosmic.ctrl.kdf.table.KDTableXmlTrans");
    }

    static Object getDefaultTablePrintSetsXmlTrans() {
        return ObjectLoadUtil.loadObject("com.kingdee.cosmic.ctrl.kdf.table.TablePrintSets");
    }

    static final class DocInfo {
        private String version;
        private String encoding;
        private String created;
        private String lastModified;
        private String[] authors;
        private String company;

        DocInfo() {
        }

        public String[] getAuthors() {
            if (null == this.authors) {
                this.authors = new String[0];
            }
            return this.authors;
        }

        public String getCreated() {
            return this.created;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getVersion() {
            return this.version;
        }

        public void setAuthors(String[] strings) {
            this.authors = strings;
        }

        public void setCreated(String string) {
            this.created = string;
        }

        public void setLastModified(String string) {
            this.lastModified = string;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getCompany() {
            return this.company;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setCompany(String string) {
            this.company = string;
        }

        public void setEncoding(String string) {
            this.encoding = string;
        }
    }
}

