/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.file;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlException;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KDFXmlReader {
    private static final Logger logger = LogUtil.getPackageLogger(KDFXmlReader.class);
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected InputStream source;
    protected IXmlElement doc;
    protected IXmlElement root;
    protected String encode;
    protected HashMap styleNodeBuf;

    protected KDFXmlReader() {
        String strTime = new Date().toString();
        String initSource = "<?xml version=\"1.0\" encoding=\"UNICODE\"?><DocRoot xmlns=\"http://www.kingdee.com/Common\" xmlns=\"http://www.kingdee.com/Form\" xmlns=\"http://www.kingdee.com/Table\" xmlns=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"0.0\"><DocInfo><Author>null</Author><Created>" + strTime + "</Created><Company>kingdee.com</Company><LastModified>" + strTime + "</LastModified></DocInfo><DataSources/><DataObjects/><Styles/></DocRoot>";
        try {
            this.source = new ByteArrayInputStream(initSource.getBytes("utf-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KDFXmlReader(InputStream byteStream) {
        this.source = byteStream;
        this.bufStyleNodes();
    }

    public KDFXmlReader(Reader reader) {
        try {
            char[] chrText = new char[1024];
            int len = 0;
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(chrText, 0, chrText.length)) != -1) {
                sb.append(chrText, 0, len);
            }
            this.source = new ByteArrayInputStream(sb.toString().getBytes("utf-8"));
            this.bufStyleNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KDFXmlReader(String fileName) throws KDFXmlException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(FilenameUtils.normalize((String)fileName));
            this.source = fis;
        }
        catch (FileNotFoundException err) {
            try {
                throw new KDFXmlException("File [" + fileName + "] loading failed", err, fileName);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        this.bufStyleNodes();
    }

    public final IXmlElement getDoc() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            this.doc = XmlUtil.loadRootElement((InputStream)this.source);
        }
        catch (XmlParsingException | IOException e) {
            e.printStackTrace();
        }
        return this.doc;
    }

    public final IXmlElement getRoot() {
        if (this.root == null) {
            IXmlElement doc = this.getDoc();
            if (doc == null) {
                throw new AssertionError((Object)"Failed get doc");
            }
            this.root = doc;
        }
        return this.root;
    }

    public final IXmlElement getDocInfoNode() {
        IXmlElement nodeDocInfo = this.getRoot().getChild("DocInfo");
        if (null == nodeDocInfo) {
            nodeDocInfo = XmlUtil.createNode((String)"DocInfo");
            this.getRoot().addChild(nodeDocInfo);
        }
        return nodeDocInfo;
    }

    public final String getVersion() {
        return this.getRoot().getAttribute("version");
    }

    public final String[] getAuthors() {
        IXmlElement docInfoNode = this.getDocInfoNode();
        List listAuthors = docInfoNode.searchChildren("Author");
        if (null == listAuthors || listAuthors.size() < 1) {
            return new String[0];
        }
        String[] authors = new String[listAuthors.size()];
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = ((IXmlElement)listAuthors.get(i)).getText().trim();
        }
        return authors;
    }

    public final String getCompany() {
        IXmlElement docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChild("Company").getText();
    }

    public final String getCreatedTime() {
        IXmlElement docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChild("Created").getText();
    }

    public final String getLastModified() {
        IXmlElement docInfoNode = this.getDocInfoNode();
        return docInfoNode.getChild("LastModified").getText();
    }

    public final IXmlElement getDBConnectionsNode() {
        IXmlElement nodeDBS = this.getRoot().getChild("DBConnections");
        if (null == nodeDBS) {
            nodeDBS = XmlUtil.createNode((String)"DBConnections");
            this.getRoot().addChild(nodeDBS);
        }
        return nodeDBS;
    }

    public final List getDBConnectionNodes() {
        return this.getDBConnectionsNode().getChildren();
    }

    public final IXmlElement getDataSourcesNode() {
        IXmlElement nodeDS = this.getRoot().getChild("DataSources");
        if (null == nodeDS) {
            nodeDS = XmlUtil.createNode((String)"DataSources");
            this.getRoot().addChild(nodeDS);
        }
        return nodeDS;
    }

    public final List getDataSourceNodes() {
        return this.getDataSourcesNode().getChildren();
    }

    public final IXmlElement getStylesNode() {
        IXmlElement nodeStyles = this.getRoot().getChild("Styles");
        if (null == nodeStyles) {
            nodeStyles = XmlUtil.createNode((String)"Styles");
            this.getRoot().addChild(nodeStyles);
        }
        return nodeStyles;
    }

    public final List getStyleNodes() {
        return this.getStylesNode().getChildren();
    }

    public final IXmlElement getParamsNode() {
        IXmlElement nodeParams = this.getRoot().getChild("Params");
        if (null == nodeParams) {
            nodeParams = XmlUtil.createNode((String)"Params");
            this.getRoot().addChild(nodeParams);
        }
        return nodeParams;
    }

    public final List getParamNodes() {
        return this.getParamsNode().getChildren();
    }

    public final IXmlElement getPageSetupNode() {
        return this.getPrintInfoNode().getChild("PageSetup");
    }

    public final IXmlElement getPrintInfoNode() {
        IXmlElement nodePrinter = this.getRoot().getChild("PrintInfo");
        if (null == nodePrinter) {
            nodePrinter = XmlUtil.createNode((String)"PrintInfo");
            this.getRoot().addChild(nodePrinter);
        }
        return nodePrinter;
    }

    public final IXmlElement getHeadersNode() {
        IXmlElement nodeHeaders = this.getRoot().getChild("Headers");
        if (null == nodeHeaders) {
            nodeHeaders = XmlUtil.createNode((String)"Headers");
            this.getRoot().addChild(nodeHeaders);
        }
        return nodeHeaders;
    }

    public final List getHeaderNodes() {
        return this.getHeadersNode().getChildren();
    }

    public final IXmlElement getFootersNode() {
        IXmlElement nodeFooters = this.getRoot().getChild("Footers");
        if (null == nodeFooters) {
            nodeFooters = XmlUtil.createNode((String)"Footers");
            this.getRoot().addChild(nodeFooters);
        }
        return nodeFooters;
    }

    public final List getFooterNodes() {
        return this.getFootersNode().getChildren();
    }

    public final List getFormNodes() {
        return this.getRoot().searchChildren("Form");
    }

    public final List getTableNodes() {
        return this.getRoot().searchChildren("Table");
    }

    public final IXmlElement getStyleNodeByID(String id) {
        return (IXmlElement)this.styleNodeBuf.get(id);
    }

    private final void bufStyleNodes() {
        StyleParser.upgrade((IXmlElement)this.getRoot().getChild("Styles"));
        this.styleNodeBuf = new HashMap();
        List listStyleNodes = this.getStyleNodes();
        for (IXmlElement node : listStyleNodes) {
            String strID = node.getAttribute("id");
            this.styleNodeBuf.put(strID, node);
        }
    }

    public final HashMap getStyleNodeBuf() {
        return this.styleNodeBuf;
    }

    public static final String readNodeSource(IXmlElement node) {
        if (null == node) {
            return "";
        }
        return XmlUtil.toString((IXmlElement)node);
    }

    public static final String readNodeContentSource(IXmlElement node) {
        if (null == node) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IXmlElement next : node.getChildren()) {
            sb.append(XmlUtil.toString((IXmlElement)next));
        }
        return sb.toString();
    }

    public IXmlElement getUserObjectsNode() {
        return this.getRoot().getChild("UserObjects");
    }

    public final IXmlElement getDataObjectsNode() {
        IXmlElement node = this.getRoot().getChild("DataObjects");
        if (null == node) {
            node = XmlUtil.createNode((String)"DataObjects");
            this.getRoot().addChild(node);
        }
        return node;
    }

    public final List getDataObjectNodes() {
        return this.getDataObjectsNode().getChildren();
    }

    public IXmlElement getElement(String name) {
        return this.getRoot().getChild(name);
    }
}

