/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.file;

import com.kingdee.cosmic.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.cosmic.ctrl.common.util.ZipUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import com.kingdee.cosmic.ctrl.kdf.util.file.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ZipKDF {
    private static Logger logger = com.kingdee.cosmic.ctrl.common.util.LogUtil.getLogger(ZipKDF.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KDF unpack(byte[] source) throws IOException, KDFException {
        LogUtil.print("ZipUtil.unpack()," + CtrlKDFMessages.getMLS("zipUtilUnpack", "\u5c06\u538b\u7f29\u6d41\u8f6c\u6210KDF\u5bf9\u8c61"));
        try (InputStream is = ZipUtil.unpack((byte[])source);){
            KDF kDF = new KDF(is);
            return kDF;
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static byte[] pack(KDF kdf) throws IOException {
        LogUtil.print("ZipUtil.pack()," + CtrlKDFMessages.getMLS("zipUtilPack", "\u5c06KDF\u5bf9\u8c61\u8f6c\u6210\u538b\u7f29\u6d41"));
        SectionByteOutputStream os = new SectionByteOutputStream();
        kdf.save((OutputStream)os);
        return ZipUtil.pack((SectionByteOutputStream)os);
    }

    public static byte[] pppack(KDF kdf) throws IOException {
        LogUtil.print("ZipUtil.pack()," + CtrlKDFMessages.getMLS("zipUtilPack", "\u5c06KDF\u5bf9\u8c61\u8f6c\u6210\u538b\u7f29\u6d41"));
        SectionByteOutputStream os = new SectionByteOutputStream();
        kdf.save((OutputStream)os);
        return ZipUtil.pppack((SectionByteOutputStream)os);
    }

    public static byte[] pack2(KDF kdf) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            kdf.save(os);
            byte[] byArray = ZipUtil.pack((ByteArrayOutputStream)os);
            return byArray;
        }
    }

    public static KDF unpack2(byte[] source) throws IOException, KDFException {
        KDF kDF;
        InputStream is = null;
        try {
            is = ZipUtil.unpack2((byte[])source);
            kDF = new KDF(is);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        return kDF;
    }
}

