/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.print;

import com.kingdee.cosmic.ctrl.kdf.util.DimensionDouble;
import com.kingdee.cosmic.ctrl.kdf.util.print.BasicGridPageArea;
import com.kingdee.cosmic.ctrl.kdf.util.print.IContentGrid;
import com.kingdee.cosmic.ctrl.kdf.util.print.IGridPagination;
import java.util.ArrayList;
import java.util.List;

public class CommonGridPager
implements IGridPagination {
    static final double E = 0.01;

    @Override
    public List getPageAreaList(IContentGrid[] grids, int sectSpace, DimensionDouble area) {
        ArrayList listPages = new ArrayList();
        for (int i = 0; i < grids.length; ++i) {
            listPages.addAll(this.getPageAreaList(grids[i], area));
        }
        return listPages;
    }

    @Override
    public List getPageAreaList(IContentGrid grid, DimensionDouble area) {
        ArrayList<BasicGridPageArea> alPages = new ArrayList<BasicGridPageArea>();
        int[] alColDiv = this.getColDiv(grid, area.width);
        int[] alRowDiv = this.getRowDiv(grid, area.height);
        for (int i = 0; i < alRowDiv.length - 1; ++i) {
            for (int j = 0; j < alColDiv.length - 1; ++j) {
                BasicGridPageArea page = new BasicGridPageArea();
                BasicGridPageArea.PageSect sect = new BasicGridPageArea.PageSect(grid, alRowDiv[i], alRowDiv[i + 1], alColDiv[j], alColDiv[j + 1]);
                page.addSect(sect);
                alPages.add(page);
            }
        }
        return alPages;
    }

    private int[] getColDiv(IContentGrid grid, double pageWidth) {
        int colCount = grid.getColumnCount();
        ArrayList<Integer> alColDiv = new ArrayList<Integer>();
        double fWidth = 0.0;
        alColDiv.add(0);
        int iLast = 0;
        for (int i = 0; i < colCount; ++i) {
            if ((fWidth += (double)grid.getColumnWidth(i)) >= pageWidth + 0.01) {
                if (i == iLast) {
                    // empty if block
                }
                iLast = ++i;
                alColDiv.add(i);
                fWidth = grid.getColumnWidth(i);
            }
            if (!grid.isPageBreakColumn(i + 1)) continue;
            iLast = i + 1;
            alColDiv.add(iLast);
        }
        alColDiv.add(colCount);
        Object[] objs = alColDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }

    private int[] getRowDiv(IContentGrid grid, double pageHeight) {
        int rowCount = grid.getRowCount();
        ArrayList<Integer> alRowDiv = new ArrayList<Integer>();
        alRowDiv.add(0);
        double fHeight = 0.0;
        int iLast = 0;
        for (int i = 0; i < rowCount; ++i) {
            if ((fHeight += (double)grid.getRowHeight(i)) >= pageHeight + 0.01) {
                if (i == iLast) {
                    // empty if block
                }
                iLast = ++i;
                alRowDiv.add(i);
                fHeight = grid.getRowHeight(i);
            }
            if (!grid.isPageBreakRow(i + 1)) continue;
            iLast = i + 1;
            alRowDiv.add(iLast);
        }
        alRowDiv.add(rowCount);
        Object[] objs = alRowDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }
}

