/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.servertable;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.servertable.ICell;
import com.kingdee.cosmic.ctrl.kdf.servertable.IColumn;
import com.kingdee.cosmic.ctrl.kdf.servertable.IRow;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTDataStyle;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTHead;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.servertable.KDTScriptManager;
import com.kingdee.cosmic.ctrl.kdf.servertable.ScriptContext;
import com.kingdee.cosmic.ctrl.kdf.util.Tools;
import java.util.ArrayList;
import java.util.List;

public class KDTable {
    public static final long beginDate = System.currentTimeMillis();
    private String ID;
    private KDTHead head;
    private KDTBody body;
    private KDTColumns columns;
    private int rowCount = -1;
    private int verticalCount = 2;
    private int horizonCount = 3;
    protected KDTScriptManager scriptManager;
    protected ScriptContext scriptHelper;
    private int defaultHeadRowHeight = 22;
    private int defaultRowHeight = 20;
    private int defaultColumnWidth = 100;
    private boolean verticalHeadGridLineVisible = true;
    private boolean horizonHeadGridLineVisible = true;
    private boolean verticalGridLineVisible = true;
    private boolean horizonGridLineVisible = true;
    private int cellDisplayMode = 0;
    private int activeCellStatus = 0;
    private Object userObject;
    private static boolean debug = false;
    private int formulaMode = 0;
    private boolean scriptAutoRun = true;

    public KDTable() {
        KDTable.printDebugInfo("initialize begin" + (System.currentTimeMillis() - beginDate));
        this.initialize();
        KDTable.printDebugInfo("initialize agfter" + (System.currentTimeMillis() - beginDate));
    }

    public void repaint() {
    }

    public KDTable(int colCount, int headRowCount, int bodyRowCount) {
        this.initialize();
        this.createBlankTable(colCount, headRowCount, bodyRowCount);
    }

    public void createBlankTable(int colCount, int headRowCount, int bodyRowCount) {
        this.addColumns(colCount);
        this.addHeadRows(headRowCount);
        this.addRows(bodyRowCount);
    }

    private void initialize() {
        this.head = new KDTHead(this);
        KDTable.printDebugInfo("KDTHead" + (System.currentTimeMillis() - beginDate));
        this.body = new KDTBody(this);
        KDTable.printDebugInfo("KDTBody" + (System.currentTimeMillis() - beginDate));
        this.columns = new KDTColumns(this);
        KDTable.printDebugInfo("KDTColumns" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTTreeColumn" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTIndexColumn" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTCorner" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTDataRequestManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTViewManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTLayoutManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTSelectManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTMergeManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTGroupManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTIOManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("KDTEditManager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("create Manager" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("create style" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("create render" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("create editor" + (System.currentTimeMillis() - beginDate));
        this.setID(KDTable.getDefaultID());
        KDTable.printDebugInfo("create keybournd" + (System.currentTimeMillis() - beginDate));
    }

    private void reInitialize() {
        if (this.scriptManager != null) {
            this.scriptManager.removeAll();
        }
    }

    private static synchronized String getDefaultID() {
        return "KDT" + System.currentTimeMillis();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public int getHeadRowCount() {
        return this.getHead().size();
    }

    public void setHeadRowCount(int headRowCount) {
    }

    public int getRowCount() {
        return this.getBody().size();
    }

    int getRowCount1() {
        return this.getBody().size();
    }

    int getRowCount2() {
        return this.rowCount;
    }

    int getRowCount3() {
        return this.getBody().size();
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public void setColumnCount(int columnCount) {
    }

    public KDTHead getHead() {
        return this.head;
    }

    public KDTBody getBody() {
        return this.body;
    }

    public KDTColumns getColumns() {
        return this.columns;
    }

    public String getColumnKey(int colIndex) {
        return this.columns.getColumnKey(colIndex);
    }

    public int getColumnIndex(String key) {
        return this.columns.getColumnIndex(key);
    }

    public synchronized int getVerticalCount() {
        return this.verticalCount;
    }

    public synchronized void setVerticalCount(int verticalCount) {
        this.verticalCount = verticalCount;
    }

    public synchronized int getHorizonCount() {
        return this.horizonCount;
    }

    public synchronized void setHorizonCount(int horizonCount) {
        this.horizonCount = horizonCount;
    }

    public KDTScriptManager getScriptManager() {
        if (this.scriptManager == null) {
            this.scriptManager = new KDTScriptManager(this);
        }
        return this.scriptManager;
    }

    public ScriptContext getScriptContext() {
        if (this.scriptHelper == null) {
            this.scriptHelper = new ScriptContext(this);
        }
        return this.scriptHelper;
    }

    public RelationsListener getRelationsListener() {
        return this.getScriptContext();
    }

    public int getExpandedColumnCount() {
        int i;
        int exRowCount = this.getExpandedRowCount();
        int exColumnCount = 0;
        List cols = this.columns.getColumns();
        for (i = cols.size() - 1; i >= 0; --i) {
            KDTColumn col = (KDTColumn)cols.get(i);
            if (col == null || col.isEmpty()) continue;
            exColumnCount = i + 1;
        }
        block1: for (i = 0; i < exRowCount; ++i) {
            KDTRow row = this.body.getRow2(i);
            ArrayList l = row.getCells();
            for (int j = l.size(); j >= exColumnCount; --j) {
                KDTCell cell = row.getCell(j);
                if (cell == null || cell.isEmpty()) continue;
                exColumnCount = j + 1;
                continue block1;
            }
        }
        return exColumnCount;
    }

    public int getExpandedRowCount() {
        List rows = this.body.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            KDTRow row = (KDTRow)rows.get(i);
            if (row == null || row.isEmpty()) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean isHorizonHeadGridLineVisible() {
        return this.horizonHeadGridLineVisible;
    }

    public void setHorizonHeadGridLineVisible(boolean horizonHeadGridLineVisible) {
        this.horizonHeadGridLineVisible = horizonHeadGridLineVisible;
        this.repaint();
    }

    public boolean isVerticalHeadGridLineVisible() {
        return this.verticalHeadGridLineVisible;
    }

    public void setVerticalHeadGridLineVisible(boolean verticalHeadGridLineVisible) {
        this.verticalHeadGridLineVisible = verticalHeadGridLineVisible;
        this.repaint();
    }

    public boolean isHorizonGridLineVisible() {
        return this.horizonGridLineVisible;
    }

    public void setHorizonGridLineVisible(boolean horizonGridLineVisible) {
        this.horizonGridLineVisible = horizonGridLineVisible;
        this.repaint();
    }

    public boolean isVerticalGridLineVisible() {
        return this.verticalGridLineVisible;
    }

    public void setVerticalGridLineVisible(boolean verticalGridLineVisible) {
        this.verticalGridLineVisible = verticalGridLineVisible;
        this.repaint();
    }

    public int getActiveCellStatus() {
        return this.activeCellStatus;
    }

    public void setActiveCellStatus(int activeCellStatus) {
        this.activeCellStatus = activeCellStatus;
    }

    public int getCellDisplayMode() {
        return this.cellDisplayMode;
    }

    public void setCellDisplayMode(int cellDisplayMode) {
        this.cellDisplayMode = cellDisplayMode;
        this.repaint();
    }

    public int getDefaultHeadRowHeight() {
        return this.defaultHeadRowHeight;
    }

    public void setDefaultHeadRowHeight(int height) {
        this.defaultHeadRowHeight = height;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int height) {
        this.defaultRowHeight = height;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void refresh() {
        this.removeRows();
    }

    public IColumn addColumn() {
        return this.addColumn(this.columns.size());
    }

    public IColumn addColumn(int colIndex) {
        KDTColumn column = new KDTColumn();
        return this.addColumn(colIndex, column);
    }

    public IColumn addColumn(int colIndex, IColumn column) {
        return this.addColumn(colIndex, column.getKDTColumn());
    }

    IColumn addColumn(int colIndex, KDTColumn column) {
        KDTRow row;
        int i;
        this.columns.addColumn(colIndex, column);
        for (i = 0; i < this.head.size(); ++i) {
            row = this.head.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, null);
        }
        for (i = 0; i < this.body.size(); ++i) {
            row = this.body.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, null);
        }
        if (this.scriptManager != null) {
            this.scriptManager.adjustInsertCol(colIndex);
        }
        return new XColumn(colIndex, column);
    }

    public void addColumns(int colCount) {
        for (int i = 0; i < colCount; ++i) {
            this.addColumn();
        }
    }

    public IRow addRow() {
        return this.addRow(this.body.size());
    }

    public IRow addRow(int rowIndex) {
        KDTRow row = new KDTRow(this.getColumnCount());
        return this.addRow(rowIndex, row);
    }

    public IRow addRow(int rowIndex, IRow row) {
        return this.addRow(rowIndex, row.getKDTRow());
    }

    IRow addRow(int rowIndex, KDTRow row) {
        this.body.addRow(rowIndex, row);
        if (this.scriptManager != null) {
            this.scriptManager.adjustInsertRow(rowIndex);
        }
        return new XRow(rowIndex, 1, row);
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    public IRow addHeadRow() {
        return this.addHeadRow(this.head.size());
    }

    public IRow addHeadRow(int rowIndex) {
        KDTRow row = new KDTRow(this.getColumnCount());
        return this.addHeadRow(rowIndex, row);
    }

    public IRow addHeadRow(int rowIndex, IRow row) {
        return this.addHeadRow(rowIndex, row.getKDTRow());
    }

    IRow addHeadRow(int rowIndex, KDTRow row) {
        this.head.addRow(rowIndex, row);
        return new XRow(rowIndex, 0, row);
    }

    public void addHeadRows(int headRowCount) {
        for (int i = 0; i < headRowCount; ++i) {
            this.addHeadRow();
        }
    }

    public IColumn removeColumn(int colIndex) {
        KDTRow row;
        int i;
        if (colIndex < 0 || colIndex >= this.columns.size()) {
            return null;
        }
        KDTColumn column = this.columns.removeColumn(colIndex);
        for (i = 0; i < this.head.size(); ++i) {
            row = this.head.getRow2(i);
            if (row == null) continue;
            row.removeCell(colIndex);
        }
        for (i = 0; i < this.body.size(); ++i) {
            row = this.body.getRow2(i);
            if (row == null) continue;
            row.removeCell(colIndex);
        }
        if (this.scriptManager != null) {
            this.scriptManager.adjustDeleteCol(colIndex);
        }
        return new XColumn(colIndex, column);
    }

    public void removeColumns() {
        this.reInitialize();
        this.body.removeRows();
        this.head.removeRows();
        this.columns.removeColumns();
        this.setRowCount(0);
    }

    public IRow removeRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.body.size()) {
            return null;
        }
        KDTRow row = this.body.removeRow(rowIndex);
        if (this.scriptManager != null) {
            this.scriptManager.adjustDeleteRow(rowIndex);
        }
        return new XRow(rowIndex, 1, row);
    }

    public void removeRows() {
        this.removeRows(true);
    }

    public void removeRows(boolean autoRefreshData) {
        this.reInitialize();
        this.body.removeRows();
        if (autoRefreshData) {
            this.setRowCount(-1);
        } else {
            this.setRowCount(0);
        }
    }

    public IRow removeHeadRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.head.size()) {
            return null;
        }
        KDTRow row = this.head.removeRow(rowIndex);
        return new XRow(rowIndex, 0, row);
    }

    public void removeHeadRows() {
        this.head.removeRows();
    }

    public IColumn getColumn(int colIndex) {
        KDTColumn column = this.columns.getColumn(colIndex);
        if (column == null) {
            return null;
        }
        return new XColumn(colIndex, column);
    }

    public IColumn getColumn(String key) {
        int colIndex = this.columns.getColumnIndex(key);
        KDTColumn column = this.columns.getColumn(colIndex);
        if (column == null) {
            return null;
        }
        return new XColumn(colIndex, column);
    }

    public IRow getRow(int rowIndex) {
        KDTRow row = this.body.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 1, row);
    }

    public IRow getHeadRow(int rowIndex) {
        KDTRow row = this.head.getRow2(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 0, row);
    }

    public ICell getCell(int rowIndex, int colIndex) {
        IRow row = this.getRow(rowIndex);
        if (row != null) {
            return row.getCell(colIndex);
        }
        return null;
    }

    public ICell getCell(int rowIndex, String colKey) {
        int colIndex = this.columns.getColumnIndex(colKey);
        return this.getCell(rowIndex, colIndex);
    }

    KDTCell createBlankCell(int rowIndex, int colIndex) {
        KDTCell cell = new KDTCell();
        KDTRow row = this.getBody().getRow(rowIndex);
        row.setCell(colIndex, cell);
        return cell;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        KDTable.debug = debug;
    }

    public static void printDebugInfo(String info) {
    }

    public int getFormulaMode() {
        return this.formulaMode;
    }

    public void setFormulaMode(int formula) {
        this.formulaMode = formula;
    }

    boolean isScriptAutoRun() {
        return this.scriptAutoRun;
    }

    void setScriptAutoRun(boolean scriptAutoRun) {
        this.scriptAutoRun = scriptAutoRun;
    }

    class XCell
    implements ICell {
        KDTCellIndex index = new KDTCellIndex();
        private KDTCell cell;

        public XCell(int rowIndex, int colIndex, int type, KDTCell cell) {
            this.index.setRowIndex(rowIndex);
            this.index.setColIndex(colIndex);
            this.index.setType(type);
            this.cell = cell;
        }

        @Override
        public KDTCell getKDTCell() {
            return this.cell;
        }

        @Override
        public Object clone() {
            return new XCell(this.index.getRowIndex(), this.index.getColIndex(), this.index.getType(), (KDTCell)this.cell.clone());
        }

        @Override
        public Object getValue() {
            return this.cell.getValue();
        }

        @Override
        public void setValue(Object value) {
            Object oldValue = this.cell.getValue();
            if (KDTable.this.getFormulaMode() == 0) {
                this.cell.setExpressions(null);
                if (Tools.equalsObject((Object)oldValue, (Object)value)) {
                    return;
                }
            }
            this.cell.setValue(value);
            if (this.index.getType() == 1 && KDTable.this.scriptManager != null) {
                KDTable.this.scriptManager.cellPropertyChanged(this.index.getRowIndex(), this.index.getColIndex());
            }
            KDTable.this.repaint();
        }

        @Override
        public boolean isChange() {
            return this.cell.isChange();
        }

        @Override
        public void setChange(boolean newValue) {
            this.cell.setChange(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.cell.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.cell.setDataStyle(dataStyle);
        }

        @Override
        public Object getUserObject() {
            return this.cell.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.cell.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.cell.getExpressions() != null ? this.cell.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            String oldFormula = this.cell.getExpressions();
            if (KDTable.this.getFormulaMode() == 0) {
                if (StringUtil.equalsIgnoreCase((String)oldFormula, (String)expressions)) {
                    return;
                }
                this.cell.setValue(null);
            }
            this.cell.setExpressions(expressions);
            if (this.index.getType() != 4 && !StringUtil.isEmptyString((String)expressions) && KDTable.this.getScriptManager() != null) {
                KDTable.this.scriptManager.cellFormulaChanged(this.index.getRowIndex(), this.index.getColIndex());
            }
            KDTable.this.repaint();
        }

        @Override
        public int getColumnIndex() {
            return this.index.getColIndex();
        }

        @Override
        public int getRowIndex() {
            return this.index.getRowIndex();
        }
    }

    class XRow
    implements IRow {
        private KDTCellIndex index = new KDTCellIndex();
        private KDTRow row;

        public XRow(int rowIndex, int type, KDTRow row) {
            this.index.setRowIndex(rowIndex);
            this.index.setColIndex(-1);
            this.index.setType(type);
            this.row = row;
        }

        KDTCell createBlankCell(int cellIndex) {
            KDTCell cell = new KDTCell();
            return cell;
        }

        public void exchangeCell(int cellIndex1, int cellIndex2) {
            this.row.exchangeCell(cellIndex1, cellIndex2);
        }

        @Override
        public ICell getCell(int cellIndex) {
            return this.getCell(cellIndex, true);
        }

        @Override
        public ICell getCell(String key) {
            return this.getCell(key, true);
        }

        @Override
        public ICell getCell(int cellIndex, boolean autoCreate) {
            if (cellIndex < 0 || cellIndex >= KDTable.this.getColumnCount()) {
                return null;
            }
            KDTCell cell = this.row.getCell(cellIndex);
            if (cell == null) {
                if (autoCreate) {
                    cell = this.createBlankCell(cellIndex);
                    this.row.setCell(cellIndex, cell);
                    return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cell);
                }
                return null;
            }
            return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cell);
        }

        @Override
        public ICell getCell(String key, boolean autoCreate) {
            int cellIndex = KDTable.this.getColumns().getColumnIndex(key);
            return this.getCell(cellIndex, autoCreate);
        }

        @Override
        public ICell setCell(int cellIndex, ICell cell) {
            if (cellIndex < 0 || cellIndex >= KDTable.this.getColumnCount()) {
                return null;
            }
            if (cell == null) {
                this.row.setCell(cellIndex, null);
                KDTable.this.repaint();
                return null;
            }
            KDTCell cellTemp = cell.getKDTCell();
            this.row.setCell(cellIndex, cellTemp);
            return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cellTemp);
        }

        @Override
        public ICell setCell(String key, ICell cell) {
            int cellIndex = KDTable.this.getColumns().getColumnIndex(key);
            return this.setCell(cellIndex, cell);
        }

        @Override
        public KDTRow getKDTRow() {
            return this.row;
        }

        @Override
        public Object clone() {
            return new XRow(this.index.getRowIndex(), this.index.getType(), (KDTRow)this.row.clone());
        }

        @Override
        public int getHeight() {
            if (this.row != null) {
                int height = this.row.getHeight();
                if (height == -1) {
                    height = this.index.getType() == 0 ? KDTable.this.getDefaultHeadRowHeight() : KDTable.this.getDefaultRowHeight();
                }
                return height;
            }
            return -1;
        }

        @Override
        public void setHeight(int height) {
            this.row.setHeight(height);
            KDTable.this.repaint();
        }

        @Override
        public boolean isMergeable() {
            return this.row.isMergeable();
        }

        @Override
        public void setMergeable(boolean newValue) {
            this.row.setMergeable(newValue);
        }

        @Override
        public boolean isResizeable() {
            return this.row.isResizeable();
        }

        @Override
        public void setResizeable(boolean newValue) {
            this.row.setResizeable(newValue);
        }

        @Override
        public boolean isCollapse() {
            return this.row.isCollapse();
        }

        @Override
        public void setCollapse(boolean collapse) {
            this.row.setCollapse(collapse);
        }

        @Override
        public int getTreeLevel() {
            return this.row.getTreeLevel();
        }

        @Override
        public void setTreeLevel(int treeLevel) {
            this.row.setTreeLevel(treeLevel);
        }

        @Override
        public boolean isStat() {
            return this.row.isStat();
        }

        @Override
        public void setStat(boolean newValue) {
            this.row.setStat(newValue);
        }

        @Override
        public boolean isChange() {
            return this.row.isChange();
        }

        @Override
        public void setChange(boolean newValue) {
            this.row.setChange(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.row.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.row.setDataStyle(dataStyle);
        }

        @Override
        public Object getUserObject() {
            return this.row.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.row.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.row.getExpressions() != null ? this.row.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            this.row.setExpressions(expressions);
        }

        @Override
        public int getRowIndex() {
            return this.index.getRowIndex();
        }
    }

    class XColumn
    implements IColumn {
        KDTCellIndex index = new KDTCellIndex();
        private KDTColumn column;

        public XColumn(int colIndex, KDTColumn column) {
            this.index.setRowIndex(-1);
            this.index.setColIndex(colIndex);
            this.index.setType(5);
            this.column = column;
        }

        @Override
        public KDTColumn getKDTColumn() {
            return this.column;
        }

        @Override
        public Object clone() {
            return new XColumn(this.index.getColIndex(), (KDTColumn)this.column.clone());
        }

        @Override
        public int getWidth() {
            if (this.column != null) {
                int width = this.column.getWidth();
                if (width == -1) {
                    width = KDTable.this.getDefaultColumnWidth();
                }
                return width;
            }
            return -1;
        }

        @Override
        public void setWidth(int width) {
            this.column.setWidth(width);
            KDTable.this.repaint();
        }

        @Override
        public String getKey() {
            return this.column.getKey();
        }

        @Override
        public void setKey(String key) {
            this.column.setKey(key);
        }

        @Override
        public boolean isMergeable() {
            return this.column.isMergeable();
        }

        @Override
        public void setMergeable(boolean newValue) {
            this.column.setMergeable(newValue);
        }

        @Override
        public boolean isResizeable() {
            return this.column.isResizeable();
        }

        @Override
        public void setResizeable(boolean newValue) {
            this.column.setResizeable(newValue);
        }

        @Override
        public boolean isMoveable() {
            return this.column.isMoveable();
        }

        @Override
        public void setMoveable(boolean newValue) {
            this.column.setMoveable(newValue);
        }

        @Override
        public boolean isGroup() {
            return this.column.isGroup();
        }

        @Override
        public void setGroup(boolean newValue) {
            this.column.setGroup(newValue);
        }

        @Override
        public boolean isStat() {
            return this.column.isStat();
        }

        @Override
        public void setStat(boolean newValue) {
            this.column.setStat(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.column.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.column.setDataStyle(dataStyle);
        }

        @Override
        public Object getUserObject() {
            return this.column.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.column.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.column.getExpressions() != null ? this.column.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            this.column.setExpressions(expressions);
        }

        @Override
        public String getDataSourceName() {
            return this.column.getDataSourceName();
        }

        @Override
        public String getFieldName() {
            return this.column.getFieldName();
        }

        @Override
        public int getColumnIndex() {
            return this.index.getColIndex();
        }
    }
}

