/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.AbstractTableTravelPolicy;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;

public class CellFocusTravelByColumn
extends AbstractTableTravelPolicy {
    public CellFocusTravelByColumn(KDTable table) {
        super(table);
    }

    @Override
    public KDTCellIndex nextCellIndex(int rowIndex, int colIndex) {
        KDTCellIndex cellIndex = new KDTCellIndex();
        cellIndex.setRowIndex(rowIndex);
        cellIndex.setColIndex(colIndex);
        KDTSelectManager sman = this.table.getSelectManager();
        int blockIndex = sman.getSelectBlockIndexOfCell(rowIndex, colIndex);
        if (blockIndex > -1) {
            if (this.isSingleSelectedCell()) {
                cellIndex.setRowIndex(sman.nextRowIndex(rowIndex, colIndex, true));
                if (cellIndex.getRowIndex() > this.table.getRowCount1() - 1) {
                    cellIndex.setRowIndex(0);
                    cellIndex.setColIndex((colIndex + 1) % this.table.getColumnCount());
                }
            } else {
                KDTSelectBlock block = (KDTSelectBlock)sman.getBlocks().get(blockIndex);
                cellIndex.setRowIndex(sman.nextRowIndex(rowIndex, colIndex));
                if (cellIndex.getRowIndex() >= block.getBottom()) {
                    if (block.getRight() == colIndex) {
                        block = (KDTSelectBlock)sman.getBlocks().get((blockIndex + 1) % sman.getBlocks().size());
                        cellIndex.setColIndex(block.getLeft());
                    } else {
                        cellIndex.setColIndex(colIndex + 1);
                    }
                    cellIndex.setRowIndex(block.getTop());
                }
            }
        } else if (sman.getBlocks().size() != 0) {
            KDTSelectBlock lastBlock = (KDTSelectBlock)sman.getBlocks().get(sman.getBlocks().size() - 1);
            if (null != lastBlock) {
                cellIndex.setColIndex(lastBlock.getLeft());
                cellIndex.setRowIndex(lastBlock.getTop());
            } else {
                cellIndex.setRowIndex(rowIndex);
                cellIndex.setColIndex(colIndex);
            }
        } else {
            sman.add(0, 0, 0, 0);
            cellIndex.setColIndex(0);
            cellIndex.setRowIndex(0);
        }
        return cellIndex;
    }

    @Override
    public KDTCellIndex previousCellIndex(int rowIndex, int colIndex) {
        KDTCellIndex cellIndex = new KDTCellIndex();
        cellIndex.setRowIndex(rowIndex);
        cellIndex.setColIndex(colIndex);
        KDTSelectManager sman = this.table.getSelectManager();
        int blockIndex = sman.getSelectBlockIndexOfCell(rowIndex, colIndex);
        if (blockIndex > -1) {
            if (this.isSingleSelectedCell()) {
                cellIndex.setRowIndex(sman.previousRowIndex(rowIndex, colIndex));
                if (cellIndex.getRowIndex() < 0) {
                    cellIndex.setRowIndex(this.table.getRowCount() - 1);
                    int colCount = this.table.getColumnCount();
                    cellIndex.setColIndex((colIndex - 1 + colCount) % colCount);
                }
            } else {
                KDTSelectBlock block = (KDTSelectBlock)sman.getBlocks().get(blockIndex);
                cellIndex.setRowIndex(sman.previousRowIndex(rowIndex, colIndex));
                if (cellIndex.getRowIndex() < block.getTop()) {
                    if (block.getRight() == colIndex) {
                        int blockSize = sman.getBlocks().size();
                        block = (KDTSelectBlock)sman.getBlocks().get((blockIndex - 1 + blockSize) % blockSize);
                        cellIndex.setColIndex(block.getRight());
                    } else {
                        cellIndex.setColIndex(colIndex - 1);
                    }
                    cellIndex.setRowIndex(block.getBottom());
                }
            }
        } else if (sman.getBlocks().size() != 0) {
            KDTSelectBlock lastBlock = (KDTSelectBlock)sman.getBlocks().get(sman.getBlocks().size() - 1);
            if (null != lastBlock) {
                cellIndex.setColIndex(lastBlock.getRight());
                cellIndex.setRowIndex(lastBlock.getBottom());
            } else {
                cellIndex.setRowIndex(rowIndex);
                cellIndex.setColIndex(colIndex);
            }
        } else {
            sman.add(0, 0, 0, 0);
            cellIndex.setColIndex(0);
            cellIndex.setRowIndex(0);
        }
        return cellIndex;
    }

    private boolean isSingleSelectedCell() {
        if (this.table.getSelectManager().getBlocks().size() == 1) {
            KDTSelectBlock block = (KDTSelectBlock)this.table.getSelectManager().getBlocks().get(0);
            return block.getBeginCol() == block.getEndCol() && block.getBeginRow() == block.getEndRow();
        }
        return false;
    }
}

