/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.KDTAbstractCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTextFieldSelectAll;
import com.kingdee.cosmic.ctrl.kdf.util.Tools;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellValueParse;
import com.kingdee.cosmic.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.cosmic.ctrl.kdf.util.editor.TableCheckBoxIcon;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.swing.BasicNumberTextField;
import com.kingdee.cosmic.ctrl.swing.DecimalFormatEx;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDBusiCurrencyField;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDCurrencyEditor;
import com.kingdee.cosmic.ctrl.swing.KDDatePicker;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDMultiLangArea;
import com.kingdee.cosmic.ctrl.swing.KDMultiLangBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDTimePicker;
import com.kingdee.cosmic.ctrl.swing.MultiLangItem;
import com.kingdee.cosmic.ctrl.swing.calculator.KDCalculator;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class KDTDefaultCellEditor
extends KDTAbstractCellEditor
implements ICellValueParse {
    private static final Logger logger = LogUtil.getPackageLogger(KDTDefaultCellEditor.class);
    public static final String MultiLangBox_Modal = "All_Modal";
    protected JComponent comp;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 2;

    public KDTDefaultCellEditor() {
    }

    public KDTDefaultCellEditor(final KDTextAreaCtrl textAreaCtrl) {
        this.comp = textAreaCtrl;
        textAreaCtrl.getTextComponent().setAutoAdjustCaret(false);
        textAreaCtrl.getTextComponent().setSelectAllOnFocus(false);
        InputMap inputMap = this.comp.getInputMap(0);
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        Object actionName = inputMap.get(ks);
        inputMap.put(ks, "no-action");
        ks = KeyStroke.getKeyStroke(10, 512);
        inputMap.put(ks, actionName);
        this.delegate = new EditorDelegate(){

            @Override
            public Object parseValue(Object src) {
                int length;
                int upperLimit = textAreaCtrl.getMaxLength();
                int lowerLimit = textAreaCtrl.getMinLength();
                if (src instanceof String && (length = ((String)src).length()) >= lowerLimit && length <= upperLimit) {
                    return (String)src;
                }
                if (src instanceof Number && (length = ((Number)src).toString().length()) >= lowerLimit && length <= upperLimit) {
                    return (Number)src;
                }
                return super.parseValue(src);
            }

            @Override
            public void setValue(Object value) {
                textAreaCtrl.setText(value == null ? "" : value.toString());
            }

            @Override
            public Object getValue() {
                String str = textAreaCtrl.getText();
                if (str == null || str.equals("")) {
                    str = null;
                }
                return str;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                if (anEvent instanceof KeyEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    char keyChar = ((KeyEvent)anEvent).getKeyChar();
                    if (keyChar >= ' ' && keyChar <= '~') {
                        textAreaCtrl.setText(String.valueOf(keyChar));
                    }
                } else if (anEvent instanceof InputMethodEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textAreaCtrl.setText(KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent));
                } else if (anEvent instanceof ActionEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textAreaCtrl.setText(KDTDefaultCellEditor.getActionEventText((ActionEvent)anEvent));
                } else {
                    super.initComponent(value, expandValue, style, anEvent);
                }
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(121, 0), "fff");
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("fff", new AbstractAction(){
                    private static final long serialVersionUID = -9218062580280908551L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
            }

            @Override
            public void releaseComponent() {
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectUpCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectDownCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
    }

    public KDTDefaultCellEditor(final JTextField textField) {
        if (textField instanceof KDTextField) {
            ((KDTextField)textField).setEnabledPopup(false);
            ((KDTextField)textField).setSelectAllOnFocus(false);
        }
        this.comp = textField;
        if (JFormattedTextField.class.isAssignableFrom(textField.getClass())) {
            this.handleEsc(textField);
        } else {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    KDTDefaultCellEditor.this.fireEditingChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    KDTDefaultCellEditor.this.fireEditingChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    KDTDefaultCellEditor.this.fireEditingChanged();
                }
            });
        }
        this.delegate = new EditorDelegate(){

            @Override
            public String getText() {
                String text = null;
                if (textField instanceof KDBusiCurrencyField) {
                    KDBusiCurrencyField btextField = (KDBusiCurrencyField)textField;
                    text = btextField.getText();
                } else {
                    text = textField.getText();
                }
                return text;
            }

            @Override
            public void setValue(Object value) {
                if (JFormattedTextField.class.isAssignableFrom(textField.getClass())) {
                    String s = value.toString();
                    if (textField instanceof BasicNumberTextField && value != null) {
                        BasicNumberTextField b = (BasicNumberTextField)textField;
                        BigDecimal n = null;
                        if ("".equals(s)) {
                            return;
                        }
                        n = new BigDecimal(s);
                        b.setNumberValue((Number)n);
                    } else if (textField instanceof KDFormattedTextField) {
                        BigDecimal n = null;
                        if (value != null && !"".equals(value.toString())) {
                            try {
                                n = new BigDecimal(s);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ((KDFormattedTextField)textField).setNumberValue(n);
                    } else {
                        ((JFormattedTextField)textField).setValue(value);
                    }
                } else {
                    textField.setText(value != null ? value.toString() : "");
                }
            }

            @Override
            public Object getValue() {
                Object value = null;
                if (JFormattedTextField.class.isAssignableFrom(textField.getClass())) {
                    if (textField instanceof KDFormattedTextField) {
                        KDFormattedTextField ftf;
                        block6: {
                            ftf = (KDFormattedTextField)textField;
                            try {
                                ftf.commitEdit();
                            }
                            catch (ParseException ex) {
                                if (ftf.getDataVerifierType() != -1) break block6;
                                Object ftfValue = ftf.getValue();
                                ftf.setValue(ftfValue);
                            }
                        }
                        value = ftf.getNumberValue();
                    } else {
                        value = textField instanceof BasicNumberTextField ? this.getText() : ((JFormattedTextField)textField).getValue();
                    }
                } else {
                    String str = textField.getText();
                    value = str == null || str.equals("") ? null : str;
                }
                return value;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                if (anEvent instanceof KeyEvent) {
                    String str = String.valueOf(((KeyEvent)anEvent).getKeyChar());
                    this.initComponent(str);
                } else if (anEvent instanceof InputMethodEvent) {
                    String str = KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent);
                    if (StringUtil.isEmptyString((String)str) && !StringUtil.isEmptyString((String)this.getText())) {
                        this.initComponent(this.getText());
                        textField.selectAll();
                    } else {
                        this.initComponent(str);
                    }
                } else if (anEvent instanceof ActionEvent) {
                    String str = KDTDefaultCellEditor.getActionEventText((ActionEvent)anEvent);
                    this.initComponent(str);
                } else if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(true);
                } else {
                    textField.selectAll();
                }
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
                if (value == null) {
                    KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "SelectLeftCell");
                    KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "SelectRightCell");
                    KDTDefaultCellEditor.this.comp.getActionMap().put("SelectLeftCell", ((KDTable)expandValue).getActionMap().get("SelectLeftCell"));
                    KDTDefaultCellEditor.this.comp.getActionMap().put("SelectRightCell", ((KDTable)expandValue).getActionMap().get("SelectRightCell"));
                }
            }

            void initComponent(String str) {
                if (textField instanceof KDFormattedTextField) {
                    KDFormattedTextField ftf = (KDFormattedTextField)textField;
                    ftf.setSelectAllOnFocus(false);
                    ftf.reInstallEditFormater();
                    if (!StringUtil.isEmptyString((String)str)) {
                        if (!"-".equals(str)) {
                            try {
                                new BigDecimal(str);
                            }
                            catch (Exception e) {
                                str = null;
                            }
                        }
                        ftf.selectAll();
                        ftf.replaceSelection(str);
                    }
                } else if (textField instanceof BasicNumberTextField) {
                    ((BasicNumberTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        try {
                            new Double(str);
                        }
                        catch (Exception e) {
                            str = null;
                        }
                        ((BasicNumberTextField)textField).setText(str);
                        textField.setCaretPosition(textField.getText().length());
                    }
                } else {
                    if (KDTextFieldSelectAll.isInsert()) {
                        textField.setText(textField.getText() + str);
                    } else {
                        textField.setText(str);
                    }
                    if (!StringUtil.isEmptyString((String)str)) {
                        textField.setCaretPosition(textField.getText().length());
                    }
                }
            }

            @Override
            public void releaseComponent() {
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectUpCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectDownCell");
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(37, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(39, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectLeftCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectRightCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }

            @Override
            public Object parseValue(Object src) {
                if (textField instanceof KDFormattedTextField) {
                    if (src instanceof String || src instanceof Number) {
                        String text = src instanceof Number ? new DecimalFormatEx(CtrlFormatUtilities.getDecimalFormatString(), CtrlFormatUtilities.getDecimalFormatSymbols()).format(src) : src.toString();
                        KDFormattedTextField ftf = (KDFormattedTextField)textField;
                        try {
                            JFormattedTextField.AbstractFormatter format = ftf.getFormatter();
                            if (format != null) {
                                return KDFormattedTextField.getValueByType((Number)((Number)format.stringToValue(text)), (int)ftf.getDataType());
                            }
                        }
                        catch (ParseException e) {
                            return null;
                        }
                    }
                    return null;
                }
                if (textField instanceof BasicNumberTextField) {
                    if (src instanceof String || src instanceof Number) {
                        String text = src.toString();
                        BasicNumberTextField btf = (BasicNumberTextField)textField;
                        try {
                            JFormattedTextField.AbstractFormatter format = btf.getFormatter();
                            if (format != null) {
                                return (Number)format.stringToValue(text);
                            }
                        }
                        catch (ParseException e) {
                            return null;
                        }
                    }
                    return null;
                }
                if (textField instanceof KDTextField) {
                    int length;
                    int upperLimit = ((KDTextField)textField).getMaxLength();
                    int lowerLimit = ((KDTextField)textField).getMinLength();
                    if (upperLimit == -1) {
                        upperLimit = Integer.MAX_VALUE;
                    }
                    if (src instanceof String && (length = ((String)src).length()) >= lowerLimit && length <= upperLimit) {
                        return (String)src;
                    }
                    if (src instanceof Number && (length = ((Number)src).toString().length()) >= lowerLimit && length <= upperLimit) {
                        return (Number)src;
                    }
                    return null;
                }
                return super.parseValue(src);
            }
        };
        textField.addActionListener(this.delegate);
    }

    public KDTDefaultCellEditor(final JTextArea textArea) {
        this.comp = textArea;
        if (textArea instanceof KDTextArea) {
            ((KDTextArea)textArea).setAutoAdjustCaret(false);
            ((KDTextArea)textArea).setSelectAllOnFocus(false);
        }
        InputMap inputMap = this.comp.getInputMap(0);
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        Object actionName = inputMap.get(ks);
        inputMap.put(ks, "no-action");
        ks = KeyStroke.getKeyStroke(10, 512);
        inputMap.put(ks, actionName);
        this.delegate = new EditorDelegate(){

            @Override
            public Object parseValue(Object src) {
                int length;
                int upperLimit = ((KDTextArea)textArea).getMaxLength();
                int lowerLimit = ((KDTextArea)textArea).getMinLength();
                if (src instanceof String && (length = ((String)src).length()) >= lowerLimit && length <= upperLimit) {
                    return (String)src;
                }
                if (src instanceof Number && (length = ((Number)src).toString().length()) >= lowerLimit && length <= upperLimit) {
                    return (Number)src;
                }
                return super.parseValue(src);
            }

            @Override
            public void setValue(Object value) {
                textArea.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getValue() {
                String str = textArea.getText();
                if (str == null || str.equals("")) {
                    str = null;
                }
                return str;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                if (anEvent instanceof KeyEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    char keyChar = ((KeyEvent)anEvent).getKeyChar();
                    if (keyChar >= ' ' && keyChar <= '~') {
                        textArea.setText(String.valueOf(keyChar));
                    }
                } else if (anEvent instanceof InputMethodEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textArea.setText(KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent));
                } else if (anEvent instanceof ActionEvent) {
                    super.initComponent(null, expandValue, style, anEvent);
                    textArea.setText(KDTDefaultCellEditor.getActionEventText((ActionEvent)anEvent));
                } else {
                    super.initComponent(value, expandValue, style, anEvent);
                }
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(121, 0), "fff");
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("fff", new AbstractAction(){
                    private static final long serialVersionUID = -3908100425724002987L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
            }

            @Override
            public void releaseComponent() {
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectUpCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectDownCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
    }

    public KDTDefaultCellEditor(final JCheckBox checkBox) {
        checkBox.setIcon(new TableCheckBoxIcon());
        checkBox.setHorizontalAlignment(0);
        this.comp = checkBox;
        this.clickCountToStart = 1;
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDefaultCellEditor.this.fireEditingChanged();
            }
        });
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                KDCheckBox kdcb;
                boolean selected = false;
                int iSel = 16;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                    iSel = selected ? 32 : 16;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                    iSel = selected ? 32 : 16;
                } else if (value instanceof Integer) {
                    iSel = (Integer)value;
                    boolean bl = selected = iSel == 1;
                }
                if (checkBox instanceof KDCheckBox && !(kdcb = (KDCheckBox)checkBox).isSwitch() && kdcb.getAlterType() == 1) {
                    kdcb.setSelected(iSel);
                    return;
                }
                checkBox.setSelected(selected);
            }

            @Override
            public Object getValue() {
                KDCheckBox kdcb;
                if (checkBox instanceof KDCheckBox && !(kdcb = (KDCheckBox)checkBox).isSwitch() && kdcb.getAlterType() == 1) {
                    return ((KDCheckBox)checkBox).getSelected();
                }
                return checkBox.isSelected();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                if (anEvent != null) {
                    if (anEvent instanceof KeyEvent || anEvent instanceof ActionEvent) {
                        ((JCheckBox)KDTDefaultCellEditor.this.comp).doClick();
                    } else if (anEvent instanceof MouseEvent) {
                        ((JCheckBox)KDTDefaultCellEditor.this.comp).doClick();
                    }
                }
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                KDTDefaultCellEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                KDTDefaultCellEditor.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
            }

            @Override
            public void releaseComponent() {
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectUpCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectDownCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                String text;
                char keyChar;
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? (keyChar = ((KeyEvent)anEvent).getKeyChar()) == ' ' : anEvent instanceof ActionEvent && !StringUtil.isEmptyString((String)(text = KDTDefaultCellEditor.getActionEventText((ActionEvent)anEvent))) && text.charAt(0) == ' ';
            }

            @Override
            public Object parseValue(Object src) {
                if (!(src instanceof Boolean)) {
                    return ICellValueParse.ParseError;
                }
                return src;
            }
        };
    }

    public KDTDefaultCellEditor(final KDDatePicker editor) {
        this.clickCountToStart = 1;
        this.comp = editor;
        editor.setShowErrorInfo(false);
        this.delegate = new EditorDelegate(){

            @Override
            public Object getValue() {
                try {
                    editor.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return editor.getValue();
            }

            @Override
            public void setValue(Object value) {
                if (value instanceof Date) {
                    editor.setValue(value);
                } else {
                    editor.setValue(null);
                }
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                if (height > 20) {
                    height = 20;
                }
                super.setBounds(x, y, width, height);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getFocusComponent() {
                KDDatePicker dp = editor;
                if (dp.isEditable()) {
                    return dp.getEditor().getEditorComponent();
                }
                return dp;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                KDDatePicker dp = editor;
                JComponent tempC = dp.getEditor().getEditorComponent();
                if (tempC != null) {
                    tempC.setBorder(null);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDefaultCellEditor.this.stopCellEditing();
            }

            @Override
            public Object parseValue(Object src) {
                block5: {
                    if (src instanceof String) {
                        try {
                            JComponent editComp = editor.getEditor().getEditorComponent();
                            if (editComp instanceof JFormattedTextField) {
                                JFormattedTextField ftf = (JFormattedTextField)editComp;
                                JFormattedTextField.AbstractFormatter format = ftf.getFormatter();
                                return format.stringToValue(src.toString());
                            }
                            break block5;
                        }
                        catch (ParseException pe) {
                            return null;
                        }
                    }
                    if (src instanceof Date) {
                        return src;
                    }
                }
                return null;
            }
        };
        JComponent tempC = editor.getEditor().getEditorComponent();
        if (tempC instanceof JFormattedTextField) {
            ((JFormattedTextField)tempC).addActionListener(this.delegate);
            this.handleEsc(tempC);
        }
    }

    public KDTDefaultCellEditor(final JComboBox comboBox) {
        this.comp = comboBox;
        this.clickCountToStart = 1;
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                comboBox.removeActionListener(KDTDefaultCellEditor.this.delegate);
                if (comboBox instanceof KDMultiLangBox) {
                    if (Boolean.TRUE.equals(comboBox.getClientProperty(KDTDefaultCellEditor.MultiLangBox_Modal))) {
                        this.clearMultiLangBox((KDMultiLangBox)comboBox);
                        if (value instanceof MultiLangItemList) {
                            MultiLangItem[] items = ((MultiLangItemList)value).getItems();
                            KDMultiLangBox mb = (KDMultiLangBox)comboBox;
                            for (int i = 0; i < items.length; ++i) {
                                mb.addItem(items[i]);
                            }
                            MultiLangItem item = mb.getItemBy(((MultiLangItemList)value).getCurrentItem().getLang());
                            MultiLangItem currentItem = ((MultiLangItemList)value).getCurrentItem();
                            currentItem.setData(item.getData());
                            mb.setSelectedItem((Object)currentItem);
                        }
                    } else {
                        ((KDMultiLangBox)comboBox).setSelectedItemData(value);
                    }
                } else {
                    comboBox.setSelectedItem(value);
                }
                comboBox.addActionListener(KDTDefaultCellEditor.this.delegate);
            }

            @Override
            public Object getValue() {
                if (comboBox instanceof KDMultiLangBox && Boolean.TRUE.equals(comboBox.getClientProperty(KDTDefaultCellEditor.MultiLangBox_Modal))) {
                    KDMultiLangBox mb = (KDMultiLangBox)comboBox;
                    int size = mb.getModel().getSize();
                    MultiLangItem[] items = new MultiLangItem[size];
                    for (int i = 0; i < size; ++i) {
                        MultiLangItem item = (MultiLangItem)mb.getModel().getElementAt(i);
                        items[i] = new MultiLangItem(item);
                    }
                    MultiLangItemList list = new MultiLangItemList(items);
                    list.setCurrentItem(new MultiLangItem((MultiLangItem)mb.getSelectedItem()));
                    return list;
                }
                if (comboBox instanceof KDComboBox) {
                    ((KDComboBox)comboBox).validateInputValue();
                }
                Object obj = null;
                obj = comboBox.isEditable() && comboBox.getEditor().getItem() != null ? comboBox.getEditor().getItem() : (comboBox.getSelectedItem() != null ? comboBox.getSelectedItem() : null);
                if (obj instanceof MultiLangItem) {
                    obj = ((MultiLangItem)obj).getData();
                }
                return obj;
            }

            @Override
            public Object parseValue(Object src) {
                Object object = null;
                if (src instanceof String && comboBox instanceof KDComboBox) {
                    ComboBoxModel cm = ((KDComboBox)comboBox).getDataModel();
                    int size = cm.getSize();
                    for (int i = 0; i < size; ++i) {
                        Object item = cm.getElementAt(i);
                        if (item == null || !item.toString().equals(src)) continue;
                        object = item;
                        comboBox.setSelectedItem(item);
                        break;
                    }
                }
                return object;
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                if (!(KDTDefaultCellEditor.this.comp instanceof KDMultiLangArea) && height > 20) {
                    height = 20;
                }
                super.setBounds(x, y, width, height);
            }

            private void clearMultiLangBox(KDMultiLangBox mlb) {
                KDMultiLangBox mb = (KDMultiLangBox)comboBox;
                int size = mb.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    MultiLangItem item = (MultiLangItem)mb.getModel().getElementAt(i);
                    item.setData(null);
                }
                mb.updateText();
            }

            @Override
            public Component getFocusComponent() {
                if (comboBox instanceof KDMultiLangBox) {
                    return ((KDMultiLangBox)comboBox).getEditorComponent();
                }
                return comboBox;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
            }

            @Override
            public void releaseComponent() {
            }
        };
        comboBox.addActionListener(this.delegate);
    }

    public KDTDefaultCellEditor(final IKDEditor editor) {
        JComponent tempC;
        this.clickCountToStart = 1;
        this.comp = (JComponent)editor;
        if (editor instanceof KDPromptBox) {
            ((KDPromptBox)editor).setSelectAllOnFocus(false);
        }
        this.delegate = new EditorDelegate(){

            @Override
            public Object getValue() {
                if (editor instanceof KDPromptBox) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    if (f7.isEditable()) {
                        try {
                            f7.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    }
                } else if (editor instanceof KDDatePicker) {
                    try {
                        ((KDDatePicker)editor).commitEdit();
                    }
                    catch (ParseException parseException) {}
                } else if (editor instanceof KDTimePicker) {
                    try {
                        ((KDTimePicker)editor).commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return editor.getValue();
            }

            @Override
            public void setValue(Object value) {
                if (editor instanceof KDDatePicker) {
                    if (value instanceof Date && value != null) {
                        editor.setValue(value);
                    } else {
                        editor.setValue(null);
                    }
                } else if (editor instanceof KDComboColor) {
                    if (value instanceof Color && value != null) {
                        ((KDComboColor)editor).setColor((Color)value);
                    }
                } else {
                    editor.setValue(value);
                }
            }

            @Override
            public Object parseValue(Object src) {
                if (src instanceof String && editor instanceof KDPromptBox) {
                    ((KDPromptBox)editor).setText((String)src);
                    Object object = ((KDPromptBox)editor).parseToSingleValue((String)src);
                    ((KDPromptBox)editor).setValue(object);
                    return object;
                }
                ((KDPromptBox)editor).setValue(null);
                return null;
            }

            @Override
            public Component getFocusComponent() {
                if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    return f7.getEditor();
                }
                if (KDDatePicker.class.isAssignableFrom(editor.getClass())) {
                    KDDatePicker dp = (KDDatePicker)editor;
                    if (dp.isEditable()) {
                        return dp.getEditor().getEditorComponent();
                    }
                    return dp;
                }
                if (KDTimePicker.class.isAssignableFrom(editor.getClass())) {
                    KDTimePicker tp = (KDTimePicker)editor;
                    if (tp.isEditable()) {
                        return tp.getEditor().getEditorComponent();
                    }
                    return tp;
                }
                return super.getFocusComponent();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                if (editor instanceof KDCurrencyEditor) {
                    ((KDCurrencyEditor)editor).setNegative(false);
                }
                super.initComponent(value, expandValue, style, anEvent);
                if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    KDPromptBox f7 = (KDPromptBox)editor;
                    JComponent f7Editor = f7.getEditor();
                    if (f7.isAutoAddRow()) {
                        f7Editor.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                        f7Editor.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                        f7Editor.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                        f7Editor.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
                    } else if (!f7.isHistoryRecordEnabled()) {
                        f7Editor.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                        f7Editor.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                        f7Editor.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                        f7Editor.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
                    }
                    f7Editor.setBorder(null);
                    f7Editor.setBackground(KDTDefaultCellEditor.this.getBackgroundColor(style.getBackground()));
                    f7.setAlignment(1);
                    f7.setOpaque(true);
                    f7.setToolTipText(null);
                    f7.setButtonTooltipsText(null);
                    f7.setAutoFocusNextComponent(false);
                    if (anEvent instanceof KeyEvent) {
                        int keyCode;
                        if (f7.isEditable() && (keyCode = ((KeyEvent)anEvent).getKeyCode()) != 118 && Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent))) {
                            char keyChar = ((KeyEvent)anEvent).getKeyChar();
                            if (f7Editor instanceof JTextField) {
                                f7.setEditingText(String.valueOf(keyChar));
                            }
                        }
                    } else if (anEvent instanceof InputMethodEvent) {
                        if (f7.isEditable() && f7Editor instanceof JTextField) {
                            String text = KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)anEvent);
                            String editorText = ((JTextField)f7Editor).getText();
                            if (StringUtil.isEmptyString((String)text) && !StringUtil.isEmptyString((String)editorText)) {
                                f7.setEditingText(editorText);
                                ((JTextField)f7Editor).selectAll();
                            } else {
                                f7.setEditingText(text);
                            }
                        }
                    } else if (anEvent instanceof ActionEvent) {
                        if (f7.isEditable()) {
                            String text = KDTDefaultCellEditor.getActionEventText((ActionEvent)anEvent);
                            if (f7Editor instanceof JTextField) {
                                f7.setEditingText(text);
                            }
                        }
                    } else if (f7Editor instanceof JTextField) {
                        f7.updateData();
                        ((JTextField)f7Editor).selectAll();
                    }
                } else if (KDDatePicker.class.isAssignableFrom(editor.getClass())) {
                    KDDatePicker dp = (KDDatePicker)editor;
                    JComponent tempC = dp.getEditor().getEditorComponent();
                    if (tempC != null) {
                        tempC.setBorder(null);
                    }
                } else if (editor instanceof KDCurrencyEditor) {
                    ((KDCurrencyEditor)editor).resetTrianglePosition();
                }
            }

            @Override
            public void releaseComponent() {
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                KDTDefaultCellEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectUpCell");
                KDTDefaultCellEditor.this.comp.getActionMap().remove("SelectDownCell");
                if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                    KDPromptBox kDPromptBox = (KDPromptBox)editor;
                }
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                if (anEvent instanceof KeyEvent) {
                    if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
                        int keyCode = ((KeyEvent)anEvent).getKeyCode();
                        if (Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) || keyCode == 118) {
                            return true;
                        }
                    } else if (editor instanceof KDCurrencyEditor && Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent))) {
                        return true;
                    }
                } else if ((anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent) && (editor instanceof KDPromptBox || editor instanceof KDCurrencyEditor)) {
                    return true;
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDefaultCellEditor.this.stopCellEditing();
            }
        };
        if (KDPromptBox.class.isAssignableFrom(editor.getClass())) {
            KDPromptBox e = (KDPromptBox)editor;
            e.addActionListener((ActionListener)this.delegate);
            e.putClientProperty((Object)"EditorForKDTable", (Object)Boolean.TRUE);
        } else if (KDDatePicker.class.isAssignableFrom(editor.getClass()) && (tempC = ((KDDatePicker)editor).getEditor().getEditorComponent()) instanceof JFormattedTextField) {
            ((JFormattedTextField)tempC).addActionListener(this.delegate);
            this.handleEsc(tempC);
        }
    }

    public KDTDefaultCellEditor(JPanel editor) {
        this.comp = editor;
        this.delegate = new EditorDelegate(){

            @Override
            public Object getValue() {
                return "editor.getValue()";
            }
        };
    }

    public KDTDefaultCellEditor(final KDCalculator editor) {
        this.clickCountToStart = 1;
        this.comp = editor;
        this.handleEsc((JComponent)editor);
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    if (value instanceof BigDecimal) {
                        editor.setValue((BigDecimal)value);
                    } else if (value instanceof Number) {
                        editor.setValue(new BigDecimal(((Number)value).toString()));
                    } else {
                        String text = value.toString();
                        try {
                            BigDecimal bValue = new BigDecimal(text);
                            editor.setValue(bValue);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    editor.setValue(BigDecimal.valueOf(0.0));
                }
            }

            @Override
            public Object getValue() {
                try {
                    editor.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
                return editor.getValue();
            }

            @Override
            public Component getFocusComponent() {
                return editor.getDisplay();
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                editor.getDisplay().setBorder(null);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDefaultCellEditor.this.stopCellEditing();
            }
        };
        KDFormattedTextField tempC = editor.getDisplay();
        if (tempC instanceof JFormattedTextField) {
            ((JFormattedTextField)tempC).addActionListener(this.delegate);
            this.handleEsc((JComponent)tempC);
        }
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    private void handleEsc(JComponent comp) {
        comp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "esc2");
        comp.getActionMap().put("esc2", new AbstractAction(){
            private static final long serialVersionUID = -8707756768484022703L;

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDefaultCellEditor.this.fireEditingCanceled();
            }
        });
    }

    Color getBackgroundColor(Color color) {
        if (color.getAlpha() == 0) {
            return Color.WHITE;
        }
        return color;
    }

    @Override
    public Object parseValue(Object src) {
        return this.delegate.parseValue(src);
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public void setText(String text) {
        this.delegate.setText(text);
    }

    @Override
    public Object getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    @Override
    public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
        if (this.isDisplayable()) {
            this.delegate.initComponent(value, expandValue, style, anEvent);
            return this.comp;
        }
        this.delegate.actionPerformed(value, anEvent);
        return null;
    }

    @Override
    public void releaseComponent() {
        this.delegate.releaseComponent();
    }

    @Override
    public Component getFocusComponent() {
        return this.delegate.getFocusComponent();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    public static String getInputMethodEventText(InputMethodEvent event) {
        AttributedCharacterIterator text = event.getText();
        if (text == null) {
            return "";
        }
        StringBuilder strBuf = new StringBuilder();
        text.first();
        char c = text.current();
        for (int commitCount = event.getCommittedCharacterCount(); commitCount > 0; --commitCount) {
            strBuf.append(c);
            c = text.next();
        }
        return strBuf.toString();
    }

    public static String getActionEventText(ActionEvent event) {
        return event.getActionCommand();
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener {
        protected EditorDelegate() {
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void setExpandValue(Object value) {
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= KDTDefaultCellEditor.this.clickCountToStart;
            }
            return false;
        }

        public boolean isDisplayable() {
            return true;
        }

        public Component getFocusComponent() {
            return KDTDefaultCellEditor.this.comp;
        }

        public void setBounds(int x, int y, int width, int height) {
            KDTDefaultCellEditor.this.comp.setBounds(x, y, width, height);
            KDTDefaultCellEditor.this.comp.validate();
        }

        public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            KDTDefaultCellEditor.this.comp.setOpaque(true);
            KDTDefaultCellEditor.this.comp.setBorder(null);
            KDTDefaultCellEditor.this.comp.setBackground(KDTDefaultCellEditor.this.getBackgroundColor(style.getBackground()));
            KDTDefaultCellEditor.this.comp.setForeground(style.getFontColor());
            KDTDefaultCellEditor.this.comp.setFont((Font)style.getKDFont());
            KDTDefaultCellEditor.this.comp.setToolTipText(null);
            this.setValue(value);
        }

        public void releaseComponent() {
        }

        public void actionPerformed(Object value, EventObject anEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTDefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            KDTDefaultCellEditor.this.stopCellEditing();
        }

        public Object parseValue(Object src) {
            return src;
        }
    }
}

