/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTEditManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHorizon;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

class KDTHeadView
extends KDTView {
    private static final long serialVersionUID = 2777331683534958443L;
    int fromColumnIndex = -1;
    int lastColumn = -1;

    public KDTHeadView(KDTable table, KDTColumns columns, IRows rows) {
        super(table, columns, rows);
        this.viewType = 2;
    }

    @Override
    public Object clone() {
        KDTHeadView view = new KDTHeadView(this.table, this.columns, this.rows);
        view.topRow = this.topRow;
        view.bottomRow = this.bottomRow;
        return view;
    }

    @Override
    public void paint(Graphics g) {
        KDTable.printDebugInfo(this.getClass().toString() + " begin:" + (System.currentTimeMillis() - KDTable.beginDate));
        KDTVertical vertical = this.table.getLayoutManager().getVertical(this.table.getViewManager().getVerticalIndex(this.getIndex()));
        KDTHorizon horizon = this.table.getLayoutManager().getHorizon(this.table.getViewManager().getHorizonIndex(this.getIndex()));
        if (vertical != null) {
            this.topRow = vertical.getFirst();
            this.bottomRow = vertical.getLast();
        }
        if (horizon != null) {
            this.leftCol = horizon.getFirst();
            this.rightCol = horizon.getLast();
        }
        if (this.bottomRow == -1 || this.rightCol == -1) {
            return;
        }
        this.x2 = this.columns.getWidth(this.leftCol, this.rightCol);
        this.y2 = this.rows.getHeight(this.topRow, this.bottomRow);
        this.activeWidth = this.x2;
        this.activeHeight = this.y2;
        Graphics2D bufferGraphics = (Graphics2D)g;
        Stroke oldStroke = bufferGraphics.getStroke();
        Color oldColor = bufferGraphics.getColor();
        this.fillRect(bufferGraphics, new Rectangle(0, 0, this.x2, this.y2), this.table.getHeadStyle().getBorderColor(Styles.Position.BOTTOM));
        this.drawCells(bufferGraphics);
        this.drawSelect(bufferGraphics);
        bufferGraphics.setStroke(oldStroke);
        bufferGraphics.setColor(oldColor);
        KDTable.printDebugInfo(this.getClass().toString() + " after:" + (System.currentTimeMillis() - KDTable.beginDate));
    }

    @Override
    protected void drawCells(Graphics2D g) {
        this.drawCells(g, this.topRow, this.leftCol, this.bottomRow, this.rightCol, 0, 0);
    }

    @Override
    protected void drawCells(Graphics2D g, int top, int left, int bottom, int right, int dx, int dy) {
        Rectangle rOuter = new Rectangle();
        Rectangle rInner = new Rectangle();
        Rectangle rTemp = new Rectangle();
        KDTEditManager editEngine = this.table.getEditManager();
        int editorStatus = 0;
        if (editEngine.isEditing() && editEngine.getEditView() == this && editEngine.getEditor().isDisplayable()) {
            editorStatus = 1;
        }
        Color[] headVerges = this.table.getHeadVergesColor();
        int width = 0;
        int height = 0;
        int x = dx;
        int y = dy;
        for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
            KDTRow row = this.rows.getRow(rowIndex);
            if (row == null || row.getStyle().isHided()) continue;
            height = this.rows.getRowHeight(rowIndex);
            rTemp.y = y;
            rTemp.height = height;
            y += height;
            x = dx;
            width = 0;
            for (int colIndex = left; colIndex <= right; ++colIndex) {
                Style style;
                KDTColumn column = this.columns.getColumn(colIndex);
                width = this.columns.getColumnWidth(colIndex);
                rTemp.x = x;
                rTemp.width = width;
                x += width;
                KDTCell cell = row.getCell(colIndex);
                int bgType = this.topRow == this.bottomRow ? 3 : (this.topRow == rowIndex ? 1 : (this.bottomRow == rowIndex ? 2 : 0));
                if (cell == null) {
                    this.getCellOuterBounds(rOuter, rTemp);
                    style = this.getBlankCellStyle(row.getSSA(), column.getSSA());
                } else {
                    KDTMergeBlock mergeBlock = cell.getViewBlock();
                    if (mergeBlock != null) {
                        rOuter.y = mergeBlock.top < this.topRow ? this.topRow : mergeBlock.top;
                        int n = rOuter.x = mergeBlock.left < this.leftCol ? this.leftCol : mergeBlock.left;
                        if (rOuter.x != colIndex || rOuter.y != rowIndex) continue;
                        bgType = 0;
                        if (mergeBlock.top <= this.topRow) {
                            ++bgType;
                        }
                        if (mergeBlock.bottom >= this.bottomRow) {
                            bgType += 2;
                        }
                        cell = this.rows.getRow2(mergeBlock.top).getCell(mergeBlock.left);
                        rOuter.y = this.rows.getHeight(mergeBlock.top, rowIndex - 1);
                        rOuter.x = this.columns.getWidth(mergeBlock.left, colIndex - 1);
                        rOuter.height = rOuter.y + this.rows.getHeight(rowIndex, mergeBlock.bottom);
                        rOuter.width = rOuter.x + this.columns.getWidth(colIndex, mergeBlock.right);
                        rOuter.y = rTemp.y - rOuter.y;
                        rOuter.x = rTemp.x - rOuter.x;
                        style = cell.getStyle();
                    } else {
                        this.getCellOuterBounds(rOuter, rTemp);
                        style = cell.getStyle();
                    }
                }
                if (editorStatus == 1 && editEngine.getEditRowIndex() == rowIndex && editEngine.getEditColIndex() == colIndex) {
                    editEngine.setEditorVisible(true);
                    editEngine.getEditorComponent().repaint();
                    editEngine.setEditorBounds(rOuter.x, rOuter.y, rOuter.width - 1, rOuter.height - 1);
                    editorStatus = 2;
                    this.drawBottomBorder(g, rOuter, style);
                    this.drawRightBorder(g, rOuter, style);
                    continue;
                }
                IBasicRender render = this.rows.getType() == 0 ? this.table.getHeadCellRenderer(rowIndex, colIndex) : this.table.getCellRenderer(rowIndex, colIndex);
                if (render instanceof IExtBasicRender) {
                    IExtBasicRender extRender = (IExtBasicRender)render;
                    if (!extRender.isFillBackground()) {
                        this.fillCellBackGround(bgType, g, rOuter, headVerges, style.getBackground());
                    }
                    this.drawCellBorder(g, rOuter, style);
                    if (cell != null) {
                        if (cell.isHide()) continue;
                        Object value = cell.getValue();
                        if (extRender.isClip()) {
                            this.getCellInnerBounds(rInner, rOuter);
                            extRender.draw((Graphics)g, (Shape)rInner, value, style, null);
                            continue;
                        }
                        extRender.draw((Graphics)g, (Shape)rOuter, value, style, null);
                        continue;
                    }
                    if (extRender.isClip()) {
                        this.getCellInnerBounds(rInner, rOuter);
                        extRender.draw((Graphics)g, (Shape)rInner, null, style, null);
                        continue;
                    }
                    extRender.draw((Graphics)g, (Shape)rOuter, null, style, null);
                    continue;
                }
                this.fillCellBackGround(bgType, g, rOuter, headVerges, style.getBackground());
                if (cell != null) {
                    this.getCellInnerBounds(rInner, rOuter);
                    Object value = cell.getValue();
                    if (render != null) {
                        render.draw((Graphics)g, (Shape)rInner, value, style);
                    }
                }
                this.drawCellBorder(g, rOuter, style);
            }
        }
        if (editorStatus == 1) {
            editEngine.setEditorVisible(false);
        }
    }

    protected void fillCellBackGround(int type, Graphics2D g, Rectangle rect, Color[] headVerges, Color backColor) {
        switch (type) {
            case 0: {
                this.fillRect(g, rect, backColor);
                break;
            }
            case 1: {
                this.fillRectWithVergeTop(g, rect, headVerges, backColor);
                break;
            }
            case 2: {
                this.fillRectWithVergeBottom(g, rect, headVerges, backColor);
                break;
            }
            case 3: {
                this.fillRectWithVerge(g, rect, headVerges, backColor);
                break;
            }
        }
    }

    private void fillRectWithVerge(Graphics g, Rectangle rect, Color[] headVerges, Color backColor) {
        int y = rect.y;
        int width = rect.x + rect.width - 1;
        g.setColor(headVerges[0]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[1]);
        g.drawLine(rect.x, y + 1, width, y + 1);
        g.setColor(headVerges[2]);
        g.drawLine(rect.x, y + 2, width, y + 2);
        g.setColor(backColor);
        g.fillRect(rect.x, y + 3, rect.width, rect.height - 6);
        y = rect.y + rect.height - 3;
        g.setColor(headVerges[3]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[4]);
        g.drawLine(rect.x, y + 1, width, y + 1);
    }

    private void fillRectWithVergeTop(Graphics g, Rectangle rect, Color[] headVerges, Color backColor) {
        int y = rect.y;
        int width = rect.x + rect.width - 1;
        g.setColor(headVerges[0]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[1]);
        g.drawLine(rect.x, y + 1, width, y + 1);
        g.setColor(headVerges[2]);
        g.drawLine(rect.x, y + 2, width, y + 2);
        g.setColor(backColor);
        g.fillRect(rect.x, y + 3, rect.width, rect.height - 3);
    }

    private void fillRectWithVergeBottom(Graphics g, Rectangle rect, Color[] headVerges, Color backColor) {
        int y = rect.y;
        int width = rect.x + rect.width - 1;
        int height = rect.height - 3;
        g.setColor(backColor);
        g.fillRect(rect.x, y, rect.width, height);
        y = rect.y + height;
        g.setColor(headVerges[3]);
        g.drawLine(rect.x, y, width, y);
        g.setColor(headVerges[4]);
        g.drawLine(rect.x, y + 1, width, y + 1);
    }

    @Override
    protected Style getBlankCellStyle(ShareStyleAttributes ssaRow, ShareStyleAttributes ssaCol) {
        return this.table.getBlankCellStyle(ssaRow, null);
    }

    @Override
    protected void drawCellSelect(Graphics2D g, KDTSelectBlock block) {
        int left = block.getLeft();
        int right = block.getRight();
        if (left > this.rightCol || right < this.leftCol) {
            return;
        }
        left = left < this.leftCol ? this.leftCol : left;
        right = right > this.rightCol ? this.rightCol : right;
        int x = this.columns.getWidth(this.leftCol, left - 1);
        int w = this.columns.getWidth(left, right) - 1;
        this.drawSelectBlock(g, x, 0, w, this.y2);
    }

    @Override
    protected void drawRowSelect(Graphics2D g, KDTSelectBlock block) {
        int mode = this.table.getSelectManager().getSelectMode();
        if (mode == 2 || mode == 10) {
            return;
        }
        this.drawSelectBlock(g, 0, 0, this.x2, this.y2);
    }

    @Override
    protected void drawBottomBorder(Graphics2D g, Rectangle rect, Style style) {
        Styles.Position pos = Styles.Position.BOTTOM;
        if (style.isNullBorder(pos)) {
            if (this.table.isVerticalHeadGridLineVisible()) {
                int left = rect.x;
                int bottom = rect.y + rect.height - 1;
                int right = rect.x + rect.width - 1;
                g.setColor(this.table.getHeadGridLineColor());
                g.drawLine(left, bottom, right, bottom);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int left = rect.x;
        int bottom = rect.y + rect.height - 1;
        int right = rect.x + rect.width - 1;
        g.setColor(style.getBorderColor(pos));
        g.setStroke(style.getStroke(pos));
        g.drawLine(left, bottom, right, bottom);
        g.setStroke(oldStroke);
    }

    @Override
    protected void drawRightBorder(Graphics2D g, Rectangle rect, Style style) {
        Styles.Position pos = Styles.Position.RIGHT;
        if (style.isNullBorder(pos)) {
            if (this.table.isHorizonHeadGridLineVisible()) {
                int top = rect.y;
                int bottom = rect.y + rect.height - 1;
                int right = rect.x + rect.width - 1;
                g.setColor(this.table.getHeadGridLineColor());
                g.drawLine(right, top, right, bottom);
            }
            return;
        }
        Stroke oldStroke = g.getStroke();
        int top = rect.y;
        int bottom = rect.y + rect.height - 1;
        int right = rect.x + rect.width - 1;
        g.setColor(style.getBorderColor(pos));
        g.setStroke(style.getStroke(pos));
        g.drawLine(right, top, right, bottom);
        g.setStroke(oldStroke);
    }

    @Override
    protected void fireCellClick(MouseEvent e, int rowIndex, int colIndex) {
        KDTMouseEvent mouseEvent = new KDTMouseEvent(this.table, e, rowIndex, colIndex, 0);
        this.table.fireTableClick(mouseEvent);
    }

    @Override
    protected void startEditing(MouseEvent e, int rowIndex, int colIndex) {
        if (!this.table.getEditManager().isEditing()) {
            this.table.getSelectManager().setActiveViewIndex(this.index + this.table.getHorizonCount());
            this.table.getEditManager().editHeadCellAt(rowIndex, colIndex, e);
        }
    }

    @Override
    protected void selectBegin(int rowIndex, int colIndex, boolean isCtrl, boolean isShift) {
        KDTSelectManager sm = this.table.getSelectManager();
        if (!sm.isColumnSelectable()) {
            return;
        }
        this.setStatus(5);
        this.doSelect(rowIndex, colIndex, 4, isCtrl, isShift);
    }

    protected boolean isAboveBottomBorder1(int y) {
        int height = 0;
        for (int i = this.topRow; i <= this.bottomRow; ++i) {
            this.activeRowHeight = this.rows.getRowHeight(i);
            if (y - (height += this.activeRowHeight) >= 5 || y - height <= -5 || y > height) continue;
            this.activeRow = i;
            this.activeRowBottom = height;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAboveBottomBorder(int y) {
        int height = 0;
        for (int i = this.topRow; i <= this.bottomRow; ++i) {
            this.activeRowHeight = this.rows.getRowHeight(i);
            if (y - (height += this.activeRowHeight) < 0 && y - height > -5) {
                this.activeRowType = 0;
                this.activeRow = i;
                this.activeRowBottom = height;
                return this.table.getHeadRow(this.activeRow).isResizeable();
            }
            if (y - height < 0 || y - height >= 5) continue;
            int j = i + 1;
            int indexOfRowWithZeroHeight = -1;
            boolean hasHeightZeroRow = false;
            while (this.rows.getRowHeight(j) == 0) {
                if (!this.rows.getRow(j).getStyle().isHided()) {
                    hasHeightZeroRow = true;
                    indexOfRowWithZeroHeight = j;
                }
                ++j;
            }
            if (j > i + 1 && hasHeightZeroRow) {
                this.activeRowHeight = 0;
                this.activeRow = indexOfRowWithZeroHeight;
            } else {
                this.activeRow = i;
            }
            this.activeRowBottom = height;
            return this.table.getHeadRow(this.activeRow).isResizeable();
        }
        return false;
    }

    protected boolean isAboveRightBorder2(int x) {
        int width = 0;
        for (int i = this.leftCol; i <= this.rightCol; ++i) {
            this.activeColWidth = this.columns.getColumnWidth(i);
            if (x - (width += this.activeColWidth) >= 2 || x - width <= -2) continue;
            this.activeCol = i;
            this.activeColRight = width;
            if (!this.columns.getColumn(i).isResizeable()) break;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAboveRightBorder(int x) {
        int width = 0;
        for (int i = this.leftCol; i <= this.rightCol; ++i) {
            this.activeColWidth = this.columns.getColumnWidth(i);
            if (x - (width += this.activeColWidth) < 0 && x - width > -5) {
                this.activeCol = i;
                this.activeColRight = width;
                if (!this.columns.getColumn(i).isResizeable()) break;
                return true;
            }
            if (x - width < 0 || x - width >= 5) continue;
            int j = i + 1;
            int indexOfColumnWithZeroWidth = -1;
            boolean hasWidthZeroColumn = false;
            while (this.columns.getColumnWidth(j) == 0) {
                if (!this.columns.getColumn(j).getStyle().isHided()) {
                    hasWidthZeroColumn = true;
                    indexOfColumnWithZeroWidth = j;
                }
                ++j;
            }
            if (j > i + 1 && hasWidthZeroColumn) {
                this.activeColWidth = 0;
                this.activeCol = indexOfColumnWithZeroWidth;
                this.activeColRight = width;
                if (!this.columns.getColumn(this.activeCol).isResizeable()) {
                    return false;
                }
            } else {
                this.activeCol = i;
                this.activeColRight = width;
                if (!this.columns.getColumn(this.activeCol).isResizeable()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int doScrollAndSelect(int x, int y) {
        KDTSelectBlock sb;
        int returnValue = this.doScroll(x, y);
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.colIndex == -1) {
            p.colIndex = this.rightCol;
        }
        if (p.rowIndex == -1) {
            p.rowIndex = this.bottomRow;
        }
        if ((sb = this.table.getSelectManager().getOrigin()) != null) {
            sb.setBottom(p.rowIndex);
            sb.setRight(p.colIndex);
        }
        this.table.repaint();
        return returnValue;
    }

    public int doScroll(int x, int y) {
        KDTHorizon horizon;
        int hIndex;
        int returnValue = 0;
        Rectangle rect = this.getBounds();
        if (x > rect.width) {
            hIndex = this.table.getViewManager().getHorizonIndex(this.getIndex());
            horizon = this.table.getLayoutManager().getHorizon(hIndex);
            horizon.scrollToNextUnit();
            this.rightCol = horizon.getLast();
            x = rect.width - 2;
            returnValue = 1;
        }
        if (x < 0) {
            hIndex = this.table.getViewManager().getHorizonIndex(this.getIndex());
            horizon = this.table.getLayoutManager().getHorizon(hIndex);
            horizon.scrollToPrevUnit();
            this.rightCol = horizon.getLast();
            x = 2;
            returnValue = 1;
        }
        return returnValue;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.rowIndex == -1 || p.colIndex == -1) {
            super.mousePressed(e);
            return;
        }
        if (e.getButton() == 1) {
            if (this.status == 0) {
                this.fromColumnIndex = p.colIndex;
            }
            super.mousePressed(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.status == 4 || this.status == 2) {
            super.mouseDragged(e);
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.setStatus(7);
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (this.lastColumn != p.colIndex) {
            this.drawMoveFlag(this.lastColumn);
            this.drawMoveFlag(p.colIndex);
            this.lastColumn = p.colIndex;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.doScroll(x, y) == 1) {
            this.dragScrollX = x;
            this.dragScrollY = y;
            this.timer.start();
        }
    }

    private void drawMoveFlag(int colIndex) {
        if (colIndex != -1) {
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.setXORMode(this.getBackground());
            g.setColor(Color.RED);
            KDTVertical vertical = this.table.getLayoutManager().getVertical(this.table.getViewManager().getVerticalIndex(this.getIndex()));
            KDTHorizon horizon = this.table.getLayoutManager().getHorizon(this.table.getViewManager().getHorizonIndex(this.getIndex()));
            this.topRow = vertical.getFirst();
            this.bottomRow = vertical.getLast();
            this.leftCol = horizon.getFirst();
            this.rightCol = horizon.getLast();
            Rectangle2D.Float rTemp = new Rectangle2D.Float();
            KDTRow row = null;
            int x = 0;
            int y = 0;
            for (int rowIndex = this.topRow; rowIndex <= this.bottomRow; ++rowIndex) {
                row = this.rows.getRow(rowIndex);
                if (row == null || row.getStyle().isHided()) continue;
                int height = this.rows.getRowHeight(rowIndex);
                for (int col = this.leftCol; col <= this.rightCol; ++col) {
                    int width = this.columns.getColumnWidth(col);
                    if (col == colIndex) {
                        ((Rectangle2D)rTemp).setRect(x, y, width - 3, height - 2);
                        break;
                    }
                    x += width;
                }
                y += height;
                break;
            }
            g.setColor(new Color(127, 127, 127));
            float[] dashPattern = new float[]{1.0f};
            g.setStroke(new BasicStroke(3.0f, 0, 0, 10.0f, dashPattern, 0.0f));
            g.draw(rTemp);
            g.setPaintMode();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.status != 7) {
            super.mouseReleased(e);
            return;
        }
        int x = e.getX();
        int y = e.getY();
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.colIndex != -1) {
            if (e.isControlDown()) {
                if (this.table.exchangeColumn(this.fromColumnIndex, p.colIndex)) {
                    this.selectBegin(p.rowIndex, p.colIndex, e.isControlDown(), e.isShiftDown());
                }
            } else if (this.table.moveColumn(this.fromColumnIndex, p.colIndex)) {
                this.selectBegin(p.rowIndex, this.fromColumnIndex > p.colIndex ? p.colIndex : p.colIndex - 1, e.isControlDown(), e.isShiftDown());
            }
        }
        this.drawMoveFlag(this.lastColumn);
        this.lastColumn = -1;
        this.fromColumnIndex = -1;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        super.mouseReleased(e);
    }
}

