/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIndexColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;

public class KDTIndexColumnView
extends KDTView {
    private static final long serialVersionUID = 5017076986355593677L;
    IBasicRender render;
    private KDTIndexColumn indexColumn;

    public KDTIndexColumnView(KDTable table, KDTIndexColumn indexColumn, KDTColumns cols, IRows rows) {
        super(table, cols, rows);
        this.viewType = 3;
        this.indexColumn = indexColumn;
        this.activeRowType = 2;
        this.render = this.table.getDefaultRenderer(Object.class);
    }

    @Override
    public int getActiveWidth() {
        return this.indexColumn.getWidth();
    }

    @Override
    public void paint(Graphics g) {
        KDTable.printDebugInfo(this.getClass().toString() + " begin:" + (System.currentTimeMillis() - KDTable.beginDate));
        KDTVertical vertical = this.table.getLayoutManager().getVertical(this.table.getViewManager().getVerticalIndex(this.getIndex()));
        this.topRow = vertical.getFirst();
        this.bottomRow = vertical.getLast();
        if (this.bottomRow == -1) {
            return;
        }
        Style style = this.indexColumn.getStyle();
        if (style.isHided()) {
            return;
        }
        if (this.autoResetIndexColumnWidth(this.bottomRow, style, (Graphics2D)g)) {
            return;
        }
        this.y2 = this.rows.getHeight(this.topRow, this.bottomRow);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.y2 > height) {
            this.y2 = height;
        }
        this.x2 = width;
        Graphics2D bufferGraphics = (Graphics2D)g;
        this.fillRect(bufferGraphics, new Rectangle(0, 0, this.x2, this.y2), this.indexColumn.getStyle());
        this.drawCells(bufferGraphics);
        if (this.indexColumn.isDrawTopBorder()) {
            bufferGraphics.setPaint(KDTStyleConstants.GRID_LINE_COLOR);
            bufferGraphics.drawLine(0, 0, this.x2, 0);
        }
        if (this.indexColumn.isDrawSelect()) {
            this.drawSelect(bufferGraphics);
        }
    }

    @Override
    protected void drawCells(Graphics2D g) {
        this.drawCells(g, this.topRow, this.leftCol, this.bottomRow, this.rightCol, 0, 0);
    }

    @Override
    protected void drawCells(Graphics2D g, int top, int left, int bottom, int right, int dx, int dy) {
        Rectangle rOuter = new Rectangle();
        Rectangle rInner = new Rectangle();
        Rectangle rTemp = new Rectangle();
        int width = 0;
        int height = 0;
        int x = dx;
        int y = dy;
        width = this.indexColumn.getWidth();
        if (width <= 0) {
            return;
        }
        Style style = this.indexColumn.getStyle();
        for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
            height = this.rows.getRowHeight(rowIndex);
            rTemp.y = y;
            rTemp.height = height;
            y += height;
            rTemp.x = x;
            rTemp.width = width;
            this.getCellOuterBounds(rOuter, rTemp);
            if (rOuter.height <= 0) continue;
            this.fillRect(g, rOuter, style);
            this.getCellInnerBounds(rInner, rOuter);
            if (rInner.height > 0 && rInner.width > 0) {
                String value = this.indexColumn.getText(rowIndex);
                if (this.render != null && value != null) {
                    this.render.draw((Graphics)g, (Shape)rInner, (Object)value, style);
                }
            }
            this.drawCellBorder(g, rOuter, style);
        }
    }

    @Override
    protected void drawCellBorder(Graphics2D g, Rectangle rect, Style style) {
        this.drawBottomBorder(g, rect, style, true);
        this.drawRightBorder(g, rect, style, true);
    }

    private boolean autoResetIndexColumnWidth(int lastIndex, Style style, Graphics2D g) {
        return this.indexColumn.autoResetIndexColumnWidth(lastIndex, style, g, this.getIndex());
    }

    @Override
    protected void drawCellSelect(Graphics2D g, KDTSelectBlock block) {
        int top = block.getTop();
        int bottom = block.getBottom();
        if (top > this.bottomRow || bottom < this.topRow) {
            return;
        }
        top = top < this.topRow ? this.topRow : top;
        bottom = bottom > this.bottomRow ? this.bottomRow : bottom;
        int y = this.rows.getHeight(this.topRow, top - 1);
        int h = this.rows.getHeight(top, bottom) - 1;
        this.drawSelectBlock(g, 0, y, this.x2, h);
    }

    @Override
    protected void drawColumnSelect(Graphics2D g, KDTSelectBlock block) {
        int mode = this.table.getSelectManager().getSelectMode();
        if (mode == 4 || mode == 12) {
            return;
        }
        this.drawSelectBlock(g, 0, 0, this.x2, this.y2);
    }

    @Override
    public Object clone() {
        KDTIndexColumnView view = new KDTIndexColumnView(this.table, this.indexColumn, this.columns, this.rows);
        view.topRow = this.topRow;
        view.leftCol = this.leftCol;
        return view;
    }

    @Override
    protected void fireCellClick(MouseEvent e, int rowIndex, int colIndex) {
        KDTMouseEvent mouseEvent = new KDTMouseEvent(this.table, e, rowIndex, colIndex, 2);
        this.table.fireTableClick(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.isControlDown() && this.indexColumn.getWidthAdjustMode() != 0) {
            this.indexColumn.setWidthAdjustMode((short)0);
            this.repaint();
            return;
        }
        super.mouseClicked(e);
    }

    @Override
    protected void startEditing(MouseEvent e, int rowIndex, int colIndex) {
    }

    @Override
    protected void selectBegin(int rowIndex, int colIndex, boolean isCtrl, boolean isShift) {
        KDTSelectManager sm = this.table.getSelectManager();
        if (!sm.isRowSelectable()) {
            return;
        }
        this.setStatus(5);
        this.doSelect(rowIndex, colIndex, 2, isCtrl, isShift);
    }

    @Override
    protected boolean isAboveBottomBorder(int y) {
        int height = 0;
        for (int i = this.topRow; i <= this.bottomRow; ++i) {
            this.activeRowHeight = this.rows.getRowHeight(i);
            if (y - (height += this.activeRowHeight) < 0 && y - height > -5) {
                this.activeRowType = 2;
                this.activeRow = i;
                this.activeRowBottom = height;
                return this.table.getRow(this.activeRow) == null || this.table.getRow(this.activeRow).isResizeable();
            }
            if (y - height < 0 || y - height >= 5) continue;
            int j = i + 1;
            int indexOfRowWithZeroHeight = -1;
            boolean hasHeightZeroRow = false;
            while (this.rows.getRowHeight(j) == 0) {
                if (!this.rows.getRow(j).getStyle().isHided()) {
                    hasHeightZeroRow = true;
                    indexOfRowWithZeroHeight = j;
                }
                ++j;
            }
            if (j > i + 1 && hasHeightZeroRow) {
                this.activeRowHeight = 0;
                this.activeRow = indexOfRowWithZeroHeight;
            } else {
                this.activeRow = i;
            }
            this.activeRowBottom = height;
            return this.table.getRow(this.activeRow) == null || this.table.getRow(this.activeRow).isResizeable();
        }
        return false;
    }

    @Override
    protected boolean isAboveRightBorder(int x) {
        return false;
    }

    @Override
    public int doScrollAndSelect(int x, int y) {
        KDTSelectBlock sb;
        KDTVertical vertical;
        int vIndex;
        int returnValue = 0;
        Rectangle rect = this.getBounds();
        if (y > rect.height) {
            vIndex = this.table.getViewManager().getVerticalIndex(this.getIndex());
            vertical = this.table.getLayoutManager().getVertical(vIndex);
            vertical.scrollToNextUnit();
            this.bottomRow = vertical.getLast();
            y = rect.height - 2;
            returnValue = 1;
        }
        if (y < 0) {
            vIndex = this.table.getViewManager().getVerticalIndex(this.getIndex());
            vertical = this.table.getLayoutManager().getVertical(vIndex);
            vertical.scrollToPrevUnit();
            this.bottomRow = vertical.getLast();
            y = 2;
            returnValue = 1;
        }
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.colIndex == -1) {
            p.colIndex = this.rightCol;
        }
        if (p.rowIndex == -1) {
            p.rowIndex = this.bottomRow;
        }
        if ((sb = this.table.getSelectManager().getOrigin()) != null) {
            sb.setBottom(p.rowIndex);
            sb.setRight(this.table.getColumnCount() - 1);
        }
        this.table.repaint();
        return returnValue;
    }

    @Override
    public KDTCellPosition getCellPosition2(int x, int y) {
        int span;
        KDTCellPosition pos = new KDTCellPosition();
        pos.colIndex = -1;
        pos.rowIndex = -1;
        if (x <= this.x2 && (span = this.indexColumn.getWidth()) > x) {
            pos.colIndex = 0;
        }
        if (y <= this.y2) {
            span = 0;
            for (int i = this.topRow; i <= this.bottomRow; ++i) {
                if ((span += this.rows.getRowHeight(i)) <= y) continue;
                pos.rowIndex = i;
                break;
            }
        }
        return pos;
    }
}

