/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.util.NumberGroup;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class KDTRange
extends ArrayList {
    private static final long serialVersionUID = 9047264398009975924L;
    public static final int NO_DIRECT = -1;
    public static final int ROW_DIRECT = 0;
    public static final int COL_DIRECT = 1;

    public KDTRange() {
    }

    public KDTRange(Collection c) {
        super(c);
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof KDTRange)) {
            return false;
        }
        KDTRange range = (KDTRange)obj;
        if (range.size() != this.size()) {
            return false;
        }
        int size = this.size();
        boolean[] checked = new boolean[size];
        for (i = 0; i < size; ++i) {
            checked[i] = false;
        }
        block1: for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!checked[j] && this.get(i).equals(range.get(j))) {
                    checked[j] = true;
                    continue block1;
                }
                if (j != size - 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int size = this.size();
        int[] hc = new int[size];
        for (int i = 0; i < size; ++i) {
            hc[i] = this.get(i).hashCode();
        }
        Arrays.sort(hc);
        int result = 17;
        for (int i = 0; i < size; ++i) {
            result = 2 * result + hc[i];
        }
        return result;
    }

    public boolean contains(int x, int y) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            IBlock block = (IBlock)this.get(i);
            if (!block.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public KDTRange getSequenceRange() {
        int size = this.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return this;
        }
        int direct = this.getRangeDirect();
        if (direct == -1) {
            return null;
        }
        int mode = ((IBlock)this.get(0)).getMode();
        return this.mergeRange(mode, direct);
    }

    public int getRangeDirect() {
        int size = this.size();
        IBlock block1 = (IBlock)this.get(0);
        int direct = -1;
        int mode = block1.getMode();
        for (int i = 1; i < size; ++i) {
            IBlock block = (IBlock)this.get(i);
            if (mode != block.getMode()) {
                return -1;
            }
            if (block1.getMode() != 1) continue;
            if (direct == -1) {
                if (block1.getTop() == block.getTop() && block1.getBottom() == block.getBottom()) {
                    direct = 0;
                    continue;
                }
                if (block1.getLeft() == block.getLeft() && block1.getRight() == block.getRight()) {
                    direct = 1;
                    continue;
                }
                return -1;
            }
            if (!(direct == 0 ? block1.getTop() != block.getTop() || block1.getBottom() != block.getBottom() : direct == 1 && (block1.getLeft() != block.getLeft() || block1.getRight() != block.getRight()))) continue;
            return -1;
        }
        if (mode == 1) {
            return direct;
        }
        direct = mode == 4 ? 0 : 1;
        return direct;
    }

    private KDTRange mergeRange(int mode, int direct) {
        IBlock block;
        int size = this.size();
        KDTRange rangeOut = new KDTRange();
        NumberGroup ng = new NumberGroup();
        int first = 0;
        int last = 0;
        switch (mode) {
            case 8: {
                IBlock block2 = (IBlock)this.get(0);
                rangeOut.add(block2);
                return rangeOut;
            }
            case 4: {
                int j;
                int i;
                direct = 0;
                for (i = 0; i < size; ++i) {
                    block = (IBlock)this.get(i);
                    for (j = block.getLeft(); j <= block.getRight(); ++j) {
                        ng.addItem(j);
                    }
                }
                break;
            }
            case 2: {
                int j;
                int i;
                direct = 1;
                for (i = 0; i < size; ++i) {
                    block = (IBlock)this.get(i);
                    for (j = block.getTop(); j <= block.getBottom(); ++j) {
                        ng.addItem(j);
                    }
                }
                break;
            }
            case 1: {
                int j;
                int i;
                for (i = 0; i < size; ++i) {
                    block = (IBlock)this.get(i);
                    if (direct == 0) {
                        first = block.getTop();
                        last = block.getBottom();
                        for (j = block.getLeft(); j <= block.getRight(); ++j) {
                            ng.addItem(j);
                        }
                        continue;
                    }
                    first = block.getLeft();
                    last = block.getRight();
                    for (j = block.getTop(); j <= block.getBottom(); ++j) {
                        ng.addItem(j);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        for (Point pt : ng.getGroupList()) {
            block = new KDTBlock();
            block.setMode(mode);
            if (direct == 0) {
                block.setLeft(pt.x);
                block.setRight(pt.y);
                block.setTop(first);
                block.setBottom(last);
            } else {
                block.setLeft(first);
                block.setRight(last);
                block.setTop(pt.x);
                block.setBottom(pt.y);
            }
            rangeOut.add(block);
        }
        return rangeOut;
    }

    public boolean isSingleRange() {
        int size = this.size();
        return size > 0 && size <= 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IBlock block : this) {
            sb.append("block[");
            sb.append(block.getTop() + ",");
            sb.append(block.getLeft() + ",");
            sb.append(block.getBottom() + ",");
            sb.append(block.getRight() + "]\n");
        }
        return sb.toString();
    }
}

