/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.table.BasicView;
import com.kingdee.cosmic.ctrl.kdf.table.CellTreeNode;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBasicUI;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCorner;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCornerView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDataStyle;
import com.kingdee.cosmic.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.cosmic.ctrl.kdf.table.KDTEditManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTExcelHeadRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTExcelHeadView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTGroupManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHead;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHeadView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHorizon;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIOManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIndexColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTKeyControlManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTLayoutManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTScriptManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSortManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTreeColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTreeColumnView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTreeCornerView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTViewManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTextFieldSelectAll;
import com.kingdee.cosmic.ctrl.kdf.table.ScriptContext;
import com.kingdee.cosmic.ctrl.kdf.table.cellformatter.ICellFormatter;
import com.kingdee.cosmic.ctrl.kdf.table.conditionstyle.ConditionStyleManager;
import com.kingdee.cosmic.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.DataActionEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.ExportDataActionListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.ImportDataActionListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTColumnMoveEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTColumnMoveListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTGetRowListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.cosmic.ctrl.kdf.table.splitrectangle.KDTableSplitRectangleInfo;
import com.kingdee.cosmic.ctrl.kdf.table.undo.KDTableUndoManager;
import com.kingdee.cosmic.ctrl.kdf.util.LazyValueMap;
import com.kingdee.cosmic.ctrl.kdf.util.Tools;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.file.IDObject;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.I18nStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.SpreadStyleDesigner;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDInfoTip;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TableUI;
import org.apache.log4j.Logger;
import sun.awt.im.InputMethodContext;

public class KDTable
extends JComponent
implements Accessible,
IKDTextComponent,
IDObject {
    private static final Logger log = LogUtil.getPackageLogger(KDTable.class);
    private static final long serialVersionUID = -9026505877910153794L;
    private Map userProperties;
    private KDTableUndoManager undoManager;
    private ConditionStyleManager csManager;
    private BeforeActionListener beforeAction;
    private BeforeActionListener afterAction;
    private ArrayList beforeActions;
    private ArrayList afterActions;
    private ICellFormatter cellCustomFormatter;
    private KDTSortManager sortMange;
    private boolean exportPrintSetup2Xls = false;
    private boolean columnMoveable = false;
    private boolean mergeHeadMoveable = false;
    private boolean pasteF7Block = false;
    private List<ExportDataActionListener> exportActionListeners;
    private List<ImportDataActionListener> importDataActionListeners;
    public static final long beginDate = System.currentTimeMillis();
    private String ID;
    protected KDTKeyControlManager keyControlManager;
    private KDTPrintManager printManager;
    protected KDTHead head;
    protected KDTBody body;
    private KDTIndexColumn indexCol;
    private KDTCorner corner;
    private KDTFootManager footManager;
    protected KDTColumns columns;
    private KDTTreeColumn treeColumn;
    private int rowCount = -1;
    private KDTDataRequestManager dataRequestManager;
    private KDTViewManager viewManager;
    private int verticalCount = 2;
    private int horizonCount = 3;
    private KDTLayoutManager layoutManager;
    private KDTSelectManager selectManager;
    private KDTEditManager editManager;
    private KDTEditHelper editHelper;
    private KDTMergeManager headMergeManager;
    private KDTMergeManager mergeManager;
    boolean autoMerge = true;
    private KDTGroupManager groupManager;
    private KDTIOManager ioManager;
    protected KDTScriptManager scriptManager;
    protected ScriptContext scriptHelper;
    private static final String uiClassID = "KDTableUI";
    private static BufferedImage bufferImage;
    private static Graphics2D bufferGraphics;
    private int defaultHeadRowHeight = 22;
    private int defaultRowHeight = 20;
    private int defaultColumnWidth = 100;
    private ShareStyleAttributes headSSA;
    private Style headStyle;
    private ShareStyleAttributes bodySSA;
    private Style bodyStyle;
    private Color[] headVergesColor;
    private boolean verticalHeadGridLineVisible = true;
    private boolean horizonHeadGridLineVisible = true;
    private boolean verticalGridLineVisible = true;
    private boolean horizonGridLineVisible = true;
    private Color headGridLineColor;
    private Color gridLineColor;
    private int cellDisplayMode = 0;
    private int activeCellStatus = 0;
    private int headDisplayMode = 0;
    private KDTGetRowListener getRowListener;
    private Action beforeRemoveRowsAction;
    private String formatXml = null;
    private Reader formatXmlReader = null;
    private InputStream formatXmlStream = null;
    private boolean autoParse = true;
    String objectName = null;
    String[] objectNames = null;
    String[] fields = null;
    private Object userObject;
    boolean isAutoResize = false;
    private boolean refresh = false;
    boolean enableRepaint = true;
    StyleAttributesListener saListener;
    FormatStyleAttributesListener fsaListener;
    private SpreadStyleDesigner spreadStyleDesigner;
    private StyleDesigner styleDesigner;
    private Hashtable defaultRenderers;
    private Hashtable defaultEditors;
    IUserCellDisplayParser userCellDisplayParser;
    private int m_scrollStateVertical = 0;
    private int m_scrollStateHorizon = 0;
    private static boolean debug;
    private int formulaMode = 0;
    private boolean scriptAutoRun = true;
    private boolean scriptAutoAdjust = true;
    private InputMethodRequests imRequestHandle;
    int colAutoResizeMode = 0;
    int rowAutoResizeMode = 0;
    private Color requiredColor;
    protected boolean editable = true;
    KDInfoTip kit3 = null;
    private boolean i18nEnabled = true;
    private boolean copyFID = false;
    private List copyColNames;
    Set printHiddenColIndex = new HashSet();

    public boolean isExportPrintSetup2Xls() {
        return this.exportPrintSetup2Xls;
    }

    public void setExportPrintSetup2Xls(boolean exportPrintSetup2Xls) {
        this.exportPrintSetup2Xls = exportPrintSetup2Xls;
    }

    public KDTable() {
        KDTable.printDebugInfo("initialize begin" + (System.currentTimeMillis() - beginDate));
        this.initialize();
        KDTable.printDebugInfo("initialize agfter" + (System.currentTimeMillis() - beginDate));
        KDTextFieldSelectAll.register(this, KeyStroke.getKeyStroke(73, 576));
    }

    public KDTable(int colCount, int headRowCount, int bodyRowCount) {
        this.initialize();
        this.createBlankTable(colCount, headRowCount, bodyRowCount);
    }

    public void createBlankTable(int colCount, int headRowCount, int bodyRowCount) {
        this.addColumns(colCount);
        this.addHeadRows(headRowCount);
        this.addRows(bodyRowCount);
    }

    private void initialize() {
        this.initDataCenter();
        this.initManager();
        this.createDefaultRenderers();
        KDTable.printDebugInfo("create render" + (System.currentTimeMillis() - beginDate));
        this.createDefaultEditors();
        KDTable.printDebugInfo("create editor" + (System.currentTimeMillis() - beginDate));
        this.saListener = new StyleAttributesListener();
        this.fsaListener = new FormatStyleAttributesListener();
        this.setID(this.getDefaultID());
        this.initCompConfig();
        this.initUIElement();
        this.updateUI();
    }

    protected void initDataCenter() {
        this.head = new KDTHead(this);
        KDTable.printDebugInfo("KDTHead" + (System.currentTimeMillis() - beginDate));
        this.body = new KDTBody(this);
        KDTable.printDebugInfo("KDTBody" + (System.currentTimeMillis() - beginDate));
        this.columns = new KDTColumns(this);
        KDTable.printDebugInfo("KDTColumns" + (System.currentTimeMillis() - beginDate));
        this.treeColumn = new KDTTreeColumn(this);
        KDTable.printDebugInfo("KDTTreeColumn" + (System.currentTimeMillis() - beginDate));
        this.indexCol = new KDTIndexColumn(this);
        KDTable.printDebugInfo("KDTIndexColumn" + (System.currentTimeMillis() - beginDate));
        this.corner = new KDTCorner(this);
        KDTable.printDebugInfo("KDTCorner" + (System.currentTimeMillis() - beginDate));
    }

    protected void initManager() {
        this.dataRequestManager = new KDTDataRequestManager(this);
        KDTable.printDebugInfo("KDTDataRequestManager" + (System.currentTimeMillis() - beginDate));
        this.viewManager = new KDTViewManager(this);
        KDTable.printDebugInfo("KDTViewManager" + (System.currentTimeMillis() - beginDate));
        this.selectManager = new KDTSelectManager(this);
        KDTable.printDebugInfo("KDTSelectManager" + (System.currentTimeMillis() - beginDate));
        this.headMergeManager = new KDTMergeManager(this, this.head);
        this.mergeManager = new KDTMergeManager(this, this.body);
        KDTable.printDebugInfo("KDTMergeManager" + (System.currentTimeMillis() - beginDate));
        this.groupManager = new KDTGroupManager(this);
        KDTable.printDebugInfo("KDTGroupManager" + (System.currentTimeMillis() - beginDate));
        this.ioManager = new KDTIOManager(this);
        KDTable.printDebugInfo("KDTIOManager" + (System.currentTimeMillis() - beginDate));
        this.editManager = new KDTEditManager(this);
        KDTable.printDebugInfo("KDTEditManager" + (System.currentTimeMillis() - beginDate));
        this.keyControlManager = new KDTKeyControlManager(this);
        KDTable.printDebugInfo("create keybournd" + (System.currentTimeMillis() - beginDate));
    }

    protected void initCompConfig() {
        this.enableInputMethods(true);
        this.enableEvents(2056L);
        this.layoutManager = new KDTLayoutManager(this);
        this.setLayout(this.layoutManager);
        KDTable.printDebugInfo("KDTLayoutManager" + (System.currentTimeMillis() - beginDate));
    }

    private void reInitialize() {
        this.autoMerge = true;
        this.getSelectManager().removeAll();
        this.getEditManager().cancelEditing();
        this.getGroupManager().removeGroup();
        this.getMergeManager().getMergeBlockSet().clear();
        if (this.scriptManager != null) {
            this.scriptManager.removeAll();
        }
    }

    public boolean addShortcutKey(KeyStroke key, String actionKey) {
        if (null != this.getActionMap().get(actionKey)) {
            return false;
        }
        this.getInputMap().put(key, actionKey);
        return true;
    }

    private String getDefaultID() {
        return "KDT" + System.currentTimeMillis() + this.hashCode();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        IPrintJob job;
        this.ID = string;
        if (this.printManager != null && (job = this.printManager.getNewPrintManager().getPrintJob()) != null) {
            job.setID(this.ID);
        }
    }

    public KDTKeyControlManager getKeyControlManager() {
        return this.keyControlManager;
    }

    public KDTPrintManager getPrintManager() {
        if (this.printManager == null) {
            this.printManager = new KDTPrintManager(this);
        }
        return this.printManager;
    }

    public void setPrintConfigDefault(boolean gridDefault, boolean singleColorDefault, boolean rowIndexDefault, boolean columnIndexDefault, boolean orderDefault) {
        this.getPrintManager().setDefault(gridDefault, singleColorDefault, rowIndexDefault, columnIndexDefault, orderDefault);
    }

    public void setPrintManager(KDTPrintManager printManager) {
        this.printManager = printManager;
    }

    public void setDataModel(KDTColumns columns, KDTHead head, KDTBody body) {
        this.columns = columns;
        this.head = head;
        this.body = body;
    }

    public KDTFootManager getFootManager() {
        return this.footManager;
    }

    public void setFootManager(KDTFootManager fm) {
        this.footManager = fm;
    }

    public boolean isHasFoot() {
        return this.footManager != null && this.footManager.isFootViewAdded();
    }

    public int getHeadRowCount() {
        return this.getHead().size();
    }

    public void setHeadRowCount(int headRowCount) {
    }

    public int getRowCount() {
        if (this.dataRequestManager.getDataRequestMode() == 0) {
            return this.getBody().size();
        }
        return this.rowCount;
    }

    public int getRowCount1() {
        if (this.dataRequestManager.getDataRequestMode() == 0) {
            return this.getBody().size();
        }
        if (this.rowCount == -1) {
            return Integer.MAX_VALUE;
        }
        return this.rowCount;
    }

    int getRowCount2() {
        return this.rowCount;
    }

    public int getRowCount3() {
        if (this.dataRequestManager.getDataRequestMode() == 0) {
            return this.getBody().size();
        }
        if (this.rowCount == -1) {
            return this.getBody().size();
        }
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public void setColumnCount(int columnCount) {
    }

    public KDTCorner getCorner() {
        return this.corner;
    }

    public KDTHead getHead() {
        return this.head;
    }

    public KDTBody getBody() {
        return this.body;
    }

    public KDTIndexColumn getIndexColumn() {
        return this.indexCol;
    }

    public KDTColumns getColumns() {
        return this.columns;
    }

    public KDTTreeColumn getTreeColumn() {
        return this.treeColumn;
    }

    public void expandTreeColumnTo(int valve) {
        if (valve < 0) {
            return;
        }
        int maxLevel = this.treeColumn.getDepth() - 1;
        int rowCount = this.getRowCount3();
        boolean refresh = this.isRefresh();
        this.setRefresh(false);
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = this.getBody().getRow(i);
            if (row == null) continue;
            int rLevel = row.getTreeLevel();
            if (rLevel == valve && rLevel < maxLevel) {
                this.treeColumn.doCollapse(i);
                continue;
            }
            if (rLevel >= valve) continue;
            row.setCollapse(false);
            this.treeColumn.doExpand(i);
        }
        this.setRefresh(refresh);
        this.repaint();
    }

    public String getColumnKey(int colIndex) {
        return this.columns.getColumnKey(colIndex);
    }

    public int getColumnIndex(String key) {
        return this.columns.getColumnIndex(key);
    }

    public KDTDataRequestManager getDataRequestManager() {
        return this.dataRequestManager;
    }

    public KDTViewManager getViewManager() {
        return this.viewManager;
    }

    public synchronized int getVerticalCount() {
        return this.verticalCount;
    }

    public synchronized void setVerticalCount(int verticalCount) {
        this.verticalCount = verticalCount;
    }

    public synchronized int getHorizonCount() {
        return this.horizonCount;
    }

    public synchronized void setHorizonCount(int horizonCount) {
        this.horizonCount = horizonCount;
    }

    public KDTLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public KDTSelectManager getSelectManager() {
        return this.selectManager;
    }

    public KDTEditManager getEditManager() {
        return this.editManager;
    }

    public KDTEditHelper getEditHelper() {
        if (this.editHelper == null) {
            this.editHelper = new KDTEditHelper(this);
        }
        return this.editHelper;
    }

    public KDTMergeManager getHeadMergeManager() {
        return this.headMergeManager;
    }

    public KDTMergeManager getMergeManager() {
        return this.mergeManager;
    }

    public KDTGroupManager gerGroupManager() {
        return this.groupManager;
    }

    public KDTGroupManager getGroupManager() {
        return this.groupManager;
    }

    public KDTIOManager getIOManager() {
        return this.ioManager;
    }

    public KDTScriptManager getScriptManager() {
        if (this.scriptManager == null) {
            this.scriptManager = new KDTScriptManager(this);
        }
        return this.scriptManager;
    }

    public ScriptContext getScriptContext() {
        if (this.scriptHelper == null) {
            this.scriptHelper = new ScriptContext(this);
        }
        return this.scriptHelper;
    }

    public RelationsListener getRelationsListener() {
        return this.getScriptContext();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(KDTBasicUI.createUI(this));
    }

    @Override
    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    static void createBuffer(Rectangle rect) {
        if (rect == null || rect.width <= 0 || rect.height <= 0) {
            if (bufferImage == null) {
                Dimension screenSize = KDToolkit.getScreenSize();
                bufferImage = new BufferedImage(screenSize.width, screenSize.height, 2);
                bufferGraphics = (Graphics2D)bufferImage.getGraphics();
            }
            return;
        }
        if (bufferImage == null || bufferImage.getWidth() < rect.width || bufferImage.getHeight() < rect.height) {
            int bw = 0;
            int bh = 0;
            if (bufferImage != null) {
                bw = bufferImage.getWidth();
                bh = bufferImage.getHeight();
            }
            int width = Math.max(bw, rect.width);
            int height = Math.max(bh, rect.height);
            bufferImage = new BufferedImage(width, height, 2);
            bufferGraphics = (Graphics2D)bufferImage.getGraphics();
        }
    }

    public static BufferedImage getBufferedImage() {
        if (bufferImage == null) {
            KDTable.createBuffer(null);
        }
        return bufferImage;
    }

    public static Graphics2D getBufferGraphics() {
        if (bufferGraphics == null) {
            KDTable.createBuffer(null);
        }
        return bufferGraphics;
    }

    public int getExpandedColumnCount() {
        int i;
        int exRowCount = this.getExpandedRowCount();
        int exColumnCount = 0;
        List cols = this.columns.getColumns();
        for (i = cols.size() - 1; i >= 0; --i) {
            KDTColumn col = (KDTColumn)cols.get(i);
            if (col == null || col.isEmpty()) continue;
            exColumnCount = i + 1;
            break;
        }
        block1: for (i = 0; i < exRowCount; ++i) {
            KDTRow row = this.body.getRow2(i);
            if (row == null) continue;
            ArrayList l = row.getCells();
            for (int j = l.size(); j >= exColumnCount; --j) {
                KDTCell cell = row.getCell(j);
                if (cell == null || cell.isEmpty()) continue;
                exColumnCount = j + 1;
                continue block1;
            }
        }
        return exColumnCount;
    }

    public int getExpandedRowCount() {
        List rows = this.body.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            KDTRow row = (KDTRow)rows.get(i);
            if (row == null || row.isEmpty()) continue;
            return i + 1;
        }
        return 0;
    }

    public Color getHeadGridLineColor() {
        return this.headGridLineColor;
    }

    public void setHeadGridLineColor(Color headGridLineColor) {
        this.headGridLineColor = headGridLineColor;
    }

    public boolean isHorizonHeadGridLineVisible() {
        return this.horizonHeadGridLineVisible;
    }

    public void setHorizonHeadGridLineVisible(boolean horizonHeadGridLineVisible) {
        this.horizonHeadGridLineVisible = horizonHeadGridLineVisible;
        this.repaint();
    }

    public boolean isVerticalHeadGridLineVisible() {
        return this.verticalHeadGridLineVisible;
    }

    public void setVerticalHeadGridLineVisible(boolean verticalHeadGridLineVisible) {
        this.verticalHeadGridLineVisible = verticalHeadGridLineVisible;
        this.repaint();
    }

    public boolean isHorizonGridLineVisible() {
        return this.horizonGridLineVisible;
    }

    public void setHorizonGridLineVisible(boolean horizonGridLineVisible) {
        this.horizonGridLineVisible = horizonGridLineVisible;
        this.repaint();
    }

    public boolean isVerticalGridLineVisible() {
        return this.verticalGridLineVisible;
    }

    public void setVerticalGridLineVisible(boolean verticalGridLineVisible) {
        this.verticalGridLineVisible = verticalGridLineVisible;
        this.repaint();
    }

    public Color getGridLineColor() {
        return this.gridLineColor;
    }

    public void setGridLineColor(Color gridLineColor) {
        this.gridLineColor = gridLineColor;
    }

    public int getActiveCellStatus() {
        return this.activeCellStatus;
    }

    public void setActiveCellStatus(int activeCellStatus) {
        this.activeCellStatus = activeCellStatus;
    }

    public int getCellDisplayMode() {
        return this.cellDisplayMode;
    }

    public void setCellDisplayMode(int cellDisplayMode) {
        this.cellDisplayMode = cellDisplayMode;
        this.repaint();
    }

    public Color[] getHeadVergesColor() {
        return this.headVergesColor;
    }

    public void setHeadVergesColor(Color[] colors) {
        this.headVergesColor = colors;
    }

    public int getDefaultHeadRowHeight() {
        return this.defaultHeadRowHeight;
    }

    public void setDefaultHeadRowHeight(int height) {
        this.defaultHeadRowHeight = height;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int height) {
        this.defaultRowHeight = height;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    public StyleAttributes getHeadStyleAttributes() {
        KDTCellIndex index = new KDTCellIndex();
        index.setRowIndex(-1);
        index.setColIndex(-1);
        index.setType(0);
        I18nStyleAttributes sa = new I18nStyleAttributes(this.headSSA, this.i18nEnabled);
        sa.append((ShareStyleAttributes)this.headStyle, false);
        sa.setOwner((Object)index);
        sa.setListener((StyleAttributesChangeListener)this.saListener);
        return sa;
    }

    public void setHeadStyleAttributes(StyleAttributes sa) {
        this.headSSA = Styles.getSSA((StyleAttributes)sa);
        this.headStyle = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{this.headSSA});
        int rowCount = this.getHeadRowCount();
        int colCount = this.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = this.head.getRow2(i);
            row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), this.headSSA}));
            for (int j = 0; j < colCount; ++j) {
                KDTCell cell = row.getCell(j);
                cell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), this.headSSA}));
            }
        }
        this.repaint();
    }

    void setHeadSSA(ShareStyleAttributes ssa) {
        this.headSSA = ssa;
    }

    void setHeadStyle(Style style) {
        this.headStyle = style;
    }

    public StyleAttributes getStyleAttributes() {
        KDTCellIndex index = new KDTCellIndex();
        index.setRowIndex(-1);
        index.setColIndex(-1);
        index.setType(1);
        I18nStyleAttributes sa = new I18nStyleAttributes(this.bodySSA, this.i18nEnabled);
        sa.append((ShareStyleAttributes)this.bodyStyle, false);
        sa.setOwner((Object)index);
        sa.setListener((StyleAttributesChangeListener)this.saListener);
        return sa;
    }

    public void setStyleAttributes(StyleAttributes sa) {
        int i;
        this.bodySSA = Styles.getSSA((StyleAttributes)sa);
        this.bodyStyle = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{this.bodySSA});
        int rowCount = this.getRowCount3();
        int colCount = this.getColumnCount();
        for (i = 0; i < colCount; ++i) {
            KDTColumn column = this.columns.getColumn(i);
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)column.getSSA());
            tsa.clearDirtyFlag();
            tsa.replaceDirty((ShareStyleAttributes)sa, false);
            ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)tsa);
            column.setSSA(ssa);
            column.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{column.getSSA(), this.bodySSA}));
        }
        for (i = 0; i < rowCount; ++i) {
            KDTRow row = this.body.getRow2(i);
            if (row == null) continue;
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)row.getSSA());
            tsa.clearDirtyFlag();
            tsa.replaceDirty((ShareStyleAttributes)sa, false);
            ShareStyleAttributes rowssa = Styles.getSSA((StyleAttributes)tsa);
            row.setSSA(rowssa);
            row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), this.bodySSA}));
            for (int j = 0; j < colCount; ++j) {
                KDTCell cell = row.getCell(j);
                if (cell == null) continue;
                tsa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                tsa.replaceDirty((ShareStyleAttributes)sa, false);
                if (sa.isDirtyAttribute(ShareStyleAttributes.NUMBER_FORMAT)) {
                    cell.setFormattedValue(null);
                }
                ShareStyleAttributes cellssa = Styles.getSSA((StyleAttributes)tsa);
                cell.setSSA(cellssa);
                cell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), this.columns.getColumn(j).getSSA(), this.bodySSA}));
            }
        }
        this.repaint();
    }

    public int getHeadDisplayMode() {
        return this.headDisplayMode;
    }

    public void setHeadDisplayMode(int headDisplayMode) {
        if (this.headDisplayMode != headDisplayMode) {
            this.headDisplayMode = headDisplayMode;
            if (this.headDisplayMode == 1) {
                this.removeHeadRows();
                KDTExcelHeadRow row = new KDTExcelHeadRow(this.getHeadSSA());
                ShareStyleAttributes ssa = Styles.getEmptySSA();
                row.setSSA(ssa);
                row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.headSSA}));
                this.getHead().addRow(0, row);
            }
            this.reLayoutAndPaint();
        }
    }

    public ShareStyleAttributes getHeadSSA() {
        return this.headSSA;
    }

    Style getHeadStyle() {
        return this.headStyle;
    }

    public ShareStyleAttributes getSSA() {
        return this.bodySSA;
    }

    Style getStyle() {
        return this.bodyStyle;
    }

    public void setGetRowListener(KDTGetRowListener getRowListener) {
        this.getRowListener = getRowListener;
    }

    public KDTGetRowListener getGetRowListener() {
        return this.getRowListener;
    }

    public void setBeforeRemoveRowsAction(Action action) {
        this.beforeRemoveRowsAction = action;
    }

    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void addKDTDataRequestListener(KDTDataRequestListener l) {
        if (this.getDataRequestManager() != null) {
            this.getDataRequestManager().addDataRequestListener(l);
        }
    }

    public void removeKDTDataRequestListener(KDTDataRequestListener l) {
        if (this.getDataRequestManager() != null) {
            this.getDataRequestManager().removeDataRequestListener(l);
        }
    }

    public void addKDTDataFillListener(KDTDataFillListener l) {
        if (this.getDataRequestManager() != null) {
            this.getDataRequestManager().addDataFillListener(l);
        }
    }

    public void removeKDTDataFillListener(KDTDataFillListener l) {
        if (this.getDataRequestManager() != null) {
            this.getDataRequestManager().removeDataFillListener(l);
        }
    }

    public void addKDTMouseListener(KDTMouseListener l) {
        this.getListenerList().add(KDTMouseListener.class, l);
    }

    public void removeKDTMouseListener(KDTMouseListener l) {
        this.getListenerList().remove(KDTMouseListener.class, l);
    }

    public void addKDTSelectListener(KDTSelectListener l) {
        if (this.getSelectManager() != null) {
            this.getSelectManager().addKDTSelectListener(l);
        }
    }

    public void removeKDTSelectListener(KDTSelectListener l) {
        if (this.getSelectManager() != null) {
            this.getSelectManager().removeKDTSelectListener(l);
        }
    }

    public void addKDTActiveCellListener(KDTActiveCellListener l) {
        if (this.getSelectManager() != null) {
            this.getSelectManager().addKDTActiveCellListener(l);
        }
    }

    public void removeKDTActiveCellListener(KDTActiveCellListener l) {
        if (this.getSelectManager() != null) {
            this.getSelectManager().removeKDTActiveCellListener(l);
        }
    }

    public void addKDTEditListener(KDTEditListener l) {
        if (this.getEditManager() != null) {
            this.getEditManager().addKDTEditListener(l);
        }
    }

    public void removeKDTEditListener(KDTEditListener l) {
        if (this.getEditManager() != null) {
            this.getEditManager().removeKDTEditListener(l);
        }
    }

    public void addKDTPropertyChangeListener(KDTPropertyChangeListener l) {
        this.getListenerList().add(KDTPropertyChangeListener.class, l);
    }

    public void removeKDTPropertyChangeListener(KDTPropertyChangeListener l) {
        this.getListenerList().remove(KDTPropertyChangeListener.class, l);
    }

    void fireTableRowResize(KDTResizeEvent e) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTResizeListener.class) continue;
            ((KDTResizeListener)listeners[i + 1]).tableRowResize(e);
        }
    }

    void fireTableColumnResize(KDTResizeEvent e) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTResizeListener.class) continue;
            ((KDTResizeListener)listeners[i + 1]).tableColumnResize(e);
        }
    }

    void fireTableClick(KDTMouseEvent e) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            ((KDTMouseListener)listeners[i + 1]).tableClicked(e);
        }
    }

    void fireCellPropertyChange(String propertyName, Object oldValue, Object value, KDTCellIndex index) {
        Object[] listeners = this.getListenerList().getListenerList();
        KDTPropertyChangeEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTPropertyChangeListener.class) continue;
            if (e == null) {
                e = new KDTPropertyChangeEvent(this, propertyName, oldValue, value, index.getRowIndex(), index.getColIndex(), index.getType());
            }
            ((KDTPropertyChangeListener)listeners[i + 1]).propertyChange(e);
        }
    }

    void firePropertyChange(KDTPropertyChangeEvent e) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTPropertyChangeListener.class) continue;
            ((KDTPropertyChangeListener)listeners[i + 1]).propertyChange(e);
        }
    }

    public void setFormatXml(String formatXml) {
        this.formatXml = formatXml;
        this.formatXmlReader = null;
        this.formatXmlStream = null;
    }

    public void setFormatXml(Reader formatXml) {
        this.formatXml = null;
        this.formatXmlReader = formatXml;
        this.formatXmlStream = null;
    }

    public void setFormatXml(InputStream formatXml) {
        this.formatXml = null;
        this.formatXmlReader = null;
        this.formatXmlStream = formatXml;
    }

    public String getOringinFormatXML() {
        return this.formatXml;
    }

    public void checkParsed() {
        KDTable.printDebugInfo("checkParsed begin" + (System.currentTimeMillis() - beginDate));
        if (this.autoParse) {
            this.autoParse = false;
            if (this.formatXml != null) {
                this.parseFormatXml(this.formatXml);
            } else if (this.formatXmlReader != null) {
                this.parseFormatXml(this.formatXmlReader, false);
            } else if (this.formatXmlStream != null) {
                this.parseFormatXml(this.formatXmlStream, false);
            }
            this.checkBindContents();
        }
        KDTable.printDebugInfo("checkParsed after" + (System.currentTimeMillis() - beginDate));
    }

    public void checkParsed(boolean isReparse) {
        if (isReparse) {
            this.autoParse = true;
        }
        this.checkParsed();
    }

    void checkBindContents() {
        if (this.objectName != null) {
            this.putBindContents2(this.objectName, this.fields);
        } else if (this.objectNames != null) {
            this.putBindContents2(this.objectNames, this.fields);
        }
    }

    public void parseFormatXml(String formatXml) {
        this.parseFormatXml(formatXml, false);
    }

    public void parseFormatXml(String formatXml, boolean formatOnly) {
        if (formatXml == null || formatXml.equals("")) {
            return;
        }
        this.parseFormatXml(new StringReader(formatXml), formatOnly);
    }

    public void parseFormatXml(Reader formatXml, boolean formatOnly) {
        Object obj = this.getClientProperty("formatOnly");
        this.putClientProperty("formatOnly", formatOnly);
        this.ioManager.load(formatXml);
        this.putClientProperty("formatOnly", obj);
    }

    public void parseFormatXml(InputStream formatXml, boolean formatOnly) {
        Object obj = this.getClientProperty("formatOnly");
        this.putClientProperty("formatOnly", formatOnly);
        this.ioManager.load(formatXml);
        this.putClientProperty("formatOnly", obj);
    }

    public void putBindContents(String objectName, String[] fields) {
        this.objectName = objectName;
        this.fields = fields;
    }

    void putBindContents2(String objectName, String[] fields) {
        int colCount = this.getColumnCount();
        int size = fields.length > colCount ? colCount : fields.length;
        for (int i = 0; i < size; ++i) {
            this.getDataRequestManager().putBindContents(i, objectName, fields[i]);
        }
    }

    public void putBindContents(String[] objectNames, String[] fields) {
        this.objectNames = objectNames;
        this.fields = fields;
    }

    void putBindContents2(String[] objectNames, String[] fields) {
        int size;
        int colCount = this.getColumnCount();
        int n = size = objectNames.length < fields.length ? objectNames.length : fields.length;
        if (size > colCount) {
            size = colCount;
        }
        for (int i = 0; i < size; ++i) {
            this.getDataRequestManager().putBindContents(i, objectNames[i], fields[i]);
        }
    }

    public void addRequestRowSetListener(RequestRowSetListener listener) {
        this.getDataRequestManager().getDataSetFactory().addRequestRowSetListener(listener);
    }

    public void removeRequestRowSetListener(RequestRowSetListener listener) {
        this.getDataRequestManager().getDataSetFactory().removeRequestRowSetListener(listener);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void refresh() {
        this.removeRows();
    }

    protected void initUIElement() {
        int vIndex;
        if (this.viewManager.getViewCount() > 0) {
            return;
        }
        int vCount = this.getVerticalCount();
        int hCount = this.getHorizonCount();
        BasicView view = null;
        for (vIndex = 0; vIndex < vCount; ++vIndex) {
            for (int hIndex = 0; hIndex < hCount; ++hIndex) {
                if (vIndex < 1) {
                    if (hIndex == 0) {
                        view = new KDTTreeCornerView(this);
                    } else if (hIndex < 2) {
                        view = new KDTCornerView(this, this.columns, this.corner);
                    } else if (this.getHeadDisplayMode() == 1) {
                        view = new KDTExcelHeadView(this, this.columns, this.head);
                        if (this.getHead().size() <= 0) {
                            this.addHeadRow();
                        }
                    } else {
                        view = new KDTHeadView(this, this.columns, this.head);
                    }
                } else {
                    view = hIndex == 0 ? new KDTTreeColumnView(this) : (hIndex == 1 ? new KDTIndexColumnView(this, this.getIndexColumn(), this.columns, this.body) : new KDTView(this, this.columns, this.body));
                }
                this.viewManager.addView(vIndex, hIndex, view);
            }
        }
        for (vIndex = 0; vIndex < vCount; ++vIndex) {
            KDTVertical vertical = vIndex < 1 ? new KDTVertical(this) : new KDTVertical(this, true);
            this.layoutManager.addVertical(vIndex, vertical);
        }
        for (int hIndex = 0; hIndex < hCount; ++hIndex) {
            KDTHorizon horizon = hIndex < 2 ? new KDTHorizon(this) : new KDTHorizon(this, true);
            this.layoutManager.addHorizon(hIndex, horizon);
        }
    }

    private void doAutoMerge() {
        if (!this.autoMerge) {
            return;
        }
        int lastRow = this.getHeadRowCount() - 1;
        int lastCol = this.getColumnCount() - 1;
        this.getHeadMergeManager().mergeFree(0, 0, lastRow, lastCol);
        lastRow = this.getRowCount() - 1;
        if (this.dataRequestManager.getDataRequestMode() == 0) {
            if (this.groupManager.isGroup()) {
                this.groupManager.group();
            } else {
                this.getMergeManager().mergeFree(0, 0, lastRow, lastCol);
            }
        }
        this.autoMerge = false;
    }

    @Override
    public void doLayout() {
        KDTable.printDebugInfo("doLayout begin" + (System.currentTimeMillis() - beginDate));
        if (this.autoParse) {
            this.checkParsed();
        }
        this.doUILayout();
        KDTable.printDebugInfo("doLayout after" + (System.currentTimeMillis() - beginDate));
        this.doAutoMerge();
        KDTViewManager manager = this.getViewManager();
        if (!manager.isFreeze() && this.isAutoResize()) {
            manager.getView(manager.getDefaultActiveViewIndex()).setWidthsFromPreferredWidths(false);
        }
    }

    public boolean isAutoResize() {
        return this.isAutoResize;
    }

    public void setAutoResize(boolean bool) {
        this.isAutoResize = bool;
    }

    void doUILayout() {
        Rectangle rect = this.getBounds();
        KDTable.createBuffer(rect);
        super.doLayout();
    }

    public boolean isRefresh() {
        return this.refresh && this.enableRepaint;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void update() {
        this.setRefresh(true);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        KDTable.printDebugInfo(this.getClass().toString() + " begin:" + (System.currentTimeMillis() - beginDate));
        super.paint(g);
        Rectangle r = this.getLayoutManager().getMovingSplitBarRect();
        if (r != null) {
            g.setColor(new Color(162, 162, 162));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        this.setRefresh(true);
        KDTable.printDebugInfo(this.getClass().toString() + " after:" + (System.currentTimeMillis() - beginDate));
    }

    @Override
    public void repaint() {
        if (this.isRefresh()) {
            KDTable.printDebugInfo("--------repaint");
            super.repaint();
        }
    }

    public void enableRepaint(boolean enable) {
        this.enableRepaint = enable;
    }

    public void reLayoutAndPaint() {
        if (this.isRefresh()) {
            KDTable.printDebugInfo("--------reLayoutAndPaint");
            this.doUILayout();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        for (int i = this.viewManager.getViewCount() - 1; i >= 0; --i) {
            this.viewManager.getView(i).setBackground(bg);
        }
        this.repaint();
    }

    public IColumn addColumn() {
        return this.addColumn(this.columns.size());
    }

    public IColumn addColumn(int colIndex) {
        KDTColumn column = this.createColumn();
        return this.addColumn(colIndex, column);
    }

    public KDTColumn createColumn() {
        KDTColumn column = new KDTColumn();
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        column.setSSA(ssa);
        column.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.bodySSA}));
        return column;
    }

    public IColumn addColumn(int colIndex, IColumn column) {
        return this.addColumn(colIndex, column.getKDTColumn());
    }

    public IColumn addColumn(int colIndex, KDTColumn column) {
        KDTRow row;
        int i;
        if (!this.excuteBeforeAction(2, colIndex)) {
            return null;
        }
        if (this.getUndoManager() != null) {
            this.getUndoManager().createAddColEdit(colIndex, column);
        }
        this.columns.addColumn(colIndex, column);
        for (i = 0; i < this.head.size(); ++i) {
            row = this.head.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, null);
        }
        for (i = 0; i < this.body.size(); ++i) {
            row = this.body.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, null);
        }
        this.getHeadMergeManager().adjustInserCol(colIndex);
        this.getMergeManager().adjustInserCol(colIndex);
        if (this.footManager != null && this.footManager.getFoot() != null) {
            this.footManager.getFoot().addColumn(colIndex);
            this.footManager.getMergeManager().adjustInserCol(colIndex);
        }
        if (this.scriptManager != null) {
            this.scriptManager.adjustInsertCol(colIndex);
        }
        if (this.isRefresh()) {
            this.getLayoutManager().invalidateHorizonLast();
            this.reLayoutAndPaint();
        }
        this.excuteAfterAction(2, colIndex);
        return new XColumn(colIndex, column);
    }

    public void addColumns(int colCount) {
        for (int i = 0; i < colCount; ++i) {
            this.addColumn();
        }
    }

    public IRow addRow() {
        return this.addRow(this.body.size());
    }

    public IRow addRow(int rowIndex) {
        KDTRow row = this.createRow(this.getColumnCount());
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        row.setSSA(ssa);
        if (this.csManager != null) {
            this.csManager.rowHandle(rowIndex, row);
        }
        row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), this.bodySSA}));
        return this.addRow(rowIndex, row);
    }

    public KDTRow createRow(int index) {
        KDTRow row = new KDTRow(index);
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        row.setSSA(ssa);
        return row;
    }

    public IRow addRow(int rowIndex, IRow row) {
        return this.addRow(rowIndex, row.getKDTRow());
    }

    public IRow addRow(int rowIndex, KDTRow row) {
        if (!this.excuteBeforeAction(0, rowIndex)) {
            return null;
        }
        if (this.getUndoManager() != null) {
            this.getUndoManager().createAddRowEdit(rowIndex, row);
        }
        this.body.addRow(rowIndex, row);
        this.getMergeManager().adjustInserRow(rowIndex);
        if (this.scriptManager != null) {
            this.scriptManager.adjustInsertRow(rowIndex);
        }
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
        this.excuteAfterAction(0, rowIndex);
        return new XRow(rowIndex, 1, row);
    }

    public IRow setRow(int rowIndex) {
        KDTRow row = new KDTRow(this.getColumnCount());
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        row.setSSA(ssa);
        if (this.csManager != null) {
            this.csManager.rowHandle(rowIndex, row);
        }
        row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), this.bodySSA}));
        return this.setRow(rowIndex, row);
    }

    IRow setRow(int rowIndex, KDTRow row) {
        this.body.setRow(rowIndex, row);
        return new XRow(rowIndex, 1, row);
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    public IRow addHeadRow() {
        return this.addHeadRow(this.head.size());
    }

    public IRow addHeadRow(int rowIndex) {
        KDTRow row = new KDTRow(this.getColumnCount());
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        row.setSSA(this.headSSA.isEmpty() ? ssa : this.headSSA);
        row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.headSSA}));
        return this.addHeadRow(rowIndex, row);
    }

    public IRow addHeadRow(int rowIndex, IRow row) {
        return this.addHeadRow(rowIndex, row.getKDTRow());
    }

    IRow addHeadRow(int rowIndex, KDTRow row) {
        this.head.addRow(rowIndex, row);
        this.getHeadMergeManager().adjustInserRow(rowIndex);
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
        return new XRow(rowIndex, 0, row);
    }

    public void addHeadRows(int headRowCount) {
        for (int i = 0; i < headRowCount; ++i) {
            this.addHeadRow();
        }
    }

    public IColumn removeColumn(int colIndex) {
        KDTRow row;
        int i;
        if (!this.excuteBeforeAction(3, colIndex)) {
            return null;
        }
        if (colIndex < 0 || colIndex >= this.columns.size()) {
            return null;
        }
        if (this.getUndoManager() != null) {
            this.getUndoManager().createRemoveColEdit(colIndex);
        }
        KDTColumn column = this.columns.removeColumn(colIndex);
        for (i = 0; i < this.head.size(); ++i) {
            row = this.head.getRow2(i);
            if (row == null) continue;
            row.removeCell(colIndex);
        }
        for (i = 0; i < this.body.size(); ++i) {
            row = this.body.getRow2(i);
            if (row == null) continue;
            row.removeCell(colIndex);
        }
        this.getSelectManager().adjustDeleteCol(colIndex);
        this.getHeadMergeManager().adjustDeleteCol(colIndex);
        this.getMergeManager().adjustDeleteCol(colIndex);
        if (this.footManager != null && this.footManager.getFoot() != null) {
            this.footManager.getFoot().removeColumn(colIndex);
            this.footManager.getMergeManager().adjustDeleteCol(colIndex);
        }
        if (this.scriptManager != null) {
            this.scriptManager.adjustDeleteCol(colIndex);
        }
        this.getLayoutManager().invalidateHorizonLast();
        this.reLayoutAndPaint();
        this.groupManager.fillIndexs();
        this.excuteAfterAction(3, colIndex);
        return new XColumn(colIndex, column);
    }

    public void removeColumns() {
        this.getDataRequestManager().removeBindContents();
        this.getHeadMergeManager().getMergeBlockSet().clear();
        this.reInitialize();
        this.getGroupManager().reInitialize();
        this.body.removeRows();
        this.head.removeRows();
        this.columns.removeColumns();
        this.setHeadDisplayMode(0);
        this.setRowCount(0);
        this.getLayoutManager().invalidateHorizon();
        this.getLayoutManager().invalidateVertical();
        this.reLayoutAndPaint();
    }

    public IRow removeRow(int rowIndex) {
        if (!this.excuteBeforeAction(1, rowIndex)) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.body.size()) {
            return null;
        }
        if (this.getUndoManager() != null) {
            this.getUndoManager().createRemoveRowEdit(rowIndex);
        }
        KDTRow row = this.body.removeRow(rowIndex);
        if (this.rowCount > 0) {
            --this.rowCount;
        }
        this.getSelectManager().adjustDeleteRow(rowIndex);
        this.getMergeManager().adjustDeleteRow(rowIndex);
        if (this.getEditManager().getEditRowIndex() == rowIndex) {
            this.getEditManager().cancelEditing();
        }
        if (this.scriptManager != null) {
            this.scriptManager.adjustDeleteRow(rowIndex);
        }
        if (this.body.getRows().size() == 0) {
            this.getLayoutManager().invalidateVertical();
        }
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
        this.excuteAfterAction(1, rowIndex);
        return new XRow(rowIndex, 1, row);
    }

    public void removeRows() {
        this.removeRows(true);
    }

    public void removeRows(boolean autoRefreshData) {
        if (this.beforeRemoveRowsAction != null) {
            this.beforeRemoveRowsAction.actionPerformed(null);
        }
        this.body.removeRows();
        if (autoRefreshData) {
            this.setRowCount(-1);
        } else {
            this.setRowCount(0);
        }
        this.reInitialize();
        this.getLayoutManager().invalidateVertical();
        this.reLayoutAndPaint();
    }

    public IRow removeHeadRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.head.size()) {
            return null;
        }
        KDTRow row = this.head.removeRow(rowIndex);
        this.getHeadMergeManager().adjustDeleteRow(rowIndex);
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
        return new XRow(rowIndex, 0, row);
    }

    public void removeHeadRows() {
        this.getHeadMergeManager().getMergeBlockSet().clear();
        this.head.removeRows();
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
    }

    public IColumn getColumn(int colIndex) {
        KDTColumn column = this.columns.getColumn(colIndex);
        if (column == null) {
            return null;
        }
        return new XColumn(colIndex, column);
    }

    public IColumn getColumn(String key) {
        int colIndex = this.columns.getColumnIndex(key);
        KDTColumn column = this.columns.getColumn(colIndex);
        if (column == null) {
            return null;
        }
        return new XColumn(colIndex, column);
    }

    public IRow getRow(int rowIndex) {
        KDTRow row = this.body.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 1, row);
    }

    public IRow getRow2(int rowIndex) {
        KDTRow row = this.body.getRow2(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 1, row);
    }

    public IRow getHeadRow(int rowIndex) {
        KDTRow row = this.head.getRow2(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 0, row);
    }

    public ICell getCell(int rowIndex, int colIndex) {
        IRow row = this.getRow(rowIndex);
        if (row != null) {
            return row.getCell(colIndex);
        }
        return null;
    }

    public ICell getCell(int rowIndex, String colKey) {
        int colIndex = this.columns.getColumnIndex(colKey);
        return this.getCell(rowIndex, colIndex);
    }

    public IRow getFootRow(int rowIndex) {
        if (!this.isHasFoot()) {
            return null;
        }
        KDTRow row = this.getFootManager().getFoot().getRow2(rowIndex);
        if (row == null) {
            return null;
        }
        return new XRow(rowIndex, 6, row);
    }

    public IRow addFootRow(int rowIndex) {
        KDTRow row = new KDTRow(this.getColumnCount());
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        row.setSSA(ssa);
        row.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.bodySSA}));
        return this.addFootRow(rowIndex, row);
    }

    public IRow addFootRow(int rowIndex, IRow row) {
        return this.addFootRow(rowIndex, row.getKDTRow());
    }

    IRow addFootRow(int rowIndex, KDTRow row) {
        this.getFootManager().getFoot().addRow(rowIndex, row);
        this.footManager.getMergeManager().adjustInserRow(rowIndex);
        this.getLayoutManager().invalidateVerticalLast();
        this.reLayoutAndPaint();
        return new XRow(rowIndex, 6, row);
    }

    public void setColumnStyle(int colIndex, StyleAttributes sa, boolean bAll) {
        if (bAll) {
            this.setColumnStyle2(colIndex, sa);
        } else {
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)this.columns.getColumn(colIndex).getSSA());
            tsa.clearDirtyFlag();
            tsa.replaceDirty((ShareStyleAttributes)sa);
            this.setColumnStyle2(colIndex, sa);
        }
        int rowCount = this.body.size();
        boolean formatChange = bAll || sa.isDirtyAttribute(ShareStyleAttributes.NUMBER_FORMAT);
        KDTColumn column = this.columns.getColumn(colIndex);
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = this.body.getRow2(i);
            if (row == null) continue;
            KDTCell cell = row.getCell(colIndex);
            ShareStyleAttributes tempssa = cell != null ? cell.getSSA() : Styles.getEmptySSA();
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)tempssa);
            int count = tsa.replaceDirty((ShareStyleAttributes)sa, row.getSSA());
            if (cell == null) {
                if (count <= 0) continue;
                cell = new KDTCell();
                cell.setSSA(this.getBlankCellSSA());
                row.setCell(colIndex, cell);
            }
            if (formatChange) {
                cell.setFormattedValue(null);
            }
            ShareStyleAttributes cellssa = Styles.getSSA((StyleAttributes)tsa);
            cell.setSSA(cellssa);
            cell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), column.getSSA(), this.bodySSA}));
        }
    }

    private void setColumnStyle2(int colIndex, StyleAttributes sa) {
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.bodySSA});
        KDTColumn column = this.columns.getColumn(colIndex);
        column.setSSA(ssa);
        column.setStyle(style);
    }

    public void setRowStyle(int rowIndex, StyleAttributes sa, boolean bAll) {
        KDTRow row = this.body.getRow(rowIndex);
        this.setRowStyle(row, sa, bAll);
    }

    public void setRowStyle(KDTRow row, StyleAttributes sa, boolean bAll) {
        if (row == null) {
            return;
        }
        StyleAttributes trowsa = Styles.getSA((ShareStyleAttributes)row.getSSA());
        trowsa.clearDirtyFlag();
        trowsa.replaceDirty((ShareStyleAttributes)sa);
        this.setRowStyle2(row, trowsa);
        boolean formatChange = bAll || sa.isDirtyAttribute(ShareStyleAttributes.NUMBER_FORMAT);
        int colCount = this.columns.size();
        for (int i = 0; i < colCount; ++i) {
            KDTCell cell;
            KDTColumn column = this.columns.getColumn(i);
            if (column == null || (cell = row.getCell(i)) == null) continue;
            if (formatChange) {
                cell.setFormattedValue(null);
            }
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
            tsa.clearDirtyFlag();
            tsa.replaceDirty((ShareStyleAttributes)sa, false);
            ShareStyleAttributes cellssa = Styles.getSSA((StyleAttributes)tsa);
            cell.setSSA(cellssa);
            cell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), column.getSSA(), this.bodySSA}));
        }
        if (trowsa.isDirtyAttribute(ShareStyleAttributes.PROTECTION_HIDDED)) {
            this.getLayoutManager().invalidateVerticalLast();
            this.reLayoutAndPaint();
        }
    }

    private void setRowStyle2(KDTRow row, StyleAttributes sa) {
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.bodySSA});
        row.setSSA(ssa);
        row.setStyle(style);
    }

    private void setCellStyle(KDTRow row, int colIndex, StyleAttributes sa) {
        ShareStyleAttributes ssaRow = row.getSSA();
        KDTCell cell = row.getCell(colIndex);
        if (cell != null) {
            StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
            tsa.clearDirtyFlag();
            tsa.replaceDirty((ShareStyleAttributes)sa);
            sa = tsa;
            ShareStyleAttributes ssaCol = this.getColumns().getColumn(colIndex).getSSA();
            ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
            Style style = cell.getFormattedSSA() == null ? Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, ssaCol, this.bodySSA}) : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getFormattedSSA(), ssa, ssaRow, ssaCol, this.bodySSA});
            cell.setSSA(ssa);
            cell.setStyle(style);
            if (sa.isDirtyAttribute(ShareStyleAttributes.NUMBER_FORMAT)) {
                cell.setFormattedValue(null);
            }
        }
    }

    void setHeadRowStyle(int rowIndex, StyleAttributes sa) {
        this.setHeadRowStyle2(rowIndex, sa);
        int colCount = this.columns.size();
        KDTRow row = this.head.getRow2(rowIndex);
        for (int i = 0; i < colCount; ++i) {
            KDTCell cell;
            KDTColumn column = this.columns.getColumn(i);
            if (column == null || (cell = row.getCell(i)) == null) continue;
            Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), sa, this.headSSA});
            cell.setStyle(style);
        }
    }

    void setHeadRowStyle2(int rowIndex, StyleAttributes sa) {
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{sa, this.headSSA});
        KDTRow row = this.head.getRow2(rowIndex);
        row.setSSA(Styles.getSSA((StyleAttributes)sa));
        row.setStyle(style);
    }

    void setHeadCellStyle(int rowIndex, int colIndex, StyleAttributes sa) {
        KDTRow row = this.head.getRow2(rowIndex);
        ShareStyleAttributes ssaRow = row.getSSA();
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{sa, ssaRow, this.headSSA});
        row.getCell(colIndex).setSSA(Styles.getSSA((StyleAttributes)sa));
        row.getCell(colIndex).setStyle(style);
    }

    void setCellStyle(int rowIndex, int colIndex, StyleAttributes sa) {
        KDTRow row = this.body.getRow2(rowIndex);
        KDTCell cell = row.getCell(colIndex);
        if (cell == null) {
            cell = new KDTCell();
            cell.setSSA(this.getBlankCellSSA());
            row.setCell(colIndex, cell);
        }
        Object formatOld = cell.getSSA().get(ShareStyleAttributes.NUMBER_FORMAT);
        StyleAttributes saTemp = Styles.getSA((StyleAttributes)sa);
        saTemp.append(cell.getSSA(), false);
        ShareStyleAttributes cellssa = Styles.getSSA((StyleAttributes)saTemp);
        cell.setSSA(cellssa);
        cell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), this.columns.getColumn(colIndex).getSSA(), this.bodySSA}));
        Object format = cell.getSSA().get(ShareStyleAttributes.NUMBER_FORMAT);
        if (!(formatOld == null && format == null || formatOld != null && format != null && formatOld.equals(format))) {
            cell.setFormattedValue(null);
        }
    }

    public ShareStyleAttributes getBlankCellSSA() {
        return Styles.getEmptySSA();
    }

    StyleAttributes getBlankCellSA(ShareStyleAttributes ssaRow, ShareStyleAttributes ssaCol) {
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, ssaCol, this.bodySSA});
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
        sa.append((ShareStyleAttributes)style, false);
        return sa;
    }

    Style getBlankCellStyle(ShareStyleAttributes ssaRow, ShareStyleAttributes ssaCol) {
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        Style style = ssaCol == null ? (ssaRow == ssa ? this.headStyle : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, this.headSSA})) : (ssaRow == ssa && ssaCol == ssa ? this.bodyStyle : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, ssaCol, this.bodySSA}));
        return style;
    }

    KDTCell createBlankCell(int rowIndex, int colIndex) {
        KDTCell cell = new KDTCell();
        KDTRow row = this.getBody().getRow(rowIndex);
        ShareStyleAttributes ssaCol = this.getColumns().getColumn(colIndex).getSSA();
        ShareStyleAttributes ssa = Styles.getEmptySSA();
        ShareStyleAttributes ssaRow = row.getSSA();
        Style style = this.getBlankCellStyle(ssaRow, ssaCol);
        cell.setSSA(ssa);
        cell.setStyle(style);
        row.setCell(colIndex, cell);
        return cell;
    }

    Style applyCellStyle(int rowIndex, int colIndex) {
        KDTRow row = this.getBody().getRow(rowIndex);
        KDTCell cell = row.getCell(colIndex);
        if (cell != null) {
            ShareStyleAttributes ssaRow = row.getSSA();
            ShareStyleAttributes ssaCol = this.getColumns().getColumn(colIndex).getSSA();
            ShareStyleAttributes ssa = cell.getSSA();
            Style style = cell.getFormattedSSA() == null ? Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, ssaCol, this.bodySSA}) : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getFormattedSSA(), ssa, ssaRow, ssaCol, this.bodySSA});
            cell.setStyle(style);
            return style;
        }
        return null;
    }

    void applyHeadCellStyle() {
        KDTHead rows = this.getHead();
        for (int i = 0; i < rows.size(); ++i) {
            KDTRow row = rows.getRow(i);
            ArrayList cells = row.getCells();
            for (int j = 0; j < cells.size(); ++j) {
                KDTCell cell = row.getCell(j);
                if (cell == null) continue;
                ShareStyleAttributes ssaRow = row.getSSA();
                ShareStyleAttributes ssa = cell.getSSA();
                Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, this.headSSA});
                cell.setStyle(style);
            }
        }
    }

    SpreadStyleDesigner getSpreadStyleDesigner(Component parent, boolean modal) {
        if (this.spreadStyleDesigner == null) {
            if (parent == null) {
                parent = SwingUtilities.getRoot(this);
            }
            this.spreadStyleDesigner = parent instanceof Frame ? new SpreadStyleDesigner((Frame)parent, modal) : (parent instanceof Dialog ? new SpreadStyleDesigner((Dialog)parent, modal) : new SpreadStyleDesigner((Frame)null, modal));
            this.spreadStyleDesigner.setTitle(CtrlKDTableMessages.getMLS("cellStyle", "Cell Style"));
            this.spreadStyleDesigner.setLocationRelativeTo(null);
            this.spreadStyleDesigner.getPanProtection().setChkHiddenVisible(false);
        }
        return this.spreadStyleDesigner;
    }

    StyleDesigner getStyleDesigner(Component parent, boolean modal) {
        if (this.styleDesigner == null) {
            if (parent == null) {
                parent = SwingUtilities.getRoot(this);
            }
            this.styleDesigner = parent instanceof Frame ? new StyleDesigner((Frame)parent, modal) : (parent instanceof Dialog ? new StyleDesigner((Dialog)parent, modal) : new StyleDesigner((Frame)null, modal));
            this.styleDesigner.setTitle(CtrlKDTableMessages.getMLS("cellStyle", "Cell Style"));
            this.styleDesigner.setLocationRelativeTo(null);
            this.styleDesigner.getPanProtection().setChkHiddenVisible(false);
        }
        return this.styleDesigner;
    }

    public void showStyleDesigner() {
        KDTRange range = this.getSelectManager().toRange();
        this.showInnerStyleDesigner(this.getSpreadStyleDesigner(null, true), range);
    }

    public void showStyleDesigner(Dialog parent, boolean modal) {
        KDTRange range = this.getSelectManager().toRange();
        this.showStyleDesigner(range, parent, modal);
    }

    public void showStyleDesigner(Frame parent, boolean modal) {
        KDTRange range = this.getSelectManager().toRange();
        this.showStyleDesigner(range, parent, modal);
    }

    public void showStyleDesigner(KDTRange range, Dialog parent, boolean modal) {
        if (range == null || range.size() <= 0) {
            return;
        }
        SpreadStyleDesigner sd = new SpreadStyleDesigner(parent, modal);
        sd.setTitle(CtrlKDFMessages.getMLS((String)"BooleanValueFalse", (String)"Cell Style"));
        sd.setLocationRelativeTo(null);
        sd.getPanProtection().setChkHiddenVisible(false);
        this.showInnerStyleDesigner(sd, range);
    }

    public void showStyleDesigner(KDTRange range, Frame parent, boolean modal) {
        if (range == null || range.size() <= 0) {
            return;
        }
        SpreadStyleDesigner sd = new SpreadStyleDesigner(parent, modal);
        sd.setTitle(CtrlKDTableMessages.getMLS("cellStyle", "Cell Style"));
        sd.setLocationRelativeTo(null);
        sd.getPanProtection().setChkHiddenVisible(false);
        this.showInnerStyleDesigner(sd, range);
    }

    public void showStyleDesigner(StyleDesigner sd, KDTRange range) {
        sd.getPanProtection().setChkHiddenVisible(false);
        StyleAttributes saMix = this.getRangeSA(range);
        sd.setSA(saMix);
        sd.show();
        if (sd.isChanged()) {
            if (this.getUndoManager() != null) {
                this.getUndoManager().createStyleEdit(range);
            }
            StyleAttributes sa = sd.getSA();
            this.setRangeSA(range, sa);
            this.repaint();
        }
    }

    private void showInnerStyleDesigner(SpreadStyleDesigner sd, KDTRange range) {
        sd.getPanProtection().setChkHiddenVisible(false);
        StyleAttributes saMix = this.getRangeSA(range);
        sd.setSA(saMix);
        sd.show();
        if (sd.isChanged()) {
            if (this.getUndoManager() != null) {
                this.getUndoManager().createStyleEdit(range);
            }
            StyleAttributes sa = sd.getSA();
            this.setRangeSA(range, sa);
            this.repaint();
        }
    }

    private void setRangeSA(KDTRange range, StyleAttributes sa) {
        block6: for (IBlock block : range) {
            switch (block.getMode()) {
                case 8: {
                    StyleAttributes saTemp = this.getStyleAttributes();
                    saTemp.setOwner(null);
                    saTemp.clearDirtyFlag();
                    saTemp.replaceDirty((ShareStyleAttributes)sa);
                    this.setStyleAttributes(saTemp);
                    continue block6;
                }
                case 4: {
                    int i;
                    int left = block.getLeft();
                    int right = block.getRight();
                    for (i = left; i <= right; ++i) {
                        this.setColumnStyle(i, sa, false);
                    }
                    continue block6;
                }
                case 2: {
                    int i;
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    for (i = top; i <= bottom; ++i) {
                        this.getRow(i).setStyleAttributes(sa);
                    }
                    continue block6;
                }
                case 1: {
                    StyleAttributes saTemp;
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    int left = block.getLeft();
                    int right = block.getRight();
                    for (int i = top; i <= bottom; ++i) {
                        IRow row = this.getRow(i);
                        for (int j = left; j <= right; ++j) {
                            ICell cell = row.getCell(j);
                            if (cell == null) continue;
                            saTemp = cell.getStyleAttributes();
                            saTemp.setOwner(null);
                            saTemp.clearDirtyFlag();
                            saTemp.replaceDirty((ShareStyleAttributes)sa);
                            cell.setStyleAttributes(saTemp);
                        }
                    }
                    continue block6;
                }
            }
        }
    }

    private StyleAttributes getRangeSA(KDTRange range) {
        HashMap<Style, Style> saMap = new HashMap<Style, Style>();
        Iterator it = range.iterator();
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        while (it.hasNext()) {
            Style styleTemp;
            IBlock block = (IBlock)it.next();
            switch (block.getMode()) {
                case 8: {
                    top = 0;
                    bottom = this.getRowCount() - 1;
                    left = 0;
                    right = this.getColumnCount() - 1;
                    styleTemp = this.getStyle();
                    saMap.put(styleTemp, styleTemp);
                    break;
                }
                case 4: {
                    int i;
                    top = 0;
                    bottom = this.getRowCount() - 1;
                    left = block.getLeft();
                    right = block.getRight();
                    for (i = left; i <= right; ++i) {
                        styleTemp = this.getColumn(i).getKDTColumn().getStyle();
                        saMap.put(styleTemp, styleTemp);
                    }
                    break;
                }
                case 2: {
                    int i;
                    top = block.getTop();
                    bottom = block.getBottom();
                    left = 0;
                    right = this.getColumnCount() - 1;
                    for (i = top; i <= bottom; ++i) {
                        styleTemp = this.getRow(i).getKDTRow().getStyle();
                        saMap.put(styleTemp, styleTemp);
                    }
                    break;
                }
                case 1: {
                    top = block.getTop();
                    bottom = block.getBottom();
                    left = block.getLeft();
                    right = block.getRight();
                    break;
                }
            }
            for (int i = top; i <= bottom; ++i) {
                KDTRow row = this.body.getRow(i);
                for (int j = left; j <= right; ++j) {
                    KDTCell cell = row.getCell(j);
                    styleTemp = cell != null ? cell.getStyle() : this.getBlankCellStyle(row.getSSA(), this.columns.getColumn(j).getSSA());
                    saMap.put(styleTemp, styleTemp);
                }
            }
        }
        Object[] os = saMap.values().toArray();
        int length = os.length;
        if (length <= 0) {
            return null;
        }
        ShareStyleAttributes[] sas = new ShareStyleAttributes[os.length];
        for (int i = 0; i < os.length; ++i) {
            sas[i] = (ShareStyleAttributes)os[i];
        }
        StyleAttributes sa = Styles.mixSA((ShareStyleAttributes[])sas);
        sa.append((ShareStyleAttributes)Styles.getDefaultStyle(), false);
        sa.clearDirtyFlag();
        return sa;
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new LazyValueMap.LazyValue(s));
    }

    public void putDefaultRenderers(Class c, IBasicRender renderer) {
        this.defaultRenderers.put(c, renderer);
    }

    public void putDefaultEditor(Class c, ICellEditor editor) {
        this.defaultEditors.put(c, editor);
    }

    private void createDefaultRenderers() {
        this.defaultRenderers = new LazyValueMap();
        this.setLazyValue(this.defaultRenderers, Object.class, "com.kingdee.cosmic.ctrl.kdf.util.render.CellTextRender");
        KDTable.printDebugInfo("CellTextRender" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultRenderers, Boolean.class, "com.kingdee.cosmic.ctrl.kdf.util.render.CellCheckBoxRenderer");
        KDTable.printDebugInfo("CellCheckBoxRenderer" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultRenderers, ImageIcon.class, "com.kingdee.cosmic.ctrl.kdf.util.render.CellIconRender");
        KDTable.printDebugInfo("CellIconRender" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultRenderers, Image.class, "com.kingdee.cosmic.ctrl.kdf.util.render.CellImageRender");
        KDTable.printDebugInfo("CellImageRender" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultRenderers, CellTreeNode.class, "com.kingdee.cosmic.ctrl.kdf.util.render.CellTreeRender2");
        this.setLazyValue(this.defaultRenderers, KDTableSplitRectangleInfo.class, "com.kingdee.cosmic.ctrl.kdf.table.render.TableBiasRender");
        this.setLazyValue(this.defaultRenderers, Date.class, "com.kingdee.cosmic.ctrl.kdf.util.render.DatePickerRender");
        this.setLazyValue(this.defaultRenderers, HyperLink.class, "com.kingdee.cosmic.ctrl.kdf.util.render.HyperLinkRender");
    }

    private void createDefaultEditors() {
        this.defaultEditors = new LazyValueMap();
        this.setLazyValue(this.defaultEditors, Object.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$TextEditor");
        KDTable.printDebugInfo("JTextField" + (System.currentTimeMillis() - beginDate));
        KDTable.printDebugInfo("FormattedTextEditor" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultEditors, Boolean.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$BooleanEditor");
        KDTable.printDebugInfo("JCheckBox" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultEditors, Date.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$DatePickerEditor");
        KDTable.printDebugInfo("KDDatePicker" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultEditors, Image.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$ImageEditor");
        KDTable.printDebugInfo("KDTDefaultCellEditor" + (System.currentTimeMillis() - beginDate));
        this.setLazyValue(this.defaultEditors, CellTreeNode.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$CellTreeEditor");
        this.setLazyValue(this.defaultEditors, HyperLink.class, "com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory$HyperLinkEditor");
    }

    private IBasicRender getHeadCustomRenderer(int rowIndex, int colIndex) {
        IBasicRender renderer = null;
        KDTCell cell = this.head.getRow(rowIndex).getCell(colIndex);
        if (cell != null) {
            renderer = cell.getRenderer();
        }
        if (renderer == null) {
            renderer = this.head.getRow(rowIndex).getRenderer();
        }
        return renderer;
    }

    private IBasicRender getCustomRenderer(int rowIndex, int colIndex) {
        KDTColumn col;
        IBasicRender renderer = null;
        KDTRow row = this.body.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        KDTCell cell = row.getCell(colIndex);
        if (cell != null) {
            renderer = cell.getRenderer();
        }
        if (renderer == null) {
            renderer = this.body.getRow(rowIndex).getRenderer();
        }
        if (renderer == null && (col = this.columns.getColumn(colIndex)) != null) {
            renderer = col.getRenderer();
        }
        return renderer;
    }

    public IBasicRender getDefaultRenderer(Class c) {
        if (c == null) {
            return null;
        }
        Object renderer = this.defaultRenderers.get(c);
        if (renderer != null) {
            return (IBasicRender)renderer;
        }
        return this.getDefaultRenderer(c.getSuperclass());
    }

    ICellEditor getCustomEditor(int rowIndex, int colIndex) {
        return this.getCustomEditor(rowIndex, colIndex, this.body);
    }

    ICellEditor getHeadCustomEditor(int rowIndex, int colIndex) {
        return this.getCustomEditor(rowIndex, colIndex, this.head);
    }

    ICellEditor getCustomEditor(int rowIndex, int colIndex, IRows rows) {
        KDTColumn col;
        ICellEditor editor = null;
        KDTRow row = rows.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        KDTCell cell = row.getCell(colIndex);
        if (cell != null) {
            editor = cell.getEditor();
        }
        if (editor == null) {
            editor = row.getEditor();
        }
        if (editor == null && (col = this.columns.getColumn(colIndex)) != null) {
            editor = col.getEditor();
        }
        return editor;
    }

    public ICellEditor getDefaultEditor(Class c) {
        if (c == null) {
            return null;
        }
        Object editor = this.defaultEditors.get(c);
        if (editor != null) {
            return (ICellEditor)editor;
        }
        return this.getDefaultEditor(c.getSuperclass());
    }

    public ICellEditor getCellEditor(int rowIndex, int colIndex) {
        return this.getCellEditor(rowIndex, colIndex, true);
    }

    public ICellEditor getHeadCellEditor(int rowIndex, int colIndex) {
        return this.getCellEditor(rowIndex, colIndex, false);
    }

    public ICellEditor getCellEditor(int rowIndex, int colIndex, boolean isBody) {
        ICellEditor editor = null;
        editor = isBody ? this.getCustomEditor(rowIndex, colIndex) : this.getHeadCustomEditor(rowIndex, colIndex);
        if (editor == null) {
            Object value = null;
            KDTCell cell = null;
            KDTRow row = null;
            row = isBody ? this.body.getRow(rowIndex) : this.head.getRow(rowIndex);
            if (row != null) {
                cell = row.getCell(colIndex);
            }
            if (cell != null) {
                value = cell.getValue();
            }
            editor = this.getDefaultEditor(value == null ? Object.class : value.getClass());
        }
        return editor;
    }

    public IBasicRender getCellRenderer(int rowIndex, int colIndex) {
        IBasicRender renderer = this.getCustomRenderer(rowIndex, colIndex);
        if (renderer == null) {
            Object value = null;
            KDTRow row = this.body.getRow(rowIndex);
            if (row != null) {
                KDTCell cell = row.getCell(colIndex);
                if (cell != null) {
                    value = cell.getValue();
                }
                renderer = this.getDefaultRenderer(value == null ? Object.class : value.getClass());
            }
        }
        return renderer;
    }

    public IBasicRender getHeadCellRenderer(int rowIndex, int colIndex) {
        IBasicRender renderer = this.getHeadCustomRenderer(rowIndex, colIndex);
        if (renderer == null) {
            Object value = null;
            KDTCell cell = this.head.getRow(rowIndex).getCell(colIndex);
            if (cell != null) {
                value = cell.getValue();
            }
            renderer = this.getDefaultRenderer(value == null ? Object.class : value.getClass());
        }
        return renderer;
    }

    Object getCellEditValue(ICell cell) {
        Object value = cell.getValue();
        if (value instanceof Calendar) {
            Format format = Formats.getFormat((String)"yyyy-MM-dd");
            value = format.format(new Variant(value)).getText();
        }
        return value;
    }

    public Object getCellDisplayValue(KDTCell cell, int rowIndex, int colIndex) {
        return this.getCellDisplayValue(new XCell(rowIndex, colIndex, 1, cell));
    }

    public Object getCellDisplayValue(ICell cell) {
        Object value = null;
        Format format = Formats.getFormat((String)"yyyy-MM-dd");
        switch (this.getCellDisplayMode()) {
            case 0: {
                value = cell.getFormattedValue();
                if (value != null || !((value = cell.getValue()) instanceof Calendar)) break;
                value = format.format(new Variant(value));
                break;
            }
            case 1: {
                value = cell.getExpressions();
                if (value == null) {
                    value = cell.getFormattedValue();
                }
                if (value != null || !((value = cell.getValue()) instanceof Calendar)) break;
                value = format.format(new Variant(value));
                break;
            }
            case 2: {
                value = cell.getExpressions();
                break;
            }
        }
        if (this.getUserCellDisplayParser() != null) {
            int rowIndex = cell.getRowIndex();
            int colIndex = cell.getColumnIndex();
            value = this.getUserCellDisplayParser().parse(rowIndex, colIndex, cell, value);
        }
        return value;
    }

    public void setUserCellDisplayParser(IUserCellDisplayParser parser) {
        this.userCellDisplayParser = parser;
    }

    public IUserCellDisplayParser getUserCellDisplayParser() {
        return this.userCellDisplayParser;
    }

    public String getCellDisplayText(KDTCell cell, int rowIndex, int colIndex) {
        return this.getCellDisplayText(new XCell(rowIndex, colIndex, 1, cell));
    }

    public String getCellDisplayText(ICell cell) {
        String text;
        if (cell == null || cell.getKDTCell() == null) {
            return "";
        }
        Object obj = this.getCellDisplayValue(cell);
        IBasicRender render = this.getCellRenderer(cell.getRowIndex(), cell.getColumnIndex());
        if (render instanceof ObjectValueRender) {
            text = ((ObjectValueRender)render).getText(obj);
            if (text == null) {
                text = "";
            }
        } else if (render instanceof CellTextRender) {
            text = ((CellTextRender)render).getText(obj);
            if (text == null) {
                text = "";
            }
        } else {
            text = obj != null ? String.valueOf(obj) : "";
        }
        return text;
    }

    public int getScrollStateVertical() {
        return this.m_scrollStateVertical;
    }

    public int getScrollStateHorizon() {
        return this.m_scrollStateHorizon;
    }

    public void setScrollStateVertical(int value) {
        if (value == 0 || value == 1 || value == 2) {
            this.m_scrollStateVertical = value;
            this.reLayoutAndPaint();
        }
    }

    public void setScrollStateHorizon(int value) {
        if (value == 0 || value == 1 || value == 2) {
            this.m_scrollStateHorizon = value;
            this.reLayoutAndPaint();
        }
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        KDTable.debug = debug;
    }

    public static void printDebugInfo(String info) {
        if (debug) {
            System.out.println(info);
            log.info((Object)info);
        }
    }

    public void setSSA(ShareStyleAttributes bodySSA) {
        this.bodySSA = bodySSA;
    }

    void setStyle(Style bodyStyle) {
        this.bodyStyle = bodyStyle;
    }

    public int getFormulaMode() {
        return this.formulaMode;
    }

    public void setFormulaMode(int formula) {
        this.formulaMode = formula;
    }

    boolean isScriptAutoRun() {
        return this.scriptAutoRun;
    }

    void setScriptAutoRun(boolean scriptAutoRun) {
        this.scriptAutoRun = scriptAutoRun;
    }

    boolean isScriptAutoAdjust() {
        return this.scriptAutoAdjust;
    }

    void setScriptAutoAdjust(boolean scriptAutoAdjust) {
        this.scriptAutoAdjust = scriptAutoAdjust;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.imRequestHandle == null) {
            this.imRequestHandle = new InputMethodContext();
        }
        return this.imRequestHandle;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void putUserProperty(String name, Object o) {
        if (this.userProperties == null) {
            this.userProperties = new HashMap();
        }
        this.userProperties.put(name, o);
    }

    public Object getUserProperty(String name) {
        return this.userProperties.get(name);
    }

    public void setUndo(boolean enable) {
        if (enable) {
            if (this.undoManager == null) {
                this.undoManager = new KDTableUndoManager(this);
            }
        } else if (this.undoManager != null) {
            this.undoManager.clear();
        }
    }

    public KDTableUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoPause(boolean isPause) {
        if (this.undoManager != null) {
            this.undoManager.setPause(isPause);
        }
    }

    public void addKDTResizeListener(KDTResizeListener l) {
        this.getListenerList().add(KDTResizeListener.class, l);
    }

    public void removeKDTResizeListener(KDTResizeListener l) {
        this.getListenerList().remove(KDTResizeListener.class, l);
    }

    public int getRowsAutoResizeMode() {
        return this.rowAutoResizeMode;
    }

    public void setRowsAutoResizeMode(int mode) {
        this.rowAutoResizeMode = mode;
    }

    public int getColumnsAutoResizeMode() {
        return this.colAutoResizeMode;
    }

    public void setColumnsAutoResizeMode(int mode) {
        if (mode == 0 || mode == 1 || mode == 2 || mode == 3 || mode == 4) {
            this.colAutoResizeMode = mode;
        }
    }

    public boolean isColumnMoveable() {
        return this.columnMoveable;
    }

    public void setColumnMoveable(boolean bool) {
        this.columnMoveable = bool;
    }

    public void setMergeHeadMoveable(boolean moveable) {
        this.getHeadMergeManager().setMergeMode(3);
        this.mergeHeadMoveable = moveable;
    }

    public boolean isMergeHeadMoveable() {
        return this.mergeHeadMoveable;
    }

    public void addKDTColumnMoveListener(KDTColumnMoveListener l) {
        this.getListenerList().add(KDTColumnMoveListener.class, l);
    }

    public boolean moveColumn(int from, int to) {
        int flag = this.isCanMoveColumn(from, to);
        if (flag == 0) {
            return false;
        }
        boolean refresh = this.isRefresh();
        this.setRefresh(false);
        this.columns.moveColumn(from, to);
        if (this.head != null) {
            this.head.moveColumn(from, to);
        }
        if (this.body != null) {
            this.body.moveColumn(from, to);
        }
        this.getHeadMergeManager().adjustMoveCol(from, to);
        this.getMergeManager().adjustMoveCol(from, to);
        this.getGroupManager().fillIndexs();
        if (this.footManager != null && this.footManager.getFoot() != null) {
            this.footManager.getFoot().moveColumn(from, to);
            this.footManager.getMergeManager().adjustMoveCol(from, to);
        }
        if (this.mergeHeadMoveable) {
            this.getHeadMergeManager().setIgnoreHideCol(true);
            this.getHeadMergeManager().mergeFree(0, 0, this.getHeadRowCount() - 1, this.getColumnCount() - 1);
            this.getHeadMergeManager().setIgnoreHideCol(false);
        }
        this.setRefresh(refresh);
        this.fireColumnMove(new KDTColumnMoveEvent(this, KDTColumnMoveEvent.COLUMN_MOVE, from, to));
        this.reLayoutAndPaint();
        return true;
    }

    public boolean exchangeColumn(int from, int to) {
        if (!this.isCanExchangeColumn(from, to)) {
            return false;
        }
        boolean refresh = this.isRefresh();
        this.setRefresh(false);
        this.columns.exchangeColumn(from, to);
        if (this.head != null) {
            this.head.exchangeColumn(from, to);
        }
        if (this.body != null) {
            this.body.exchangeColumn(from, to);
        }
        this.getHeadMergeManager().adjustExchangeCol(from, to);
        this.getMergeManager().adjustExchangeCol(from, to);
        if (this.footManager != null && this.footManager.getFoot() != null) {
            this.footManager.getFoot().exchangeColumn(from, to);
            this.footManager.getMergeManager().adjustExchangeCol(from, to);
        }
        this.fireColumnMove(new KDTColumnMoveEvent(this, KDTColumnMoveEvent.COLUMN_EXCHANGE, from, to));
        this.setRefresh(refresh);
        this.reLayoutAndPaint();
        return true;
    }

    public boolean exchangeColumn(String fromCcolumnKey, String toCcolumnKey) {
        int from = this.getColumnIndex(fromCcolumnKey);
        int to = this.getColumnIndex(toCcolumnKey);
        return this.exchangeColumn(from, to);
    }

    public void fireColumnMove(KDTColumnMoveEvent event) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTColumnMoveListener.class) continue;
            ((KDTColumnMoveListener)listeners[i + 1]).columnMoved(event);
        }
    }

    private boolean isCanExchangeColumn(int from, int to) {
        if (!this.checkMoveORexchangeColumn(from, to)) {
            return false;
        }
        KDTMergeManager manager = this.getHeadMergeManager();
        return !manager.hasMultiColumnMerge(from) && !manager.hasMultiColumnMerge(to);
    }

    private int isCanMoveColumn(int from, int to) {
        if (to == from + 1) {
            return 0;
        }
        if (!this.checkMoveORexchangeColumn(from, to)) {
            return 0;
        }
        KDTMergeManager manager = this.getHeadMergeManager();
        if (manager.hasMultiColumnMerge(from) || !manager.hasFirstColumnInMultiColumnMerge(to)) {
            KDTMergeBlock mb;
            KDTCell cell = this.head.getRow2(0).getCell(from);
            if (this.head.size() <= 2 && cell != null && cell.getMergeBlock() != null && (mb = cell.getMergeBlock()).getLeft() <= to && mb.getRight() >= to) {
                return 2;
            }
            return this.mergeHeadMoveable ? 3 : 0;
        }
        return 1;
    }

    private boolean checkMoveORexchangeColumn(int from, int to) {
        if (!this.isColumnMoveable()) {
            return false;
        }
        if (from < 0 || to < 0 || from == to || from >= this.getColumnCount() || to >= this.getColumnCount()) {
            return false;
        }
        return this.getColumn(from).isMoveable() && this.getColumn(to).isMoveable();
    }

    public boolean moveRow(int from, int to) {
        if (this.canMoveRow(from, to)) {
            boolean refresh = this.isRefresh();
            this.setRefresh(false);
            this.getBody().moveRow(from, to);
            this.setRefresh(refresh);
            this.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public boolean exchangeRow(int from, int to) {
        if (this.canMoveRow(from, to)) {
            boolean refresh = this.isRefresh();
            this.setRefresh(false);
            this.getBody().exchangeRow(from, to);
            this.setRefresh(refresh);
            this.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public boolean canMoveRow(int from, int to) {
        return from >= 0 && to >= 0 && from != to && from < this.getRowCount() && to < this.getRowCount();
    }

    public ConditionStyleManager getCsManager() {
        if (this.csManager == null) {
            this.csManager = new ConditionStyleManager();
        }
        return this.csManager;
    }

    public void setCsManager(ConditionStyleManager csManager) {
        this.csManager = csManager;
    }

    public BeforeActionListener getBeforeAction() {
        return this.beforeAction;
    }

    public void setBeforeAction(BeforeActionListener beforeAction) {
        this.beforeAction = beforeAction;
    }

    public BeforeActionListener getAfterAction() {
        return this.afterAction;
    }

    public void setAfterAction(BeforeActionListener afterAction) {
        this.afterAction = afterAction;
    }

    public void addBeforeActionListener(BeforeActionListener beforeAction) {
        if (this.beforeActions == null) {
            this.beforeActions = new ArrayList();
        }
        this.beforeActions.add(beforeAction);
    }

    public void removeBeforeActionListener(BeforeActionListener beforeAction) {
        if (this.beforeActions == null) {
            this.beforeActions = new ArrayList();
        }
        this.beforeActions.remove(beforeAction);
    }

    public void addExportActionListener(ExportDataActionListener l) {
        if (null == this.exportActionListeners) {
            this.exportActionListeners = new ArrayList<ExportDataActionListener>();
        }
        this.exportActionListeners.add(l);
    }

    public void removeExportActionListener(ExportDataActionListener l) {
        if (null != this.exportActionListeners) {
            this.exportActionListeners.remove(l);
        }
    }

    public void removeExportActionListener(int n) {
        if (null != this.exportActionListeners && n >= 0 && n < this.exportActionListeners.size()) {
            this.exportActionListeners.remove(n);
        }
    }

    public void addImportActionListener(ImportDataActionListener l) {
        if (null == this.importDataActionListeners) {
            this.importDataActionListeners = new ArrayList<ImportDataActionListener>();
        }
        this.importDataActionListeners.add(l);
    }

    public void removeImportActionListener(ImportDataActionListener l) {
        if (null != this.importDataActionListeners) {
            this.importDataActionListeners.remove(l);
        }
    }

    public void removeImportActionListener(int n) {
        if (null != this.importDataActionListeners && n >= 0 && n < this.importDataActionListeners.size()) {
            this.importDataActionListeners.remove(n);
        }
    }

    public void addAfterActionListener(BeforeActionListener afterAction) {
        if (this.afterActions == null) {
            this.afterActions = new ArrayList();
        }
        this.afterActions.add(afterAction);
    }

    public void removeAfterActionListener(BeforeActionListener afterAction) {
        if (this.afterActions == null) {
            this.afterActions = new ArrayList();
        }
        this.afterActions.add(afterAction);
    }

    boolean excuteBeforeAction(int type, Object parameter) {
        if (this.beforeAction != null || this.beforeActions != null) {
            BeforeActionEvent e = new BeforeActionEvent(this, type, parameter);
            if (this.beforeAction != null) {
                this.beforeAction.beforeAction(e);
                if (e.isCancel()) {
                    return false;
                }
            }
            if (this.beforeActions != null) {
                Iterator iterator = this.beforeActions.iterator();
                while (iterator.hasNext()) {
                    ((BeforeActionListener)iterator.next()).beforeAction(e);
                    if (!e.isCancel()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    void excuteAfterAction(int type, Object parameter) {
        if (this.afterAction != null || this.afterActions != null) {
            BeforeActionEvent e = new BeforeActionEvent(this, type, parameter);
            if (this.afterAction != null) {
                this.afterAction.beforeAction(e);
            }
            if (this.afterActions != null) {
                Iterator iterator = this.afterActions.iterator();
                while (iterator.hasNext()) {
                    ((BeforeActionListener)iterator.next()).beforeAction(e);
                }
            }
        }
    }

    void fireImportEvent(DataActionEvent e) {
        if (null != this.importDataActionListeners) {
            for (ImportDataActionListener l : this.importDataActionListeners) {
                l.doImport(e);
            }
        }
    }

    void fireExportEvent(DataActionEvent e) {
        if (null != this.exportActionListeners) {
            for (ExportDataActionListener l : this.exportActionListeners) {
                l.doExport(e);
            }
        }
    }

    public Color getRequiredColor() {
        if (this.requiredColor == null) {
            this.requiredColor = new Color(252, 251, 223);
        }
        return this.requiredColor;
    }

    public void setRequiredColor(Color requiredColor) {
        this.requiredColor = requiredColor;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getAccessAuthority() {
        return 0;
    }

    public void setAccessAuthority(int authority) {
    }

    public ICellFormatter getCellCustomFormatter() {
        return this.cellCustomFormatter;
    }

    public void setCellCustomFormatter(ICellFormatter cellCustomFormatter) {
        this.cellCustomFormatter = cellCustomFormatter;
    }

    void updateCellFormula(int rowIndex, int colIndex) {
        if (this.scriptManager != null) {
            this.scriptManager.cellFormulaChanged(rowIndex, colIndex);
        }
    }

    private KDInfoTip getInfoTip() {
        if (this.kit3 == null) {
            this.kit3 = new KDInfoTip(null, new Rectangle(), "", 1);
            this.kit3.setMaxRenderWidth(600.0f);
        }
        return this.kit3;
    }

    public void showCellDetailInfo() {
        int r = this.getSelectManager().getActiveRowIndex();
        int c = this.getSelectManager().getActiveColumnIndex();
        this.showCellDetailInfo(r, c);
    }

    public void hideCellDetailInfo() {
        if (this.kit3 != null) {
            this.kit3.setShowing(false);
        }
    }

    public void showCellDetailInfo(int rIndex, int cIndex) {
        int viewIdx = this.getSelectManager().getActiveViewIndex();
        BasicView view = this.getViewManager().getView(viewIdx);
        if (view instanceof KDTView) {
            KDTView kdtView = (KDTView)view;
            ICell cell = this.getCell(rIndex, cIndex);
            if (cell == null) {
                return;
            }
            String text = this.getCellDisplayText(cell);
            if (text != null && !"".equals(text)) {
                Rectangle rect = kdtView.getCellRectangle(rIndex, cIndex);
                KDInfoTip kit3 = this.getInfoTip();
                kit3.setParent((JComponent)kdtView);
                kit3.setInnerRectangle(rect);
                kit3.setText(text);
                kit3.setArrowHeight(15);
                kit3.setShowing(true);
            }
        }
    }

    public Object getTextAt(int rowIndex, int colIndex) {
        ICell cell = this.getCell(rowIndex, colIndex);
        if (cell != null) {
            return this.getCellDisplayText(cell);
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        KDTCell cell = this.getBody().getCell(rowIndex, colIndex);
        if (cell != null) {
            return cell.getValue();
        }
        return null;
    }

    public void fireTableClick(int rowIndex, int colIndex, int clickCount) {
        this.getSelectManager().select(rowIndex, colIndex);
        MouseEvent e = new MouseEvent(this, 500, System.currentTimeMillis(), 16, rowIndex, colIndex, clickCount, false, 1);
        KDTMouseEvent e1 = new KDTMouseEvent(this, e, rowIndex, colIndex, 1);
        this.fireTableClick(e1);
    }

    public void scrollToVisible(int rowIndex, int colIndex) {
        int viewIndex = this.getMainViewIndex();
        this.getLayoutManager().scrollToShow(viewIndex, rowIndex, colIndex);
    }

    public Point cellAtPosition(int x, int y) {
        int viewIndex = this.getMainViewIndex();
        KDTView view = (KDTView)this.getViewManager().getView(viewIndex);
        Point p = SwingUtilities.convertPoint(this, x, y, view);
        KDTCellPosition pos = view.getCellPosition(p.x, p.y);
        return new Point(pos.colIndex, pos.rowIndex);
    }

    public Rectangle positionOfCell(int rowIndex, int colIndex) {
        int viewIndex = this.getMainViewIndex();
        this.getLayoutManager().scrollToShow(viewIndex, rowIndex, colIndex);
        KDTView view = (KDTView)this.getViewManager().getView(viewIndex);
        Rectangle rect = view.getCellRectangle(rowIndex, colIndex);
        Point p = SwingUtilities.convertPoint(view, rect.x, rect.y, this);
        rect.x = p.x;
        rect.y = p.y;
        return rect;
    }

    private int getMainViewIndex() {
        int v = this.getVerticalCount();
        int h = this.getHorizonCount();
        if (this.isHasFoot()) {
            --v;
        }
        return v * h - 1;
    }

    public boolean isRequired() {
        return false;
    }

    public void setRequired(boolean required) {
    }

    public KDTSortManager getSortMange() {
        return this.sortMange;
    }

    public void setSortMange(KDTSortManager sortMange) {
        this.sortMange = sortMange;
    }

    public void setI18nEnabled(boolean i18nEnabled) {
        this.i18nEnabled = i18nEnabled;
    }

    public boolean isI18nEnabled() {
        return this.i18nEnabled;
    }

    public boolean isAreaPrint() {
        return this.printManager.getNewPrintManager().getPrintJobConfig().getPrintAreas() == null;
    }

    public void setCopyFID(boolean b) {
        this.copyFID = b;
    }

    public boolean isCopyFID() {
        return this.copyFID;
    }

    public void setCopyColName(List names) {
        this.copyColNames = names;
    }

    public List getCopyColNames() {
        if (this.copyColNames == null) {
            this.copyColNames = new ArrayList();
        }
        return this.copyColNames;
    }

    public Set getPrintHiddenColIndex() {
        return this.printHiddenColIndex;
    }

    public void setPrintHiddenColIndex(Set printHiddenColIndex) {
        this.printHiddenColIndex = printHiddenColIndex;
    }

    public boolean isPasteF7Block() {
        return this.pasteF7Block;
    }

    public void setPasteF7Block(boolean pasteF7Block) {
        this.pasteF7Block = pasteF7Block;
    }

    static {
        debug = false;
    }

    class StyleAttributesListener
    implements StyleAttributesChangeListener {
        StyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent event) {
            StyleAttributes sa = event.getSA();
            Object owner = event.getOwner();
            if (sa.isEmpty()) {
                return;
            }
            KDTCellIndex index = (KDTCellIndex)owner;
            int rowIndex = index.getRowIndex();
            int colIndex = index.getColIndex();
            int type = index.getType();
            switch (type) {
                case 0: {
                    if (rowIndex == -1 && colIndex == -1) {
                        KDTable.this.setHeadStyleAttributes(sa);
                        break;
                    }
                    if (colIndex == -1) {
                        KDTable.this.setHeadSSA((ShareStyleAttributes)sa);
                        KDTable.this.setHeadRowStyle(rowIndex, sa);
                        if (!sa.isDirtyAttribute(ShareStyleAttributes.PROTECTION_HIDDED)) break;
                        KDTable.this.getLayoutManager().invalidateVerticalLast();
                        KDTable.this.reLayoutAndPaint();
                        break;
                    }
                    KDTRow row = KDTable.this.getHead().getRow(rowIndex);
                    KDTCell cell = row.getCell(colIndex);
                    if (cell == null) break;
                    ShareStyleAttributes ssaRow = row.getSSA();
                    ShareStyleAttributes ssaCol = KDTable.this.getColumns().getColumn(colIndex).getSSA();
                    ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                    Style style = cell.getFormattedSSA() == null ? Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, ssaRow, ssaCol, KDTable.this.headSSA}) : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getFormattedSSA(), ssa, ssaRow, ssaCol, KDTable.this.headSSA});
                    cell.setSSA(ssa);
                    cell.setStyle(style);
                    break;
                }
                case 1: {
                    if (rowIndex == -1 && colIndex == -1) {
                        StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)KDTable.this.bodySSA);
                        tsa.clearDirtyFlag();
                        tsa.replaceDirty((ShareStyleAttributes)sa);
                        sa = tsa;
                        KDTable.this.setStyleAttributes(sa);
                        break;
                    }
                    if (colIndex == -1) {
                        KDTable.this.setRowStyle(rowIndex, sa, false);
                        break;
                    }
                    KDTRow row = KDTable.this.getBody().getRow(rowIndex);
                    KDTable.this.setCellStyle(row, colIndex, sa);
                    break;
                }
                case 6: {
                    if (colIndex == -1) {
                        IRow row = KDTable.this.getFootRow(rowIndex);
                        if (row == null) break;
                        KDTable.this.setRowStyle(row.getKDTRow(), sa, false);
                        break;
                    }
                    IRow row = KDTable.this.getFootRow(rowIndex);
                    if (row == null) break;
                    KDTable.this.setCellStyle(row.getKDTRow(), colIndex, sa);
                    break;
                }
                case 4: {
                    KDTRow row = KDTable.this.getGroupManager().getStatRowTemplate(rowIndex).getKDTRow();
                    if (colIndex == -1) {
                        StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)row.getSSA());
                        tsa.clearDirtyFlag();
                        tsa.replaceDirty((ShareStyleAttributes)sa);
                        sa = tsa;
                        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa});
                        row.setSSA(ssa);
                        row.setStyle(style);
                        if (!sa.isDirtyAttribute(ShareStyleAttributes.PROTECTION_HIDDED)) break;
                        KDTable.this.getLayoutManager().invalidateVerticalLast();
                        KDTable.this.reLayoutAndPaint();
                        break;
                    }
                    KDTCell cell = row.getCell(colIndex);
                    if (cell == null) break;
                    StyleAttributes tsa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                    tsa.clearDirtyFlag();
                    tsa.replaceDirty((ShareStyleAttributes)sa);
                    sa = tsa;
                    ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                    Style style = cell.getFormattedSSA() == null ? Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, row.getSSA()}) : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getFormattedSSA(), ssa, row.getSSA()});
                    cell.setSSA(ssa);
                    cell.setStyle(style);
                    break;
                }
                case 5: {
                    KDTable.this.setColumnStyle(colIndex, sa, false);
                    if (!sa.isDirtyAttribute(ShareStyleAttributes.PROTECTION_HIDDED)) break;
                    KDTable.this.getLayoutManager().invalidateHorizonLast();
                    KDTable.this.reLayoutAndPaint();
                    break;
                }
            }
            KDTable.this.repaint();
        }
    }

    class FormatStyleAttributesListener
    implements StyleAttributesChangeListener {
        FormatStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent event) {
            StyleAttributes sa = event.getSA();
            Object owner = event.getOwner();
            if (sa.isEmpty()) {
                return;
            }
            KDTCellIndex index = (KDTCellIndex)owner;
            int rowIndex = index.getRowIndex();
            int colIndex = index.getColIndex();
            int type = index.getType();
            switch (type) {
                case 0: {
                    KDTRow row = KDTable.this.getHead().getRow(rowIndex);
                    KDTCell cell = row.getCell(colIndex);
                    if (cell == null) break;
                    ShareStyleAttributes ssaRow = row.getSSA();
                    ShareStyleAttributes ssaCol = KDTable.this.getColumns().getColumn(colIndex).getSSA();
                    ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                    Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, cell.getSSA(), ssaRow, ssaCol, KDTable.this.headSSA});
                    cell.setFormattedSSA(ssa);
                    cell.setStyle(style);
                    break;
                }
                case 1: {
                    KDTRow row = KDTable.this.getBody().getRow(rowIndex);
                    KDTCell cell = row.getCell(colIndex);
                    if (cell == null) break;
                    ShareStyleAttributes ssaRow = row.getSSA();
                    ShareStyleAttributes ssaCol = KDTable.this.getColumns().getColumn(colIndex).getSSA();
                    ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                    Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, cell.getSSA(), ssaRow, ssaCol, KDTable.this.bodySSA});
                    cell.setFormattedSSA(ssa);
                    cell.setStyle(style);
                    break;
                }
                case 4: {
                    KDTRow row = KDTable.this.getGroupManager().getStatRowTemplate(rowIndex).getKDTRow();
                    KDTCell cell = row.getCell(colIndex);
                    if (cell == null) break;
                    ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                    Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, cell.getSSA(), row.getSSA()});
                    cell.setFormattedSSA(ssa);
                    cell.setStyle(style);
                    break;
                }
            }
        }
    }

    class XCell
    implements ICell {
        KDTCellIndex index = new KDTCellIndex();
        private KDTCell cell;

        public XCell(int rowIndex, int colIndex, int type, KDTCell cell) {
            this.index.setRowIndex(rowIndex);
            this.index.setColIndex(colIndex);
            this.index.setType(type);
            this.cell = cell;
        }

        @Override
        public KDTCell getKDTCell() {
            this.cell.setType(this.index.getType());
            return this.cell;
        }

        @Override
        public Object clone() {
            return new XCell(this.index.getRowIndex(), this.index.getColIndex(), this.index.getType(), (KDTCell)this.cell.clone());
        }

        @Override
        public StyleAttributes getStyleAttributes() {
            I18nStyleAttributes sa = new I18nStyleAttributes(this.cell.getSSA(), KDTable.this.i18nEnabled);
            sa.append((ShareStyleAttributes)this.cell.getStyle(), false);
            sa.setOwner((Object)this.index);
            sa.setListener((StyleAttributesChangeListener)KDTable.this.saListener);
            return sa;
        }

        @Override
        public void setStyleAttributes(StyleAttributes sa) {
            if (this.index.getType() == 0) {
                KDTable.this.setHeadCellStyle(this.index.getRowIndex(), this.index.getColIndex(), sa);
            } else {
                KDTable.this.setCellStyle(this.index.getRowIndex(), this.index.getColIndex(), sa);
            }
        }

        @Override
        public KDTMergeBlock getMergeBlock() {
            return this.cell.getViewBlock();
        }

        @Override
        public Object getValue() {
            return this.cell.getValue();
        }

        @Override
        public void setValue(Object value) {
            Object oldValue = this.cell.getValue();
            if (KDTable.this.getFormulaMode() == 0) {
                this.cell.setExpressions(null);
                if (Tools.equalsObject((Object)oldValue, (Object)value)) {
                    return;
                }
            }
            this.cell.setValue(value);
            if (this.index.getType() == 1) {
                KDTEditManager em;
                if (KDTable.this.scriptManager != null) {
                    KDTable.this.scriptManager.cellPropertyChanged(this.index.getRowIndex(), this.index.getColIndex());
                }
                if ((em = KDTable.this.getEditManager()).isEditing() && this.index.getRowIndex() == em.getEditRowIndex() && this.index.getColIndex() == em.getEditColIndex()) {
                    em.getEditor().setValue(value);
                }
            }
            KDTable.this.fireCellPropertyChange("cellValue", oldValue, value, this.index);
            KDTable.this.repaint();
        }

        void setValue2(Object value) {
            Object oldValue = this.cell.getValue();
            this.cell.setValue(value);
            KDTable.this.fireCellPropertyChange("cellValue", oldValue, value, this.index);
        }

        @Override
        public boolean isChange() {
            return this.cell.isChange();
        }

        @Override
        public void setChange(boolean newValue) {
            this.cell.setChange(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.cell.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.cell.setDataStyle(dataStyle);
        }

        @Override
        public IBasicRender getRenderer() {
            return this.cell.getRenderer();
        }

        @Override
        public void setRenderer(IBasicRender renderer) {
            this.cell.setRenderer(renderer);
        }

        @Override
        public ICellEditor getEditor() {
            return this.cell.getEditor();
        }

        @Override
        public void setEditor(ICellEditor editor) {
            this.cell.setEditor(editor);
        }

        @Override
        public Object getUserObject() {
            return this.cell.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.cell.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.cell.getExpressions() != null ? this.cell.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            String oldFormula = this.cell.getExpressions();
            if (KDTable.this.getFormulaMode() == 0) {
                if (StringUtil.equalsIgnoreCase((String)oldFormula, (String)expressions)) {
                    return;
                }
                this.cell.setValue(null);
            }
            this.cell.setExpressions(expressions);
            if (this.index.getType() != 4 && KDTable.this.getScriptManager() != null) {
                KDTable.this.scriptManager.cellFormulaChanged(this.index.getRowIndex(), this.index.getColIndex());
            }
            KDTable.this.repaint();
        }

        @Override
        public Object getFormattedValue() {
            Object formattedValue = null;
            if (this.cell.macroInfo != null) {
                formattedValue = this.cell.macroInfo.getFormattedValue();
            }
            if (formattedValue == null && this.cell.style != null) {
                String nFormat = this.cell.style.getNumberFormat();
                Object data = this.cell.getValue();
                if (data instanceof Date && !StringUtil.equals((String)nFormat, (String)CtrlFormatUtilities.getDateFormatString()) && !StringUtil.equals((String)nFormat, (String)CtrlFormatUtilities.getTimeFormatString()) && !StringUtil.equals((String)nFormat, (String)CtrlFormatUtilities.getDateTimeFormatString())) {
                    if (data instanceof java.sql.Date) {
                        nFormat = CtrlFormatUtilities.getDateFormatString();
                    } else if (data instanceof Time) {
                        nFormat = CtrlFormatUtilities.getTimeFormatString();
                    } else if (data instanceof Timestamp) {
                        nFormat = CtrlFormatUtilities.getDateTimeFormatString();
                    }
                    if (StringUtil.isEmptyString((String)nFormat)) {
                        nFormat = CtrlFormatUtilities.getDateFormatString();
                    }
                }
                if (StringUtil.isEmptyString((String)nFormat)) {
                    return null;
                }
                if (nFormat.startsWith("@")) {
                    if (KDTable.this.getCellCustomFormatter() != null) {
                        formattedValue = KDTable.this.getCellCustomFormatter().format(nFormat, data);
                    }
                } else if (data != null && nFormat.startsWith("%")) {
                    formattedValue = Tools.format((String)nFormat, (Object)data);
                }
                if (data == null && formattedValue == null) {
                    return null;
                }
                if (formattedValue == null) {
                    Variant vData = null;
                    vData = data instanceof Variant ? (Variant)data : new Variant(data);
                    formattedValue = Formats.getFormat((String)nFormat).format(vData).toString();
                    StyleAttributes sa = Styles.getEmptySA();
                    Formats.getFormat((String)nFormat).formatStyle(vData, sa);
                    if (sa.isEmpty()) {
                        if (this.cell.getFormattedSSA() != null) {
                            this.cell.setFormattedSSA(null);
                            KDTable.this.applyCellStyle(this.index.getRowIndex(), this.index.getColIndex());
                        }
                    } else {
                        this.cell.setFormattedSSA(null);
                        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                        this.cell.setFormattedSSA(ssa);
                        KDTable.this.applyCellStyle(this.index.getRowIndex(), this.index.getColIndex());
                    }
                }
            }
            this.cell.setFormattedValue(formattedValue);
            return formattedValue;
        }

        @Override
        public StyleAttributes getFormattedStyleAttributes() {
            ShareStyleAttributes ssa = this.cell.getFormattedSSA();
            StyleAttributes sa = ssa == null ? Styles.getEmptySA() : Styles.getSA((ShareStyleAttributes)this.cell.getFormattedSSA());
            sa.append((ShareStyleAttributes)this.cell.getStyle(), false);
            sa.setOwner((Object)this.index);
            sa.setListener((StyleAttributesChangeListener)KDTable.this.fsaListener);
            return sa;
        }

        @Override
        public Style getStyle() {
            Style style = this.cell.getStyle();
            if (style == null) {
                // empty if block
            }
            return style;
        }

        @Override
        public int getColumnIndex() {
            return this.index.getColIndex();
        }

        @Override
        public int getRowIndex() {
            return this.index.getRowIndex();
        }
    }

    class XRow
    implements IRow {
        private KDTCellIndex index = new KDTCellIndex();
        private KDTRow row;

        public XRow(int rowIndex, int type, KDTRow row) {
            this.index.setRowIndex(rowIndex);
            this.index.setColIndex(-1);
            this.index.setType(type);
            this.row = row;
        }

        KDTCell createBlankCell(int cellIndex) {
            Style style;
            KDTCell cell = new KDTCell();
            ShareStyleAttributes ssa = Styles.getEmptySSA();
            ShareStyleAttributes ssaRow = this.row.getSSA();
            if (this.index.getType() == 0) {
                style = KDTable.this.getBlankCellStyle(ssaRow, null);
            } else {
                ShareStyleAttributes ssaCol = KDTable.this.getColumns().getColumn(cellIndex).getSSA();
                style = KDTable.this.getBlankCellStyle(ssaRow, ssaCol);
            }
            cell.setSSA(ssa);
            cell.setStyle(style);
            return cell;
        }

        public void exchangeCell(int cellIndex1, int cellIndex2) {
            this.row.exchangeCell(cellIndex1, cellIndex2);
        }

        @Override
        public ICell getCell(int cellIndex) {
            return this.getCell(cellIndex, true);
        }

        @Override
        public ICell getCell(String key) {
            return this.getCell(key, true);
        }

        @Override
        public ICell getCell(int cellIndex, boolean autoCreate) {
            if (cellIndex < 0 || cellIndex >= KDTable.this.getColumnCount()) {
                return null;
            }
            KDTCell cell = this.row.getCell(cellIndex);
            if (cell == null) {
                if (autoCreate) {
                    cell = this.createBlankCell(cellIndex);
                    this.row.setCell(cellIndex, cell);
                    return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cell);
                }
                return null;
            }
            return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cell);
        }

        @Override
        public ICell getCell(String key, boolean autoCreate) {
            int cellIndex = KDTable.this.getColumns().getColumnIndex(key);
            return this.getCell(cellIndex, autoCreate);
        }

        @Override
        public ICell setCell(int cellIndex, ICell cell) {
            if (cellIndex < 0 || cellIndex >= KDTable.this.getColumnCount()) {
                return null;
            }
            if (cell == null) {
                this.row.setCell(cellIndex, null);
                KDTable.this.repaint();
                return null;
            }
            KDTCell cellTemp = cell.getKDTCell();
            this.row.setCell(cellIndex, cellTemp);
            return new XCell(this.index.getRowIndex(), cellIndex, this.index.getType(), cellTemp);
        }

        @Override
        public ICell setCell(String key, ICell cell) {
            int cellIndex = KDTable.this.getColumns().getColumnIndex(key);
            return this.setCell(cellIndex, cell);
        }

        @Override
        public KDTRow getKDTRow() {
            return this.row;
        }

        @Override
        public Object clone() {
            return new XRow(this.index.getRowIndex(), this.index.getType(), (KDTRow)this.row.clone());
        }

        @Override
        public int getHeight() {
            if (this.row != null) {
                if (this.row.getStyle().isHided()) {
                    return 0;
                }
                int height = this.row.getHeight();
                if (height == -1) {
                    height = this.index.getType() == 0 ? KDTable.this.getDefaultHeadRowHeight() : KDTable.this.getDefaultRowHeight();
                }
                return height;
            }
            return -1;
        }

        @Override
        public void setHeight(int height) {
            this.row.setHeight(height);
            KDTable.this.repaint();
        }

        @Override
        public StyleAttributes getStyleAttributes() {
            I18nStyleAttributes sa = new I18nStyleAttributes(this.row.getSSA(), KDTable.this.i18nEnabled);
            sa.append((ShareStyleAttributes)this.row.getStyle(), false);
            sa.setOwner((Object)this.index);
            sa.setListener((StyleAttributesChangeListener)KDTable.this.saListener);
            return sa;
        }

        @Override
        public void setStyleAttributes(StyleAttributes sa) {
            if (this.index.getType() == 0) {
                KDTable.this.setHeadRowStyle(this.index.getRowIndex(), sa);
            } else {
                KDTable.this.setRowStyle(this.index.getRowIndex(), sa, true);
            }
        }

        @Override
        public boolean isMergeable() {
            return this.row.isMergeable();
        }

        @Override
        public void setMergeable(boolean newValue) {
            this.row.setMergeable(newValue);
        }

        @Override
        public boolean isResizeable() {
            return this.row.isResizeable();
        }

        @Override
        public void setResizeable(boolean newValue) {
            this.row.setResizeable(newValue);
        }

        @Override
        public boolean isCollapse() {
            return this.row.isCollapse();
        }

        @Override
        public void setCollapse(boolean collapse) {
            this.row.setCollapse(collapse);
        }

        @Override
        public int getTreeLevel() {
            return this.row.getTreeLevel();
        }

        @Override
        public void setTreeLevel(int treeLevel) {
            this.row.setTreeLevel(treeLevel);
        }

        @Override
        public boolean isStat() {
            return this.row.isStat();
        }

        @Override
        public void setStat(boolean newValue) {
            this.row.setStat(newValue);
        }

        @Override
        public boolean isChange() {
            return this.row.isChange();
        }

        @Override
        public void setChange(boolean newValue) {
            this.row.setChange(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.row.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.row.setDataStyle(dataStyle);
        }

        @Override
        public IBasicRender getRenderer() {
            return this.row.getRenderer();
        }

        @Override
        public void setRenderer(IBasicRender renderer) {
            this.row.setRenderer(renderer);
        }

        @Override
        public ICellEditor getEditor() {
            return this.row.getEditor();
        }

        @Override
        public void setEditor(ICellEditor editor) {
            this.row.setEditor(editor);
        }

        @Override
        public Object getUserObject() {
            return this.row.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.row.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.row.getExpressions() != null ? this.row.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            this.row.setExpressions(expressions);
        }

        @Override
        public int getRowIndex() {
            return this.index.getRowIndex();
        }

        @Override
        public int getRowType() {
            return this.index.getType();
        }
    }

    class XColumn
    implements IColumn {
        KDTCellIndex index = new KDTCellIndex();
        private KDTColumn column;

        public XColumn(int colIndex, KDTColumn column) {
            this.index.setRowIndex(-1);
            this.index.setColIndex(colIndex);
            this.index.setType(5);
            this.column = column;
        }

        @Override
        public KDTColumn getKDTColumn() {
            return this.column;
        }

        @Override
        public Object clone() {
            return new XColumn(this.index.getColIndex(), (KDTColumn)this.column.clone());
        }

        @Override
        public int getWidth() {
            if (this.column != null) {
                if (this.column.getStyle().isHided()) {
                    return 0;
                }
                int width = this.column.getWidth();
                if (width == -1) {
                    width = KDTable.this.getDefaultColumnWidth();
                }
                return width;
            }
            return -1;
        }

        @Override
        public void setWidth(int width) {
            this.column.setWidth(width);
            KDTable.this.repaint();
        }

        @Override
        public String getKey() {
            return this.column.getKey();
        }

        @Override
        public void setKey(String key) {
            this.column.setKey(key);
        }

        @Override
        public StyleAttributes getStyleAttributes() {
            DelegateSA sa = new DelegateSA(this.column.getSSA(), KDTable.this.i18nEnabled);
            sa.append((ShareStyleAttributes)this.column.getStyle(), false);
            sa.clearDirtyFlag();
            sa.setOwner(this.index);
            sa.setListener(KDTable.this.saListener);
            return sa;
        }

        @Override
        public void setStyleAttributes(StyleAttributes sa) {
            KDTable.this.setColumnStyle(this.index.getColIndex(), sa, true);
        }

        @Override
        public boolean isMergeable() {
            return this.column.isMergeable();
        }

        @Override
        public void setMergeable(boolean newValue) {
            this.column.setMergeable(newValue);
        }

        @Override
        public boolean isResizeable() {
            return this.column.isResizeable();
        }

        @Override
        public void setResizeable(boolean newValue) {
            this.column.setResizeable(newValue);
        }

        @Override
        public boolean isMoveable() {
            return this.column.isMoveable();
        }

        @Override
        public void setMoveable(boolean newValue) {
            this.column.setMoveable(newValue);
        }

        @Override
        public boolean isGroup() {
            return this.column.isGroup();
        }

        @Override
        public void setGroup(boolean newValue) {
            this.column.setGroup(newValue);
        }

        @Override
        public boolean isStat() {
            return this.column.isStat();
        }

        @Override
        public void setStat(boolean newValue) {
            this.column.setStat(newValue);
        }

        @Override
        public boolean isSortable() {
            return this.column.isSortable();
        }

        @Override
        public void setSortable(boolean newValue) {
            this.column.setSortable(newValue);
        }

        @Override
        public KDTDataStyle getDataStyle() {
            return this.column.getDataStyle();
        }

        @Override
        public void setDataStyle(KDTDataStyle dataStyle) {
            this.column.setDataStyle(dataStyle);
        }

        @Override
        public IBasicRender getRenderer() {
            return this.column.getRenderer();
        }

        @Override
        public void setRenderer(IBasicRender renderer) {
            this.column.setRenderer(renderer);
        }

        @Override
        public ICellEditor getEditor() {
            return this.column.getEditor();
        }

        @Override
        public void setEditor(ICellEditor editor) {
            this.column.setEditor(editor);
        }

        @Override
        public Object getUserObject() {
            return this.column.getUserObject();
        }

        @Override
        public void setUserObject(Object object) {
            this.column.setUserObject(object);
        }

        @Override
        public String getExpressions() {
            return this.column.getExpressions() != null ? this.column.getExpressions() : null;
        }

        @Override
        public void setExpressions(String expressions) {
            this.column.setExpressions(expressions);
        }

        @Override
        public String getDataSourceName() {
            return this.column.getDataSourceName();
        }

        @Override
        public String getFieldName() {
            return this.column.getFieldName();
        }

        @Override
        public int getColumnIndex() {
            return this.index.getColIndex();
        }

        @Override
        public boolean isRequired() {
            return this.column.isRequired();
        }

        @Override
        public void setRequired(boolean newValue) {
            this.column.setRequired(newValue);
            if (newValue) {
                this.getStyleAttributes().setBackground(KDTable.this.getRequiredColor());
            } else {
                this.getStyleAttributes().setBackground(Styles.getNullColor());
            }
        }

        class DelegateSA
        extends I18nStyleAttributes {
            public DelegateSA(ShareStyleAttributes ssa, boolean i18nEnabled) {
                super(ssa, i18nEnabled);
            }

            public void setHided(boolean bHided) {
                boolean origin = super.isHided();
                super.setHided(bHided);
                if (origin != bHided) {
                    int first = KDTable.this.getLayoutManager().getHorizon(2).getFirst();
                    if (bHided) {
                        --first;
                    }
                    if (first >= 0) {
                        KDTable.this.getLayoutManager().getHorizon(2).setFirst(first);
                    }
                }
            }
        }
    }
}

