/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.TableRelations;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDataStyle;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class KDTableXmlTrans
implements IXmlTrans {
    private static final Logger logger = LogUtil.getPackageLogger(KDTableXmlTrans.class);
    private KDTable table;
    private KDFXmlReader reader;
    private IXmlElement nodeDSS;
    private Hashtable dssCache;
    private int styleID = 0;
    private KDF kdf;
    private TableRelations tableRelations;
    public static String TABLEPRINTS_NODENAME = "TablePrintSets";
    public static String TABLEPRINT_NODENAME = "TablePrintSet";
    public static String TABLEPRINT_NODESERVICENAME = "printerName";
    public static String TABLEPRINT_NODETABLESETUP = "tableSetup";
    public static String TABLEPRINT_NODEATTRIBUTESET = "attributeSet";

    public KDTableXmlTrans() {
        long b = System.currentTimeMillis();
        this.dssCache = new Hashtable();
        long e = System.currentTimeMillis() - b;
        KDTable.printDebugInfo("coustruct:" + e);
    }

    public IXmlElement writeToNode(Object obj, KDF kdf) {
        if (obj instanceof KDTable) {
            this.table = (KDTable)obj;
            return this.out(kdf);
        }
        throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("KDTableSerializerAcceptsOnlyKDTableType", "KDTable\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7KDTable\u7c7b\u578b\u7684\u53c2\u6570"));
    }

    public Object readFromNode(IXmlElement ele, KDF kdf) {
        this.kdf = kdf;
        if ("Table".equals(ele.getName())) {
            return this.readFromNode(ele, kdf.getReader());
        }
        return null;
    }

    private Object readFromNode(IXmlElement ele, KDFXmlReader reader) {
        this.reader = reader;
        this.table = new KDTable();
        this.table.getScriptManager().setRelationsObject(this.getTableRelations());
        this.parse(ele);
        return this.table;
    }

    public void readDefaultTableFromFile(KDTable table, KDF kdf) {
        this.kdf = kdf;
        this.reader = kdf.getReader();
        this.table = table;
        this.parse((IXmlElement)this.reader.getTableNodes().get(0));
    }

    IXmlElement out(KDF kdf) {
        if (null == kdf) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("KDTableSerializationMethodRequiresNonNullParam", "KDTable\u5e8f\u5217\u5316\u65b9\u6cd5\u9700\u8981\u975e\u7a7a\u7684\u53c2\u6570\uff1akdf"));
        }
        this.kdf = kdf;
        IXmlElement nodeKDTable = XmlUtil.createNode((String)"Table");
        if (this.isEmptyString(this.table.getID())) {
            this.table.setID(KDF.getDefaultID());
        }
        this.setNodeAttribute(nodeKDTable, "id", this.table.getID());
        IXmlElement nodeDataStyles = XmlUtil.createNode((String)"DataStyles");
        nodeKDTable.addChild(nodeDataStyles);
        this.nodeDSS = nodeDataStyles;
        IXmlElement nodeSheet = XmlUtil.createNode((String)"Sheet");
        nodeKDTable.addChild(nodeSheet);
        this.buildSheet(nodeSheet);
        return nodeKDTable;
    }

    private String setDataStyles(KDTDataStyle ds) {
        if (null == ds) {
            return null;
        }
        if (this.dssCache.containsKey(ds)) {
            return (String)this.dssCache.get(ds);
        }
        IXmlElement nodeDataStyle = XmlUtil.createNode((String)"DataStyle");
        String dsID = "ds" + String.valueOf(this.styleID);
        ++this.styleID;
        this.dssCache.put(ds, dsID);
        this.setNodeAttribute(nodeDataStyle, "id", dsID);
        IXmlElement nodeRenderer = XmlUtil.createNode((String)"Renderer");
        nodeDataStyle.addChild(nodeRenderer);
        IXmlElement nodeEditor = XmlUtil.createNode((String)"Editor");
        nodeDataStyle.addChild(nodeEditor);
        this.nodeDSS.addChild(nodeDataStyle);
        return dsID;
    }

    private void buildSheet(IXmlElement nodeSheet) {
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion");
        IXmlElement nodeTable = XmlUtil.createNode((String)"Table");
        this.buildTable(nodeTable);
        nodeSheet.addChild(nodeTable);
        IXmlElement nodeOptions = XmlUtil.createNode((String)"SheetOptions");
        this.buildSheetOptions(nodeOptions);
        nodeSheet.addChild(nodeOptions);
    }

    private void buildSheetOptions(IXmlElement nodeOptions) {
        IXmlElement nodeGridLine = XmlUtil.createNode((String)"GridLine");
        this.setNodeAttribute(nodeGridLine, "headVertical", this.table.isVerticalHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "headHorizon", this.table.isHorizonHeadGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyVertical", this.table.isVerticalGridLineVisible() ? "true" : "false");
        this.setNodeAttribute(nodeGridLine, "bodyHorizon", this.table.isHorizonGridLineVisible() ? "true" : "false");
        nodeOptions.addChild(nodeGridLine);
        IXmlElement nodePrintInfo = XmlUtil.createNode((String)"PrintInfo");
        nodeOptions.addChild(nodePrintInfo);
        this.table.getPrintManager().doNothing();
        if (this.isFormatOnly()) {
            return;
        }
        IXmlElement nodeSelections = XmlUtil.createNode((String)"Selections");
        nodeOptions.addChild(nodeSelections);
        this.setNodeAttribute(nodeSelections, "selectMode", String.valueOf(this.table.getSelectManager().getSelectMode()));
        this.buildSelectionsNode(nodeSelections, this.table.getSelectManager().getBlocks().toArray());
        IXmlElement nodeActiveCell = XmlUtil.createNode((String)"ActiveCell");
        this.setNodeAttribute(nodeActiveCell, "row", String.valueOf(this.table.getSelectManager().getActiveRowIndex()));
        this.setNodeAttribute(nodeActiveCell, "column", String.valueOf(this.table.getSelectManager().getActiveColumnIndex()));
        nodeOptions.addChild(nodeActiveCell);
        IXmlElement nodeMergeBlocks = XmlUtil.createNode((String)"MergeBlocks");
        this.buildMergeBlocks(nodeMergeBlocks, this.table.getMergeManager().getMergeBlockList().toArray(), this.table.getHeadMergeManager().getMergeBlockList().toArray());
        nodeOptions.addChild(nodeMergeBlocks);
        IXmlElement nodeIndexColumn = XmlUtil.createNode((String)"IndexColumn");
        this.setNodeAttribute(nodeIndexColumn, "styleID", this.kdf.addSSA(this.table.getIndexColumn().getSsa()));
        this.setNodeAttribute(nodeIndexColumn, "width", String.valueOf(this.table.getIndexColumn().getRealWidth()));
        this.setNodeAttribute(nodeIndexColumn, "widthMode", String.valueOf(this.table.getIndexColumn().getWidthAdjustMode()));
        nodeOptions.addChild(nodeIndexColumn);
        IXmlElement nodeExcelStyleHead = XmlUtil.createNode((String)"ExcelStyleHead");
        this.setNodeAttribute(nodeExcelStyleHead, "mode", String.valueOf(this.table.getHeadDisplayMode()));
        nodeOptions.addChild(nodeExcelStyleHead);
    }

    private void buildSelectionsNode(IXmlElement nodeSelections, Object[] blocks) {
        KDTSelectBlock block = null;
        for (int i = 0; i < blocks.length; ++i) {
            IXmlElement nodeBlock = XmlUtil.createNode((String)"Block");
            block = (KDTSelectBlock)blocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            this.setNodeAttribute(nodeBlock, "mode", String.valueOf(block.getMode()));
            nodeSelections.addChild(nodeBlock);
        }
    }

    private void buildMergeBlocks(IXmlElement nodeBlocks, Object[] blocks, Object[] headBlocks) {
        KDTMergeBlock block = null;
        IXmlElement nodeBlock = null;
        IXmlElement nodeHead = XmlUtil.createNode((String)"Head");
        for (int i = 0; i < headBlocks.length; ++i) {
            nodeBlock = XmlUtil.createNode((String)"Block");
            block = (KDTMergeBlock)headBlocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            nodeHead.addChild(nodeBlock);
        }
        nodeBlocks.addChild(nodeHead);
        IXmlElement nodeBody = XmlUtil.createNode((String)"Body");
        for (int i = 0; i < blocks.length; ++i) {
            nodeBlock = XmlUtil.createNode((String)"Block");
            block = (KDTMergeBlock)blocks[i];
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block.getBottom()));
            nodeBody.addChild(nodeBlock);
        }
        nodeBlocks.addChild(nodeBody);
    }

    private void buildTable(IXmlElement nodeTable) {
        String value;
        this.setTableAttributes(nodeTable);
        int rowCount = this.table.getIOManager().getTableRowCount();
        int colCount = this.table.getIOManager().getTableColumnCount();
        int headRowCount = this.table.getHeadRowCount();
        IXmlElement nodeColGroup = XmlUtil.createNode((String)"ColumnGroup");
        this.buildNodeColGroup(nodeColGroup, colCount);
        nodeTable.addChild(nodeColGroup);
        IXmlElement nodeHead = XmlUtil.createNode((String)"Head");
        this.buildNodeHead(nodeHead, this.table.getHead(), headRowCount, colCount);
        nodeTable.addChild(nodeHead);
        if (this.isFormatOnly()) {
            return;
        }
        IXmlElement nodeBody = XmlUtil.createNode((String)"Body");
        this.buildNodeBody(nodeBody, this.table.getBody(), rowCount, colCount);
        nodeTable.addChild(nodeBody);
        Object uo = this.table.getUserObject();
        if (uo != null && (value = ObjectUtil.objectToString((Object)uo)) != null) {
            IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
            nodeUO.addCData(value);
            nodeTable.addChild(nodeUO);
        }
    }

    private void setTableAttributes(IXmlElement nodeTable) {
        this.setNodeAttribute(nodeTable, "rowHeight", String.valueOf(this.table.getDefaultRowHeight()));
        this.setNodeAttribute(nodeTable, "headRowHeight", String.valueOf(this.table.getDefaultHeadRowHeight()));
        this.setNodeAttribute(nodeTable, "columnWidth", String.valueOf(this.table.getDefaultColumnWidth()));
        this.setNodeAttribute(nodeTable, "selectMode", String.valueOf(this.table.getSelectManager().getSelectMode()));
        this.setNodeAttribute(nodeTable, "mergeMode", String.valueOf(this.table.getMergeManager().getMergeMode()));
        this.setNodeAttribute(nodeTable, "dataRequestMode", String.valueOf(this.table.getDataRequestManager().getDataRequestMode()));
        this.setNodeAttribute(nodeTable, "pageRowCount", String.valueOf(this.table.getDataRequestManager().getPageRowCount()));
        this.setNodeAttribute(nodeTable, "name", this.table.getName());
        this.setNodeAttribute(nodeTable, "styleID", this.kdf.addSSA(this.table.getSSA()));
        this.setNodeAttribute(nodeTable, "headStyleID", this.kdf.addSSA(this.table.getHeadSSA()));
    }

    private void buildNodeColGroup(IXmlElement nodeColGroup, int colCount) {
        for (int i = 0; i < colCount; ++i) {
            IColumn col = this.table.getColumn(i);
            IXmlElement nodeCol = XmlUtil.createNode((String)"Column");
            this.buildColumn(nodeCol, col);
            nodeColGroup.addChild(nodeCol);
        }
    }

    private void buildColumn(IXmlElement nodeCol, IColumn col) {
        String str;
        this.setNodeAttribute(nodeCol, "width", String.valueOf(col.getKDTColumn().getWidth()));
        this.setNodeAttribute(nodeCol, "key", col.getKey());
        this.setNodeAttribute(nodeCol, "objectName", col.getDataSourceName());
        this.setNodeAttribute(nodeCol, "fieldName", col.getFieldName());
        this.setNodeAttribute(nodeCol, "mergeable", String.valueOf(col.isMergeable()));
        this.setNodeAttribute(nodeCol, "group", String.valueOf(col.isGroup()));
        this.setNodeAttribute(nodeCol, "resizeable", String.valueOf(col.isResizeable()));
        this.setNodeAttribute(nodeCol, "moveable", String.valueOf(col.isMoveable()));
        this.setNodeAttribute(nodeCol, "dataStyleID", this.setDataStyles(col.getKDTColumn().getDataStyle()));
        this.setNodeAttribute(nodeCol, "styleID", this.kdf.addSSA(col.getKDTColumn().getSSA()));
        Object obj = col.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
            nodeUO.addCData(str);
            nodeCol.addChild(nodeUO);
        }
    }

    private void setNodeAttribute(IXmlElement node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        node.setAttribute(attrName, value);
    }

    private void buildNodeHead(IXmlElement nodeHead, IRows rows, int rowCount, int colCount) {
        this.buildRowsNode(nodeHead, rows, rowCount, colCount);
    }

    private void buildRowsNode(IXmlElement nodeRows, IRows rows, int rowCount, int colCount) {
        KDTRow row;
        for (int i = 0; i < rowCount && (row = rows.getRow(i)) != null; ++i) {
            IXmlElement nodeRow = XmlUtil.createNode((String)"Row");
            this.buildRow(nodeRow, row, colCount);
            nodeRows.addChild(nodeRow);
        }
    }

    private void buildRow(IXmlElement nodeRow, KDTRow row, int colCount) {
        String str;
        this.setNodeAttribute(nodeRow, "mergeable", String.valueOf(row.isMergeable()));
        this.setNodeAttribute(nodeRow, "resizeable", String.valueOf(row.isResizeable()));
        this.setNodeAttribute(nodeRow, "height", String.valueOf(row.getHeight()));
        this.setNodeAttribute(nodeRow, "styleID", this.kdf.addSSA(row.getSSA()));
        boolean isNeedCellIndex = false;
        for (int i = 0; i < colCount; ++i) {
            KDTCell cell = row.getCell(i);
            if (cell == null || cell.isEmpty()) {
                isNeedCellIndex = true;
                continue;
            }
            IXmlElement nodeCell = XmlUtil.createNode((String)"Cell");
            if (isNeedCellIndex) {
                nodeCell.setAttribute("index", String.valueOf(i));
                isNeedCellIndex = false;
            }
            this.buildCell(nodeCell, row.getCell(i));
            nodeRow.addChild(nodeCell);
        }
        Object obj = row.getUserObject();
        if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
            IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
            nodeUO.addCData(str);
            nodeRow.addChild(nodeUO);
        }
    }

    private void buildCell(IXmlElement nodeCell, KDTCell cell) {
        ShareStyleAttributes ssa;
        String value;
        IXmlElement node;
        if (null == cell || cell.isEmpty()) {
            return;
        }
        Object obj = cell.getValue();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"Value");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"Value");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        obj = cell.getFormattedValue();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"FormattedValue");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"FormattedValue");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        obj = cell.getUserObject();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"UserObject");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"UserObject");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        value = cell.getExpressions();
        if (!this.isEmptyString(value)) {
            node = XmlUtil.createNode((String)"Expression");
            node.addCData(value);
            nodeCell.addChild(node);
        }
        if ((ssa = cell.getSSA()) != null) {
            this.setNodeAttribute(nodeCell, "styleID", this.kdf.addSSA(ssa));
        }
        if ((ssa = cell.getFormattedSSA()) != null) {
            this.setNodeAttribute(nodeCell, "formattedStyleID", this.kdf.addSSA(ssa));
        }
    }

    private void buildNodeBody(IXmlElement nodeBody, IRows rows, int rowCount, int colCount) {
        this.buildRowsNode(nodeBody, rows, rowCount, colCount);
    }

    void parse(IXmlElement nodeKDTable) {
        boolean autoRun = this.table.isScriptAutoRun();
        boolean autoAdjust = this.table.isScriptAutoAdjust();
        this.table.setScriptAutoRun(false);
        this.table.setScriptAutoAdjust(false);
        String id = nodeKDTable.getAttribute("id");
        if (!this.isEmptyString(id)) {
            this.table.setID(id);
        }
        IXmlElement nodeTable = null;
        try {
            nodeTable = nodeKDTable.getChild("Sheet").getChild("Table");
        }
        catch (Exception e) {
            return;
        }
        if (nodeTable == null) {
            return;
        }
        this.fillTable(nodeTable);
        IXmlElement nodeSheetOptions = nodeKDTable.getChild("Sheet").getChild("SheetOptions");
        if (null != nodeSheetOptions) {
            this.fillSheetOptions(nodeSheetOptions);
        }
        this.table.reLayoutAndPaint();
        this.table.setScriptAutoRun(autoRun);
        this.table.setScriptAutoAdjust(autoAdjust);
    }

    private void fillSheetOptions(IXmlElement nodeSheetOptions) {
        IXmlElement nodeESH;
        String value;
        IXmlElement nodePrintInfo = nodeSheetOptions.getChild("PrintInfo");
        this.parsePrintInfo(nodePrintInfo);
        IXmlElement nodeGridLine = nodeSheetOptions.getChild("GridLine");
        this.parseGridLine(nodeGridLine);
        IXmlElement nodeActiveCell = nodeSheetOptions.getChild("ActiveCell");
        this.parseActiveCellIndex(nodeActiveCell);
        IXmlElement nodeSelections = nodeSheetOptions.getChild("Selections");
        this.parseSelections(nodeSelections);
        IXmlElement nodeMerges = nodeSheetOptions.getChild("MergeBlocks");
        this.parseMergeBlocks(nodeMerges);
        IXmlElement nodeIndexColumn = nodeSheetOptions.getChild("IndexColumn");
        if (null != nodeIndexColumn) {
            value = nodeIndexColumn.getAttribute("styleID");
            if (!this.isEmptyString(value)) {
                ShareStyleAttributes ssa = this.getStyleAttributes(value);
                this.table.getIndexColumn().setSsa(ssa);
            }
            if (!this.isEmptyString(value = nodeIndexColumn.getAttribute("width"))) {
                this.table.getIndexColumn().setRealWidth(Integer.parseInt(value));
            }
            if (!this.isEmptyString(value = nodeIndexColumn.getAttribute("widthMode"))) {
                this.table.getIndexColumn().setWidthAdjustMode(Short.parseShort(value));
            }
        }
        if (null != (nodeESH = nodeSheetOptions.getChild("ExcelStyleHead")) && !this.isEmptyString(value = nodeESH.getAttribute("mode"))) {
            this.table.setHeadDisplayMode(Integer.parseInt(value));
        }
    }

    private void parseMergeBlocks(IXmlElement nodeMerges) {
        if (null == nodeMerges) {
            return;
        }
        IXmlElement nodeHead = nodeMerges.getChild("Head");
        IXmlElement nodeBody = nodeMerges.getChild("Body");
        if (nodeHead != null) {
            this.parseMergePart(nodeHead, this.table.getHeadMergeManager());
        }
        if (nodeBody != null) {
            this.parseMergePart(nodeBody, this.table.getMergeManager());
        }
    }

    private void parseMergePart(IXmlElement blocksNode, KDTMergeManager merMan) {
        List nodeBlockList = blocksNode.searchChildren("Block");
        Iterator iter = nodeBlockList.iterator();
        while (iter.hasNext()) {
            KDTMergeBlock block = this.parseMergeBlock((IXmlElement)iter.next());
            if (null == block) continue;
            merMan.mergeBlock(block);
        }
    }

    private KDTMergeBlock parseMergeBlock(IXmlElement nodeBlock) {
        if (null == nodeBlock) {
            return null;
        }
        KDTMergeBlock block = new KDTMergeBlock();
        try {
            String top = nodeBlock.getAttribute("top");
            String right = nodeBlock.getAttribute("right");
            String left = nodeBlock.getAttribute("left");
            String bottom = nodeBlock.getAttribute("bottom");
            if (this.isEmptyString(top) || this.isEmptyString(right) || this.isEmptyString(left) || this.isEmptyString(bottom)) {
                throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("selectionBlockParamIncomplete", "\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574"));
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            return block;
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
            return null;
        }
    }

    private void parsePrintInfo(IXmlElement nodePrintInfo) {
        if (null == nodePrintInfo) {
            return;
        }
        this.table.getPrintManager().doNothing();
    }

    private void parseGridLine(IXmlElement nodeGridLine) {
        if (null == nodeGridLine) {
            return;
        }
        String sVal = nodeGridLine.getAttribute("headVertical");
        this.table.setVerticalHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("headHorizon");
        this.table.setHorizonHeadGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("bodyVertical");
        this.table.setVerticalGridLineVisible(this.getBooleanFromString(sVal));
        sVal = nodeGridLine.getAttribute("bodyHorizon");
        this.table.setHorizonGridLineVisible(this.getBooleanFromString(sVal));
    }

    private void parseActiveCellIndex(IXmlElement nodeActiveCell) {
        if (null == nodeActiveCell) {
            return;
        }
        String rowIndex = nodeActiveCell.getAttribute("row");
        String colIndex = nodeActiveCell.getAttribute("column");
        try {
            if (!this.isEmptyString(rowIndex)) {
                this.table.getSelectManager().setActiveRowIndex(Integer.parseInt(rowIndex));
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            this.table.getSelectManager().setActiveRowIndex(0);
        }
        try {
            if (!this.isEmptyString(colIndex)) {
                this.table.getSelectManager().setActiveColumnIndex(Integer.parseInt(colIndex));
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            this.table.getSelectManager().setActiveColumnIndex(0);
        }
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private boolean getBooleanFromString(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    private void parseSelections(IXmlElement nodeSelections) {
        if (null == nodeSelections) {
            return;
        }
        KDTSelectManager selMan = this.table.getSelectManager();
        List nodeBlockList = nodeSelections.searchChildren("Block");
        for (IXmlElement nodeBlock : nodeBlockList) {
            KDTSelectBlock block = this.parseSelectBlock(nodeBlock);
            if (null == block) continue;
            selMan.add(block);
        }
    }

    private KDTSelectBlock parseSelectBlock(IXmlElement nodeBlock) {
        if (null == nodeBlock) {
            return null;
        }
        KDTSelectBlock block = new KDTSelectBlock();
        try {
            String top = nodeBlock.getAttribute("top");
            String right = nodeBlock.getAttribute("right");
            String left = nodeBlock.getAttribute("left");
            String bottom = nodeBlock.getAttribute("bottom");
            String mode = nodeBlock.getAttribute("mode");
            if (this.isEmptyString(top) || this.isEmptyString(right) || this.isEmptyString(left) || this.isEmptyString(bottom)) {
                throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("selectionBlockParamIncomplete", "\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574"));
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            block.setMode(Integer.parseInt(mode));
            return block;
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
            return null;
        }
    }

    private void fillTable(IXmlElement nodeTable) {
        Object uo;
        this.fillTableAttributes(this.table, nodeTable);
        IXmlElement e = nodeTable.getChild("ColumnGroup");
        if (e != null) {
            this.fillColumns(e);
        }
        if (this.isFormatOnly()) {
            return;
        }
        e = nodeTable.getChild("Head");
        if (e != null) {
            this.fillHead(e);
        }
        if ((e = nodeTable.getChild("Body")) != null) {
            this.fillBody(e);
        }
        if ((e = nodeTable.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            this.table.setUserObject(uo);
        }
    }

    private void fillColumns(IXmlElement e) {
        List list1 = e.searchChildren("Column");
        for (int i = 0; i < list1.size(); ++i) {
            IXmlElement colNode = (IXmlElement)list1.get(i);
            this.fillColAttributes(i, colNode);
        }
    }

    private void fillHead(IXmlElement e) {
        int i;
        ShareStyleAttributes ssa = this.table.getHeadSSA();
        List list1 = e.searchChildren("Row");
        IRow[] rows = new IRow[list1.size()];
        for (i = 0; i < rows.length; ++i) {
            rows[i] = this.table.addHeadRow(i);
        }
        StyleAttributes sa = Styles.getEmptySA();
        for (i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            IXmlElement rowNode = (IXmlElement)list1.get(i);
            this.fillRowAttributes(row, rowNode, ssa);
            List list2 = rowNode.searchChildren("Cell");
            for (int j = 0; j < list2.size(); ++j) {
                ICell cell;
                IXmlElement cellNode = (IXmlElement)list2.get(j);
                int cellIndex = j;
                String value = cellNode.getAttribute("index");
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) == null) continue;
                this.fillCellAttributes(cell, cellNode, ssa, (ShareStyleAttributes)row.getStyleAttributes(), (ShareStyleAttributes)sa);
            }
        }
    }

    private void fillBody(IXmlElement e) {
        List list1 = e.searchChildren("Row");
        ShareStyleAttributes ssa = this.table.getSSA();
        for (int i = 0; i < list1.size(); ++i) {
            IRow row = this.table.addRow(i);
            IXmlElement rowNode = (IXmlElement)list1.get(i);
            this.fillRowAttributes(row, rowNode, ssa);
            List list2 = rowNode.searchChildren("Cell");
            int j = 0;
            int cellIndex = 0;
            while (j < list2.size()) {
                ICell cell;
                IXmlElement cellNode = (IXmlElement)list2.get(j);
                String value = cellNode.getAttribute("index");
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                if ((cell = row.getCell(cellIndex)) != null) {
                    this.fillCellAttributes(cell, cellNode, ssa, row.getKDTRow().getSSA(), this.table.getColumn(cellIndex).getKDTColumn().getSSA());
                }
                ++j;
                ++cellIndex;
            }
        }
    }

    private void fillTableAttributes(KDTable objTable, IXmlElement objXml) {
        StyleAttributes sa;
        ShareStyleAttributes ssa;
        String attVal = objXml.getAttribute("columnWidth");
        if (!this.isEmptyString(attVal)) {
            objTable.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("headRowHeight"))) {
            objTable.setDefaultHeadRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("rowHeight"))) {
            objTable.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("selectMode"))) {
            objTable.getSelectManager().setSelectMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeMode"))) {
            objTable.getMergeManager().setMergeMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("dataRequestMode"))) {
            objTable.getDataRequestManager().setDataRequestMode(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("name"))) {
            objTable.setName(attVal);
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            this.table.setSSA(ssa);
            this.table.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("headStyleID"))) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            this.table.setHeadSSA(ssa);
            this.table.setHeadStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
    }

    private ShareStyleAttributes getStyleAttributes(String id) {
        if (this.kdf != null) {
            return this.kdf.getSSA(id);
        }
        return Styles.getEmptySSA();
    }

    private void fillColAttributes(int colIndex, IXmlElement objXml) {
        Object uo;
        IXmlElement e;
        IColumn col = this.isFormatOnly() ? this.table.getColumn(colIndex) : this.table.addColumn(colIndex);
        if (col == null) {
            return;
        }
        String attVal = objXml.getAttribute("width");
        if (!this.isEmptyString(attVal)) {
            col.setWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("key"))) {
            col.setKey(attVal);
        }
        attVal = objXml.getAttribute("objectName");
        String attVal2 = objXml.getAttribute("fieldName");
        if (!this.isEmptyString(attVal) && !this.isEmptyString(attVal2)) {
            this.table.getDataRequestManager().putBindContents(colIndex, attVal, attVal2);
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeable"))) {
            col.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("resizeable"))) {
            col.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("moveable"))) {
            col.setMoveable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("group"))) {
            col.setGroup(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            if (this.isFormatOnly()) {
                col.setStyleAttributes(sa);
            } else {
                col.getKDTColumn().setSSA(ssa);
                col.getKDTColumn().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.table.getSSA()}));
            }
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("required")) && this.getBooleanFromString(attVal)) {
            col.setRequired(true);
        }
        if ((e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            col.setUserObject(uo);
        }
    }

    private void fillRowAttributes(IRow objTable, IXmlElement objXml, ShareStyleAttributes fatherSSA) {
        Object uo;
        IXmlElement e;
        String attVal = objXml.getAttribute("height");
        if (!this.isEmptyString(attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeable"))) {
            objTable.setMergeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("resizeable"))) {
            objTable.setResizeable(this.getBooleanFromString(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objTable.getKDTRow().setSSA(ssa);
            objTable.getKDTRow().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, fatherSSA}));
        }
        if ((e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private void fillCellAttributes(ICell objCell, IXmlElement objXml, ShareStyleAttributes tableSSA, ShareStyleAttributes rowSSA, ShareStyleAttributes colSSA) {
        Object obj;
        String type;
        StyleAttributes sa;
        ShareStyleAttributes ssa = null;
        ShareStyleAttributes fssa = null;
        String attVal = objXml.getAttribute("styleID");
        if (!this.isEmptyString(attVal)) {
            ssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objCell.getKDTCell().setSSA(ssa);
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("formattedStyleID"))) {
            fssa = this.getStyleAttributes(attVal.trim());
            sa = Styles.getSA((ShareStyleAttributes)ssa);
            KDTableUtil.checkInvalideSA(sa);
            ssa = sa;
            objCell.getKDTCell().setFormattedSSA(ssa);
        }
        if (ssa != null) {
            if (fssa != null) {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{fssa, ssa, rowSSA, colSSA, tableSSA}));
            } else {
                objCell.getKDTCell().setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, rowSSA, colSSA, tableSSA}));
            }
        }
        if (objXml.getChildren().size() == 0) {
            attVal = objXml.getText();
            if (attVal != null) {
                objCell.setValue(attVal);
            }
            return;
        }
        IXmlElement node = objXml.getChild("FormattedValue");
        if (node != null) {
            attVal = node.getText();
            type = node.getAttribute("type");
            if ("string".equalsIgnoreCase(type)) {
                if (attVal != null) {
                    objCell.getKDTCell().setFormattedValue(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    objCell.getKDTCell().setFormattedValue(obj);
                }
            }
        }
        if ((node = objXml.getChild("UserObject")) != null) {
            attVal = node.getText();
            type = node.getAttribute("type");
            if ("string".equalsIgnoreCase(type)) {
                if (attVal != null) {
                    objCell.getKDTCell().setUserObject(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    objCell.getKDTCell().setUserObject(obj);
                }
            }
        }
        if ((node = objXml.getChild("Expression")) != null && !this.isEmptyString(attVal = node.getText())) {
            objCell.setExpressions(attVal);
        }
        if ((node = objXml.getChild("Value")) != null) {
            attVal = node.getText();
            type = node.getAttribute("type");
            if ("string".equalsIgnoreCase(type)) {
                if (StringUtil.isEmptyString((String)attVal)) {
                    objCell.getKDTCell().setValue(null);
                } else {
                    objCell.getKDTCell().setValue(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    if (obj instanceof String && StringUtil.isEmptyString((String)((String)obj))) {
                        objCell.getKDTCell().setValue(null);
                    } else {
                        objCell.getKDTCell().setValue(obj);
                    }
                } else if (attVal != null) {
                    if (StringUtil.isEmptyString((String)attVal)) {
                        objCell.getKDTCell().setValue(null);
                    } else {
                        objCell.getKDTCell().setValue(attVal);
                    }
                }
            }
        }
    }

    public boolean isFormatOnly() {
        return this.table.getIOManager().isFormatOnly();
    }

    private TableRelations getTableRelations() {
        if (this.tableRelations == null) {
            this.tableRelations = new TableRelations();
        }
        return this.tableRelations;
    }
}

